//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfdocument?language=objc)
#[repr(C)]
pub struct CGPDFDocument {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "CGPDFDocument"]
    unsafe impl CGPDFDocument {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfaccesspermissions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGPDFAccessPermissions(pub u32);
bitflags::bitflags! {
    impl CGPDFAccessPermissions: u32 {
        #[doc(alias = "kCGPDFAllowsLowQualityPrinting")]
        const AllowsLowQualityPrinting = 1<<0;
        #[doc(alias = "kCGPDFAllowsHighQualityPrinting")]
        const AllowsHighQualityPrinting = 1<<1;
        #[doc(alias = "kCGPDFAllowsDocumentChanges")]
        const AllowsDocumentChanges = 1<<2;
        #[doc(alias = "kCGPDFAllowsDocumentAssembly")]
        const AllowsDocumentAssembly = 1<<3;
        #[doc(alias = "kCGPDFAllowsContentCopying")]
        const AllowsContentCopying = 1<<4;
        #[doc(alias = "kCGPDFAllowsContentAccessibility")]
        const AllowsContentAccessibility = 1<<5;
        #[doc(alias = "kCGPDFAllowsCommenting")]
        const AllowsCommenting = 1<<6;
        #[doc(alias = "kCGPDFAllowsFormFieldEntry")]
        const AllowsFormFieldEntry = 1<<7;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPDFAccessPermissions {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPDFAccessPermissions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgpdfoutlinetitle?language=objc)
    pub static kCGPDFOutlineTitle: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgpdfoutlinechildren?language=objc)
    pub static kCGPDFOutlineChildren: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgpdfoutlinedestination?language=objc)
    pub static kCGPDFOutlineDestination: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgpdfoutlinedestinationrect?language=objc)
    pub static kCGPDFOutlineDestinationRect: &'static CFString;
}

#[cfg(feature = "CGDataProvider")]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFDocumentCreateWithProvider(
    provider: Option<&CGDataProvider>,
) -> Option<CFRetained<CGPDFDocument>> {
    extern "C-unwind" {
        fn CGPDFDocumentCreateWithProvider(
            provider: Option<&CGDataProvider>,
        ) -> Option<NonNull<CGPDFDocument>>;
    }
    let ret = unsafe { CGPDFDocumentCreateWithProvider(provider) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGPDFDocumentCreateWithURL(
    url: Option<&CFURL>,
) -> Option<CFRetained<CGPDFDocument>> {
    extern "C-unwind" {
        fn CGPDFDocumentCreateWithURL(url: Option<&CFURL>) -> Option<NonNull<CGPDFDocument>>;
    }
    let ret = unsafe { CGPDFDocumentCreateWithURL(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    pub fn CGPDFDocumentGetVersion(
        document: Option<&CGPDFDocument>,
        major_version: NonNull<c_int>,
        minor_version: NonNull<c_int>,
    );
}

extern "C-unwind" {
    pub fn CGPDFDocumentIsEncrypted(document: Option<&CGPDFDocument>) -> bool;
}

extern "C-unwind" {
    pub fn CGPDFDocumentUnlockWithPassword(
        document: Option<&CGPDFDocument>,
        password: NonNull<c_char>,
    ) -> bool;
}

extern "C-unwind" {
    pub fn CGPDFDocumentIsUnlocked(document: Option<&CGPDFDocument>) -> bool;
}

extern "C-unwind" {
    pub fn CGPDFDocumentAllowsPrinting(document: Option<&CGPDFDocument>) -> bool;
}

extern "C-unwind" {
    pub fn CGPDFDocumentAllowsCopying(document: Option<&CGPDFDocument>) -> bool;
}

extern "C-unwind" {
    pub fn CGPDFDocumentGetNumberOfPages(document: Option<&CGPDFDocument>) -> usize;
}

#[cfg(feature = "CGPDFPage")]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFDocumentGetPage(
    document: Option<&CGPDFDocument>,
    page_number: usize,
) -> Option<CFRetained<CGPDFPage>> {
    extern "C-unwind" {
        fn CGPDFDocumentGetPage(
            document: Option<&CGPDFDocument>,
            page_number: usize,
        ) -> Option<NonNull<CGPDFPage>>;
    }
    let ret = unsafe { CGPDFDocumentGetPage(document, page_number) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDictionary")]
    pub fn CGPDFDocumentGetCatalog(document: Option<&CGPDFDocument>) -> CGPDFDictionaryRef;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDictionary")]
    pub fn CGPDFDocumentGetInfo(document: Option<&CGPDFDocument>) -> CGPDFDictionaryRef;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFArray")]
    pub fn CGPDFDocumentGetID(document: Option<&CGPDFDocument>) -> CGPDFArrayRef;
}

unsafe impl ConcreteType for CGPDFDocument {
    #[doc(alias = "CGPDFDocumentGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGPDFDocumentGetTypeID() -> CFTypeID;
        }
        unsafe { CGPDFDocumentGetTypeID() }
    }
}

#[inline]
pub unsafe extern "C-unwind" fn CGPDFDocumentGetOutline(
    document: &CGPDFDocument,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CGPDFDocumentGetOutline(document: &CGPDFDocument) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CGPDFDocumentGetOutline(document) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    pub fn CGPDFDocumentGetAccessPermissions(document: &CGPDFDocument) -> CGPDFAccessPermissions;
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGPDFDocumentGetMediaBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGPDFDocumentGetCropBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGPDFDocumentGetBleedBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGPDFDocumentGetTrimBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGPDFDocumentGetArtBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGPDFDocumentGetRotationAngle(document: Option<&CGPDFDocument>, page: c_int) -> c_int;
}
