//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimage?language=objc)
#[repr(C)]
pub struct CGImage {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "CGImage"]
    unsafe impl CGImage {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimagealphainfo?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGImageAlphaInfo(pub u32);
impl CGImageAlphaInfo {
    #[doc(alias = "kCGImageAlphaNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "kCGImageAlphaPremultipliedLast")]
    pub const PremultipliedLast: Self = Self(1);
    #[doc(alias = "kCGImageAlphaPremultipliedFirst")]
    pub const PremultipliedFirst: Self = Self(2);
    #[doc(alias = "kCGImageAlphaLast")]
    pub const Last: Self = Self(3);
    #[doc(alias = "kCGImageAlphaFirst")]
    pub const First: Self = Self(4);
    #[doc(alias = "kCGImageAlphaNoneSkipLast")]
    pub const NoneSkipLast: Self = Self(5);
    #[doc(alias = "kCGImageAlphaNoneSkipFirst")]
    pub const NoneSkipFirst: Self = Self(6);
    #[doc(alias = "kCGImageAlphaOnly")]
    pub const Only: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGImageAlphaInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGImageAlphaInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimagebyteorderinfo?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGImageByteOrderInfo(pub u32);
impl CGImageByteOrderInfo {
    #[doc(alias = "kCGImageByteOrderMask")]
    pub const OrderMask: Self = Self(0x7000);
    #[doc(alias = "kCGImageByteOrderDefault")]
    pub const OrderDefault: Self = Self(0 << 12);
    #[doc(alias = "kCGImageByteOrder16Little")]
    pub const Order16Little: Self = Self(1 << 12);
    #[doc(alias = "kCGImageByteOrder32Little")]
    pub const Order32Little: Self = Self(2 << 12);
    #[doc(alias = "kCGImageByteOrder16Big")]
    pub const Order16Big: Self = Self(3 << 12);
    #[doc(alias = "kCGImageByteOrder32Big")]
    pub const Order32Big: Self = Self(4 << 12);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGImageByteOrderInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGImageByteOrderInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimagepixelformatinfo?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGImagePixelFormatInfo(pub u32);
impl CGImagePixelFormatInfo {
    #[doc(alias = "kCGImagePixelFormatMask")]
    pub const Mask: Self = Self(0xF0000);
    #[doc(alias = "kCGImagePixelFormatPacked")]
    pub const Packed: Self = Self(0 << 16);
    #[doc(alias = "kCGImagePixelFormatRGB555")]
    pub const RGB555: Self = Self(1 << 16);
    #[doc(alias = "kCGImagePixelFormatRGB565")]
    pub const RGB565: Self = Self(2 << 16);
    #[doc(alias = "kCGImagePixelFormatRGB101010")]
    pub const RGB101010: Self = Self(3 << 16);
    #[doc(alias = "kCGImagePixelFormatRGBCIF10")]
    pub const RGBCIF10: Self = Self(4 << 16);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGImagePixelFormatInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGImagePixelFormatInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgbitmapinfo?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGBitmapInfo(pub u32);
bitflags::bitflags! {
    impl CGBitmapInfo: u32 {
        #[doc(alias = "kCGBitmapAlphaInfoMask")]
        const AlphaInfoMask = 0x1F;
        #[doc(alias = "kCGBitmapFloatInfoMask")]
        const FloatInfoMask = 0xF00;
        #[doc(alias = "kCGBitmapFloatComponents")]
        const FloatComponents = 1<<8;
        #[doc(alias = "kCGBitmapByteOrderMask")]
        const ByteOrderMask = CGImageByteOrderInfo::OrderMask.0;
        #[doc(alias = "kCGBitmapByteOrderDefault")]
        const ByteOrderDefault = CGImageByteOrderInfo::OrderDefault.0;
        #[doc(alias = "kCGBitmapByteOrder16Little")]
        const ByteOrder16Little = CGImageByteOrderInfo::Order16Little.0;
        #[doc(alias = "kCGBitmapByteOrder32Little")]
        const ByteOrder32Little = CGImageByteOrderInfo::Order32Little.0;
        #[doc(alias = "kCGBitmapByteOrder16Big")]
        const ByteOrder16Big = CGImageByteOrderInfo::Order16Big.0;
        #[doc(alias = "kCGBitmapByteOrder32Big")]
        const ByteOrder32Big = CGImageByteOrderInfo::Order32Big.0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGBitmapInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGBitmapInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CGImage {
    #[doc(alias = "CGImageGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGImageGetTypeID() -> CFTypeID;
        }
        unsafe { CGImageGetTypeID() }
    }
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreate(
    width: usize,
    height: usize,
    bits_per_component: usize,
    bits_per_pixel: usize,
    bytes_per_row: usize,
    space: Option<&CGColorSpace>,
    bitmap_info: CGBitmapInfo,
    provider: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
    intent: CGColorRenderingIntent,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreate(
            width: usize,
            height: usize,
            bits_per_component: usize,
            bits_per_pixel: usize,
            bytes_per_row: usize,
            space: Option<&CGColorSpace>,
            bitmap_info: CGBitmapInfo,
            provider: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
            intent: CGColorRenderingIntent,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe {
        CGImageCreate(
            width,
            height,
            bits_per_component,
            bits_per_pixel,
            bytes_per_row,
            space,
            bitmap_info,
            provider,
            decode,
            should_interpolate,
            intent,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGDataProvider")]
#[inline]
pub unsafe extern "C-unwind" fn CGImageMaskCreate(
    width: usize,
    height: usize,
    bits_per_component: usize,
    bits_per_pixel: usize,
    bytes_per_row: usize,
    provider: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageMaskCreate(
            width: usize,
            height: usize,
            bits_per_component: usize,
            bits_per_pixel: usize,
            bytes_per_row: usize,
            provider: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe {
        CGImageMaskCreate(
            width,
            height,
            bits_per_component,
            bits_per_pixel,
            bytes_per_row,
            provider,
            decode,
            should_interpolate,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateCopy(
    image: Option<&CGImage>,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateCopy(image: Option<&CGImage>) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateCopy(image) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithJPEGDataProvider(
    source: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
    intent: CGColorRenderingIntent,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithJPEGDataProvider(
            source: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
            intent: CGColorRenderingIntent,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret =
        unsafe { CGImageCreateWithJPEGDataProvider(source, decode, should_interpolate, intent) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithPNGDataProvider(
    source: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
    intent: CGColorRenderingIntent,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithPNGDataProvider(
            source: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
            intent: CGColorRenderingIntent,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret =
        unsafe { CGImageCreateWithPNGDataProvider(source, decode, should_interpolate, intent) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithImageInRect(
    image: Option<&CGImage>,
    rect: CGRect,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithImageInRect(
            image: Option<&CGImage>,
            rect: CGRect,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateWithImageInRect(image, rect) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithMask(
    image: Option<&CGImage>,
    mask: Option<&CGImage>,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithMask(
            image: Option<&CGImage>,
            mask: Option<&CGImage>,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateWithMask(image, mask) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithMaskingColors(
    image: Option<&CGImage>,
    components: *const CGFloat,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithMaskingColors(
            image: Option<&CGImage>,
            components: *const CGFloat,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateWithMaskingColors(image, components) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGColorSpace")]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateCopyWithColorSpace(
    image: Option<&CGImage>,
    space: Option<&CGColorSpace>,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateCopyWithColorSpace(
            image: Option<&CGImage>,
            space: Option<&CGColorSpace>,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateCopyWithColorSpace(image, space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithContentHeadroom(
    headroom: c_float,
    width: usize,
    height: usize,
    bits_per_component: usize,
    bits_per_pixel: usize,
    bytes_per_row: usize,
    space: Option<&CGColorSpace>,
    bitmap_info: CGBitmapInfo,
    provider: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
    intent: CGColorRenderingIntent,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithContentHeadroom(
            headroom: c_float,
            width: usize,
            height: usize,
            bits_per_component: usize,
            bits_per_pixel: usize,
            bytes_per_row: usize,
            space: Option<&CGColorSpace>,
            bitmap_info: CGBitmapInfo,
            provider: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
            intent: CGColorRenderingIntent,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe {
        CGImageCreateWithContentHeadroom(
            headroom,
            width,
            height,
            bits_per_component,
            bits_per_pixel,
            bytes_per_row,
            space,
            bitmap_info,
            provider,
            decode,
            should_interpolate,
            intent,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateCopyWithContentHeadroom(
    headroom: c_float,
    image: Option<&CGImage>,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateCopyWithContentHeadroom(
            headroom: c_float,
            image: Option<&CGImage>,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateCopyWithContentHeadroom(headroom, image) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdefaulthdrimagecontentheadroom?language=objc)
    pub static kCGDefaultHDRImageContentHeadroom: c_float;
}

extern "C-unwind" {
    pub fn CGImageGetContentHeadroom(image: Option<&CGImage>) -> c_float;
}

extern "C-unwind" {
    pub fn CGImageIsMask(image: Option<&CGImage>) -> bool;
}

extern "C-unwind" {
    pub fn CGImageGetWidth(image: Option<&CGImage>) -> usize;
}

extern "C-unwind" {
    pub fn CGImageGetHeight(image: Option<&CGImage>) -> usize;
}

extern "C-unwind" {
    pub fn CGImageGetBitsPerComponent(image: Option<&CGImage>) -> usize;
}

extern "C-unwind" {
    pub fn CGImageGetBitsPerPixel(image: Option<&CGImage>) -> usize;
}

extern "C-unwind" {
    pub fn CGImageGetBytesPerRow(image: Option<&CGImage>) -> usize;
}

#[cfg(feature = "CGColorSpace")]
#[inline]
pub unsafe extern "C-unwind" fn CGImageGetColorSpace(
    image: Option<&CGImage>,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGImageGetColorSpace(image: Option<&CGImage>) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGImageGetColorSpace(image) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    pub fn CGImageGetAlphaInfo(image: Option<&CGImage>) -> CGImageAlphaInfo;
}

#[cfg(feature = "CGDataProvider")]
#[inline]
pub unsafe extern "C-unwind" fn CGImageGetDataProvider(
    image: Option<&CGImage>,
) -> Option<CFRetained<CGDataProvider>> {
    extern "C-unwind" {
        fn CGImageGetDataProvider(image: Option<&CGImage>) -> Option<NonNull<CGDataProvider>>;
    }
    let ret = unsafe { CGImageGetDataProvider(image) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    pub fn CGImageGetDecode(image: Option<&CGImage>) -> *const CGFloat;
}

extern "C-unwind" {
    pub fn CGImageGetShouldInterpolate(image: Option<&CGImage>) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGColorSpace")]
    pub fn CGImageGetRenderingIntent(image: Option<&CGImage>) -> CGColorRenderingIntent;
}

extern "C-unwind" {
    pub fn CGImageGetBitmapInfo(image: Option<&CGImage>) -> CGBitmapInfo;
}

extern "C-unwind" {
    pub fn CGImageGetByteOrderInfo(image: Option<&CGImage>) -> CGImageByteOrderInfo;
}

extern "C-unwind" {
    pub fn CGImageGetPixelFormatInfo(image: Option<&CGImage>) -> CGImagePixelFormatInfo;
}

extern "C-unwind" {
    pub fn CGImageShouldToneMap(image: Option<&CGImage>) -> bool;
}

extern "C-unwind" {
    pub fn CGImageContainsImageSpecificToneMappingMetadata(image: Option<&CGImage>) -> bool;
}

#[inline]
pub unsafe extern "C-unwind" fn CGImageGetUTType(
    image: Option<&CGImage>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CGImageGetUTType(image: Option<&CGImage>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CGImageGetUTType(image) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}
