//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataprovider?language=objc)
#[repr(C)]
pub struct CGDataProvider {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "CGDataProvider"]
    unsafe impl CGDataProvider {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataprovidergetbytescallback?language=objc)
pub type CGDataProviderGetBytesCallback =
    Option<unsafe extern "C-unwind" fn(*mut c_void, NonNull<c_void>, usize) -> usize>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataproviderskipforwardcallback?language=objc)
#[cfg(feature = "libc")]
pub type CGDataProviderSkipForwardCallback =
    Option<unsafe extern "C-unwind" fn(*mut c_void, libc::off_t) -> libc::off_t>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataproviderrewindcallback?language=objc)
pub type CGDataProviderRewindCallback = Option<unsafe extern "C-unwind" fn(*mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataproviderreleaseinfocallback?language=objc)
pub type CGDataProviderReleaseInfoCallback = Option<unsafe extern "C-unwind" fn(*mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataprovidersequentialcallbacks?language=objc)
#[cfg(feature = "libc")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CGDataProviderSequentialCallbacks {
    pub version: c_uint,
    pub getBytes: CGDataProviderGetBytesCallback,
    pub skipForward: CGDataProviderSkipForwardCallback,
    pub rewind: CGDataProviderRewindCallback,
    pub releaseInfo: CGDataProviderReleaseInfoCallback,
}

#[cfg(all(feature = "libc", feature = "objc2"))]
unsafe impl Encode for CGDataProviderSequentialCallbacks {
    const ENCODING: Encoding = Encoding::Struct(
        "CGDataProviderSequentialCallbacks",
        &[
            <c_uint>::ENCODING,
            <CGDataProviderGetBytesCallback>::ENCODING,
            <CGDataProviderSkipForwardCallback>::ENCODING,
            <CGDataProviderRewindCallback>::ENCODING,
            <CGDataProviderReleaseInfoCallback>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for CGDataProviderSequentialCallbacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataprovidergetbytepointercallback?language=objc)
pub type CGDataProviderGetBytePointerCallback =
    Option<unsafe extern "C-unwind" fn(*mut c_void) -> *const c_void>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataproviderreleasebytepointercallback?language=objc)
pub type CGDataProviderReleaseBytePointerCallback =
    Option<unsafe extern "C-unwind" fn(*mut c_void, NonNull<c_void>)>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataprovidergetbytesatpositioncallback?language=objc)
#[cfg(feature = "libc")]
pub type CGDataProviderGetBytesAtPositionCallback =
    Option<unsafe extern "C-unwind" fn(*mut c_void, NonNull<c_void>, libc::off_t, usize) -> usize>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataproviderdirectcallbacks?language=objc)
#[cfg(feature = "libc")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CGDataProviderDirectCallbacks {
    pub version: c_uint,
    pub getBytePointer: CGDataProviderGetBytePointerCallback,
    pub releaseBytePointer: CGDataProviderReleaseBytePointerCallback,
    pub getBytesAtPosition: CGDataProviderGetBytesAtPositionCallback,
    pub releaseInfo: CGDataProviderReleaseInfoCallback,
}

#[cfg(all(feature = "libc", feature = "objc2"))]
unsafe impl Encode for CGDataProviderDirectCallbacks {
    const ENCODING: Encoding = Encoding::Struct(
        "CGDataProviderDirectCallbacks",
        &[
            <c_uint>::ENCODING,
            <CGDataProviderGetBytePointerCallback>::ENCODING,
            <CGDataProviderReleaseBytePointerCallback>::ENCODING,
            <CGDataProviderGetBytesAtPositionCallback>::ENCODING,
            <CGDataProviderReleaseInfoCallback>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for CGDataProviderDirectCallbacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CGDataProvider {
    #[doc(alias = "CGDataProviderGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGDataProviderGetTypeID() -> CFTypeID;
        }
        unsafe { CGDataProviderGetTypeID() }
    }
}

#[cfg(feature = "libc")]
#[inline]
pub unsafe extern "C-unwind" fn CGDataProviderCreateSequential(
    info: *mut c_void,
    callbacks: *const CGDataProviderSequentialCallbacks,
) -> Option<CFRetained<CGDataProvider>> {
    extern "C-unwind" {
        fn CGDataProviderCreateSequential(
            info: *mut c_void,
            callbacks: *const CGDataProviderSequentialCallbacks,
        ) -> Option<NonNull<CGDataProvider>>;
    }
    let ret = unsafe { CGDataProviderCreateSequential(info, callbacks) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "libc")]
#[inline]
pub unsafe extern "C-unwind" fn CGDataProviderCreateDirect(
    info: *mut c_void,
    size: libc::off_t,
    callbacks: *const CGDataProviderDirectCallbacks,
) -> Option<CFRetained<CGDataProvider>> {
    extern "C-unwind" {
        fn CGDataProviderCreateDirect(
            info: *mut c_void,
            size: libc::off_t,
            callbacks: *const CGDataProviderDirectCallbacks,
        ) -> Option<NonNull<CGDataProvider>>;
    }
    let ret = unsafe { CGDataProviderCreateDirect(info, size, callbacks) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdataproviderreleasedatacallback?language=objc)
pub type CGDataProviderReleaseDataCallback =
    Option<unsafe extern "C-unwind" fn(*mut c_void, NonNull<c_void>, usize)>;

#[inline]
pub unsafe extern "C-unwind" fn CGDataProviderCreateWithData(
    info: *mut c_void,
    data: *const c_void,
    size: usize,
    release_data: CGDataProviderReleaseDataCallback,
) -> Option<CFRetained<CGDataProvider>> {
    extern "C-unwind" {
        fn CGDataProviderCreateWithData(
            info: *mut c_void,
            data: *const c_void,
            size: usize,
            release_data: CGDataProviderReleaseDataCallback,
        ) -> Option<NonNull<CGDataProvider>>;
    }
    let ret = unsafe { CGDataProviderCreateWithData(info, data, size, release_data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGDataProviderCreateWithCFData(
    data: Option<&CFData>,
) -> Option<CFRetained<CGDataProvider>> {
    extern "C-unwind" {
        fn CGDataProviderCreateWithCFData(data: Option<&CFData>)
            -> Option<NonNull<CGDataProvider>>;
    }
    let ret = unsafe { CGDataProviderCreateWithCFData(data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGDataProviderCreateWithURL(
    url: Option<&CFURL>,
) -> Option<CFRetained<CGDataProvider>> {
    extern "C-unwind" {
        fn CGDataProviderCreateWithURL(url: Option<&CFURL>) -> Option<NonNull<CGDataProvider>>;
    }
    let ret = unsafe { CGDataProviderCreateWithURL(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGDataProviderCreateWithFilename(
    filename: *const c_char,
) -> Option<CFRetained<CGDataProvider>> {
    extern "C-unwind" {
        fn CGDataProviderCreateWithFilename(
            filename: *const c_char,
        ) -> Option<NonNull<CGDataProvider>>;
    }
    let ret = unsafe { CGDataProviderCreateWithFilename(filename) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGDataProviderCopyData(
    provider: Option<&CGDataProvider>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CGDataProviderCopyData(provider: Option<&CGDataProvider>) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CGDataProviderCopyData(provider) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    pub fn CGDataProviderGetInfo(provider: Option<&CGDataProvider>) -> *mut c_void;
}
