//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgcontext?language=objc)
#[repr(C)]
pub struct CGContext {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "CGContext"]
    unsafe impl CGContext {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpathdrawingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGPathDrawingMode(pub i32);
impl CGPathDrawingMode {
    #[doc(alias = "kCGPathFill")]
    pub const Fill: Self = Self(0);
    #[doc(alias = "kCGPathEOFill")]
    pub const EOFill: Self = Self(1);
    #[doc(alias = "kCGPathStroke")]
    pub const Stroke: Self = Self(2);
    #[doc(alias = "kCGPathFillStroke")]
    pub const FillStroke: Self = Self(3);
    #[doc(alias = "kCGPathEOFillStroke")]
    pub const EOFillStroke: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPathDrawingMode {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPathDrawingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgtextdrawingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGTextDrawingMode(pub i32);
impl CGTextDrawingMode {
    #[doc(alias = "kCGTextFill")]
    pub const Fill: Self = Self(0);
    #[doc(alias = "kCGTextStroke")]
    pub const Stroke: Self = Self(1);
    #[doc(alias = "kCGTextFillStroke")]
    pub const FillStroke: Self = Self(2);
    #[doc(alias = "kCGTextInvisible")]
    pub const Invisible: Self = Self(3);
    #[doc(alias = "kCGTextFillClip")]
    pub const FillClip: Self = Self(4);
    #[doc(alias = "kCGTextStrokeClip")]
    pub const StrokeClip: Self = Self(5);
    #[doc(alias = "kCGTextFillStrokeClip")]
    pub const FillStrokeClip: Self = Self(6);
    #[doc(alias = "kCGTextClip")]
    pub const Clip: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGTextDrawingMode {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGTextDrawingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgtextencoding?language=objc)
// NS_ENUM
#[deprecated = "No longer supported"]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGTextEncoding(pub i32);
impl CGTextEncoding {
    #[deprecated = "No longer supported"]
    #[doc(alias = "kCGEncodingFontSpecific")]
    pub const EncodingFontSpecific: Self = Self(0);
    #[deprecated = "No longer supported"]
    #[doc(alias = "kCGEncodingMacRoman")]
    pub const EncodingMacRoman: Self = Self(1);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGTextEncoding {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGTextEncoding {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cginterpolationquality?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGInterpolationQuality(pub i32);
impl CGInterpolationQuality {
    #[doc(alias = "kCGInterpolationDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "kCGInterpolationNone")]
    pub const None: Self = Self(1);
    #[doc(alias = "kCGInterpolationLow")]
    pub const Low: Self = Self(2);
    #[doc(alias = "kCGInterpolationMedium")]
    pub const Medium: Self = Self(4);
    #[doc(alias = "kCGInterpolationHigh")]
    pub const High: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGInterpolationQuality {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGInterpolationQuality {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgblendmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGBlendMode(pub i32);
impl CGBlendMode {
    #[doc(alias = "kCGBlendModeNormal")]
    pub const Normal: Self = Self(0);
    #[doc(alias = "kCGBlendModeMultiply")]
    pub const Multiply: Self = Self(1);
    #[doc(alias = "kCGBlendModeScreen")]
    pub const Screen: Self = Self(2);
    #[doc(alias = "kCGBlendModeOverlay")]
    pub const Overlay: Self = Self(3);
    #[doc(alias = "kCGBlendModeDarken")]
    pub const Darken: Self = Self(4);
    #[doc(alias = "kCGBlendModeLighten")]
    pub const Lighten: Self = Self(5);
    #[doc(alias = "kCGBlendModeColorDodge")]
    pub const ColorDodge: Self = Self(6);
    #[doc(alias = "kCGBlendModeColorBurn")]
    pub const ColorBurn: Self = Self(7);
    #[doc(alias = "kCGBlendModeSoftLight")]
    pub const SoftLight: Self = Self(8);
    #[doc(alias = "kCGBlendModeHardLight")]
    pub const HardLight: Self = Self(9);
    #[doc(alias = "kCGBlendModeDifference")]
    pub const Difference: Self = Self(10);
    #[doc(alias = "kCGBlendModeExclusion")]
    pub const Exclusion: Self = Self(11);
    #[doc(alias = "kCGBlendModeHue")]
    pub const Hue: Self = Self(12);
    #[doc(alias = "kCGBlendModeSaturation")]
    pub const Saturation: Self = Self(13);
    #[doc(alias = "kCGBlendModeColor")]
    pub const Color: Self = Self(14);
    #[doc(alias = "kCGBlendModeLuminosity")]
    pub const Luminosity: Self = Self(15);
    #[doc(alias = "kCGBlendModeClear")]
    pub const Clear: Self = Self(16);
    #[doc(alias = "kCGBlendModeCopy")]
    pub const Copy: Self = Self(17);
    #[doc(alias = "kCGBlendModeSourceIn")]
    pub const SourceIn: Self = Self(18);
    #[doc(alias = "kCGBlendModeSourceOut")]
    pub const SourceOut: Self = Self(19);
    #[doc(alias = "kCGBlendModeSourceAtop")]
    pub const SourceAtop: Self = Self(20);
    #[doc(alias = "kCGBlendModeDestinationOver")]
    pub const DestinationOver: Self = Self(21);
    #[doc(alias = "kCGBlendModeDestinationIn")]
    pub const DestinationIn: Self = Self(22);
    #[doc(alias = "kCGBlendModeDestinationOut")]
    pub const DestinationOut: Self = Self(23);
    #[doc(alias = "kCGBlendModeDestinationAtop")]
    pub const DestinationAtop: Self = Self(24);
    #[doc(alias = "kCGBlendModeXOR")]
    pub const XOR: Self = Self(25);
    #[doc(alias = "kCGBlendModePlusDarker")]
    pub const PlusDarker: Self = Self(26);
    #[doc(alias = "kCGBlendModePlusLighter")]
    pub const PlusLighter: Self = Self(27);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGBlendMode {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGBlendMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CGContext {
    #[doc(alias = "CGContextGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGContextGetTypeID() -> CFTypeID;
        }
        unsafe { CGContextGetTypeID() }
    }
}

extern "C-unwind" {
    /// Graphics state functions. *
    pub fn CGContextSaveGState(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextRestoreGState(c: Option<&CGContext>);
}

extern "C-unwind" {
    /// Coordinate space transformations. *
    pub fn CGContextScaleCTM(c: Option<&CGContext>, sx: CGFloat, sy: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextTranslateCTM(c: Option<&CGContext>, tx: CGFloat, ty: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextRotateCTM(c: Option<&CGContext>, angle: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextConcatCTM(c: Option<&CGContext>, transform: CGAffineTransform);
}

extern "C-unwind" {
    pub fn CGContextGetCTM(c: Option<&CGContext>) -> CGAffineTransform;
}

extern "C-unwind" {
    /// Drawing attribute functions. *
    pub fn CGContextSetLineWidth(c: Option<&CGContext>, width: CGFloat);
}

extern "C-unwind" {
    #[cfg(feature = "CGPath")]
    pub fn CGContextSetLineCap(c: Option<&CGContext>, cap: CGLineCap);
}

extern "C-unwind" {
    #[cfg(feature = "CGPath")]
    pub fn CGContextSetLineJoin(c: Option<&CGContext>, join: CGLineJoin);
}

extern "C-unwind" {
    pub fn CGContextSetMiterLimit(c: Option<&CGContext>, limit: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextSetLineDash(
        c: Option<&CGContext>,
        phase: CGFloat,
        lengths: *const CGFloat,
        count: usize,
    );
}

extern "C-unwind" {
    pub fn CGContextSetFlatness(c: Option<&CGContext>, flatness: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextSetAlpha(c: Option<&CGContext>, alpha: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextSetBlendMode(c: Option<&CGContext>, mode: CGBlendMode);
}

extern "C-unwind" {
    /// Path construction functions. *
    pub fn CGContextBeginPath(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextMoveToPoint(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextAddLineToPoint(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextAddCurveToPoint(
        c: Option<&CGContext>,
        cp1x: CGFloat,
        cp1y: CGFloat,
        cp2x: CGFloat,
        cp2y: CGFloat,
        x: CGFloat,
        y: CGFloat,
    );
}

extern "C-unwind" {
    pub fn CGContextAddQuadCurveToPoint(
        c: Option<&CGContext>,
        cpx: CGFloat,
        cpy: CGFloat,
        x: CGFloat,
        y: CGFloat,
    );
}

extern "C-unwind" {
    pub fn CGContextClosePath(c: Option<&CGContext>);
}

extern "C-unwind" {
    /// Path construction convenience functions. *
    pub fn CGContextAddRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    pub fn CGContextAddRects(c: Option<&CGContext>, rects: *const CGRect, count: usize);
}

extern "C-unwind" {
    pub fn CGContextAddLines(c: Option<&CGContext>, points: *const CGPoint, count: usize);
}

extern "C-unwind" {
    pub fn CGContextAddEllipseInRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    pub fn CGContextAddArc(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        radius: CGFloat,
        start_angle: CGFloat,
        end_angle: CGFloat,
        clockwise: c_int,
    );
}

extern "C-unwind" {
    pub fn CGContextAddArcToPoint(
        c: Option<&CGContext>,
        x1: CGFloat,
        y1: CGFloat,
        x2: CGFloat,
        y2: CGFloat,
        radius: CGFloat,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGPath")]
    pub fn CGContextAddPath(c: Option<&CGContext>, path: Option<&CGPath>);
}

extern "C-unwind" {
    pub fn CGContextReplacePathWithStrokedPath(c: Option<&CGContext>);
}

extern "C-unwind" {
    /// Path information functions. *
    pub fn CGContextIsPathEmpty(c: Option<&CGContext>) -> bool;
}

extern "C-unwind" {
    pub fn CGContextGetPathCurrentPoint(c: Option<&CGContext>) -> CGPoint;
}

extern "C-unwind" {
    pub fn CGContextGetPathBoundingBox(c: Option<&CGContext>) -> CGRect;
}

#[cfg(feature = "CGPath")]
#[inline]
pub unsafe extern "C-unwind" fn CGContextCopyPath(
    c: Option<&CGContext>,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGContextCopyPath(c: Option<&CGContext>) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGContextCopyPath(c) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    pub fn CGContextPathContainsPoint(
        c: Option<&CGContext>,
        point: CGPoint,
        mode: CGPathDrawingMode,
    ) -> bool;
}

extern "C-unwind" {
    /// Path drawing functions. *
    pub fn CGContextDrawPath(c: Option<&CGContext>, mode: CGPathDrawingMode);
}

extern "C-unwind" {
    /// Path drawing convenience functions. *
    pub fn CGContextFillPath(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextEOFillPath(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextStrokePath(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextFillRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    pub fn CGContextFillRects(c: Option<&CGContext>, rects: *const CGRect, count: usize);
}

extern "C-unwind" {
    pub fn CGContextStrokeRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    pub fn CGContextStrokeRectWithWidth(c: Option<&CGContext>, rect: CGRect, width: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextClearRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    pub fn CGContextFillEllipseInRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    pub fn CGContextStrokeEllipseInRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    pub fn CGContextStrokeLineSegments(c: Option<&CGContext>, points: *const CGPoint, count: usize);
}

extern "C-unwind" {
    /// Clipping functions. *
    pub fn CGContextClip(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextEOClip(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextResetClip(c: &CGContext);
}

extern "C-unwind" {
    #[cfg(feature = "CGImage")]
    pub fn CGContextClipToMask(c: Option<&CGContext>, rect: CGRect, mask: Option<&CGImage>);
}

extern "C-unwind" {
    pub fn CGContextGetClipBoundingBox(c: Option<&CGContext>) -> CGRect;
}

extern "C-unwind" {
    /// Clipping convenience functions. *
    pub fn CGContextClipToRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    pub fn CGContextClipToRects(c: Option<&CGContext>, rects: NonNull<CGRect>, count: usize);
}

extern "C-unwind" {
    /// Primitive color functions. *
    #[cfg(feature = "CGColor")]
    pub fn CGContextSetFillColorWithColor(c: Option<&CGContext>, color: Option<&CGColor>);
}

extern "C-unwind" {
    #[cfg(feature = "CGColor")]
    pub fn CGContextSetStrokeColorWithColor(c: Option<&CGContext>, color: Option<&CGColor>);
}

extern "C-unwind" {
    /// Color space functions. *
    #[cfg(feature = "CGColorSpace")]
    pub fn CGContextSetFillColorSpace(c: Option<&CGContext>, space: Option<&CGColorSpace>);
}

extern "C-unwind" {
    #[cfg(feature = "CGColorSpace")]
    pub fn CGContextSetStrokeColorSpace(c: Option<&CGContext>, space: Option<&CGColorSpace>);
}

extern "C-unwind" {
    /// Color functions. *
    pub fn CGContextSetFillColor(c: Option<&CGContext>, components: *const CGFloat);
}

extern "C-unwind" {
    pub fn CGContextSetStrokeColor(c: Option<&CGContext>, components: *const CGFloat);
}

extern "C-unwind" {
    /// Pattern functions. *
    #[cfg(feature = "CGPattern")]
    pub fn CGContextSetFillPattern(
        c: Option<&CGContext>,
        pattern: Option<&CGPattern>,
        components: *const CGFloat,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGPattern")]
    pub fn CGContextSetStrokePattern(
        c: Option<&CGContext>,
        pattern: Option<&CGPattern>,
        components: *const CGFloat,
    );
}

extern "C-unwind" {
    pub fn CGContextSetPatternPhase(c: Option<&CGContext>, phase: CGSize);
}

extern "C-unwind" {
    /// Color convenience functions. *
    pub fn CGContextSetGrayFillColor(c: Option<&CGContext>, gray: CGFloat, alpha: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextSetGrayStrokeColor(c: Option<&CGContext>, gray: CGFloat, alpha: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextSetRGBFillColor(
        c: Option<&CGContext>,
        red: CGFloat,
        green: CGFloat,
        blue: CGFloat,
        alpha: CGFloat,
    );
}

extern "C-unwind" {
    pub fn CGContextSetRGBStrokeColor(
        c: Option<&CGContext>,
        red: CGFloat,
        green: CGFloat,
        blue: CGFloat,
        alpha: CGFloat,
    );
}

extern "C-unwind" {
    pub fn CGContextSetCMYKFillColor(
        c: Option<&CGContext>,
        cyan: CGFloat,
        magenta: CGFloat,
        yellow: CGFloat,
        black: CGFloat,
        alpha: CGFloat,
    );
}

extern "C-unwind" {
    pub fn CGContextSetCMYKStrokeColor(
        c: Option<&CGContext>,
        cyan: CGFloat,
        magenta: CGFloat,
        yellow: CGFloat,
        black: CGFloat,
        alpha: CGFloat,
    );
}

extern "C-unwind" {
    /// Rendering intent. *
    #[cfg(feature = "CGColorSpace")]
    pub fn CGContextSetRenderingIntent(c: Option<&CGContext>, intent: CGColorRenderingIntent);
}

extern "C-unwind" {
    pub fn CGContextSetEDRTargetHeadroom(c: &CGContext, headroom: c_float) -> bool;
}

extern "C-unwind" {
    pub fn CGContextGetEDRTargetHeadroom(c: &CGContext) -> c_float;
}

extern "C-unwind" {
    /// Image functions. *
    #[cfg(feature = "CGImage")]
    pub fn CGContextDrawImage(c: Option<&CGContext>, rect: CGRect, image: Option<&CGImage>);
}

extern "C-unwind" {
    #[cfg(feature = "CGImage")]
    pub fn CGContextDrawTiledImage(c: Option<&CGContext>, rect: CGRect, image: Option<&CGImage>);
}

extern "C-unwind" {
    #[cfg(all(feature = "CGImage", feature = "CGToneMapping"))]
    pub fn CGContextDrawImageApplyingToneMapping(
        c: &CGContext,
        r: CGRect,
        image: &CGImage,
        method: CGToneMapping,
        options: Option<&CFDictionary>,
    ) -> bool;
}

extern "C-unwind" {
    pub fn CGContextGetInterpolationQuality(c: Option<&CGContext>) -> CGInterpolationQuality;
}

extern "C-unwind" {
    pub fn CGContextSetInterpolationQuality(c: Option<&CGContext>, quality: CGInterpolationQuality);
}

extern "C-unwind" {
    #[cfg(feature = "CGColor")]
    pub fn CGContextSetShadowWithColor(
        c: Option<&CGContext>,
        offset: CGSize,
        blur: CGFloat,
        color: Option<&CGColor>,
    );
}

extern "C-unwind" {
    pub fn CGContextSetShadow(c: Option<&CGContext>, offset: CGSize, blur: CGFloat);
}

extern "C-unwind" {
    #[cfg(feature = "CGGradient")]
    pub fn CGContextDrawLinearGradient(
        c: Option<&CGContext>,
        gradient: Option<&CGGradient>,
        start_point: CGPoint,
        end_point: CGPoint,
        options: CGGradientDrawingOptions,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGGradient")]
    pub fn CGContextDrawRadialGradient(
        c: Option<&CGContext>,
        gradient: Option<&CGGradient>,
        start_center: CGPoint,
        start_radius: CGFloat,
        end_center: CGPoint,
        end_radius: CGFloat,
        options: CGGradientDrawingOptions,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGGradient")]
    pub fn CGContextDrawConicGradient(
        c: &CGContext,
        gradient: Option<&CGGradient>,
        center: CGPoint,
        angle: CGFloat,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGShading")]
    pub fn CGContextDrawShading(c: Option<&CGContext>, shading: Option<&CGShading>);
}

extern "C-unwind" {
    /// Text functions. *
    pub fn CGContextSetCharacterSpacing(c: Option<&CGContext>, spacing: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextSetTextPosition(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
}

extern "C-unwind" {
    pub fn CGContextGetTextPosition(c: Option<&CGContext>) -> CGPoint;
}

extern "C-unwind" {
    pub fn CGContextSetTextMatrix(c: Option<&CGContext>, t: CGAffineTransform);
}

extern "C-unwind" {
    pub fn CGContextGetTextMatrix(c: Option<&CGContext>) -> CGAffineTransform;
}

extern "C-unwind" {
    pub fn CGContextSetTextDrawingMode(c: Option<&CGContext>, mode: CGTextDrawingMode);
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    pub fn CGContextSetFont(c: Option<&CGContext>, font: Option<&CGFont>);
}

extern "C-unwind" {
    pub fn CGContextSetFontSize(c: Option<&CGContext>, size: CGFloat);
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    pub fn CGContextShowGlyphsAtPositions(
        c: Option<&CGContext>,
        glyphs: *const CGGlyph,
        lpositions: *const CGPoint,
        count: usize,
    );
}

extern "C-unwind" {
    /// PDF functions. *
    #[cfg(feature = "CGPDFPage")]
    pub fn CGContextDrawPDFPage(c: Option<&CGContext>, page: Option<&CGPDFPage>);
}

extern "C-unwind" {
    /// Output page functions. *
    pub fn CGContextBeginPage(c: Option<&CGContext>, media_box: *const CGRect);
}

extern "C-unwind" {
    pub fn CGContextEndPage(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextFlush(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextSynchronize(c: Option<&CGContext>);
}

extern "C-unwind" {
    pub fn CGContextSetShouldAntialias(c: Option<&CGContext>, should_antialias: bool);
}

extern "C-unwind" {
    pub fn CGContextSetAllowsAntialiasing(c: Option<&CGContext>, allows_antialiasing: bool);
}

extern "C-unwind" {
    pub fn CGContextSetShouldSmoothFonts(c: Option<&CGContext>, should_smooth_fonts: bool);
}

extern "C-unwind" {
    pub fn CGContextSetAllowsFontSmoothing(c: Option<&CGContext>, allows_font_smoothing: bool);
}

extern "C-unwind" {
    pub fn CGContextSetShouldSubpixelPositionFonts(
        c: Option<&CGContext>,
        should_subpixel_position_fonts: bool,
    );
}

extern "C-unwind" {
    pub fn CGContextSetAllowsFontSubpixelPositioning(
        c: Option<&CGContext>,
        allows_font_subpixel_positioning: bool,
    );
}

extern "C-unwind" {
    pub fn CGContextSetShouldSubpixelQuantizeFonts(
        c: Option<&CGContext>,
        should_subpixel_quantize_fonts: bool,
    );
}

extern "C-unwind" {
    pub fn CGContextSetAllowsFontSubpixelQuantization(
        c: Option<&CGContext>,
        allows_font_subpixel_quantization: bool,
    );
}

extern "C-unwind" {
    /// Transparency layer support. *
    pub fn CGContextBeginTransparencyLayer(
        c: Option<&CGContext>,
        auxiliary_info: Option<&CFDictionary>,
    );
}

extern "C-unwind" {
    pub fn CGContextBeginTransparencyLayerWithRect(
        c: Option<&CGContext>,
        rect: CGRect,
        aux_info: Option<&CFDictionary>,
    );
}

extern "C-unwind" {
    pub fn CGContextEndTransparencyLayer(c: Option<&CGContext>);
}

extern "C-unwind" {
    /// User space to device space tranformations. *
    pub fn CGContextGetUserSpaceToDeviceSpaceTransform(c: Option<&CGContext>) -> CGAffineTransform;
}

extern "C-unwind" {
    pub fn CGContextConvertPointToDeviceSpace(c: Option<&CGContext>, point: CGPoint) -> CGPoint;
}

extern "C-unwind" {
    pub fn CGContextConvertPointToUserSpace(c: Option<&CGContext>, point: CGPoint) -> CGPoint;
}

extern "C-unwind" {
    pub fn CGContextConvertSizeToDeviceSpace(c: Option<&CGContext>, size: CGSize) -> CGSize;
}

extern "C-unwind" {
    pub fn CGContextConvertSizeToUserSpace(c: Option<&CGContext>, size: CGSize) -> CGSize;
}

extern "C-unwind" {
    pub fn CGContextConvertRectToDeviceSpace(c: Option<&CGContext>, rect: CGRect) -> CGRect;
}

extern "C-unwind" {
    pub fn CGContextConvertRectToUserSpace(c: Option<&CGContext>, rect: CGRect) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGContextSelectFont(
        c: Option<&CGContext>,
        name: *const c_char,
        size: CGFloat,
        text_encoding: CGTextEncoding,
    );
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGContextShowText(c: Option<&CGContext>, string: *const c_char, length: usize);
}

extern "C-unwind" {
    #[deprecated = "No longer supported"]
    pub fn CGContextShowTextAtPoint(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        string: *const c_char,
        length: usize,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    #[deprecated = "No longer supported"]
    pub fn CGContextShowGlyphs(c: Option<&CGContext>, g: *const CGGlyph, count: usize);
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    #[deprecated = "No longer supported"]
    pub fn CGContextShowGlyphsAtPoint(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        glyphs: *const CGGlyph,
        count: usize,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    #[deprecated = "No longer supported"]
    pub fn CGContextShowGlyphsWithAdvances(
        c: Option<&CGContext>,
        glyphs: *const CGGlyph,
        advances: *const CGSize,
        count: usize,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDocument")]
    #[deprecated = "No longer supported"]
    pub fn CGContextDrawPDFDocument(
        c: Option<&CGContext>,
        rect: CGRect,
        document: Option<&CGPDFDocument>,
        page: c_int,
    );
}
