//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgcolorspace?language=objc)
#[repr(C)]
pub struct CGColorSpace {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "CGColorSpace"]
    unsafe impl CGColorSpace {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgcolorrenderingintent?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGColorRenderingIntent(pub i32);
impl CGColorRenderingIntent {
    #[doc(alias = "kCGRenderingIntentDefault")]
    pub const RenderingIntentDefault: Self = Self(0);
    #[doc(alias = "kCGRenderingIntentAbsoluteColorimetric")]
    pub const RenderingIntentAbsoluteColorimetric: Self = Self(1);
    #[doc(alias = "kCGRenderingIntentRelativeColorimetric")]
    pub const RenderingIntentRelativeColorimetric: Self = Self(2);
    #[doc(alias = "kCGRenderingIntentPerceptual")]
    pub const RenderingIntentPerceptual: Self = Self(3);
    #[doc(alias = "kCGRenderingIntentSaturation")]
    pub const RenderingIntentSaturation: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGColorRenderingIntent {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGColorRenderingIntent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgcolorspacemodel?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGColorSpaceModel(pub i32);
impl CGColorSpaceModel {
    #[doc(alias = "kCGColorSpaceModelUnknown")]
    pub const Unknown: Self = Self(-1);
    #[doc(alias = "kCGColorSpaceModelMonochrome")]
    pub const Monochrome: Self = Self(0);
    #[doc(alias = "kCGColorSpaceModelRGB")]
    pub const RGB: Self = Self(1);
    #[doc(alias = "kCGColorSpaceModelCMYK")]
    pub const CMYK: Self = Self(2);
    #[doc(alias = "kCGColorSpaceModelLab")]
    pub const Lab: Self = Self(3);
    #[doc(alias = "kCGColorSpaceModelDeviceN")]
    pub const DeviceN: Self = Self(4);
    #[doc(alias = "kCGColorSpaceModelIndexed")]
    pub const Indexed: Self = Self(5);
    #[doc(alias = "kCGColorSpaceModelPattern")]
    pub const Pattern: Self = Self(6);
    #[doc(alias = "kCGColorSpaceModelXYZ")]
    pub const XYZ: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGColorSpaceModel {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGColorSpaceModel {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacegenericgray?language=objc)
    pub static kCGColorSpaceGenericGray: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacegenericrgb?language=objc)
    pub static kCGColorSpaceGenericRGB: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacegenericcmyk?language=objc)
    pub static kCGColorSpaceGenericCMYK: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacedisplayp3?language=objc)
    pub static kCGColorSpaceDisplayP3: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacegenericrgblinear?language=objc)
    pub static kCGColorSpaceGenericRGBLinear: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceadobergb1998?language=objc)
    pub static kCGColorSpaceAdobeRGB1998: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacesrgb?language=objc)
    pub static kCGColorSpaceSRGB: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacegenericgraygamma2_2?language=objc)
    pub static kCGColorSpaceGenericGrayGamma2_2: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacegenericxyz?language=objc)
    pub static kCGColorSpaceGenericXYZ: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacegenericlab?language=objc)
    pub static kCGColorSpaceGenericLab: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceacescglinear?language=objc)
    pub static kCGColorSpaceACESCGLinear: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_709?language=objc)
    pub static kCGColorSpaceITUR_709: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_709_pq?language=objc)
    pub static kCGColorSpaceITUR_709_PQ: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_709_hlg?language=objc)
    pub static kCGColorSpaceITUR_709_HLG: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_2020?language=objc)
    pub static kCGColorSpaceITUR_2020: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_2020_srgbgamma?language=objc)
    pub static kCGColorSpaceITUR_2020_sRGBGamma: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacerommrgb?language=objc)
    pub static kCGColorSpaceROMMRGB: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacedcip3?language=objc)
    pub static kCGColorSpaceDCIP3: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacelinearitur_2020?language=objc)
    pub static kCGColorSpaceLinearITUR_2020: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendeditur_2020?language=objc)
    pub static kCGColorSpaceExtendedITUR_2020: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendedlinearitur_2020?language=objc)
    pub static kCGColorSpaceExtendedLinearITUR_2020: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacelineardisplayp3?language=objc)
    pub static kCGColorSpaceLinearDisplayP3: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendeddisplayp3?language=objc)
    pub static kCGColorSpaceExtendedDisplayP3: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendedlineardisplayp3?language=objc)
    pub static kCGColorSpaceExtendedLinearDisplayP3: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_2100_pq?language=objc)
    pub static kCGColorSpaceITUR_2100_PQ: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_2100_hlg?language=objc)
    pub static kCGColorSpaceITUR_2100_HLG: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacedisplayp3_pq?language=objc)
    pub static kCGColorSpaceDisplayP3_PQ: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacedisplayp3_hlg?language=objc)
    pub static kCGColorSpaceDisplayP3_HLG: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_2020_pq?language=objc)
    pub static kCGColorSpaceITUR_2020_PQ: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_2020_hlg?language=objc)
    pub static kCGColorSpaceITUR_2020_HLG: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacedisplayp3_pq_eotf?language=objc)
    pub static kCGColorSpaceDisplayP3_PQ_EOTF: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceitur_2020_pq_eotf?language=objc)
    pub static kCGColorSpaceITUR_2020_PQ_EOTF: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendedsrgb?language=objc)
    pub static kCGColorSpaceExtendedSRGB: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacelinearsrgb?language=objc)
    pub static kCGColorSpaceLinearSRGB: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendedlinearsrgb?language=objc)
    pub static kCGColorSpaceExtendedLinearSRGB: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendedgray?language=objc)
    pub static kCGColorSpaceExtendedGray: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacelineargray?language=objc)
    pub static kCGColorSpaceLinearGray: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendedlineargray?language=objc)
    pub static kCGColorSpaceExtendedLinearGray: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspacecoremedia709?language=objc)
    pub static kCGColorSpaceCoreMedia709: &'static CFString;
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateDeviceGray() -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateDeviceGray() -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateDeviceGray() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateDeviceRGB() -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateDeviceRGB() -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateDeviceRGB() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateDeviceCMYK() -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateDeviceCMYK() -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateDeviceCMYK() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateWithICCData(
    data: Option<&CFType>,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateWithICCData(data: Option<&CFType>) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateWithICCData(data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGDataProvider")]
#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateICCBased(
    n_components: usize,
    range: *const CGFloat,
    profile: Option<&CGDataProvider>,
    alternate: Option<&CGColorSpace>,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateICCBased(
            n_components: usize,
            range: *const CGFloat,
            profile: Option<&CGDataProvider>,
            alternate: Option<&CGColorSpace>,
        ) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateICCBased(n_components, range, profile, alternate) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateIndexed(
    base_space: Option<&CGColorSpace>,
    last_index: usize,
    color_table: *const c_uchar,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateIndexed(
            base_space: Option<&CGColorSpace>,
            last_index: usize,
            color_table: *const c_uchar,
        ) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateIndexed(base_space, last_index, color_table) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreatePattern(
    base_space: Option<&CGColorSpace>,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreatePattern(
            base_space: Option<&CGColorSpace>,
        ) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreatePattern(base_space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgcolorspaceextendedrange?language=objc)
    pub static kCGColorSpaceExtendedRange: &'static CFString;
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateWithName(
    name: Option<&CFString>,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateWithName(name: Option<&CFString>) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateWithName(name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceGetName(
    space: Option<&CGColorSpace>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CGColorSpaceGetName(space: Option<&CGColorSpace>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CGColorSpaceGetName(space) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCopyName(
    space: Option<&CGColorSpace>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CGColorSpaceCopyName(space: Option<&CGColorSpace>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CGColorSpaceCopyName(space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

unsafe impl ConcreteType for CGColorSpace {
    #[doc(alias = "CGColorSpaceGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGColorSpaceGetTypeID() -> CFTypeID;
        }
        unsafe { CGColorSpaceGetTypeID() }
    }
}

extern "C-unwind" {
    pub fn CGColorSpaceGetNumberOfComponents(space: Option<&CGColorSpace>) -> usize;
}

extern "C-unwind" {
    pub fn CGColorSpaceGetModel(space: Option<&CGColorSpace>) -> CGColorSpaceModel;
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceGetBaseColorSpace(
    space: Option<&CGColorSpace>,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceGetBaseColorSpace(
            space: Option<&CGColorSpace>,
        ) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceGetBaseColorSpace(space) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCopyBaseColorSpace(
    space: &CGColorSpace,
) -> CFRetained<CGColorSpace> {
    extern "C-unwind" {
        fn CGColorSpaceCopyBaseColorSpace(space: &CGColorSpace) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCopyBaseColorSpace(space) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    pub fn CGColorSpaceGetColorTableCount(space: Option<&CGColorSpace>) -> usize;
}

extern "C-unwind" {
    pub fn CGColorSpaceGetColorTable(space: Option<&CGColorSpace>, table: *mut u8);
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCopyICCData(
    space: Option<&CGColorSpace>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CGColorSpaceCopyICCData(space: Option<&CGColorSpace>) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CGColorSpaceCopyICCData(space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    pub fn CGColorSpaceIsWideGamutRGB(param1: &CGColorSpace) -> bool;
}

extern "C-unwind" {
    pub fn CGColorSpaceIsHDR(param1: &CGColorSpace) -> bool;
}

extern "C-unwind" {
    pub fn CGColorSpaceUsesITUR_2100TF(param1: &CGColorSpace) -> bool;
}

extern "C-unwind" {
    pub fn CGColorSpaceIsPQBased(s: &CGColorSpace) -> bool;
}

extern "C-unwind" {
    pub fn CGColorSpaceIsHLGBased(s: &CGColorSpace) -> bool;
}

extern "C-unwind" {
    pub fn CGColorSpaceSupportsOutput(space: &CGColorSpace) -> bool;
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCopyPropertyList(
    space: &CGColorSpace,
) -> Option<CFRetained<CFPropertyList>> {
    extern "C-unwind" {
        fn CGColorSpaceCopyPropertyList(space: &CGColorSpace) -> Option<NonNull<CFPropertyList>>;
    }
    let ret = unsafe { CGColorSpaceCopyPropertyList(space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateWithPropertyList(
    plist: &CFPropertyList,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateWithPropertyList(
            plist: &CFPropertyList,
        ) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateWithPropertyList(plist) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    pub fn CGColorSpaceUsesExtendedRange(space: &CGColorSpace) -> bool;
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateLinearized(
    space: &CGColorSpace,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateLinearized(space: &CGColorSpace) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateLinearized(space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateExtended(
    space: &CGColorSpace,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateExtended(space: &CGColorSpace) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateExtended(space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateExtendedLinearized(
    space: &CGColorSpace,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateExtendedLinearized(
            space: &CGColorSpace,
        ) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateExtendedLinearized(space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateCopyWithStandardRange(
    s: &CGColorSpace,
) -> CFRetained<CGColorSpace> {
    extern "C-unwind" {
        fn CGColorSpaceCreateCopyWithStandardRange(
            s: &CGColorSpace,
        ) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateCopyWithStandardRange(s) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "No longer supported"]
#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateWithICCProfile(
    data: Option<&CFData>,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateWithICCProfile(data: Option<&CFData>)
            -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateWithICCProfile(data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "No longer supported"]
#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCopyICCProfile(
    space: Option<&CGColorSpace>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CGColorSpaceCopyICCProfile(space: Option<&CGColorSpace>) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CGColorSpaceCopyICCProfile(space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "No longer supported"]
#[inline]
pub unsafe extern "C-unwind" fn CGColorSpaceCreateWithPlatformColorSpace(
    r#ref: *const c_void,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGColorSpaceCreateWithPlatformColorSpace(
            r#ref: *const c_void,
        ) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGColorSpaceCreateWithPlatformColorSpace(r#ref) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
