//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsselectiongranularity?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSelectionGranularity(pub NSUInteger);
impl NSSelectionGranularity {
    #[doc(alias = "NSSelectByCharacter")]
    pub const SelectByCharacter: Self = Self(0);
    #[doc(alias = "NSSelectByWord")]
    pub const SelectByWord: Self = Self(1);
    #[doc(alias = "NSSelectByParagraph")]
    pub const SelectByParagraph: Self = Self(2);
}

unsafe impl Encode for NSSelectionGranularity {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSSelectionGranularity {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsselectionaffinity?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSelectionAffinity(pub NSUInteger);
impl NSSelectionAffinity {
    #[doc(alias = "NSSelectionAffinityUpstream")]
    pub const Upstream: Self = Self(0);
    #[doc(alias = "NSSelectionAffinityDownstream")]
    pub const Downstream: Self = Self(1);
}

unsafe impl Encode for NSSelectionAffinity {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSSelectionAffinity {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsallromaninputsourceslocaleidentifier?language=objc)
    pub static NSAllRomanInputSourcesLocaleIdentifier: &'static NSString;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextview?language=objc)
    #[unsafe(super(NSText, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    pub struct NSTextView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAccessibility for NSTextView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAccessibilityElementProtocol for NSTextView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAccessibilityNavigableStaticText for NSTextView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAccessibilityStaticText for NSTextView {}

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAnimatablePropertyContainer for NSTextView {}

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAppearanceCustomization for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSSpellProtocol",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSChangeSpelling for NSTextView {}

#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
unsafe impl NSCoding for NSTextView {}

#[cfg(all(
    feature = "NSColorPanel",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSColorChanging for NSTextView {}

#[cfg(all(
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSDraggingDestination for NSTextView {}

#[cfg(all(
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSDraggingSource for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSSpellProtocol",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSIgnoreMisspelledWords for NSTextView {}

#[cfg(all(
    feature = "NSMenu",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSMenuItemValidation for NSTextView {}

#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
unsafe impl NSObjectProtocol for NSTextView {}

#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
unsafe impl NSStandardKeyBindingResponding for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSTextContent",
    feature = "NSView"
))]
unsafe impl NSTextContent for NSTextView {}

#[cfg(all(
    feature = "NSInputManager",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSTextInput for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSTextInputClient",
    feature = "NSView"
))]
unsafe impl NSTextInputClient for NSTextView {}

#[cfg(all(
    feature = "NSLayoutManager",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSTextLayoutOrientationProvider for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceItemIdentification for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSUserInterfaceValidation",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceValidations for NSTextView {}

#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        #[cfg(feature = "NSTextContainer")]
        /// ************************** Initializing ***************************
        #[unsafe(method(initWithFrame:textContainer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame_textContainer(
            this: Allocated<Self>,
            frame_rect: NSRect,
            container: Option<&NSTextContainer>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initUsingTextLayoutManager:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initUsingTextLayoutManager(
            this: Allocated<Self>,
            using_text_layout_manager: bool,
        ) -> Retained<Self>;

        #[unsafe(method(textViewUsingTextLayoutManager:))]
        #[unsafe(method_family = none)]
        pub unsafe fn textViewUsingTextLayoutManager(
            using_text_layout_manager: bool,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "NSTextContainer")]
        /// *************** Get/Set the container and other stuff ****************
        #[unsafe(method(textContainer))]
        #[unsafe(method_family = none)]
        pub unsafe fn textContainer(&self) -> Option<Retained<NSTextContainer>>;

        #[cfg(feature = "NSTextContainer")]
        /// Setter for [`textContainer`][Self::textContainer].
        #[unsafe(method(setTextContainer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextContainer(&self, text_container: Option<&NSTextContainer>);

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(replaceTextContainer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceTextContainer(&self, new_container: &NSTextContainer);

        #[unsafe(method(textContainerInset))]
        #[unsafe(method_family = none)]
        pub unsafe fn textContainerInset(&self) -> NSSize;

        /// Setter for [`textContainerInset`][Self::textContainerInset].
        #[unsafe(method(setTextContainerInset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextContainerInset(&self, text_container_inset: NSSize);

        #[unsafe(method(textContainerOrigin))]
        #[unsafe(method_family = none)]
        pub unsafe fn textContainerOrigin(&self) -> NSPoint;

        #[unsafe(method(invalidateTextContainerOrigin))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidateTextContainerOrigin(&self);

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(layoutManager))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutManager(&self) -> Option<Retained<NSLayoutManager>>;

        #[cfg(feature = "NSTextStorage")]
        #[unsafe(method(textStorage))]
        #[unsafe(method_family = none)]
        pub unsafe fn textStorage(&self) -> Option<Retained<NSTextStorage>>;

        #[cfg(feature = "NSTextLayoutManager")]
        #[unsafe(method(textLayoutManager))]
        #[unsafe(method_family = none)]
        pub unsafe fn textLayoutManager(&self) -> Option<Retained<NSTextLayoutManager>>;

        #[cfg(feature = "NSTextContentManager")]
        #[unsafe(method(textContentStorage))]
        #[unsafe(method_family = none)]
        pub unsafe fn textContentStorage(&self) -> Option<Retained<NSTextContentStorage>>;

        /// *********************** Key binding entry-point ************************
        #[deprecated = "Use -insertText:replacementRange: from NSTextInputClient instead. Since the method is designed to be used solely by the input system, the message should never be sent to a text view from applications. Any content modifications should be via either NSTextStorage or NSText methods."]
        #[unsafe(method(insertText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertText(&self, insert_string: &AnyObject);

        /// ************************* Sizing methods **************************
        #[unsafe(method(setConstrainedFrameSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setConstrainedFrameSize(&self, desired_size: NSSize);

        #[unsafe(method(setAlignment:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlignment_range(&self, alignment: NSTextAlignment, range: NSRange);

        #[unsafe(method(setBaseWritingDirection:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBaseWritingDirection_range(
            &self,
            writing_direction: NSWritingDirection,
            range: NSRange,
        );

        /// ************************* New Font menu commands **************************
        #[unsafe(method(turnOffKerning:))]
        #[unsafe(method_family = none)]
        pub unsafe fn turnOffKerning(&self, sender: Option<&AnyObject>);

        #[unsafe(method(tightenKerning:))]
        #[unsafe(method_family = none)]
        pub unsafe fn tightenKerning(&self, sender: Option<&AnyObject>);

        #[unsafe(method(loosenKerning:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loosenKerning(&self, sender: Option<&AnyObject>);

        #[unsafe(method(useStandardKerning:))]
        #[unsafe(method_family = none)]
        pub unsafe fn useStandardKerning(&self, sender: Option<&AnyObject>);

        #[unsafe(method(turnOffLigatures:))]
        #[unsafe(method_family = none)]
        pub unsafe fn turnOffLigatures(&self, sender: Option<&AnyObject>);

        #[unsafe(method(useStandardLigatures:))]
        #[unsafe(method_family = none)]
        pub unsafe fn useStandardLigatures(&self, sender: Option<&AnyObject>);

        #[unsafe(method(useAllLigatures:))]
        #[unsafe(method_family = none)]
        pub unsafe fn useAllLigatures(&self, sender: Option<&AnyObject>);

        #[unsafe(method(raiseBaseline:))]
        #[unsafe(method_family = none)]
        pub unsafe fn raiseBaseline(&self, sender: Option<&AnyObject>);

        #[unsafe(method(lowerBaseline:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lowerBaseline(&self, sender: Option<&AnyObject>);

        #[deprecated = "Use the traditional shaped characters encoded in the Unicode standard. Access the characters via the character palette."]
        #[unsafe(method(toggleTraditionalCharacterShape:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleTraditionalCharacterShape(&self, sender: Option<&AnyObject>);

        #[unsafe(method(outline:))]
        #[unsafe(method_family = none)]
        pub unsafe fn outline(&self, sender: Option<&AnyObject>);

        /// ************************* Find menu commands **************************
        #[unsafe(method(performFindPanelAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performFindPanelAction(&self, sender: Option<&AnyObject>);

        /// ************************* New Text commands **************************
        #[unsafe(method(alignJustified:))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignJustified(&self, sender: Option<&AnyObject>);

        #[unsafe(method(changeColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeColor(&self, sender: Option<&AnyObject>);

        #[unsafe(method(changeAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeAttributes(&self, sender: Option<&AnyObject>);

        #[unsafe(method(changeDocumentBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeDocumentBackgroundColor(&self, sender: Option<&AnyObject>);

        #[unsafe(method(orderFrontSpacingPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn orderFrontSpacingPanel(&self, sender: Option<&AnyObject>);

        #[unsafe(method(orderFrontLinkPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn orderFrontLinkPanel(&self, sender: Option<&AnyObject>);

        #[unsafe(method(orderFrontListPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn orderFrontListPanel(&self, sender: Option<&AnyObject>);

        #[unsafe(method(orderFrontTablePanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn orderFrontTablePanel(&self, sender: Option<&AnyObject>);

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        /// ************************* Ruler support **************************
        #[unsafe(method(rulerView:didMoveMarker:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_didMoveMarker(&self, ruler: &NSRulerView, marker: &NSRulerMarker);

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[unsafe(method(rulerView:didRemoveMarker:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_didRemoveMarker(&self, ruler: &NSRulerView, marker: &NSRulerMarker);

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[unsafe(method(rulerView:didAddMarker:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_didAddMarker(&self, ruler: &NSRulerView, marker: &NSRulerMarker);

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[unsafe(method(rulerView:shouldMoveMarker:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_shouldMoveMarker(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
        ) -> bool;

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[unsafe(method(rulerView:shouldAddMarker:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_shouldAddMarker(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
        ) -> bool;

        #[cfg(all(
            feature = "NSRulerMarker",
            feature = "NSRulerView",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(rulerView:willMoveMarker:toLocation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_willMoveMarker_toLocation(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
            location: CGFloat,
        ) -> CGFloat;

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[unsafe(method(rulerView:shouldRemoveMarker:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_shouldRemoveMarker(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
        ) -> bool;

        #[cfg(all(
            feature = "NSRulerMarker",
            feature = "NSRulerView",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(rulerView:willAddMarker:atLocation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_willAddMarker_atLocation(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
            location: CGFloat,
        ) -> CGFloat;

        #[cfg(all(feature = "NSEvent", feature = "NSRulerView"))]
        #[unsafe(method(rulerView:handleMouseDown:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rulerView_handleMouseDown(&self, ruler: &NSRulerView, event: &NSEvent);

        /// ************************* Fine display control **************************
        #[unsafe(method(setNeedsDisplayInRect:avoidAdditionalLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsDisplayInRect_avoidAdditionalLayout(&self, rect: NSRect, flag: bool);

        #[unsafe(method(shouldDrawInsertionPoint))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldDrawInsertionPoint(&self) -> bool;

        #[cfg(feature = "NSColor")]
        #[unsafe(method(drawInsertionPointInRect:color:turnedOn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawInsertionPointInRect_color_turnedOn(
            &self,
            rect: NSRect,
            color: &NSColor,
            flag: bool,
        );

        #[unsafe(method(drawViewBackgroundInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawViewBackgroundInRect(&self, rect: NSRect);

        /// ************************* Especially for subclassers **************************
        #[unsafe(method(updateRuler))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateRuler(&self);

        #[unsafe(method(updateFontPanel))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateFontPanel(&self);

        #[unsafe(method(updateDragTypeRegistration))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateDragTypeRegistration(&self);

        #[unsafe(method(selectionRangeForProposedRange:granularity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectionRangeForProposedRange_granularity(
            &self,
            proposed_char_range: NSRange,
            granularity: NSSelectionGranularity,
        ) -> NSRange;

        /// ************************* Especially for subclassers **************************
        #[unsafe(method(clickedOnLink:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn clickedOnLink_atIndex(&self, link: &AnyObject, char_index: NSUInteger);

        /// *********************** Speech support ************************
        #[unsafe(method(startSpeaking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn startSpeaking(&self, sender: Option<&AnyObject>);

        #[unsafe(method(stopSpeaking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopSpeaking(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(setLayoutOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLayoutOrientation(&self, orientation: NSTextLayoutOrientation);

        #[unsafe(method(changeLayoutOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeLayoutOrientation(&self, sender: Option<&AnyObject>);

        /// *********************** Helper for subclassers ************************
        #[unsafe(method(characterIndexForInsertionAtPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn characterIndexForInsertionAtPoint(&self, point: NSPoint) -> NSUInteger;

        /// ************************** Ownership policy ***************************
        #[unsafe(method(stronglyReferencesTextStorage))]
        #[unsafe(method_family = none)]
        pub unsafe fn stronglyReferencesTextStorage(mtm: MainThreadMarker) -> bool;

        #[unsafe(method(performValidatedReplacementInRange:withAttributedString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performValidatedReplacementInRange_withAttributedString(
            &self,
            range: NSRange,
            attributed_string: &NSAttributedString,
        ) -> bool;

        #[unsafe(method(usesAdaptiveColorMappingForDarkAppearance))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesAdaptiveColorMappingForDarkAppearance(&self) -> bool;

        /// Setter for [`usesAdaptiveColorMappingForDarkAppearance`][Self::usesAdaptiveColorMappingForDarkAppearance].
        #[unsafe(method(setUsesAdaptiveColorMappingForDarkAppearance:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesAdaptiveColorMappingForDarkAppearance(
            &self,
            uses_adaptive_color_mapping_for_dark_appearance: bool,
        );
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSCompletion.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        /// *********************** Completion support ********************
        #[unsafe(method(complete:))]
        #[unsafe(method_family = none)]
        pub unsafe fn complete(&self, sender: Option<&AnyObject>);

        #[unsafe(method(rangeForUserCompletion))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeForUserCompletion(&self) -> NSRange;

        #[unsafe(method(completionsForPartialWordRange:indexOfSelectedItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn completionsForPartialWordRange_indexOfSelectedItem(
            &self,
            char_range: NSRange,
            index: NonNull<NSInteger>,
        ) -> Option<Retained<NSArray<NSString>>>;

        #[unsafe(method(insertCompletion:forPartialWordRange:movement:isFinal:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertCompletion_forPartialWordRange_movement_isFinal(
            &self,
            word: &NSString,
            char_range: NSRange,
            movement: NSInteger,
            flag: bool,
        );
    );
}

/// NSPasteboard.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        #[cfg(feature = "NSPasteboard")]
        /// ***************** Pasteboard support (mainly for subclassers) ******************
        #[unsafe(method(writablePasteboardTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn writablePasteboardTypes(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(writeSelectionToPasteboard:type:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeSelectionToPasteboard_type(
            &self,
            pboard: &NSPasteboard,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(writeSelectionToPasteboard:types:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeSelectionToPasteboard_types(
            &self,
            pboard: &NSPasteboard,
            types: &NSArray<NSPasteboardType>,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(readablePasteboardTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn readablePasteboardTypes(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(preferredPasteboardTypeFromArray:restrictedToTypesFromArray:))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredPasteboardTypeFromArray_restrictedToTypesFromArray(
            &self,
            available_types: &NSArray<NSPasteboardType>,
            allowed_types: Option<&NSArray<NSPasteboardType>>,
        ) -> Option<Retained<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(readSelectionFromPasteboard:type:))]
        #[unsafe(method_family = none)]
        pub unsafe fn readSelectionFromPasteboard_type(
            &self,
            pboard: &NSPasteboard,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(readSelectionFromPasteboard:))]
        #[unsafe(method_family = none)]
        pub unsafe fn readSelectionFromPasteboard(&self, pboard: &NSPasteboard) -> bool;

        #[unsafe(method(registerForServices))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerForServices(mtm: MainThreadMarker);

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(validRequestorForSendType:returnType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn validRequestorForSendType_returnType(
            &self,
            send_type: Option<&NSPasteboardType>,
            return_type: Option<&NSPasteboardType>,
        ) -> Option<Retained<AnyObject>>;

        #[unsafe(method(pasteAsPlainText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteAsPlainText(&self, sender: Option<&AnyObject>);

        #[unsafe(method(pasteAsRichText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteAsRichText(&self, sender: Option<&AnyObject>);
    );
}

/// NSDragging.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        #[cfg(feature = "NSEvent")]
        #[unsafe(method(dragSelectionWithEvent:offset:slideBack:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragSelectionWithEvent_offset_slideBack(
            &self,
            event: &NSEvent,
            mouse_offset: NSSize,
            slide_back: bool,
        ) -> bool;

        #[cfg(all(feature = "NSEvent", feature = "NSImage"))]
        #[unsafe(method(dragImageForSelectionWithEvent:origin:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragImageForSelectionWithEvent_origin(
            &self,
            event: &NSEvent,
            origin: NSPointPointer,
        ) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(acceptableDragTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn acceptableDragTypes(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(all(feature = "NSDragging", feature = "NSPasteboard"))]
        #[unsafe(method(dragOperationForDraggingInfo:type:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragOperationForDraggingInfo_type(
            &self,
            drag_info: &ProtocolObject<dyn NSDraggingInfo>,
            r#type: &NSPasteboardType,
        ) -> NSDragOperation;

        #[unsafe(method(cleanUpAfterDragOperation))]
        #[unsafe(method_family = none)]
        pub unsafe fn cleanUpAfterDragOperation(&self);
    );
}

/// NSSharing.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        /// ************************* Selected/Marked range **************************
        #[unsafe(method(selectedRanges))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedRanges(&self) -> Retained<NSArray<NSValue>>;

        /// Setter for [`selectedRanges`][Self::selectedRanges].
        #[unsafe(method(setSelectedRanges:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectedRanges(&self, selected_ranges: &NSArray<NSValue>);

        #[unsafe(method(setSelectedRanges:affinity:stillSelecting:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectedRanges_affinity_stillSelecting(
            &self,
            ranges: &NSArray<NSValue>,
            affinity: NSSelectionAffinity,
            still_selecting_flag: bool,
        );

        #[unsafe(method(setSelectedRange:affinity:stillSelecting:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectedRange_affinity_stillSelecting(
            &self,
            char_range: NSRange,
            affinity: NSSelectionAffinity,
            still_selecting_flag: bool,
        );

        #[unsafe(method(selectionAffinity))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectionAffinity(&self) -> NSSelectionAffinity;

        #[unsafe(method(selectionGranularity))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectionGranularity(&self) -> NSSelectionGranularity;

        /// Setter for [`selectionGranularity`][Self::selectionGranularity].
        #[unsafe(method(setSelectionGranularity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectionGranularity(&self, selection_granularity: NSSelectionGranularity);

        #[unsafe(method(selectedTextAttributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedTextAttributes(
            &self,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        /// Setter for [`selectedTextAttributes`][Self::selectedTextAttributes].
        #[unsafe(method(setSelectedTextAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectedTextAttributes(
            &self,
            selected_text_attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
        );

        #[cfg(feature = "NSColor")]
        #[unsafe(method(insertionPointColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertionPointColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`insertionPointColor`][Self::insertionPointColor].
        #[unsafe(method(setInsertionPointColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInsertionPointColor(&self, insertion_point_color: Option<&NSColor>);

        #[unsafe(method(updateInsertionPointStateAndRestartTimer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateInsertionPointStateAndRestartTimer(&self, restart_flag: bool);

        #[unsafe(method(markedTextAttributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn markedTextAttributes(
            &self,
        ) -> Option<Retained<NSDictionary<NSAttributedStringKey, AnyObject>>>;

        /// Setter for [`markedTextAttributes`][Self::markedTextAttributes].
        #[unsafe(method(setMarkedTextAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMarkedTextAttributes(
            &self,
            marked_text_attributes: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
        );

        #[unsafe(method(linkTextAttributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn linkTextAttributes(
            &self,
        ) -> Option<Retained<NSDictionary<NSAttributedStringKey, AnyObject>>>;

        /// Setter for [`linkTextAttributes`][Self::linkTextAttributes].
        #[unsafe(method(setLinkTextAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLinkTextAttributes(
            &self,
            link_text_attributes: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
        );

        #[unsafe(method(displaysLinkToolTips))]
        #[unsafe(method_family = none)]
        pub unsafe fn displaysLinkToolTips(&self) -> bool;

        /// Setter for [`displaysLinkToolTips`][Self::displaysLinkToolTips].
        #[unsafe(method(setDisplaysLinkToolTips:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDisplaysLinkToolTips(&self, displays_link_tool_tips: bool);

        /// *********************** Glyph info support ************************
        #[unsafe(method(acceptsGlyphInfo))]
        #[unsafe(method_family = none)]
        pub unsafe fn acceptsGlyphInfo(&self) -> bool;

        /// Setter for [`acceptsGlyphInfo`][Self::acceptsGlyphInfo].
        #[unsafe(method(setAcceptsGlyphInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAcceptsGlyphInfo(&self, accepts_glyph_info: bool);

        /// ************************* Other NSTextView methods **************************
        #[unsafe(method(usesRuler))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesRuler(&self) -> bool;

        /// Setter for [`usesRuler`][Self::usesRuler].
        #[unsafe(method(setUsesRuler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesRuler(&self, uses_ruler: bool);

        #[unsafe(method(usesInspectorBar))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesInspectorBar(&self) -> bool;

        /// Setter for [`usesInspectorBar`][Self::usesInspectorBar].
        #[unsafe(method(setUsesInspectorBar:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesInspectorBar(&self, uses_inspector_bar: bool);

        #[unsafe(method(isContinuousSpellCheckingEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isContinuousSpellCheckingEnabled(&self) -> bool;

        /// Setter for [`isContinuousSpellCheckingEnabled`][Self::isContinuousSpellCheckingEnabled].
        #[unsafe(method(setContinuousSpellCheckingEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContinuousSpellCheckingEnabled(
            &self,
            continuous_spell_checking_enabled: bool,
        );

        #[unsafe(method(toggleContinuousSpellChecking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleContinuousSpellChecking(&self, sender: Option<&AnyObject>);

        #[unsafe(method(spellCheckerDocumentTag))]
        #[unsafe(method_family = none)]
        pub unsafe fn spellCheckerDocumentTag(&self) -> NSInteger;

        #[unsafe(method(isGrammarCheckingEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isGrammarCheckingEnabled(&self) -> bool;

        /// Setter for [`isGrammarCheckingEnabled`][Self::isGrammarCheckingEnabled].
        #[unsafe(method(setGrammarCheckingEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGrammarCheckingEnabled(&self, grammar_checking_enabled: bool);

        #[unsafe(method(toggleGrammarChecking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleGrammarChecking(&self, sender: Option<&AnyObject>);

        #[unsafe(method(setSpellingState:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSpellingState_range(&self, value: NSInteger, char_range: NSRange);

        #[unsafe(method(typingAttributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn typingAttributes(
            &self,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        /// Setter for [`typingAttributes`][Self::typingAttributes].
        #[unsafe(method(setTypingAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTypingAttributes(
            &self,
            typing_attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
        );

        #[unsafe(method(shouldChangeTextInRanges:replacementStrings:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldChangeTextInRanges_replacementStrings(
            &self,
            affected_ranges: &NSArray<NSValue>,
            replacement_strings: Option<&NSArray<NSString>>,
        ) -> bool;

        #[unsafe(method(rangesForUserTextChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangesForUserTextChange(&self) -> Option<Retained<NSArray<NSValue>>>;

        #[unsafe(method(rangesForUserCharacterAttributeChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangesForUserCharacterAttributeChange(
            &self,
        ) -> Option<Retained<NSArray<NSValue>>>;

        #[unsafe(method(rangesForUserParagraphAttributeChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangesForUserParagraphAttributeChange(
            &self,
        ) -> Option<Retained<NSArray<NSValue>>>;

        #[unsafe(method(shouldChangeTextInRange:replacementString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldChangeTextInRange_replacementString(
            &self,
            affected_char_range: NSRange,
            replacement_string: Option<&NSString>,
        ) -> bool;

        #[unsafe(method(didChangeText))]
        #[unsafe(method_family = none)]
        pub unsafe fn didChangeText(&self);

        #[unsafe(method(rangeForUserTextChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeForUserTextChange(&self) -> NSRange;

        #[unsafe(method(rangeForUserCharacterAttributeChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeForUserCharacterAttributeChange(&self) -> NSRange;

        #[unsafe(method(rangeForUserParagraphAttributeChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeForUserParagraphAttributeChange(&self) -> NSRange;

        #[unsafe(method(allowsDocumentBackgroundColorChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsDocumentBackgroundColorChange(&self) -> bool;

        /// Setter for [`allowsDocumentBackgroundColorChange`][Self::allowsDocumentBackgroundColorChange].
        #[unsafe(method(setAllowsDocumentBackgroundColorChange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsDocumentBackgroundColorChange(
            &self,
            allows_document_background_color_change: bool,
        );

        #[cfg(feature = "NSParagraphStyle")]
        #[unsafe(method(defaultParagraphStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultParagraphStyle(&self) -> Option<Retained<NSParagraphStyle>>;

        #[cfg(feature = "NSParagraphStyle")]
        /// Setter for [`defaultParagraphStyle`][Self::defaultParagraphStyle].
        #[unsafe(method(setDefaultParagraphStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultParagraphStyle(
            &self,
            default_paragraph_style: Option<&NSParagraphStyle>,
        );

        #[unsafe(method(allowsUndo))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsUndo(&self) -> bool;

        /// Setter for [`allowsUndo`][Self::allowsUndo].
        #[unsafe(method(setAllowsUndo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsUndo(&self, allows_undo: bool);

        #[unsafe(method(breakUndoCoalescing))]
        #[unsafe(method_family = none)]
        pub unsafe fn breakUndoCoalescing(&self);

        #[unsafe(method(isCoalescingUndo))]
        #[unsafe(method_family = none)]
        pub unsafe fn isCoalescingUndo(&self) -> bool;

        #[unsafe(method(allowsImageEditing))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsImageEditing(&self) -> bool;

        /// Setter for [`allowsImageEditing`][Self::allowsImageEditing].
        #[unsafe(method(setAllowsImageEditing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsImageEditing(&self, allows_image_editing: bool);

        #[unsafe(method(showFindIndicatorForRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showFindIndicatorForRange(&self, char_range: NSRange);

        #[unsafe(method(usesRolloverButtonForSelection))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesRolloverButtonForSelection(&self) -> bool;

        /// Setter for [`usesRolloverButtonForSelection`][Self::usesRolloverButtonForSelection].
        #[unsafe(method(setUsesRolloverButtonForSelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesRolloverButtonForSelection(
            &self,
            uses_rollover_button_for_selection: bool,
        );

        /// ************************* NSText methods **************************
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSTextViewDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSTextViewDelegate>>);

        #[unsafe(method(isEditable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEditable(&self) -> bool;

        /// Setter for [`isEditable`][Self::isEditable].
        #[unsafe(method(setEditable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEditable(&self, editable: bool);

        #[unsafe(method(isSelectable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isSelectable(&self) -> bool;

        /// Setter for [`isSelectable`][Self::isSelectable].
        #[unsafe(method(setSelectable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectable(&self, selectable: bool);

        #[unsafe(method(isRichText))]
        #[unsafe(method_family = none)]
        pub unsafe fn isRichText(&self) -> bool;

        /// Setter for [`isRichText`][Self::isRichText].
        #[unsafe(method(setRichText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRichText(&self, rich_text: bool);

        #[unsafe(method(importsGraphics))]
        #[unsafe(method_family = none)]
        pub unsafe fn importsGraphics(&self) -> bool;

        /// Setter for [`importsGraphics`][Self::importsGraphics].
        #[unsafe(method(setImportsGraphics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImportsGraphics(&self, imports_graphics: bool);

        #[unsafe(method(drawsBackground))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawsBackground(&self) -> bool;

        /// Setter for [`drawsBackground`][Self::drawsBackground].
        #[unsafe(method(setDrawsBackground:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDrawsBackground(&self, draws_background: bool);

        #[cfg(feature = "NSColor")]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundColor(&self, background_color: &NSColor);

        #[unsafe(method(isFieldEditor))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFieldEditor(&self) -> bool;

        /// Setter for [`isFieldEditor`][Self::isFieldEditor].
        #[unsafe(method(setFieldEditor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFieldEditor(&self, field_editor: bool);

        #[unsafe(method(usesFontPanel))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesFontPanel(&self) -> bool;

        /// Setter for [`usesFontPanel`][Self::usesFontPanel].
        #[unsafe(method(setUsesFontPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesFontPanel(&self, uses_font_panel: bool);

        #[unsafe(method(isRulerVisible))]
        #[unsafe(method_family = none)]
        pub unsafe fn isRulerVisible(&self) -> bool;

        /// Setter for [`isRulerVisible`][Self::isRulerVisible].
        #[unsafe(method(setRulerVisible:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRulerVisible(&self, ruler_visible: bool);

        #[unsafe(method(setSelectedRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectedRange(&self, char_range: NSRange);

        /// ************************* Input Source support **************************
        #[unsafe(method(allowedInputSourceLocales))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowedInputSourceLocales(&self) -> Option<Retained<NSArray<NSString>>>;

        /// Setter for [`allowedInputSourceLocales`][Self::allowedInputSourceLocales].
        #[unsafe(method(setAllowedInputSourceLocales:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowedInputSourceLocales(
            &self,
            allowed_input_source_locales: Option<&NSArray<NSString>>,
        );

        #[unsafe(method(isWritingToolsActive))]
        #[unsafe(method_family = none)]
        pub unsafe fn isWritingToolsActive(&self) -> bool;

        #[cfg(feature = "NSTextCheckingClient")]
        #[unsafe(method(writingToolsBehavior))]
        #[unsafe(method_family = none)]
        pub unsafe fn writingToolsBehavior(&self) -> NSWritingToolsBehavior;

        #[cfg(feature = "NSTextCheckingClient")]
        /// Setter for [`writingToolsBehavior`][Self::writingToolsBehavior].
        #[unsafe(method(setWritingToolsBehavior:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWritingToolsBehavior(
            &self,
            writing_tools_behavior: NSWritingToolsBehavior,
        );

        #[cfg(feature = "NSTextCheckingClient")]
        #[unsafe(method(allowedWritingToolsResultOptions))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowedWritingToolsResultOptions(&self) -> NSWritingToolsResultOptions;

        #[cfg(feature = "NSTextCheckingClient")]
        /// Setter for [`allowedWritingToolsResultOptions`][Self::allowedWritingToolsResultOptions].
        #[unsafe(method(setAllowedWritingToolsResultOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowedWritingToolsResultOptions(
            &self,
            allowed_writing_tools_result_options: NSWritingToolsResultOptions,
        );
    );
}

/// NSTextChecking.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        /// ************************* Smart copy/paste/delete/substitution support **************************
        #[unsafe(method(smartInsertDeleteEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn smartInsertDeleteEnabled(&self) -> bool;

        /// Setter for [`smartInsertDeleteEnabled`][Self::smartInsertDeleteEnabled].
        #[unsafe(method(setSmartInsertDeleteEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSmartInsertDeleteEnabled(&self, smart_insert_delete_enabled: bool);

        #[unsafe(method(smartDeleteRangeForProposedRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn smartDeleteRangeForProposedRange(
            &self,
            proposed_char_range: NSRange,
        ) -> NSRange;

        #[unsafe(method(toggleSmartInsertDelete:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleSmartInsertDelete(&self, sender: Option<&AnyObject>);

        #[unsafe(method(smartInsertForString:replacingRange:beforeString:afterString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn smartInsertForString_replacingRange_beforeString_afterString(
            &self,
            paste_string: &NSString,
            char_range_to_replace: NSRange,
            before_string: Option<&mut Option<Retained<NSString>>>,
            after_string: Option<&mut Option<Retained<NSString>>>,
        );

        #[unsafe(method(smartInsertBeforeStringForString:replacingRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn smartInsertBeforeStringForString_replacingRange(
            &self,
            paste_string: &NSString,
            char_range_to_replace: NSRange,
        ) -> Option<Retained<NSString>>;

        #[unsafe(method(smartInsertAfterStringForString:replacingRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn smartInsertAfterStringForString_replacingRange(
            &self,
            paste_string: &NSString,
            char_range_to_replace: NSRange,
        ) -> Option<Retained<NSString>>;

        #[unsafe(method(isAutomaticQuoteSubstitutionEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAutomaticQuoteSubstitutionEnabled(&self) -> bool;

        /// Setter for [`isAutomaticQuoteSubstitutionEnabled`][Self::isAutomaticQuoteSubstitutionEnabled].
        #[unsafe(method(setAutomaticQuoteSubstitutionEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticQuoteSubstitutionEnabled(
            &self,
            automatic_quote_substitution_enabled: bool,
        );

        #[unsafe(method(toggleAutomaticQuoteSubstitution:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleAutomaticQuoteSubstitution(&self, sender: Option<&AnyObject>);

        #[unsafe(method(isAutomaticLinkDetectionEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAutomaticLinkDetectionEnabled(&self) -> bool;

        /// Setter for [`isAutomaticLinkDetectionEnabled`][Self::isAutomaticLinkDetectionEnabled].
        #[unsafe(method(setAutomaticLinkDetectionEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticLinkDetectionEnabled(
            &self,
            automatic_link_detection_enabled: bool,
        );

        #[unsafe(method(toggleAutomaticLinkDetection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleAutomaticLinkDetection(&self, sender: Option<&AnyObject>);

        #[unsafe(method(isAutomaticDataDetectionEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAutomaticDataDetectionEnabled(&self) -> bool;

        /// Setter for [`isAutomaticDataDetectionEnabled`][Self::isAutomaticDataDetectionEnabled].
        #[unsafe(method(setAutomaticDataDetectionEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticDataDetectionEnabled(
            &self,
            automatic_data_detection_enabled: bool,
        );

        #[unsafe(method(toggleAutomaticDataDetection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleAutomaticDataDetection(&self, sender: Option<&AnyObject>);

        #[unsafe(method(isAutomaticDashSubstitutionEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAutomaticDashSubstitutionEnabled(&self) -> bool;

        /// Setter for [`isAutomaticDashSubstitutionEnabled`][Self::isAutomaticDashSubstitutionEnabled].
        #[unsafe(method(setAutomaticDashSubstitutionEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticDashSubstitutionEnabled(
            &self,
            automatic_dash_substitution_enabled: bool,
        );

        #[unsafe(method(toggleAutomaticDashSubstitution:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleAutomaticDashSubstitution(&self, sender: Option<&AnyObject>);

        #[unsafe(method(isAutomaticTextReplacementEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAutomaticTextReplacementEnabled(&self) -> bool;

        /// Setter for [`isAutomaticTextReplacementEnabled`][Self::isAutomaticTextReplacementEnabled].
        #[unsafe(method(setAutomaticTextReplacementEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticTextReplacementEnabled(
            &self,
            automatic_text_replacement_enabled: bool,
        );

        #[unsafe(method(toggleAutomaticTextReplacement:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleAutomaticTextReplacement(&self, sender: Option<&AnyObject>);

        #[unsafe(method(isAutomaticSpellingCorrectionEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAutomaticSpellingCorrectionEnabled(&self) -> bool;

        /// Setter for [`isAutomaticSpellingCorrectionEnabled`][Self::isAutomaticSpellingCorrectionEnabled].
        #[unsafe(method(setAutomaticSpellingCorrectionEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticSpellingCorrectionEnabled(
            &self,
            automatic_spelling_correction_enabled: bool,
        );

        #[unsafe(method(toggleAutomaticSpellingCorrection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleAutomaticSpellingCorrection(&self, sender: Option<&AnyObject>);

        #[unsafe(method(enabledTextCheckingTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn enabledTextCheckingTypes(&self) -> NSTextCheckingTypes;

        /// Setter for [`enabledTextCheckingTypes`][Self::enabledTextCheckingTypes].
        #[unsafe(method(setEnabledTextCheckingTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEnabledTextCheckingTypes(
            &self,
            enabled_text_checking_types: NSTextCheckingTypes,
        );

        #[cfg(feature = "NSSpellChecker")]
        #[unsafe(method(checkTextInRange:types:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkTextInRange_types_options(
            &self,
            range: NSRange,
            checking_types: NSTextCheckingTypes,
            options: &NSDictionary<NSTextCheckingOptionKey, AnyObject>,
        );

        #[cfg(feature = "NSSpellChecker")]
        #[unsafe(method(handleTextCheckingResults:forRange:types:options:orthography:wordCount:))]
        #[unsafe(method_family = none)]
        pub unsafe fn handleTextCheckingResults_forRange_types_options_orthography_wordCount(
            &self,
            results: &NSArray<NSTextCheckingResult>,
            range: NSRange,
            checking_types: NSTextCheckingTypes,
            options: &NSDictionary<NSTextCheckingOptionKey, AnyObject>,
            orthography: &NSOrthography,
            word_count: NSInteger,
        );

        #[unsafe(method(orderFrontSubstitutionsPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn orderFrontSubstitutionsPanel(&self, sender: Option<&AnyObject>);

        #[unsafe(method(checkTextInSelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkTextInSelection(&self, sender: Option<&AnyObject>);

        #[unsafe(method(checkTextInDocument:))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkTextInDocument(&self, sender: Option<&AnyObject>);

        #[unsafe(method(usesFindPanel))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesFindPanel(&self) -> bool;

        /// Setter for [`usesFindPanel`][Self::usesFindPanel].
        #[unsafe(method(setUsesFindPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesFindPanel(&self, uses_find_panel: bool);

        #[unsafe(method(usesFindBar))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesFindBar(&self) -> bool;

        /// Setter for [`usesFindBar`][Self::usesFindBar].
        #[unsafe(method(setUsesFindBar:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesFindBar(&self, uses_find_bar: bool);

        #[unsafe(method(isIncrementalSearchingEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isIncrementalSearchingEnabled(&self) -> bool;

        /// Setter for [`isIncrementalSearchingEnabled`][Self::isIncrementalSearchingEnabled].
        #[unsafe(method(setIncrementalSearchingEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIncrementalSearchingEnabled(&self, incremental_searching_enabled: bool);

        #[cfg(feature = "NSTextCheckingClient")]
        #[unsafe(method(inlinePredictionType))]
        #[unsafe(method_family = none)]
        pub unsafe fn inlinePredictionType(&self) -> NSTextInputTraitType;

        #[cfg(feature = "NSTextCheckingClient")]
        /// Setter for [`inlinePredictionType`][Self::inlinePredictionType].
        #[unsafe(method(setInlinePredictionType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInlinePredictionType(&self, inline_prediction_type: NSTextInputTraitType);

        #[cfg(feature = "NSTextCheckingClient")]
        #[unsafe(method(mathExpressionCompletionType))]
        #[unsafe(method_family = none)]
        pub unsafe fn mathExpressionCompletionType(&self) -> NSTextInputTraitType;

        #[cfg(feature = "NSTextCheckingClient")]
        /// Setter for [`mathExpressionCompletionType`][Self::mathExpressionCompletionType].
        #[unsafe(method(setMathExpressionCompletionType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMathExpressionCompletionType(
            &self,
            math_expression_completion_type: NSTextInputTraitType,
        );
    );
}

/// NSQuickLookPreview.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        /// ************************* Quick Look support **************************
        #[unsafe(method(toggleQuickLookPreviewPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleQuickLookPreviewPanel(&self, sender: Option<&AnyObject>);

        #[unsafe(method(updateQuickLookPreviewPanel))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateQuickLookPreviewPanel(&self);
    );
}

/// NSTextView_SharingService.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        /// ************************* NSSharingService support **************************
        #[unsafe(method(orderFrontSharingServicePicker:))]
        #[unsafe(method_family = none)]
        pub unsafe fn orderFrontSharingServicePicker(&self, sender: Option<&AnyObject>);
    );
}

/// NSTextView_TouchBar.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        #[unsafe(method(isAutomaticTextCompletionEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAutomaticTextCompletionEnabled(&self) -> bool;

        /// Setter for [`isAutomaticTextCompletionEnabled`][Self::isAutomaticTextCompletionEnabled].
        #[unsafe(method(setAutomaticTextCompletionEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticTextCompletionEnabled(
            &self,
            automatic_text_completion_enabled: bool,
        );

        #[unsafe(method(toggleAutomaticTextCompletion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleAutomaticTextCompletion(&self, sender: Option<&AnyObject>);

        #[unsafe(method(allowsCharacterPickerTouchBarItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsCharacterPickerTouchBarItem(&self) -> bool;

        /// Setter for [`allowsCharacterPickerTouchBarItem`][Self::allowsCharacterPickerTouchBarItem].
        #[unsafe(method(setAllowsCharacterPickerTouchBarItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsCharacterPickerTouchBarItem(
            &self,
            allows_character_picker_touch_bar_item: bool,
        );

        #[unsafe(method(updateTouchBarItemIdentifiers))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateTouchBarItemIdentifiers(&self);

        #[unsafe(method(updateTextTouchBarItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateTextTouchBarItems(&self);

        #[unsafe(method(updateCandidates))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateCandidates(&self);

        #[cfg(all(feature = "NSCandidateListTouchBarItem", feature = "NSTouchBarItem"))]
        #[unsafe(method(candidateListTouchBarItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn candidateListTouchBarItem(
            &self,
        ) -> Option<Retained<NSCandidateListTouchBarItem>>;
    );
}

#[cfg(all(
    feature = "NSCandidateListTouchBarItem",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSCandidateListTouchBarItemDelegate for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSTouchBar",
    feature = "NSView"
))]
unsafe impl NSTouchBarDelegate for NSTextView {}

/// NSTextView_Factory.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        #[cfg(feature = "NSScrollView")]
        #[unsafe(method(scrollableTextView))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollableTextView(mtm: MainThreadMarker) -> Retained<NSScrollView>;

        #[unsafe(method(fieldEditor))]
        #[unsafe(method_family = none)]
        pub unsafe fn fieldEditor(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "NSScrollView")]
        #[unsafe(method(scrollableDocumentContentTextView))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollableDocumentContentTextView(
            mtm: MainThreadMarker,
        ) -> Retained<NSScrollView>;

        #[cfg(feature = "NSScrollView")]
        #[unsafe(method(scrollablePlainDocumentContentTextView))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollablePlainDocumentContentTextView(
            mtm: MainThreadMarker,
        ) -> Retained<NSScrollView>;
    );
}

/// NSTextView_TextHighlight.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        /// ************************* Text Highlight  support **************************
        #[unsafe(method(textHighlightAttributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn textHighlightAttributes(
            &self,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        /// Setter for [`textHighlightAttributes`][Self::textHighlightAttributes].
        #[unsafe(method(setTextHighlightAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextHighlightAttributes(
            &self,
            text_highlight_attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
        );

        #[cfg(feature = "NSTextRange")]
        #[unsafe(method(drawTextHighlightBackgroundForTextRange:origin:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawTextHighlightBackgroundForTextRange_origin(
            &self,
            text_range: &NSTextRange,
            origin: NSPoint,
        );

        /// An action for toggling `NSTextHighlightStyleAttributeName` in the receiver’s selected range.
        /// The sender should be a menu item with a `representedObject` of type (`NSTextHighlightColorScheme`).
        #[unsafe(method(highlight:))]
        #[unsafe(method_family = none)]
        pub unsafe fn highlight(&self, sender: Option<&AnyObject>);
    );
}

/// NSDeprecated.
#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
impl NSTextView {
    extern_methods!(
        #[deprecated = "Use NSResponder's makeBaseWritingDirectionNatural:, makeBaseWritingDirectionLeftToRight:, and makeBaseWritingDirectionRightToLeft: instead"]
        #[unsafe(method(toggleBaseWritingDirection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleBaseWritingDirection(&self, sender: Option<&AnyObject>);
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextviewdelegate?language=objc)
    #[cfg(feature = "NSText")]
    pub unsafe trait NSTextViewDelegate: NSTextDelegate {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:clickedOnLink:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_clickedOnLink_atIndex(
            &self,
            text_view: &NSTextView,
            link: &AnyObject,
            char_index: NSUInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:clickedOnCell:inRect:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_clickedOnCell_inRect_atIndex(
            &self,
            text_view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            cell_frame: NSRect,
            char_index: NSUInteger,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:doubleClickedOnCell:inRect:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_doubleClickedOnCell_inRect_atIndex(
            &self,
            text_view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            cell_frame: NSRect,
            char_index: NSUInteger,
        );

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:draggedCell:inRect:event:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_draggedCell_inRect_event_atIndex(
            &self,
            view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            rect: NSRect,
            event: &NSEvent,
            char_index: NSUInteger,
        );

        #[cfg(all(
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:writablePasteboardTypesForCell:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_writablePasteboardTypesForCell_atIndex(
            &self,
            view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            char_index: NSUInteger,
        ) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(all(
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:writeCell:atIndex:toPasteboard:type:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_writeCell_atIndex_toPasteboard_type(
            &self,
            view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            char_index: NSUInteger,
            pboard: &NSPasteboard,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:willChangeSelectionFromCharacterRange:toCharacterRange:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_willChangeSelectionFromCharacterRange_toCharacterRange(
            &self,
            text_view: &NSTextView,
            old_selected_char_range: NSRange,
            new_selected_char_range: NSRange,
        ) -> NSRange;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:willChangeSelectionFromCharacterRanges:toCharacterRanges:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_willChangeSelectionFromCharacterRanges_toCharacterRanges(
            &self,
            text_view: &NSTextView,
            old_selected_char_ranges: &NSArray<NSValue>,
            new_selected_char_ranges: &NSArray<NSValue>,
        ) -> Retained<NSArray<NSValue>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:shouldChangeTextInRanges:replacementStrings:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_shouldChangeTextInRanges_replacementStrings(
            &self,
            text_view: &NSTextView,
            affected_ranges: &NSArray<NSValue>,
            replacement_strings: Option<&NSArray<NSString>>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:shouldChangeTypingAttributes:toAttributes:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_shouldChangeTypingAttributes_toAttributes(
            &self,
            text_view: &NSTextView,
            old_typing_attributes: &NSDictionary<NSString, AnyObject>,
            new_typing_attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        #[optional]
        #[unsafe(method(textViewDidChangeSelection:))]
        #[unsafe(method_family = none)]
        unsafe fn textViewDidChangeSelection(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(textViewDidChangeTypingAttributes:))]
        #[unsafe(method_family = none)]
        unsafe fn textViewDidChangeTypingAttributes(&self, notification: &NSNotification);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:willDisplayToolTip:forCharacterAtIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_willDisplayToolTip_forCharacterAtIndex(
            &self,
            text_view: &NSTextView,
            tooltip: &NSString,
            character_index: NSUInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:completions:forPartialWordRange:indexOfSelectedItem:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_completions_forPartialWordRange_indexOfSelectedItem(
            &self,
            text_view: &NSTextView,
            words: &NSArray<NSString>,
            char_range: NSRange,
            index: *mut NSInteger,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:shouldChangeTextInRange:replacementString:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_shouldChangeTextInRange_replacementString(
            &self,
            text_view: &NSTextView,
            affected_char_range: NSRange,
            replacement_string: Option<&NSString>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:doCommandBySelector:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_doCommandBySelector(
            &self,
            text_view: &NSTextView,
            command_selector: Sel,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:shouldSetSpellingState:range:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_shouldSetSpellingState_range(
            &self,
            text_view: &NSTextView,
            value: NSInteger,
            affected_char_range: NSRange,
        ) -> NSInteger;

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSMenu",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:menu:forEvent:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_menu_forEvent_atIndex(
            &self,
            view: &NSTextView,
            menu: &NSMenu,
            event: &NSEvent,
            char_index: NSUInteger,
        ) -> Option<Retained<NSMenu>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSSpellChecker",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:willCheckTextInRange:options:types:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_willCheckTextInRange_options_types(
            &self,
            view: &NSTextView,
            range: NSRange,
            options: &NSDictionary<NSTextCheckingOptionKey, AnyObject>,
            checking_types: NonNull<NSTextCheckingTypes>,
        ) -> Retained<NSDictionary<NSTextCheckingOptionKey, AnyObject>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSSpellChecker",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:didCheckTextInRange:types:options:results:orthography:wordCount:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_didCheckTextInRange_types_options_results_orthography_wordCount(
            &self,
            view: &NSTextView,
            range: NSRange,
            checking_types: NSTextCheckingTypes,
            options: &NSDictionary<NSTextCheckingOptionKey, AnyObject>,
            results: &NSArray<NSTextCheckingResult>,
            orthography: &NSOrthography,
            word_count: NSInteger,
        ) -> Retained<NSArray<NSTextCheckingResult>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachment",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:URLForContentsOfTextAttachment:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_URLForContentsOfTextAttachment_atIndex(
            &self,
            text_view: &NSTextView,
            text_attachment: &NSTextAttachment,
            char_index: NSUInteger,
        ) -> Option<Retained<NSURL>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSSharingService",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:willShowSharingServicePicker:forItems:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_willShowSharingServicePicker_forItems(
            &self,
            text_view: &NSTextView,
            service_picker: &NSSharingServicePicker,
            items: &NSArray,
        ) -> Option<Retained<NSSharingServicePicker>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(undoManagerForTextView:))]
        #[unsafe(method_family = none)]
        unsafe fn undoManagerForTextView(
            &self,
            view: &NSTextView,
        ) -> Option<Retained<NSUndoManager>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTouchBarItem",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(textView:shouldUpdateTouchBarItemIdentifiers:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_shouldUpdateTouchBarItemIdentifiers(
            &self,
            text_view: &NSTextView,
            identifiers: &NSArray<NSTouchBarItemIdentifier>,
        ) -> Retained<NSArray<NSTouchBarItemIdentifier>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:candidatesForSelectedRange:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_candidatesForSelectedRange(
            &self,
            text_view: &NSTextView,
            selected_range: NSRange,
        ) -> Option<Retained<NSArray>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:candidates:forSelectedRange:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_candidates_forSelectedRange(
            &self,
            text_view: &NSTextView,
            candidates: &NSArray<NSTextCheckingResult>,
            selected_range: NSRange,
        ) -> Retained<NSArray<NSTextCheckingResult>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:shouldSelectCandidateAtIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_shouldSelectCandidateAtIndex(
            &self,
            text_view: &NSTextView,
            index: NSUInteger,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textViewWritingToolsWillBegin:))]
        #[unsafe(method_family = none)]
        unsafe fn textViewWritingToolsWillBegin(&self, text_view: &NSTextView);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textViewWritingToolsDidEnd:))]
        #[unsafe(method_family = none)]
        unsafe fn textViewWritingToolsDidEnd(&self, text_view: &NSTextView);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(textView:writingToolsIgnoredRangesInEnclosingRange:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_writingToolsIgnoredRangesInEnclosingRange(
            &self,
            text_view: &NSTextView,
            enclosing_range: NSRange,
        ) -> Retained<NSArray<NSValue>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use -textView:clickedOnLink:atIndex: instead"]
        #[optional]
        #[unsafe(method(textView:clickedOnLink:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_clickedOnLink(
            &self,
            text_view: &NSTextView,
            link: Option<&AnyObject>,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[deprecated = "Use -textView:clickedOnCell:inRect:atIndex: instead"]
        #[optional]
        #[unsafe(method(textView:clickedOnCell:inRect:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_clickedOnCell_inRect(
            &self,
            text_view: &NSTextView,
            cell: Option<&ProtocolObject<dyn NSTextAttachmentCellProtocol>>,
            cell_frame: NSRect,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[deprecated = "Use -textView:doubleClickedOnCell:inRect:atIndex: instead"]
        #[optional]
        #[unsafe(method(textView:doubleClickedOnCell:inRect:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_doubleClickedOnCell_inRect(
            &self,
            text_view: &NSTextView,
            cell: Option<&ProtocolObject<dyn NSTextAttachmentCellProtocol>>,
            cell_frame: NSRect,
        );

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[deprecated = "Use -textView:draggedCell:inRect:event:atIndex: instead"]
        #[optional]
        #[unsafe(method(textView:draggedCell:inRect:event:))]
        #[unsafe(method_family = none)]
        unsafe fn textView_draggedCell_inRect_event(
            &self,
            view: &NSTextView,
            cell: Option<&ProtocolObject<dyn NSTextAttachmentCellProtocol>>,
            rect: NSRect,
            event: Option<&NSEvent>,
        );
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstouchbaritemidentifiercharacterpicker?language=objc)
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierCharacterPicker: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstouchbaritemidentifiertextcolorpicker?language=objc)
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextColorPicker: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstouchbaritemidentifiertextstyle?language=objc)
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextStyle: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstouchbaritemidentifiertextalignment?language=objc)
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextAlignment: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstouchbaritemidentifiertextlist?language=objc)
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextList: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstouchbaritemidentifiertextformat?language=objc)
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextFormat: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextviewwillchangenotifyingtextviewnotification?language=objc)
    pub static NSTextViewWillChangeNotifyingTextViewNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextviewdidchangeselectionnotification?language=objc)
    pub static NSTextViewDidChangeSelectionNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextviewdidchangetypingattributesnotification?language=objc)
    pub static NSTextViewDidChangeTypingAttributesNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextviewwillswitchtonslayoutmanagernotification?language=objc)
    pub static NSTextViewWillSwitchToNSLayoutManagerNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextviewdidswitchtonslayoutmanagernotification?language=objc)
    pub static NSTextViewDidSwitchToNSLayoutManagerNotification: &'static NSNotificationName;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfindpanelaction?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFindPanelAction(pub NSUInteger);
impl NSFindPanelAction {
    #[doc(alias = "NSFindPanelActionShowFindPanel")]
    pub const ShowFindPanel: Self = Self(1);
    #[doc(alias = "NSFindPanelActionNext")]
    pub const Next: Self = Self(2);
    #[doc(alias = "NSFindPanelActionPrevious")]
    pub const Previous: Self = Self(3);
    #[doc(alias = "NSFindPanelActionReplaceAll")]
    pub const ReplaceAll: Self = Self(4);
    #[doc(alias = "NSFindPanelActionReplace")]
    pub const Replace: Self = Self(5);
    #[doc(alias = "NSFindPanelActionReplaceAndFind")]
    pub const ReplaceAndFind: Self = Self(6);
    #[doc(alias = "NSFindPanelActionSetFindString")]
    pub const SetFindString: Self = Self(7);
    #[doc(alias = "NSFindPanelActionReplaceAllInSelection")]
    pub const ReplaceAllInSelection: Self = Self(8);
    #[doc(alias = "NSFindPanelActionSelectAll")]
    pub const SelectAll: Self = Self(9);
    #[doc(alias = "NSFindPanelActionSelectAllInSelection")]
    pub const SelectAllInSelection: Self = Self(10);
}

unsafe impl Encode for NSFindPanelAction {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFindPanelAction {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfindpanelsearchoptionspboardtype?language=objc)
    #[cfg(feature = "NSPasteboard")]
    pub static NSFindPanelSearchOptionsPboardType: &'static NSPasteboardType;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspasteboardtypefindpanelsearchoptionkey?language=objc)
// NS_TYPED_ENUM
pub type NSPasteboardTypeFindPanelSearchOptionKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfindpanelcaseinsensitivesearch?language=objc)
    pub static NSFindPanelCaseInsensitiveSearch: &'static NSPasteboardTypeFindPanelSearchOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfindpanelsubstringmatch?language=objc)
    pub static NSFindPanelSubstringMatch: &'static NSPasteboardTypeFindPanelSearchOptionKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfindpanelsubstringmatchtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFindPanelSubstringMatchType(pub NSUInteger);
impl NSFindPanelSubstringMatchType {
    #[doc(alias = "NSFindPanelSubstringMatchTypeContains")]
    pub const Contains: Self = Self(0);
    #[doc(alias = "NSFindPanelSubstringMatchTypeStartsWith")]
    pub const StartsWith: Self = Self(1);
    #[doc(alias = "NSFindPanelSubstringMatchTypeFullWord")]
    pub const FullWord: Self = Self(2);
    #[doc(alias = "NSFindPanelSubstringMatchTypeEndsWith")]
    pub const EndsWith: Self = Self(3);
}

unsafe impl Encode for NSFindPanelSubstringMatchType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFindPanelSubstringMatchType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
