//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewdropoperation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewDropOperation(pub NSUInteger);
impl NSTableViewDropOperation {
    #[doc(alias = "NSTableViewDropOn")]
    pub const On: Self = Self(0);
    #[doc(alias = "NSTableViewDropAbove")]
    pub const Above: Self = Self(1);
}

unsafe impl Encode for NSTableViewDropOperation {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewDropOperation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewcolumnautoresizingstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewColumnAutoresizingStyle(pub NSUInteger);
impl NSTableViewColumnAutoresizingStyle {
    #[doc(alias = "NSTableViewNoColumnAutoresizing")]
    pub const NoColumnAutoresizing: Self = Self(0);
    #[doc(alias = "NSTableViewUniformColumnAutoresizingStyle")]
    pub const UniformColumnAutoresizingStyle: Self = Self(1);
    #[doc(alias = "NSTableViewSequentialColumnAutoresizingStyle")]
    pub const SequentialColumnAutoresizingStyle: Self = Self(2);
    #[doc(alias = "NSTableViewReverseSequentialColumnAutoresizingStyle")]
    pub const ReverseSequentialColumnAutoresizingStyle: Self = Self(3);
    #[doc(alias = "NSTableViewLastColumnOnlyAutoresizingStyle")]
    pub const LastColumnOnlyAutoresizingStyle: Self = Self(4);
    #[doc(alias = "NSTableViewFirstColumnOnlyAutoresizingStyle")]
    pub const FirstColumnOnlyAutoresizingStyle: Self = Self(5);
}

unsafe impl Encode for NSTableViewColumnAutoresizingStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewColumnAutoresizingStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewgridlinestyle?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewGridLineStyle(pub NSUInteger);
bitflags::bitflags! {
    impl NSTableViewGridLineStyle: NSUInteger {
        #[doc(alias = "NSTableViewGridNone")]
        const GridNone = 0;
        #[doc(alias = "NSTableViewSolidVerticalGridLineMask")]
        const SolidVerticalGridLineMask = 1<<0;
        #[doc(alias = "NSTableViewSolidHorizontalGridLineMask")]
        const SolidHorizontalGridLineMask = 1<<1;
        #[doc(alias = "NSTableViewDashedHorizontalGridLineMask")]
        const DashedHorizontalGridLineMask = 1<<3;
    }
}

unsafe impl Encode for NSTableViewGridLineStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewGridLineStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewrowsizestyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewRowSizeStyle(pub NSInteger);
impl NSTableViewRowSizeStyle {
    #[doc(alias = "NSTableViewRowSizeStyleDefault")]
    pub const Default: Self = Self(-1);
    #[doc(alias = "NSTableViewRowSizeStyleCustom")]
    pub const Custom: Self = Self(0);
    #[doc(alias = "NSTableViewRowSizeStyleSmall")]
    pub const Small: Self = Self(1);
    #[doc(alias = "NSTableViewRowSizeStyleMedium")]
    pub const Medium: Self = Self(2);
    #[doc(alias = "NSTableViewRowSizeStyleLarge")]
    pub const Large: Self = Self(3);
}

unsafe impl Encode for NSTableViewRowSizeStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewRowSizeStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewStyle(pub NSInteger);
impl NSTableViewStyle {
    #[doc(alias = "NSTableViewStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "NSTableViewStyleFullWidth")]
    pub const FullWidth: Self = Self(1);
    #[doc(alias = "NSTableViewStyleInset")]
    pub const Inset: Self = Self(2);
    #[doc(alias = "NSTableViewStyleSourceList")]
    pub const SourceList: Self = Self(3);
    #[doc(alias = "NSTableViewStylePlain")]
    pub const Plain: Self = Self(4);
}

unsafe impl Encode for NSTableViewStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewselectionhighlightstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewSelectionHighlightStyle(pub NSInteger);
impl NSTableViewSelectionHighlightStyle {
    #[doc(alias = "NSTableViewSelectionHighlightStyleNone")]
    pub const None: Self = Self(-1);
    #[doc(alias = "NSTableViewSelectionHighlightStyleRegular")]
    pub const Regular: Self = Self(0);
    #[deprecated = "Set the NSTableView.style property to NSTableViewStyleSourceList instead."]
    #[doc(alias = "NSTableViewSelectionHighlightStyleSourceList")]
    pub const SourceList: Self = Self(1);
}

unsafe impl Encode for NSTableViewSelectionHighlightStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewSelectionHighlightStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewdraggingdestinationfeedbackstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewDraggingDestinationFeedbackStyle(pub NSInteger);
impl NSTableViewDraggingDestinationFeedbackStyle {
    #[doc(alias = "NSTableViewDraggingDestinationFeedbackStyleNone")]
    pub const None: Self = Self(-1);
    #[doc(alias = "NSTableViewDraggingDestinationFeedbackStyleRegular")]
    pub const Regular: Self = Self(0);
    #[doc(alias = "NSTableViewDraggingDestinationFeedbackStyleSourceList")]
    pub const SourceList: Self = Self(1);
    #[doc(alias = "NSTableViewDraggingDestinationFeedbackStyleGap")]
    pub const Gap: Self = Self(2);
}

unsafe impl Encode for NSTableViewDraggingDestinationFeedbackStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewDraggingDestinationFeedbackStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstablerowactionedge?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableRowActionEdge(pub NSInteger);
impl NSTableRowActionEdge {
    #[doc(alias = "NSTableRowActionEdgeLeading")]
    pub const Leading: Self = Self(0);
    #[doc(alias = "NSTableRowActionEdgeTrailing")]
    pub const Trailing: Self = Self(1);
}

unsafe impl Encode for NSTableRowActionEdge {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableRowActionEdge {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewautosavename?language=objc)
pub type NSTableViewAutosaveName = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewanimationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewAnimationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSTableViewAnimationOptions: NSUInteger {
        #[doc(alias = "NSTableViewAnimationEffectNone")]
        const EffectNone = 0x0;
        #[doc(alias = "NSTableViewAnimationEffectFade")]
        const EffectFade = 0x1;
        #[doc(alias = "NSTableViewAnimationEffectGap")]
        const EffectGap = 0x2;
        #[doc(alias = "NSTableViewAnimationSlideUp")]
        const SlideUp = 0x10;
        #[doc(alias = "NSTableViewAnimationSlideDown")]
        const SlideDown = 0x20;
        #[doc(alias = "NSTableViewAnimationSlideLeft")]
        const SlideLeft = 0x30;
        #[doc(alias = "NSTableViewAnimationSlideRight")]
        const SlideRight = 0x40;
    }
}

unsafe impl Encode for NSTableViewAnimationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewAnimationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableview?language=objc)
    #[unsafe(super(NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    pub struct NSTableView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibility for NSTableView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityElementProtocol for NSTableView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityGroup for NSTableView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityTable for NSTableView {}

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAnimatablePropertyContainer for NSTableView {}

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAppearanceCustomization for NSTableView {}

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
unsafe impl NSCoding for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSDraggingDestination for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSDraggingSource for NSTableView {}

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
unsafe impl NSObjectProtocol for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSTextDelegate for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSTextView",
    feature = "NSView"
))]
unsafe impl NSTextViewDelegate for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceItemIdentification for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceValidation",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceValidations for NSTableView {}

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSTableView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(dataSource))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataSource(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSTableViewDataSource>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`dataSource`][Self::dataSource].
        #[unsafe(method(setDataSource:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDataSource(
            &self,
            data_source: Option<&ProtocolObject<dyn NSTableViewDataSource>>,
        );

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSTableViewDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSTableViewDelegate>>,
        );

        #[cfg(feature = "NSTableHeaderView")]
        #[unsafe(method(headerView))]
        #[unsafe(method_family = none)]
        pub unsafe fn headerView(&self) -> Option<Retained<NSTableHeaderView>>;

        #[cfg(feature = "NSTableHeaderView")]
        /// Setter for [`headerView`][Self::headerView].
        #[unsafe(method(setHeaderView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHeaderView(&self, header_view: Option<&NSTableHeaderView>);

        #[unsafe(method(cornerView))]
        #[unsafe(method_family = none)]
        pub unsafe fn cornerView(&self) -> Option<Retained<NSView>>;

        /// Setter for [`cornerView`][Self::cornerView].
        #[unsafe(method(setCornerView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCornerView(&self, corner_view: Option<&NSView>);

        #[unsafe(method(allowsColumnReordering))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsColumnReordering(&self) -> bool;

        /// Setter for [`allowsColumnReordering`][Self::allowsColumnReordering].
        #[unsafe(method(setAllowsColumnReordering:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsColumnReordering(&self, allows_column_reordering: bool);

        #[unsafe(method(allowsColumnResizing))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsColumnResizing(&self) -> bool;

        /// Setter for [`allowsColumnResizing`][Self::allowsColumnResizing].
        #[unsafe(method(setAllowsColumnResizing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsColumnResizing(&self, allows_column_resizing: bool);

        #[unsafe(method(columnAutoresizingStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn columnAutoresizingStyle(&self) -> NSTableViewColumnAutoresizingStyle;

        /// Setter for [`columnAutoresizingStyle`][Self::columnAutoresizingStyle].
        #[unsafe(method(setColumnAutoresizingStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setColumnAutoresizingStyle(
            &self,
            column_autoresizing_style: NSTableViewColumnAutoresizingStyle,
        );

        #[unsafe(method(gridStyleMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn gridStyleMask(&self) -> NSTableViewGridLineStyle;

        /// Setter for [`gridStyleMask`][Self::gridStyleMask].
        #[unsafe(method(setGridStyleMask:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGridStyleMask(&self, grid_style_mask: NSTableViewGridLineStyle);

        #[unsafe(method(intercellSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn intercellSpacing(&self) -> NSSize;

        /// Setter for [`intercellSpacing`][Self::intercellSpacing].
        #[unsafe(method(setIntercellSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIntercellSpacing(&self, intercell_spacing: NSSize);

        #[unsafe(method(usesAlternatingRowBackgroundColors))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesAlternatingRowBackgroundColors(&self) -> bool;

        /// Setter for [`usesAlternatingRowBackgroundColors`][Self::usesAlternatingRowBackgroundColors].
        #[unsafe(method(setUsesAlternatingRowBackgroundColors:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesAlternatingRowBackgroundColors(
            &self,
            uses_alternating_row_background_colors: bool,
        );

        #[cfg(feature = "NSColor")]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundColor(&self, background_color: &NSColor);

        #[cfg(feature = "NSColor")]
        #[unsafe(method(gridColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn gridColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`gridColor`][Self::gridColor].
        #[unsafe(method(setGridColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGridColor(&self, grid_color: &NSColor);

        #[unsafe(method(rowSizeStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowSizeStyle(&self) -> NSTableViewRowSizeStyle;

        /// Setter for [`rowSizeStyle`][Self::rowSizeStyle].
        #[unsafe(method(setRowSizeStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRowSizeStyle(&self, row_size_style: NSTableViewRowSizeStyle);

        #[unsafe(method(effectiveRowSizeStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn effectiveRowSizeStyle(&self) -> NSTableViewRowSizeStyle;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rowHeight))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`rowHeight`][Self::rowHeight].
        #[unsafe(method(setRowHeight:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRowHeight(&self, row_height: CGFloat);

        #[unsafe(method(noteHeightOfRowsWithIndexesChanged:))]
        #[unsafe(method_family = none)]
        pub unsafe fn noteHeightOfRowsWithIndexesChanged(&self, index_set: &NSIndexSet);

        #[cfg(feature = "NSTableColumn")]
        #[unsafe(method(tableColumns))]
        #[unsafe(method_family = none)]
        pub unsafe fn tableColumns(&self) -> Retained<NSArray<NSTableColumn>>;

        #[unsafe(method(numberOfColumns))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfColumns(&self) -> NSInteger;

        #[unsafe(method(numberOfRows))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfRows(&self) -> NSInteger;

        #[cfg(feature = "NSTableColumn")]
        #[unsafe(method(addTableColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addTableColumn(&self, table_column: &NSTableColumn);

        #[cfg(feature = "NSTableColumn")]
        #[unsafe(method(removeTableColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeTableColumn(&self, table_column: &NSTableColumn);

        #[unsafe(method(moveColumn:toColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveColumn_toColumn(&self, old_index: NSInteger, new_index: NSInteger);

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        #[unsafe(method(columnWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn columnWithIdentifier(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
        ) -> NSInteger;

        #[cfg(all(
            feature = "NSTableColumn",
            feature = "NSUserInterfaceItemIdentification"
        ))]
        #[unsafe(method(tableColumnWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn tableColumnWithIdentifier(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
        ) -> Option<Retained<NSTableColumn>>;

        #[unsafe(method(tile))]
        #[unsafe(method_family = none)]
        pub unsafe fn tile(&self);

        #[unsafe(method(sizeToFit))]
        #[unsafe(method_family = none)]
        pub unsafe fn sizeToFit(&self);

        #[unsafe(method(sizeLastColumnToFit))]
        #[unsafe(method_family = none)]
        pub unsafe fn sizeLastColumnToFit(&self);

        #[unsafe(method(scrollRowToVisible:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollRowToVisible(&self, row: NSInteger);

        #[unsafe(method(scrollColumnToVisible:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollColumnToVisible(&self, column: NSInteger);

        #[unsafe(method(reloadData))]
        #[unsafe(method_family = none)]
        pub unsafe fn reloadData(&self);

        #[unsafe(method(noteNumberOfRowsChanged))]
        #[unsafe(method_family = none)]
        pub unsafe fn noteNumberOfRowsChanged(&self);

        #[unsafe(method(reloadDataForRowIndexes:columnIndexes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn reloadDataForRowIndexes_columnIndexes(
            &self,
            row_indexes: &NSIndexSet,
            column_indexes: &NSIndexSet,
        );

        #[unsafe(method(editedColumn))]
        #[unsafe(method_family = none)]
        pub unsafe fn editedColumn(&self) -> NSInteger;

        #[unsafe(method(editedRow))]
        #[unsafe(method_family = none)]
        pub unsafe fn editedRow(&self) -> NSInteger;

        #[unsafe(method(clickedColumn))]
        #[unsafe(method_family = none)]
        pub unsafe fn clickedColumn(&self) -> NSInteger;

        #[unsafe(method(clickedRow))]
        #[unsafe(method_family = none)]
        pub unsafe fn clickedRow(&self) -> NSInteger;

        #[unsafe(method(doubleAction))]
        #[unsafe(method_family = none)]
        pub unsafe fn doubleAction(&self) -> Option<Sel>;

        /// Setter for [`doubleAction`][Self::doubleAction].
        #[unsafe(method(setDoubleAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDoubleAction(&self, double_action: Option<Sel>);

        #[unsafe(method(sortDescriptors))]
        #[unsafe(method_family = none)]
        pub unsafe fn sortDescriptors(&self) -> Retained<NSArray<NSSortDescriptor>>;

        /// Setter for [`sortDescriptors`][Self::sortDescriptors].
        #[unsafe(method(setSortDescriptors:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSortDescriptors(&self, sort_descriptors: &NSArray<NSSortDescriptor>);

        #[cfg(all(feature = "NSImage", feature = "NSTableColumn"))]
        #[unsafe(method(setIndicatorImage:inTableColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIndicatorImage_inTableColumn(
            &self,
            image: Option<&NSImage>,
            table_column: &NSTableColumn,
        );

        #[cfg(all(feature = "NSImage", feature = "NSTableColumn"))]
        #[unsafe(method(indicatorImageInTableColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn indicatorImageInTableColumn(
            &self,
            table_column: &NSTableColumn,
        ) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSTableColumn")]
        #[unsafe(method(highlightedTableColumn))]
        #[unsafe(method_family = none)]
        pub unsafe fn highlightedTableColumn(&self) -> Option<Retained<NSTableColumn>>;

        #[cfg(feature = "NSTableColumn")]
        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`highlightedTableColumn`][Self::highlightedTableColumn].
        #[unsafe(method(setHighlightedTableColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHighlightedTableColumn(
            &self,
            highlighted_table_column: Option<&NSTableColumn>,
        );

        #[unsafe(method(verticalMotionCanBeginDrag))]
        #[unsafe(method_family = none)]
        pub unsafe fn verticalMotionCanBeginDrag(&self) -> bool;

        /// Setter for [`verticalMotionCanBeginDrag`][Self::verticalMotionCanBeginDrag].
        #[unsafe(method(setVerticalMotionCanBeginDrag:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setVerticalMotionCanBeginDrag(&self, vertical_motion_can_begin_drag: bool);

        #[unsafe(method(canDragRowsWithIndexes:atPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canDragRowsWithIndexes_atPoint(
            &self,
            row_indexes: &NSIndexSet,
            mouse_down_point: NSPoint,
        ) -> bool;

        #[cfg(all(feature = "NSEvent", feature = "NSImage", feature = "NSTableColumn"))]
        #[unsafe(method(dragImageForRowsWithIndexes:tableColumns:event:offset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragImageForRowsWithIndexes_tableColumns_event_offset(
            &self,
            drag_rows: &NSIndexSet,
            table_columns: &NSArray<NSTableColumn>,
            drag_event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Retained<NSImage>;

        #[cfg(feature = "NSDragging")]
        #[unsafe(method(setDraggingSourceOperationMask:forLocal:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDraggingSourceOperationMask_forLocal(
            &self,
            mask: NSDragOperation,
            is_local: bool,
        );

        #[unsafe(method(setDropRow:dropOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDropRow_dropOperation(
            &self,
            row: NSInteger,
            drop_operation: NSTableViewDropOperation,
        );

        #[unsafe(method(allowsMultipleSelection))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsMultipleSelection(&self) -> bool;

        /// Setter for [`allowsMultipleSelection`][Self::allowsMultipleSelection].
        #[unsafe(method(setAllowsMultipleSelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsMultipleSelection(&self, allows_multiple_selection: bool);

        #[unsafe(method(allowsEmptySelection))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsEmptySelection(&self) -> bool;

        /// Setter for [`allowsEmptySelection`][Self::allowsEmptySelection].
        #[unsafe(method(setAllowsEmptySelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsEmptySelection(&self, allows_empty_selection: bool);

        #[unsafe(method(allowsColumnSelection))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsColumnSelection(&self) -> bool;

        /// Setter for [`allowsColumnSelection`][Self::allowsColumnSelection].
        #[unsafe(method(setAllowsColumnSelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsColumnSelection(&self, allows_column_selection: bool);

        #[unsafe(method(selectAll:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectAll(&self, sender: Option<&AnyObject>);

        #[unsafe(method(deselectAll:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deselectAll(&self, sender: Option<&AnyObject>);

        #[unsafe(method(selectColumnIndexes:byExtendingSelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectColumnIndexes_byExtendingSelection(
            &self,
            indexes: &NSIndexSet,
            extend: bool,
        );

        #[unsafe(method(selectRowIndexes:byExtendingSelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectRowIndexes_byExtendingSelection(
            &self,
            indexes: &NSIndexSet,
            extend: bool,
        );

        #[unsafe(method(selectedColumnIndexes))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedColumnIndexes(&self) -> Retained<NSIndexSet>;

        #[unsafe(method(selectedRowIndexes))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedRowIndexes(&self) -> Retained<NSIndexSet>;

        #[unsafe(method(deselectColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deselectColumn(&self, column: NSInteger);

        #[unsafe(method(deselectRow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deselectRow(&self, row: NSInteger);

        #[unsafe(method(selectedColumn))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedColumn(&self) -> NSInteger;

        #[unsafe(method(selectedRow))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedRow(&self) -> NSInteger;

        #[unsafe(method(isColumnSelected:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isColumnSelected(&self, column: NSInteger) -> bool;

        #[unsafe(method(isRowSelected:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isRowSelected(&self, row: NSInteger) -> bool;

        #[unsafe(method(numberOfSelectedColumns))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfSelectedColumns(&self) -> NSInteger;

        #[unsafe(method(numberOfSelectedRows))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfSelectedRows(&self) -> NSInteger;

        #[unsafe(method(allowsTypeSelect))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsTypeSelect(&self) -> bool;

        /// Setter for [`allowsTypeSelect`][Self::allowsTypeSelect].
        #[unsafe(method(setAllowsTypeSelect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsTypeSelect(&self, allows_type_select: bool);

        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub unsafe fn style(&self) -> NSTableViewStyle;

        /// Setter for [`style`][Self::style].
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStyle(&self, style: NSTableViewStyle);

        #[unsafe(method(effectiveStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn effectiveStyle(&self) -> NSTableViewStyle;

        #[unsafe(method(selectionHighlightStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectionHighlightStyle(&self) -> NSTableViewSelectionHighlightStyle;

        /// Setter for [`selectionHighlightStyle`][Self::selectionHighlightStyle].
        #[unsafe(method(setSelectionHighlightStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectionHighlightStyle(
            &self,
            selection_highlight_style: NSTableViewSelectionHighlightStyle,
        );

        #[unsafe(method(draggingDestinationFeedbackStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn draggingDestinationFeedbackStyle(
            &self,
        ) -> NSTableViewDraggingDestinationFeedbackStyle;

        /// Setter for [`draggingDestinationFeedbackStyle`][Self::draggingDestinationFeedbackStyle].
        #[unsafe(method(setDraggingDestinationFeedbackStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDraggingDestinationFeedbackStyle(
            &self,
            dragging_destination_feedback_style: NSTableViewDraggingDestinationFeedbackStyle,
        );

        #[unsafe(method(rectOfColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rectOfColumn(&self, column: NSInteger) -> NSRect;

        #[unsafe(method(rectOfRow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rectOfRow(&self, row: NSInteger) -> NSRect;

        #[unsafe(method(columnIndexesInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn columnIndexesInRect(&self, rect: NSRect) -> Retained<NSIndexSet>;

        #[unsafe(method(rowsInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowsInRect(&self, rect: NSRect) -> NSRange;

        #[unsafe(method(columnAtPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn columnAtPoint(&self, point: NSPoint) -> NSInteger;

        #[unsafe(method(rowAtPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowAtPoint(&self, point: NSPoint) -> NSInteger;

        #[unsafe(method(frameOfCellAtColumn:row:))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameOfCellAtColumn_row(&self, column: NSInteger, row: NSInteger) -> NSRect;

        #[unsafe(method(autosaveName))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosaveName(&self) -> Option<Retained<NSTableViewAutosaveName>>;

        /// Setter for [`autosaveName`][Self::autosaveName].
        #[unsafe(method(setAutosaveName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutosaveName(&self, autosave_name: Option<&NSTableViewAutosaveName>);

        #[unsafe(method(autosaveTableColumns))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosaveTableColumns(&self) -> bool;

        /// Setter for [`autosaveTableColumns`][Self::autosaveTableColumns].
        #[unsafe(method(setAutosaveTableColumns:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutosaveTableColumns(&self, autosave_table_columns: bool);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(editColumn:row:withEvent:select:))]
        #[unsafe(method_family = none)]
        pub unsafe fn editColumn_row_withEvent_select(
            &self,
            column: NSInteger,
            row: NSInteger,
            event: Option<&NSEvent>,
            select: bool,
        );

        #[unsafe(method(drawRow:clipRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawRow_clipRect(&self, row: NSInteger, clip_rect: NSRect);

        #[unsafe(method(highlightSelectionInClipRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn highlightSelectionInClipRect(&self, clip_rect: NSRect);

        #[unsafe(method(drawGridInClipRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawGridInClipRect(&self, clip_rect: NSRect);

        #[unsafe(method(drawBackgroundInClipRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawBackgroundInClipRect(&self, clip_rect: NSRect);

        #[unsafe(method(viewAtColumn:row:makeIfNecessary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewAtColumn_row_makeIfNecessary(
            &self,
            column: NSInteger,
            row: NSInteger,
            make_if_necessary: bool,
        ) -> Option<Retained<NSView>>;

        #[cfg(feature = "NSTableRowView")]
        #[unsafe(method(rowViewAtRow:makeIfNecessary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowViewAtRow_makeIfNecessary(
            &self,
            row: NSInteger,
            make_if_necessary: bool,
        ) -> Option<Retained<NSTableRowView>>;

        #[unsafe(method(rowForView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowForView(&self, view: &NSView) -> NSInteger;

        #[unsafe(method(columnForView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn columnForView(&self, view: &NSView) -> NSInteger;

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        #[unsafe(method(makeViewWithIdentifier:owner:))]
        #[unsafe(method_family = none)]
        pub unsafe fn makeViewWithIdentifier_owner(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
            owner: Option<&AnyObject>,
        ) -> Option<Retained<NSView>>;

        #[cfg(all(feature = "NSTableRowView", feature = "block2"))]
        #[unsafe(method(enumerateAvailableRowViewsUsingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn enumerateAvailableRowViewsUsingBlock(
            &self,
            handler: &block2::Block<dyn Fn(NonNull<NSTableRowView>, NSInteger) + '_>,
        );

        #[unsafe(method(floatsGroupRows))]
        #[unsafe(method_family = none)]
        pub unsafe fn floatsGroupRows(&self) -> bool;

        /// Setter for [`floatsGroupRows`][Self::floatsGroupRows].
        #[unsafe(method(setFloatsGroupRows:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFloatsGroupRows(&self, floats_group_rows: bool);

        #[unsafe(method(rowActionsVisible))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowActionsVisible(&self) -> bool;

        /// Setter for [`rowActionsVisible`][Self::rowActionsVisible].
        #[unsafe(method(setRowActionsVisible:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRowActionsVisible(&self, row_actions_visible: bool);

        #[unsafe(method(beginUpdates))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginUpdates(&self);

        #[unsafe(method(endUpdates))]
        #[unsafe(method_family = none)]
        pub unsafe fn endUpdates(&self);

        #[unsafe(method(insertRowsAtIndexes:withAnimation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertRowsAtIndexes_withAnimation(
            &self,
            indexes: &NSIndexSet,
            animation_options: NSTableViewAnimationOptions,
        );

        #[unsafe(method(removeRowsAtIndexes:withAnimation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeRowsAtIndexes_withAnimation(
            &self,
            indexes: &NSIndexSet,
            animation_options: NSTableViewAnimationOptions,
        );

        #[unsafe(method(moveRowAtIndex:toIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveRowAtIndex_toIndex(&self, old_index: NSInteger, new_index: NSInteger);

        #[unsafe(method(hideRowsAtIndexes:withAnimation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hideRowsAtIndexes_withAnimation(
            &self,
            indexes: &NSIndexSet,
            row_animation: NSTableViewAnimationOptions,
        );

        #[unsafe(method(unhideRowsAtIndexes:withAnimation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unhideRowsAtIndexes_withAnimation(
            &self,
            indexes: &NSIndexSet,
            row_animation: NSTableViewAnimationOptions,
        );

        #[unsafe(method(hiddenRowIndexes))]
        #[unsafe(method_family = none)]
        pub unsafe fn hiddenRowIndexes(&self) -> Retained<NSIndexSet>;

        #[cfg(all(feature = "NSNib", feature = "NSUserInterfaceItemIdentification"))]
        #[unsafe(method(registerNib:forIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerNib_forIdentifier(
            &self,
            nib: Option<&NSNib>,
            identifier: &NSUserInterfaceItemIdentifier,
        );

        #[cfg(all(feature = "NSNib", feature = "NSUserInterfaceItemIdentification"))]
        #[unsafe(method(registeredNibsByIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn registeredNibsByIdentifier(
            &self,
        ) -> Option<Retained<NSDictionary<NSUserInterfaceItemIdentifier, NSNib>>>;

        #[cfg(feature = "NSTableRowView")]
        #[unsafe(method(didAddRowView:forRow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didAddRowView_forRow(&self, row_view: &NSTableRowView, row: NSInteger);

        #[cfg(feature = "NSTableRowView")]
        #[unsafe(method(didRemoveRowView:forRow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didRemoveRowView_forRow(&self, row_view: &NSTableRowView, row: NSInteger);

        #[unsafe(method(usesStaticContents))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesStaticContents(&self) -> bool;

        /// Setter for [`usesStaticContents`][Self::usesStaticContents].
        #[unsafe(method(setUsesStaticContents:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesStaticContents(&self, uses_static_contents: bool);

        #[cfg(feature = "NSUserInterfaceLayout")]
        #[unsafe(method(userInterfaceLayoutDirection))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInterfaceLayoutDirection(&self) -> NSUserInterfaceLayoutDirection;

        #[cfg(feature = "NSUserInterfaceLayout")]
        /// Setter for [`userInterfaceLayoutDirection`][Self::userInterfaceLayoutDirection].
        #[unsafe(method(setUserInterfaceLayoutDirection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserInterfaceLayoutDirection(
            &self,
            user_interface_layout_direction: NSUserInterfaceLayoutDirection,
        );

        #[unsafe(method(usesAutomaticRowHeights))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesAutomaticRowHeights(&self) -> bool;

        /// Setter for [`usesAutomaticRowHeights`][Self::usesAutomaticRowHeights].
        #[unsafe(method(setUsesAutomaticRowHeights:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesAutomaticRowHeights(&self, uses_automatic_row_heights: bool);
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSTableView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSTableView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewdelegate?language=objc)
    #[cfg(feature = "NSControl")]
    pub unsafe trait NSTableViewDelegate: NSControlTextEditingDelegate {
        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:viewForTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_viewForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> Option<Retained<NSView>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTableRowView",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:rowViewForRow:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_rowViewForRow(
            &self,
            table_view: &NSTableView,
            row: NSInteger,
        ) -> Option<Retained<NSTableRowView>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTableRowView",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:didAddRowView:forRow:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_didAddRowView_forRow(
            &self,
            table_view: &NSTableView,
            row_view: &NSTableRowView,
            row: NSInteger,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTableRowView",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:didRemoveRowView:forRow:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_didRemoveRowView_forRow(
            &self,
            table_view: &NSTableView,
            row_view: &NSTableRowView,
            row: NSInteger,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:willDisplayCell:forTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_willDisplayCell_forTableColumn_row(
            &self,
            table_view: &NSTableView,
            cell: &AnyObject,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:shouldEditTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_shouldEditTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSCell",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:toolTipForCell:rect:tableColumn:row:mouseLocation:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_toolTipForCell_rect_tableColumn_row_mouseLocation(
            &self,
            table_view: &NSTableView,
            cell: &NSCell,
            rect: NSRectPointer,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
            mouse_location: NSPoint,
        ) -> Retained<NSString>;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:shouldShowCellExpansionForTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_shouldShowCellExpansionForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSCell",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:shouldTrackCell:forTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_shouldTrackCell_forTableColumn_row(
            &self,
            table_view: &NSTableView,
            cell: &NSCell,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSCell",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dataCellForTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_dataCellForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> Option<Retained<NSCell>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(selectionShouldChangeInTableView:))]
        #[unsafe(method_family = none)]
        unsafe fn selectionShouldChangeInTableView(&self, table_view: &NSTableView) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:shouldSelectRow:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_shouldSelectRow(
            &self,
            table_view: &NSTableView,
            row: NSInteger,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:selectionIndexesForProposedSelection:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_selectionIndexesForProposedSelection(
            &self,
            table_view: &NSTableView,
            proposed_selection_indexes: &NSIndexSet,
        ) -> Retained<NSIndexSet>;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:shouldSelectTableColumn:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_shouldSelectTableColumn(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:mouseDownInHeaderOfTableColumn:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_mouseDownInHeaderOfTableColumn(
            &self,
            table_view: &NSTableView,
            table_column: &NSTableColumn,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:didClickTableColumn:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_didClickTableColumn(
            &self,
            table_view: &NSTableView,
            table_column: &NSTableColumn,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:didDragTableColumn:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_didDragTableColumn(
            &self,
            table_view: &NSTableView,
            table_column: &NSTableColumn,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:heightOfRow:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_heightOfRow(&self, table_view: &NSTableView, row: NSInteger)
            -> CGFloat;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:typeSelectStringForTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_typeSelectStringForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:nextTypeSelectMatchFromRow:toRow:forString:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_nextTypeSelectMatchFromRow_toRow_forString(
            &self,
            table_view: &NSTableView,
            start_row: NSInteger,
            end_row: NSInteger,
            search_string: &NSString,
        ) -> NSInteger;

        #[cfg(all(feature = "NSEvent", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:shouldTypeSelectForEvent:withCurrentSearchString:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_shouldTypeSelectForEvent_withCurrentSearchString(
            &self,
            table_view: &NSTableView,
            event: &NSEvent,
            search_string: Option<&NSString>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:isGroupRow:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_isGroupRow(&self, table_view: &NSTableView, row: NSInteger) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:sizeToFitWidthOfColumn:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_sizeToFitWidthOfColumn(
            &self,
            table_view: &NSTableView,
            column: NSInteger,
        ) -> CGFloat;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:shouldReorderColumn:toColumn:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_shouldReorderColumn_toColumn(
            &self,
            table_view: &NSTableView,
            column_index: NSInteger,
            new_column_index: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTableViewRowAction",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:rowActionsForRow:edge:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_rowActionsForRow_edge(
            &self,
            table_view: &NSTableView,
            row: NSInteger,
            edge: NSTableRowActionEdge,
        ) -> Retained<NSArray<NSTableViewRowAction>>;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:userCanChangeVisibilityOfTableColumn:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_userCanChangeVisibilityOfTableColumn(
            &self,
            table_view: &NSTableView,
            column: &NSTableColumn,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:userDidChangeVisibilityOfTableColumns:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_userDidChangeVisibilityOfTableColumns(
            &self,
            table_view: &NSTableView,
            columns: &NSArray<NSTableColumn>,
        );

        #[optional]
        #[unsafe(method(tableViewSelectionDidChange:))]
        #[unsafe(method_family = none)]
        unsafe fn tableViewSelectionDidChange(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(tableViewColumnDidMove:))]
        #[unsafe(method_family = none)]
        unsafe fn tableViewColumnDidMove(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(tableViewColumnDidResize:))]
        #[unsafe(method_family = none)]
        unsafe fn tableViewColumnDidResize(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(tableViewSelectionIsChanging:))]
        #[unsafe(method_family = none)]
        unsafe fn tableViewSelectionIsChanging(&self, notification: &NSNotification);
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewselectiondidchangenotification?language=objc)
    pub static NSTableViewSelectionDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewcolumndidmovenotification?language=objc)
    pub static NSTableViewColumnDidMoveNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewcolumndidresizenotification?language=objc)
    pub static NSTableViewColumnDidResizeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewselectionischangingnotification?language=objc)
    pub static NSTableViewSelectionIsChangingNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewrowviewkey?language=objc)
    #[cfg(feature = "NSUserInterfaceItemIdentification")]
    pub static NSTableViewRowViewKey: &'static NSUserInterfaceItemIdentifier;
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstableviewdatasource?language=objc)
    pub unsafe trait NSTableViewDataSource: NSObjectProtocol {
        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(numberOfRowsInTableView:))]
        #[unsafe(method_family = none)]
        unsafe fn numberOfRowsInTableView(&self, table_view: &NSTableView) -> NSInteger;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:objectValueForTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_objectValueForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:setObjectValue:forTableColumn:row:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_setObjectValue_forTableColumn_row(
            &self,
            table_view: &NSTableView,
            object: Option<&AnyObject>,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        );

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tableView:sortDescriptorsDidChange:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_sortDescriptorsDidChange(
            &self,
            table_view: &NSTableView,
            old_descriptors: &NSArray<NSSortDescriptor>,
        );

        #[cfg(all(
            feature = "NSControl",
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:pasteboardWriterForRow:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_pasteboardWriterForRow(
            &self,
            table_view: &NSTableView,
            row: NSInteger,
        ) -> Option<Retained<ProtocolObject<dyn NSPasteboardWriting>>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDraggingSession",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:draggingSession:willBeginAtPoint:forRowIndexes:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_draggingSession_willBeginAtPoint_forRowIndexes(
            &self,
            table_view: &NSTableView,
            session: &NSDraggingSession,
            screen_point: NSPoint,
            row_indexes: &NSIndexSet,
        );

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSDraggingSession",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:draggingSession:endedAtPoint:operation:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_draggingSession_endedAtPoint_operation(
            &self,
            table_view: &NSTableView,
            session: &NSDraggingSession,
            screen_point: NSPoint,
            operation: NSDragOperation,
        );

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:updateDraggingItemsForDrag:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_updateDraggingItemsForDrag(
            &self,
            table_view: &NSTableView,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
        );

        #[cfg(all(
            feature = "NSControl",
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[deprecated = "Use -tableView:pasteboardWriterForRow: instead"]
        #[optional]
        #[unsafe(method(tableView:writeRowsWithIndexes:toPasteboard:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_writeRowsWithIndexes_toPasteboard(
            &self,
            table_view: &NSTableView,
            row_indexes: &NSIndexSet,
            pboard: &NSPasteboard,
        ) -> bool;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:validateDrop:proposedRow:proposedDropOperation:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_validateDrop_proposedRow_proposedDropOperation(
            &self,
            table_view: &NSTableView,
            info: &ProtocolObject<dyn NSDraggingInfo>,
            row: NSInteger,
            drop_operation: NSTableViewDropOperation,
        ) -> NSDragOperation;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(tableView:acceptDrop:row:dropOperation:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_acceptDrop_row_dropOperation(
            &self,
            table_view: &NSTableView,
            info: &ProtocolObject<dyn NSDraggingInfo>,
            row: NSInteger,
            drop_operation: NSTableViewDropOperation,
        ) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use NSFilePromiseReceiver objects instead"]
        #[optional]
        #[unsafe(method(tableView:namesOfPromisedFilesDroppedAtDestination:forDraggedRowsWithIndexes:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_namesOfPromisedFilesDroppedAtDestination_forDraggedRowsWithIndexes(
            &self,
            table_view: &NSTableView,
            drop_destination: &NSURL,
            index_set: &NSIndexSet,
        ) -> Retained<NSArray<NSString>>;
    }
);

/// NSDeprecated.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSTableView {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(setDrawsGrid:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDrawsGrid(&self, flag: bool);

        #[deprecated]
        #[unsafe(method(drawsGrid))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawsGrid(&self) -> bool;

        #[deprecated]
        #[unsafe(method(selectColumn:byExtendingSelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectColumn_byExtendingSelection(&self, column: NSInteger, extend: bool);

        #[deprecated]
        #[unsafe(method(selectRow:byExtendingSelection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectRow_byExtendingSelection(&self, row: NSInteger, extend: bool);

        #[deprecated]
        #[unsafe(method(selectedColumnEnumerator))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedColumnEnumerator(&self) -> Retained<NSEnumerator>;

        #[deprecated]
        #[unsafe(method(selectedRowEnumerator))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedRowEnumerator(&self) -> Retained<NSEnumerator>;

        #[cfg(all(feature = "NSEvent", feature = "NSImage"))]
        #[deprecated]
        #[unsafe(method(dragImageForRows:event:dragImageOffset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragImageForRows_event_dragImageOffset(
            &self,
            drag_rows: &NSArray,
            drag_event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Option<Retained<NSImage>>;

        #[deprecated]
        #[unsafe(method(setAutoresizesAllColumnsToFit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutoresizesAllColumnsToFit(&self, flag: bool);

        #[deprecated]
        #[unsafe(method(autoresizesAllColumnsToFit))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoresizesAllColumnsToFit(&self) -> bool;

        #[deprecated]
        #[unsafe(method(columnsInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn columnsInRect(&self, rect: NSRect) -> NSRange;

        #[cfg(feature = "NSCell")]
        #[deprecated = "Use View Based TableView and -viewAtColumn:row:"]
        #[unsafe(method(preparedCellAtColumn:row:))]
        #[unsafe(method_family = none)]
        pub unsafe fn preparedCellAtColumn_row(
            &self,
            column: NSInteger,
            row: NSInteger,
        ) -> Option<Retained<NSCell>>;

        #[cfg(feature = "NSText")]
        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[unsafe(method(textShouldBeginEditing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn textShouldBeginEditing(&self, text_object: &NSText) -> bool;

        #[cfg(feature = "NSText")]
        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[unsafe(method(textShouldEndEditing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn textShouldEndEditing(&self, text_object: &NSText) -> bool;

        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[unsafe(method(textDidBeginEditing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn textDidBeginEditing(&self, notification: &NSNotification);

        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[unsafe(method(textDidEndEditing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn textDidEndEditing(&self, notification: &NSNotification);

        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[unsafe(method(textDidChange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn textDidChange(&self, notification: &NSNotification);

        #[cfg(feature = "NSCell")]
        #[deprecated = "Use a View Based TableView; observe the window’s firstResponder for focus change notifications"]
        #[unsafe(method(shouldFocusCell:atColumn:row:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldFocusCell_atColumn_row(
            &self,
            cell: &NSCell,
            column: NSInteger,
            row: NSInteger,
        ) -> bool;

        #[deprecated = "Use a View Based TableView and observe the window.firstResponder"]
        #[unsafe(method(focusedColumn))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusedColumn(&self) -> NSInteger;

        #[deprecated = "Use a View Based TableView; make a particular view the first responder with [window makeFirstResponder:view] to focus it."]
        #[unsafe(method(setFocusedColumn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFocusedColumn(&self, focused_column: NSInteger);

        #[deprecated = "Use a View Based TableView; directly interact with a particular view as required and call -performClick: on it, if necessary"]
        #[unsafe(method(performClickOnCellAtColumn:row:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performClickOnCellAtColumn_row(&self, column: NSInteger, row: NSInteger);
    );
}
