//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Represents the types of sharing (collaborating on an item vs. sending a copy of the item)
/// The share picker supports up to two modes, each of which corresponds to one of these types
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingcollaborationmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSharingCollaborationMode(pub NSInteger);
impl NSSharingCollaborationMode {
    #[doc(alias = "NSSharingCollaborationModeSendCopy")]
    pub const SendCopy: Self = Self(0);
    #[doc(alias = "NSSharingCollaborationModeCollaborate")]
    pub const Collaborate: Self = Self(1);
}

unsafe impl Encode for NSSharingCollaborationMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSSharingCollaborationMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// Specifies whether a specific type of sharing should be disabled in the share picker, and if so, whether a reason should be provided for the disablement
    /// If a reason is provided, the corresponding mode will show up as an option, but an alert explaining why it is disabled will show if it is chosen, and the mode will switch back to the supported one
    /// Optionally, an extra alert button can be provided for a "recovery suggestion". This can give a user a way to fix whatever is causing this type of sharing to be disabled
    /// If no reason is provided, the corresponding mode will not show up as an option
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nssharingcollaborationmoderestriction?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSSharingCollaborationModeRestriction;
);

unsafe impl NSCoding for NSSharingCollaborationModeRestriction {}

unsafe impl NSCopying for NSSharingCollaborationModeRestriction {}

unsafe impl CopyingHelper for NSSharingCollaborationModeRestriction {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSSharingCollaborationModeRestriction {}

unsafe impl NSSecureCoding for NSSharingCollaborationModeRestriction {}

impl NSSharingCollaborationModeRestriction {
    extern_methods!(
        /// The type of sharing which should be disabled
        #[unsafe(method(disabledMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn disabledMode(&self) -> NSSharingCollaborationMode;

        /// The title of the alert if a reason for disabling is provided
        #[unsafe(method(alertTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertTitle(&self) -> Option<Retained<NSString>>;

        /// The message of the alert if a reason for disabling is provided
        #[unsafe(method(alertMessage))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertMessage(&self) -> Option<Retained<NSString>>;

        /// The label on the alert button which will simply confirm that the alert was viewed and dismiss it
        /// Defaults to "OK"
        #[unsafe(method(alertDismissButtonTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertDismissButtonTitle(&self) -> Option<Retained<NSString>>;

        /// The label on the recovery suggestion button if it is provided
        #[unsafe(method(alertRecoverySuggestionButtonTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertRecoverySuggestionButtonTitle(&self) -> Option<Retained<NSString>>;

        /// The URL that is opened when the user selects the recovery suggestion, if any
        #[unsafe(method(alertRecoverySuggestionButtonLaunchURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertRecoverySuggestionButtonLaunchURL(&self) -> Option<Retained<NSURL>>;

        /// - Parameters:
        /// - disabledMode: The disabled type of sharing
        #[unsafe(method(initWithDisabledMode:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDisabledMode(
            this: Allocated<Self>,
            disabled_mode: NSSharingCollaborationMode,
        ) -> Retained<Self>;

        /// - Parameters:
        /// - disabledMode: The disabled type of sharing
        /// - alertTitle: The alert title
        /// - alertMessage: The alert message
        #[unsafe(method(initWithDisabledMode:alertTitle:alertMessage:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDisabledMode_alertTitle_alertMessage(
            this: Allocated<Self>,
            disabled_mode: NSSharingCollaborationMode,
            alert_title: &NSString,
            alert_message: &NSString,
        ) -> Retained<Self>;

        /// - Parameters:
        /// - disabledMode: The disabled type of sharing
        /// - alertTitle: The alert title
        /// - alertMessage: The alert message
        /// - alertDismissButtonTitle: The label on the default alert button
        #[unsafe(method(initWithDisabledMode:alertTitle:alertMessage:alertDismissButtonTitle:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDisabledMode_alertTitle_alertMessage_alertDismissButtonTitle(
            this: Allocated<Self>,
            disabled_mode: NSSharingCollaborationMode,
            alert_title: &NSString,
            alert_message: &NSString,
            alert_dismiss_button_title: &NSString,
        ) -> Retained<Self>;

        /// - Parameters:
        /// - disabledMode: The disabled type of sharing
        /// - alertTitle: The alert title
        /// - alertMessage: The alert message
        /// - alertDismissButtonTitle: The label on the default alert button
        /// - alertRecoverySuggestionButtonTitle: The label on the optional recovery suggestion button on the alert
        /// - alertRecoverySuggestionButtonLaunchURL: The URL that is opened when the optional recovery suggestion button is selected
        #[unsafe(method(initWithDisabledMode:alertTitle:alertMessage:alertDismissButtonTitle:alertRecoverySuggestionButtonTitle:alertRecoverySuggestionButtonLaunchURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDisabledMode_alertTitle_alertMessage_alertDismissButtonTitle_alertRecoverySuggestionButtonTitle_alertRecoverySuggestionButtonLaunchURL(
            this: Allocated<Self>,
            disabled_mode: NSSharingCollaborationMode,
            alert_title: &NSString,
            alert_message: &NSString,
            alert_dismiss_button_title: &NSString,
            alert_recovery_suggestion_button_title: &NSString,
            alert_recovery_suggestion_button_launch_url: &NSURL,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
