//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// The following flags are for `-activateWithOptions:` and equivalent.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsapplicationactivationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSApplicationActivationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSApplicationActivationOptions: NSUInteger {
/// By default, activation brings only the main and key
/// windows forward. If you specify `activateAllWindows`,
/// all of the application's windows are brought forward.
        #[doc(alias = "NSApplicationActivateAllWindows")]
        const ActivateAllWindows = 1<<0;
/// The application is activated regardless of the currently
/// active app.
#[deprecated = "ignoringOtherApps is deprecated in macOS 14 and will have no effect."]
        #[doc(alias = "NSApplicationActivateIgnoringOtherApps")]
        const ActivateIgnoringOtherApps = 1<<1;
    }
}

unsafe impl Encode for NSApplicationActivationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSApplicationActivationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The following activation policies control whether and how an application may be activated.
/// They are determined by the `Info.plist`.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsapplicationactivationpolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSApplicationActivationPolicy(pub NSInteger);
impl NSApplicationActivationPolicy {
    #[doc(alias = "NSApplicationActivationPolicyRegular")]
    pub const Regular: Self = Self(0);
    #[doc(alias = "NSApplicationActivationPolicyAccessory")]
    pub const Accessory: Self = Self(1);
    #[doc(alias = "NSApplicationActivationPolicyProhibited")]
    pub const Prohibited: Self = Self(2);
}

unsafe impl Encode for NSApplicationActivationPolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSApplicationActivationPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// `NSRunningApplication` is a class to manipulate and provide information for a single instance of an application.  Only user applications are tracked; this does not provide information about every process on the system.
    ///
    /// Some properties of an application are fixed, such as the bundle identifier.  Other properties may vary over time, such as whether the app is hidden.  Properties that vary can be observed with KVO, in which case the description comment for the method will mention it.
    ///
    /// Properties that vary over time are inherently race-prone.  For example, a hidden app may unhide itself at any time.  To ameliorate this, properties persist until the next turn of the main run loop in a common mode.  For example, if you repeatedly poll an unhidden app for its hidden property without allowing the run loop to run, it will continue to return `NO`, even if the app hides, until the next turn of the run loop.
    ///
    /// `NSRunningApplication` is thread safe, in that its properties are returned atomically.  However, it is still subject to the main run loop policy described above.  If you access an instance of `NSRunningApplication` from a background thread, be aware that its time-varying properties may change from under you as the main run loop runs (or not).
    ///
    /// An `NSRunningApplication` instance remains valid after the application exits.  However, most properties lose their significance, and some properties may not be available on a terminated application.
    ///
    /// To access the list of all running applications, use the `-runningApplications` method on `NSWorkspace`.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrunningapplication?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSRunningApplication;
);

unsafe impl Send for NSRunningApplication {}

unsafe impl Sync for NSRunningApplication {}

unsafe impl NSObjectProtocol for NSRunningApplication {}

impl NSRunningApplication {
    extern_methods!(
        /// Indicates that the process is an exited application.
        /// This is observable through KVO.
        #[unsafe(method(isTerminated))]
        #[unsafe(method_family = none)]
        pub unsafe fn isTerminated(&self) -> bool;

        /// Indicates that the process is finished launching, which corresponds to the
        /// `NSApplicationDidFinishLaunching`internal notification.
        /// This is observable through KVO.
        /// Some applications do not post this notification and so are never reported as finished launching.
        #[unsafe(method(isFinishedLaunching))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFinishedLaunching(&self) -> bool;

        /// Indicates whether the application is currently hidden.
        /// This is observable through KVO.
        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        pub unsafe fn isHidden(&self) -> bool;

        /// Indicates whether the application is currently frontmost.
        /// This is observable through KVO.
        #[unsafe(method(isActive))]
        #[unsafe(method_family = none)]
        pub unsafe fn isActive(&self) -> bool;

        /// Indicates whether the application currently owns the menu bar.
        /// This is observable through KVO.
        #[unsafe(method(ownsMenuBar))]
        #[unsafe(method_family = none)]
        pub unsafe fn ownsMenuBar(&self) -> bool;

        /// Indicates the activation policy of the application.
        /// This is observable through KVO (the type is usually fixed, but may be changed through a call to `-[NSApplication setActivationPolicy:]`).
        #[unsafe(method(activationPolicy))]
        #[unsafe(method_family = none)]
        pub unsafe fn activationPolicy(&self) -> NSApplicationActivationPolicy;

        /// Indicates the name of the application.
        /// This is dependent on the current localization of the referenced app, and is suitable for presentation to the user.
        #[unsafe(method(localizedName))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedName(&self) -> Option<Retained<NSString>>;

        /// Indicates the `CFBundleIdentifier` of the application, or nil if the application does not have an `Info.plist`.
        #[unsafe(method(bundleIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn bundleIdentifier(&self) -> Option<Retained<NSString>>;

        /// Indicates the URL to the application's bundle, or nil if the application does not have a bundle.
        #[unsafe(method(bundleURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn bundleURL(&self) -> Option<Retained<NSURL>>;

        /// Indicates the URL to the application's executable.
        #[unsafe(method(executableURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn executableURL(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "libc")]
        /// Indicates the process identifier (pid) of the application.
        /// Do not rely on this for comparing processes.  Use `-isEqual:` instead.
        ///
        /// Note: Not all applications have a pid.  Applications without a pid return -1 from this method.
        /// This is observable through KVO (an application's pid may change if it is automatically terminated).
        #[unsafe(method(processIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn processIdentifier(&self) -> libc::pid_t;

        /// Indicates the date when the application was launched.
        /// This property is not available for all applications.
        /// Specifically, it is not available for applications that were launched without going through `LaunchServices`.
        #[unsafe(method(launchDate))]
        #[unsafe(method_family = none)]
        pub unsafe fn launchDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSImage")]
        /// Returns: The icon of the application.
        #[unsafe(method(icon))]
        #[unsafe(method_family = none)]
        pub unsafe fn icon(&self) -> Option<Retained<NSImage>>;

        /// Indicates the executing processor architecture for the application, as an
        /// `NSBundleExecutableArchitecture`from `NSBundle.h`.
        #[unsafe(method(executableArchitecture))]
        #[unsafe(method_family = none)]
        pub unsafe fn executableArchitecture(&self) -> NSInteger;

        /// Attempts to hide the receiver.
        ///
        /// Returns: `YES` if the request to hide or unhide was successfully sent, `NO` if not (for example, if the application has quit, or is of a type that cannot be unhidden).
        #[unsafe(method(hide))]
        #[unsafe(method_family = none)]
        pub unsafe fn hide(&self) -> bool;

        /// Attempts to unhide the receiver.
        ///
        /// Returns: `YES` if the request to hide or unhide was successfully sent, `NO` if not (for example, if the application has quit, or is of a type that cannot be unhidden).
        #[unsafe(method(unhide))]
        #[unsafe(method_family = none)]
        pub unsafe fn unhide(&self) -> bool;

        /// Attempts to activate the application using the specified options.
        ///
        /// You shouldn’t assume the app will be active immediately
        /// after sending this message. The framework also does not
        /// guarantee that the app will be activated at all.
        ///
        /// Additionally allows specifying another application to take
        /// the active status from, which can be used for coordinated
        /// or cooperative activation. The other application should
        /// call `-yieldActivationToApplication:` or equivalent prior to this
        /// request being sent.
        ///
        ///
        /// Returns: `YES` if the request has been allowed by the system,
        /// otherwise `NO`.
        #[unsafe(method(activateFromApplication:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn activateFromApplication_options(
            &self,
            application: &NSRunningApplication,
            options: NSApplicationActivationOptions,
        ) -> bool;

        /// Attempts to activate the receiver.
        ///
        /// Returns: `YES` if the request to activate was successfully sent, `NO` if not (for example, if the application has quit, or is of a type that cannot be activated).
        #[unsafe(method(activateWithOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn activateWithOptions(&self, options: NSApplicationActivationOptions) -> bool;

        /// Attempts to quit the receiver normally.
        ///
        /// Returns: `YES` if the request was successfully sent, `NO` if not (for example, if the application is no longer running).
        /// This method may return before the receiver exits; you should observe the terminated property or listen for the notification to detect when the app has exited.
        #[unsafe(method(terminate))]
        #[unsafe(method_family = none)]
        pub unsafe fn terminate(&self) -> bool;

        /// Attempts to force the receiver to quit.
        ///
        /// Returns: `YES` if the request was successfully sent, `NO` if not (for example, if the application is no longer running).
        /// This method may return before the receiver exits; you should observe the terminated property or listen for the notification to detect when the app has exited.
        #[unsafe(method(forceTerminate))]
        #[unsafe(method_family = none)]
        pub unsafe fn forceTerminate(&self) -> bool;

        /// Returns: An array of currently running applications with the given bundle identifier, or an empty array if no apps match.
        #[unsafe(method(runningApplicationsWithBundleIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn runningApplicationsWithBundleIdentifier(
            bundle_identifier: &NSString,
        ) -> Retained<NSArray<NSRunningApplication>>;

        #[cfg(feature = "libc")]
        /// Returns: The running application with the given process identifier, or nil if no application has that pid.
        /// Applications that do not have PIDs cannot be returned from this method.
        #[unsafe(method(runningApplicationWithProcessIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn runningApplicationWithProcessIdentifier(
            pid: libc::pid_t,
        ) -> Option<Retained<Self>>;

        /// Returns: An
        /// `NSRunningApplication`representing this application.
        #[unsafe(method(currentApplication))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentApplication() -> Retained<NSRunningApplication>;

        /// Cause any applications that are invisibly still running (see `NSProcessInfo.h` automatic termination methods and docs) to terminate as if triggered by system memory pressure.
        /// This is intended for installer apps and the like to make sure that nothing is unexpectedly relying on the files they're replacing.
        #[unsafe(method(terminateAutomaticallyTerminableApplications))]
        #[unsafe(method_family = none)]
        pub unsafe fn terminateAutomaticallyTerminableApplications();
    );
}

/// Methods declared on superclass `NSObject`.
impl NSRunningApplication {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// NSWorkspaceRunningApplications.
#[cfg(feature = "NSWorkspace")]
impl NSWorkspace {
    extern_methods!(
        /// Returns: An array of `NSRunningApplication`s representing currently running applications.
        /// The order of the array is unspecified, but it is stable, meaning that the relative order of particular applications will not change across multiple calls to `runningApplications`.
        /// Similar to `NSRunningApplication`'s properties, this property will only change when the main run loop is run in a common mode.  Instead of polling, use key-value observing to be notified of changes to this array property.
        /// This property is thread safe, in that it may be called from background threads and the result is returned atomically.  This property is observable through KVO.
        #[unsafe(method(runningApplications))]
        #[unsafe(method_family = none)]
        pub unsafe fn runningApplications(&self) -> Retained<NSArray<NSRunningApplication>>;
    );
}
