//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspopupbutton?language=objc)
    #[unsafe(super(NSButton, NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(
        feature = "NSButton",
        feature = "NSControl",
        feature = "NSResponder",
        feature = "NSView"
    ))]
    pub struct NSPopUpButton;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibility for NSPopUpButton {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityButton for NSPopUpButton {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityElementProtocol for NSPopUpButton {}

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAnimatablePropertyContainer for NSPopUpButton {}

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAppearanceCustomization for NSPopUpButton {}

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSCoding for NSPopUpButton {}

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSDraggingDestination for NSPopUpButton {}

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSObjectProtocol for NSPopUpButton {}

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceCompression",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceCompression for NSPopUpButton {}

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceItemIdentification for NSPopUpButton {}

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceValidation",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceValidations for NSPopUpButton {}

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSPopUpButton {
    extern_methods!(
        #[cfg(feature = "NSMenu")]
        /// Creates a standard pop-up button with a menu, target, and action.
        ///
        /// Parameter `menu`: A menu presented by the pop-up button, containing items that the user can choose between.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// If `menu` is non-empty, the pop-up button uses the first item for its initial selection.
        ///
        /// Returns: An initialized pop-up button object.
        #[unsafe(method(popUpButtonWithMenu:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn popUpButtonWithMenu_target_action(
            menu: &NSMenu,
            target: Option<&AnyObject>,
            action: Option<Sel>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSMenu")]
        /// Creates a standard pull-down button with a title and menu.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `menu`: The pull-down menu to present when interacting with the button.
        ///
        /// Pull-down buttons created using this method have the `usesItemFromMenu` property set to `NO`.
        ///
        /// Returns: An initialized pull-down button object.
        #[unsafe(method(pullDownButtonWithTitle:menu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pullDownButtonWithTitle_menu(
            title: &NSString,
            menu: &NSMenu,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSImage", feature = "NSMenu"))]
        /// Creates a standard pull-down button with an image and menu.
        ///
        /// Parameter `image`: The icon that is displayed on the button.
        ///
        /// Parameter `menu`: The pull-down menu to present when interacting with the button.
        ///
        /// Pull-down buttons created using this method have the `usesItemFromMenu` property set to `NO`.
        ///
        /// Returns: An initialized pull-down button object.
        #[unsafe(method(pullDownButtonWithImage:menu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pullDownButtonWithImage_menu(
            image: &NSImage,
            menu: &NSMenu,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSImage", feature = "NSMenu"))]
        /// Creates a standard pull-down button with a title, image, and menu.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `image`: The icon that is displayed on the button.
        ///
        /// Parameter `menu`: The pull-down menu to present when interacting with the button.
        ///
        /// Pull-down buttons created using this method have the `usesItemFromMenu` property set to `NO`.
        ///
        /// Returns: An initialized pull-down button object.
        #[unsafe(method(pullDownButtonWithTitle:image:menu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pullDownButtonWithTitle_image_menu(
            title: &NSString,
            image: &NSImage,
            menu: &NSMenu,
        ) -> Retained<Self>;

        #[unsafe(method(initWithFrame:pullsDown:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame_pullsDown(
            this: Allocated<Self>,
            button_frame: NSRect,
            flag: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "NSMenu")]
        /// The menu that is presented by the popup button. This overrides the inherited NSView property and replaces NSView's standard context menu behavior.
        #[unsafe(method(menu))]
        #[unsafe(method_family = none)]
        pub unsafe fn menu(&self) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        /// Setter for [`menu`][Self::menu].
        #[unsafe(method(setMenu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMenu(&self, menu: Option<&NSMenu>);

        /// When the value of this property is `YES` the button adopts 'pull-down' behavior, displaying static button contents and presenting its menu at the edge of the button. When the value of this property is `NO` the button behaves as a popup, displaying the currently-selected menu item and presenting its menu above the button, positioning the selected menu item to match the button's contents.
        #[unsafe(method(pullsDown))]
        #[unsafe(method_family = none)]
        pub unsafe fn pullsDown(&self) -> bool;

        /// Setter for [`pullsDown`][Self::pullsDown].
        #[unsafe(method(setPullsDown:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPullsDown(&self, pulls_down: bool);

        /// When the value of this property is `YES`, the popup button automatically enables and disables its menu items according to the `NSMenuValidation` protocol prior to user interaction.
        #[unsafe(method(autoenablesItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoenablesItems(&self) -> bool;

        /// Setter for [`autoenablesItems`][Self::autoenablesItems].
        #[unsafe(method(setAutoenablesItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutoenablesItems(&self, autoenables_items: bool);

        /// For pull-down buttons and for popups under severe screen position restrictions, this property specifies the edge of the control that the menu should present from.
        #[unsafe(method(preferredEdge))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredEdge(&self) -> NSRectEdge;

        /// Setter for [`preferredEdge`][Self::preferredEdge].
        #[unsafe(method(setPreferredEdge:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredEdge(&self, preferred_edge: NSRectEdge);

        /// When `usesItemFromMenu` is `YES`, a pull-down button uses the title of the first menu item and hides the first menu item. A pop-up button uses the title of the currently selected menu. The default value is `YES`.
        #[unsafe(method(usesItemFromMenu))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesItemFromMenu(&self) -> bool;

        /// Setter for [`usesItemFromMenu`][Self::usesItemFromMenu].
        #[unsafe(method(setUsesItemFromMenu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesItemFromMenu(&self, uses_item_from_menu: bool);

        /// When the value of this property is `YES`, the selected menu item's `state` is set to `NSControlStateValueOn`. When the value of this property is `NO`, the menu item's `state` is not changed. When this property changes, the `state` of the currently selected item is updated appropriately. This property is ignored for pull-down buttons.
        #[unsafe(method(altersStateOfSelectedItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn altersStateOfSelectedItem(&self) -> bool;

        /// Setter for [`altersStateOfSelectedItem`][Self::altersStateOfSelectedItem].
        #[unsafe(method(setAltersStateOfSelectedItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAltersStateOfSelectedItem(&self, alters_state_of_selected_item: bool);

        #[unsafe(method(addItemWithTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addItemWithTitle(&self, title: &NSString);

        #[unsafe(method(addItemsWithTitles:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addItemsWithTitles(&self, item_titles: &NSArray<NSString>);

        #[unsafe(method(insertItemWithTitle:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertItemWithTitle_atIndex(&self, title: &NSString, index: NSInteger);

        #[unsafe(method(removeItemWithTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeItemWithTitle(&self, title: &NSString);

        #[unsafe(method(removeItemAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeItemAtIndex(&self, index: NSInteger);

        #[unsafe(method(removeAllItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllItems(&self);

        #[cfg(feature = "NSMenuItem")]
        #[unsafe(method(itemArray))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemArray(&self) -> Retained<NSArray<NSMenuItem>>;

        #[unsafe(method(numberOfItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfItems(&self) -> NSInteger;

        #[cfg(feature = "NSMenuItem")]
        #[unsafe(method(indexOfItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn indexOfItem(&self, item: &NSMenuItem) -> NSInteger;

        #[unsafe(method(indexOfItemWithTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn indexOfItemWithTitle(&self, title: &NSString) -> NSInteger;

        #[unsafe(method(indexOfItemWithTag:))]
        #[unsafe(method_family = none)]
        pub unsafe fn indexOfItemWithTag(&self, tag: NSInteger) -> NSInteger;

        #[unsafe(method(indexOfItemWithRepresentedObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn indexOfItemWithRepresentedObject(&self, obj: Option<&AnyObject>)
            -> NSInteger;

        #[unsafe(method(indexOfItemWithTarget:andAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn indexOfItemWithTarget_andAction(
            &self,
            target: Option<&AnyObject>,
            action_selector: Option<Sel>,
        ) -> NSInteger;

        #[cfg(feature = "NSMenuItem")]
        #[unsafe(method(itemAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemAtIndex(&self, index: NSInteger) -> Option<Retained<NSMenuItem>>;

        #[cfg(feature = "NSMenuItem")]
        #[unsafe(method(itemWithTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithTitle(&self, title: &NSString) -> Option<Retained<NSMenuItem>>;

        #[cfg(feature = "NSMenuItem")]
        #[unsafe(method(lastItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn lastItem(&self) -> Option<Retained<NSMenuItem>>;

        #[cfg(feature = "NSMenuItem")]
        #[unsafe(method(selectItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectItem(&self, item: Option<&NSMenuItem>);

        #[unsafe(method(selectItemAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectItemAtIndex(&self, index: NSInteger);

        #[unsafe(method(selectItemWithTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectItemWithTitle(&self, title: &NSString);

        #[unsafe(method(selectItemWithTag:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectItemWithTag(&self, tag: NSInteger) -> bool;

        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitle(&self, string: &NSString);

        #[cfg(feature = "NSMenuItem")]
        #[unsafe(method(selectedItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedItem(&self) -> Option<Retained<NSMenuItem>>;

        #[unsafe(method(indexOfSelectedItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn indexOfSelectedItem(&self) -> NSInteger;

        #[unsafe(method(selectedTag))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedTag(&self) -> NSInteger;

        #[unsafe(method(synchronizeTitleAndSelectedItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn synchronizeTitleAndSelectedItem(&self);

        #[unsafe(method(itemTitleAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemTitleAtIndex(&self, index: NSInteger) -> Retained<NSString>;

        #[unsafe(method(itemTitles))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemTitles(&self) -> Retained<NSArray<NSString>>;

        #[unsafe(method(titleOfSelectedItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn titleOfSelectedItem(&self) -> Option<Retained<NSString>>;
    );
}

/// Methods declared on superclass `NSButton`.
#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSPopUpButton {
    extern_methods!(
        #[cfg(feature = "NSImage")]
        /// Creates a standard push button with a title and image.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `image`: The image that is displayed alongside the title. In left-to-right localizations, the image is displayed to the left of the title. In right-to-left localizations, it is displayed to the right.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithTitle:image:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithTitle_image_target_action(
            title: &NSString,
            image: &NSImage,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard push button with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        /// Creates a standard push button with the provided image. Set the image's accessibilityDescription property to ensure accessibility for this control.
        ///
        /// Parameter `image`: The image to display in the body of the button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithImage:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithImage_target_action(
            image: &NSImage,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard checkbox with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed alongside the checkbox.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(checkboxWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkboxWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard radio button with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed alongside the radio button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(radioButtonWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn radioButtonWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSControl`.
#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSPopUpButton {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSPopUpButton {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSPopUpButton {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspopupbuttonwillpopupnotification?language=objc)
    pub static NSPopUpButtonWillPopUpNotification: &'static NSNotificationName;
}
