//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Values that can be used to enable or constrain display of High Dynamic Range (HDR) content in NSImageViews. Displaying HDR content in an NSImageView requires that the assigned NSImage has HDR content in the ITU-R 2100 color space and also that the output device has Extended Dynamic Range (EDR) capabilities.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagedynamicrange?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageDynamicRange(pub NSInteger);
impl NSImageDynamicRange {
    #[doc(alias = "NSImageDynamicRangeUnspecified")]
    pub const Unspecified: Self = Self(-1);
    /// Restrict the image content dynamic range to the standard range regardless of the actual range of the image content.
    #[doc(alias = "NSImageDynamicRangeStandard")]
    pub const Standard: Self = Self(0);
    /// Allow constrained HDR image content. Useful when mixing HDR and SDR content.
    #[doc(alias = "NSImageDynamicRangeConstrainedHigh")]
    pub const ConstrainedHigh: Self = Self(1);
    /// Allow image content to use extended dynamic range if it has high dynamic range content.
    #[doc(alias = "NSImageDynamicRangeHigh")]
    pub const High: Self = Self(2);
}

unsafe impl Encode for NSImageDynamicRange {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSImageDynamicRange {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimageview?language=objc)
    #[unsafe(super(NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    pub struct NSImageView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibility for NSImageView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityElementProtocol for NSImageView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityImage for NSImageView {}

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAnimatablePropertyContainer for NSImageView {}

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAppearanceCustomization for NSImageView {}

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
unsafe impl NSCoding for NSImageView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSDraggingDestination for NSImageView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSMenu",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSMenuItemValidation for NSImageView {}

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
unsafe impl NSObjectProtocol for NSImageView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceItemIdentification for NSImageView {}

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSImageView {
    extern_methods!(
        #[cfg(feature = "NSImage")]
        /// Creates a non-editable image view containing the provided image. The image is scaled proportionally down to fit the view, and is centered within the view.
        ///
        /// Parameter `image`: The image to display within the view.
        ///
        /// Returns: An initialized image view.
        #[unsafe(method(imageViewWithImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageViewWithImage(image: &NSImage, mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub unsafe fn image(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImage(&self, image: Option<&NSImage>);

        #[unsafe(method(isEditable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEditable(&self) -> bool;

        /// Setter for [`isEditable`][Self::isEditable].
        #[unsafe(method(setEditable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEditable(&self, editable: bool);

        #[cfg(feature = "NSImageCell")]
        #[unsafe(method(imageAlignment))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageAlignment(&self) -> NSImageAlignment;

        #[cfg(feature = "NSImageCell")]
        /// Setter for [`imageAlignment`][Self::imageAlignment].
        #[unsafe(method(setImageAlignment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImageAlignment(&self, image_alignment: NSImageAlignment);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(imageScaling))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageScaling(&self) -> NSImageScaling;

        #[cfg(feature = "NSCell")]
        /// Setter for [`imageScaling`][Self::imageScaling].
        #[unsafe(method(setImageScaling:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImageScaling(&self, image_scaling: NSImageScaling);

        #[cfg(feature = "NSImageCell")]
        #[unsafe(method(imageFrameStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageFrameStyle(&self) -> NSImageFrameStyle;

        #[cfg(feature = "NSImageCell")]
        /// Setter for [`imageFrameStyle`][Self::imageFrameStyle].
        #[unsafe(method(setImageFrameStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImageFrameStyle(&self, image_frame_style: NSImageFrameStyle);

        #[cfg(feature = "NSImage")]
        /// Specifies a combination of point size, weight, and scale to use when sizing and displaying symbol images. If a symbol configuration isn't provided, the image view uses a default size, weight, and scale provided by the system. The default value is `nil`.
        #[unsafe(method(symbolConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn symbolConfiguration(&self) -> Option<Retained<NSImageSymbolConfiguration>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`symbolConfiguration`][Self::symbolConfiguration].
        #[unsafe(method(setSymbolConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSymbolConfiguration(
            &self,
            symbol_configuration: Option<&NSImageSymbolConfiguration>,
        );

        #[cfg(feature = "NSColor")]
        /// A tint color to be used when rendering template image content. This color may be combined with other effects to produce a theme-appropriate rendition of the template image. A nil value indicates the standard set of effects without color modification. The default value is nil.
        #[unsafe(method(contentTintColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentTintColor(&self) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`contentTintColor`][Self::contentTintColor].
        #[unsafe(method(setContentTintColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentTintColor(&self, content_tint_color: Option<&NSColor>);

        #[unsafe(method(animates))]
        #[unsafe(method_family = none)]
        pub unsafe fn animates(&self) -> bool;

        /// Setter for [`animates`][Self::animates].
        #[unsafe(method(setAnimates:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimates(&self, animates: bool);

        #[unsafe(method(allowsCutCopyPaste))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsCutCopyPaste(&self) -> bool;

        /// Setter for [`allowsCutCopyPaste`][Self::allowsCutCopyPaste].
        #[unsafe(method(setAllowsCutCopyPaste:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsCutCopyPaste(&self, allows_cut_copy_paste: bool);

        /// Default preferred image dynamic range. Defaults to `NSImageDynamicRangeConstrainedHigh` on macOS 14 and higher, `NSImageDynamicRangeStandard` otherwise. Set to another value to change the default for all subsequently created `NSImageView`s in your app.
        #[unsafe(method(defaultPreferredImageDynamicRange))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultPreferredImageDynamicRange(
            mtm: MainThreadMarker,
        ) -> NSImageDynamicRange;

        /// Setter for [`defaultPreferredImageDynamicRange`][Self::defaultPreferredImageDynamicRange].
        #[unsafe(method(setDefaultPreferredImageDynamicRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultPreferredImageDynamicRange(
            default_preferred_image_dynamic_range: NSImageDynamicRange,
            mtm: MainThreadMarker,
        );

        /// Preferred dynamic range when displaying an image in the receiving image view.
        #[unsafe(method(preferredImageDynamicRange))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredImageDynamicRange(&self) -> NSImageDynamicRange;

        /// Setter for [`preferredImageDynamicRange`][Self::preferredImageDynamicRange].
        #[unsafe(method(setPreferredImageDynamicRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredImageDynamicRange(
            &self,
            preferred_image_dynamic_range: NSImageDynamicRange,
        );

        /// Resolved dynamic range based on fully resolved image content. Note: this will return `NSImageDynamicRangeUnspecified` if the image view has not or can not resolve the content (either because it has no resolvable image content or has not resolved because the image view hasn't displayed.)
        #[unsafe(method(imageDynamicRange))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageDynamicRange(&self) -> NSImageDynamicRange;
    );
}

/// Methods declared on superclass `NSControl`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSImageView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSImageView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSImageView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
