//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
#[cfg(target_vendor = "apple")]
use objc2_core_graphics::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSEventType(pub NSUInteger);
impl NSEventType {
    #[doc(alias = "NSEventTypeLeftMouseDown")]
    pub const LeftMouseDown: Self = Self(1);
    #[doc(alias = "NSEventTypeLeftMouseUp")]
    pub const LeftMouseUp: Self = Self(2);
    #[doc(alias = "NSEventTypeRightMouseDown")]
    pub const RightMouseDown: Self = Self(3);
    #[doc(alias = "NSEventTypeRightMouseUp")]
    pub const RightMouseUp: Self = Self(4);
    #[doc(alias = "NSEventTypeMouseMoved")]
    pub const MouseMoved: Self = Self(5);
    #[doc(alias = "NSEventTypeLeftMouseDragged")]
    pub const LeftMouseDragged: Self = Self(6);
    #[doc(alias = "NSEventTypeRightMouseDragged")]
    pub const RightMouseDragged: Self = Self(7);
    #[doc(alias = "NSEventTypeMouseEntered")]
    pub const MouseEntered: Self = Self(8);
    #[doc(alias = "NSEventTypeMouseExited")]
    pub const MouseExited: Self = Self(9);
    #[doc(alias = "NSEventTypeKeyDown")]
    pub const KeyDown: Self = Self(10);
    #[doc(alias = "NSEventTypeKeyUp")]
    pub const KeyUp: Self = Self(11);
    #[doc(alias = "NSEventTypeFlagsChanged")]
    pub const FlagsChanged: Self = Self(12);
    #[doc(alias = "NSEventTypeAppKitDefined")]
    pub const AppKitDefined: Self = Self(13);
    #[doc(alias = "NSEventTypeSystemDefined")]
    pub const SystemDefined: Self = Self(14);
    #[doc(alias = "NSEventTypeApplicationDefined")]
    pub const ApplicationDefined: Self = Self(15);
    #[doc(alias = "NSEventTypePeriodic")]
    pub const Periodic: Self = Self(16);
    #[doc(alias = "NSEventTypeCursorUpdate")]
    pub const CursorUpdate: Self = Self(17);
    #[doc(alias = "NSEventTypeScrollWheel")]
    pub const ScrollWheel: Self = Self(22);
    #[doc(alias = "NSEventTypeTabletPoint")]
    pub const TabletPoint: Self = Self(23);
    #[doc(alias = "NSEventTypeTabletProximity")]
    pub const TabletProximity: Self = Self(24);
    #[doc(alias = "NSEventTypeOtherMouseDown")]
    pub const OtherMouseDown: Self = Self(25);
    #[doc(alias = "NSEventTypeOtherMouseUp")]
    pub const OtherMouseUp: Self = Self(26);
    #[doc(alias = "NSEventTypeOtherMouseDragged")]
    pub const OtherMouseDragged: Self = Self(27);
    #[doc(alias = "NSEventTypeGesture")]
    pub const Gesture: Self = Self(29);
    #[doc(alias = "NSEventTypeMagnify")]
    pub const Magnify: Self = Self(30);
    #[doc(alias = "NSEventTypeSwipe")]
    pub const Swipe: Self = Self(31);
    #[doc(alias = "NSEventTypeRotate")]
    pub const Rotate: Self = Self(18);
    #[doc(alias = "NSEventTypeBeginGesture")]
    pub const BeginGesture: Self = Self(19);
    #[doc(alias = "NSEventTypeEndGesture")]
    pub const EndGesture: Self = Self(20);
    #[doc(alias = "NSEventTypeSmartMagnify")]
    pub const SmartMagnify: Self = Self(32);
    #[doc(alias = "NSEventTypeQuickLook")]
    pub const QuickLook: Self = Self(33);
    #[doc(alias = "NSEventTypePressure")]
    pub const Pressure: Self = Self(34);
    #[doc(alias = "NSEventTypeDirectTouch")]
    pub const DirectTouch: Self = Self(37);
    #[doc(alias = "NSEventTypeChangeMode")]
    pub const ChangeMode: Self = Self(38);
}

unsafe impl Encode for NSEventType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSEventType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsleftmousedown?language=objc)
pub static NSLeftMouseDown: NSEventType = NSEventType(NSEventType::LeftMouseDown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsleftmouseup?language=objc)
pub static NSLeftMouseUp: NSEventType = NSEventType(NSEventType::LeftMouseUp.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrightmousedown?language=objc)
pub static NSRightMouseDown: NSEventType = NSEventType(NSEventType::RightMouseDown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrightmouseup?language=objc)
pub static NSRightMouseUp: NSEventType = NSEventType(NSEventType::RightMouseUp.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmousemoved?language=objc)
pub static NSMouseMoved: NSEventType = NSEventType(NSEventType::MouseMoved.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsleftmousedragged?language=objc)
pub static NSLeftMouseDragged: NSEventType = NSEventType(NSEventType::LeftMouseDragged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrightmousedragged?language=objc)
pub static NSRightMouseDragged: NSEventType = NSEventType(NSEventType::RightMouseDragged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmouseentered?language=objc)
pub static NSMouseEntered: NSEventType = NSEventType(NSEventType::MouseEntered.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmouseexited?language=objc)
pub static NSMouseExited: NSEventType = NSEventType(NSEventType::MouseExited.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nskeydown?language=objc)
pub static NSKeyDown: NSEventType = NSEventType(NSEventType::KeyDown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nskeyup?language=objc)
pub static NSKeyUp: NSEventType = NSEventType(NSEventType::KeyUp.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsflagschanged?language=objc)
pub static NSFlagsChanged: NSEventType = NSEventType(NSEventType::FlagsChanged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappkitdefined?language=objc)
pub static NSAppKitDefined: NSEventType = NSEventType(NSEventType::AppKitDefined.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssystemdefined?language=objc)
pub static NSSystemDefined: NSEventType = NSEventType(NSEventType::SystemDefined.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsapplicationdefined?language=objc)
pub static NSApplicationDefined: NSEventType = NSEventType(NSEventType::ApplicationDefined.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsperiodic?language=objc)
pub static NSPeriodic: NSEventType = NSEventType(NSEventType::Periodic.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscursorupdate?language=objc)
pub static NSCursorUpdate: NSEventType = NSEventType(NSEventType::CursorUpdate.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrollwheel?language=objc)
pub static NSScrollWheel: NSEventType = NSEventType(NSEventType::ScrollWheel.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstabletpoint?language=objc)
pub static NSTabletPoint: NSEventType = NSEventType(NSEventType::TabletPoint.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstabletproximity?language=objc)
pub static NSTabletProximity: NSEventType = NSEventType(NSEventType::TabletProximity.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsothermousedown?language=objc)
pub static NSOtherMouseDown: NSEventType = NSEventType(NSEventType::OtherMouseDown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsothermouseup?language=objc)
pub static NSOtherMouseUp: NSEventType = NSEventType(NSEventType::OtherMouseUp.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsothermousedragged?language=objc)
pub static NSOtherMouseDragged: NSEventType = NSEventType(NSEventType::OtherMouseDragged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventmask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSEventMask(pub c_ulonglong);
bitflags::bitflags! {
    impl NSEventMask: c_ulonglong {
        #[doc(alias = "NSEventMaskLeftMouseDown")]
        const LeftMouseDown = 1<<NSEventType::LeftMouseDown.0;
        #[doc(alias = "NSEventMaskLeftMouseUp")]
        const LeftMouseUp = 1<<NSEventType::LeftMouseUp.0;
        #[doc(alias = "NSEventMaskRightMouseDown")]
        const RightMouseDown = 1<<NSEventType::RightMouseDown.0;
        #[doc(alias = "NSEventMaskRightMouseUp")]
        const RightMouseUp = 1<<NSEventType::RightMouseUp.0;
        #[doc(alias = "NSEventMaskMouseMoved")]
        const MouseMoved = 1<<NSEventType::MouseMoved.0;
        #[doc(alias = "NSEventMaskLeftMouseDragged")]
        const LeftMouseDragged = 1<<NSEventType::LeftMouseDragged.0;
        #[doc(alias = "NSEventMaskRightMouseDragged")]
        const RightMouseDragged = 1<<NSEventType::RightMouseDragged.0;
        #[doc(alias = "NSEventMaskMouseEntered")]
        const MouseEntered = 1<<NSEventType::MouseEntered.0;
        #[doc(alias = "NSEventMaskMouseExited")]
        const MouseExited = 1<<NSEventType::MouseExited.0;
        #[doc(alias = "NSEventMaskKeyDown")]
        const KeyDown = 1<<NSEventType::KeyDown.0;
        #[doc(alias = "NSEventMaskKeyUp")]
        const KeyUp = 1<<NSEventType::KeyUp.0;
        #[doc(alias = "NSEventMaskFlagsChanged")]
        const FlagsChanged = 1<<NSEventType::FlagsChanged.0;
        #[doc(alias = "NSEventMaskAppKitDefined")]
        const AppKitDefined = 1<<NSEventType::AppKitDefined.0;
        #[doc(alias = "NSEventMaskSystemDefined")]
        const SystemDefined = 1<<NSEventType::SystemDefined.0;
        #[doc(alias = "NSEventMaskApplicationDefined")]
        const ApplicationDefined = 1<<NSEventType::ApplicationDefined.0;
        #[doc(alias = "NSEventMaskPeriodic")]
        const Periodic = 1<<NSEventType::Periodic.0;
        #[doc(alias = "NSEventMaskCursorUpdate")]
        const CursorUpdate = 1<<NSEventType::CursorUpdate.0;
        #[doc(alias = "NSEventMaskScrollWheel")]
        const ScrollWheel = 1<<NSEventType::ScrollWheel.0;
        #[doc(alias = "NSEventMaskTabletPoint")]
        const TabletPoint = 1<<NSEventType::TabletPoint.0;
        #[doc(alias = "NSEventMaskTabletProximity")]
        const TabletProximity = 1<<NSEventType::TabletProximity.0;
        #[doc(alias = "NSEventMaskOtherMouseDown")]
        const OtherMouseDown = 1<<NSEventType::OtherMouseDown.0;
        #[doc(alias = "NSEventMaskOtherMouseUp")]
        const OtherMouseUp = 1<<NSEventType::OtherMouseUp.0;
        #[doc(alias = "NSEventMaskOtherMouseDragged")]
        const OtherMouseDragged = 1<<NSEventType::OtherMouseDragged.0;
        #[doc(alias = "NSEventMaskGesture")]
        const Gesture = 1<<NSEventType::Gesture.0;
        #[doc(alias = "NSEventMaskMagnify")]
        const Magnify = 1<<NSEventType::Magnify.0;
        #[doc(alias = "NSEventMaskSwipe")]
        const Swipe = 1<<NSEventType::Swipe.0;
        #[doc(alias = "NSEventMaskRotate")]
        const Rotate = 1<<NSEventType::Rotate.0;
        #[doc(alias = "NSEventMaskBeginGesture")]
        const BeginGesture = 1<<NSEventType::BeginGesture.0;
        #[doc(alias = "NSEventMaskEndGesture")]
        const EndGesture = 1<<NSEventType::EndGesture.0;
        #[doc(alias = "NSEventMaskSmartMagnify")]
        const SmartMagnify = 1<<NSEventType::SmartMagnify.0;
        #[doc(alias = "NSEventMaskPressure")]
        const Pressure = 1<<NSEventType::Pressure.0;
        #[doc(alias = "NSEventMaskDirectTouch")]
        const DirectTouch = 1<<NSEventType::DirectTouch.0;
        #[doc(alias = "NSEventMaskChangeMode")]
        const ChangeMode = 1<<NSEventType::ChangeMode.0;
        #[doc(alias = "NSEventMaskAny")]
        const Any = NSUIntegerMax as _;
    }
}

unsafe impl Encode for NSEventMask {
    const ENCODING: Encoding = c_ulonglong::ENCODING;
}

unsafe impl RefEncode for NSEventMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsleftmousedownmask?language=objc)
pub static NSLeftMouseDownMask: NSEventMask = NSEventMask(NSEventMask::LeftMouseDown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsleftmouseupmask?language=objc)
pub static NSLeftMouseUpMask: NSEventMask = NSEventMask(NSEventMask::LeftMouseUp.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrightmousedownmask?language=objc)
pub static NSRightMouseDownMask: NSEventMask = NSEventMask(NSEventMask::RightMouseDown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrightmouseupmask?language=objc)
pub static NSRightMouseUpMask: NSEventMask = NSEventMask(NSEventMask::RightMouseUp.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmousemovedmask?language=objc)
pub static NSMouseMovedMask: NSEventMask = NSEventMask(NSEventMask::MouseMoved.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsleftmousedraggedmask?language=objc)
pub static NSLeftMouseDraggedMask: NSEventMask = NSEventMask(NSEventMask::LeftMouseDragged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrightmousedraggedmask?language=objc)
pub static NSRightMouseDraggedMask: NSEventMask = NSEventMask(NSEventMask::RightMouseDragged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmouseenteredmask?language=objc)
pub static NSMouseEnteredMask: NSEventMask = NSEventMask(NSEventMask::MouseEntered.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmouseexitedmask?language=objc)
pub static NSMouseExitedMask: NSEventMask = NSEventMask(NSEventMask::MouseExited.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nskeydownmask?language=objc)
pub static NSKeyDownMask: NSEventMask = NSEventMask(NSEventMask::KeyDown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nskeyupmask?language=objc)
pub static NSKeyUpMask: NSEventMask = NSEventMask(NSEventMask::KeyUp.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsflagschangedmask?language=objc)
pub static NSFlagsChangedMask: NSEventMask = NSEventMask(NSEventMask::FlagsChanged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappkitdefinedmask?language=objc)
pub static NSAppKitDefinedMask: NSEventMask = NSEventMask(NSEventMask::AppKitDefined.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssystemdefinedmask?language=objc)
pub static NSSystemDefinedMask: NSEventMask = NSEventMask(NSEventMask::SystemDefined.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsapplicationdefinedmask?language=objc)
pub static NSApplicationDefinedMask: NSEventMask = NSEventMask(NSEventMask::ApplicationDefined.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsperiodicmask?language=objc)
pub static NSPeriodicMask: NSEventMask = NSEventMask(NSEventMask::Periodic.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscursorupdatemask?language=objc)
pub static NSCursorUpdateMask: NSEventMask = NSEventMask(NSEventMask::CursorUpdate.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrollwheelmask?language=objc)
pub static NSScrollWheelMask: NSEventMask = NSEventMask(NSEventMask::ScrollWheel.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstabletpointmask?language=objc)
pub static NSTabletPointMask: NSEventMask = NSEventMask(NSEventMask::TabletPoint.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstabletproximitymask?language=objc)
pub static NSTabletProximityMask: NSEventMask = NSEventMask(NSEventMask::TabletProximity.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsothermousedownmask?language=objc)
pub static NSOtherMouseDownMask: NSEventMask = NSEventMask(NSEventMask::OtherMouseDown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsothermouseupmask?language=objc)
pub static NSOtherMouseUpMask: NSEventMask = NSEventMask(NSEventMask::OtherMouseUp.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsothermousedraggedmask?language=objc)
pub static NSOtherMouseDraggedMask: NSEventMask = NSEventMask(NSEventMask::OtherMouseDragged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanyeventmask?language=objc)
pub static NSAnyEventMask: NSEventMask = NSEventMask(NSUIntegerMax as _);

// TODO: pub fn NSEventMaskFromType(r#type: NSEventType,) -> NSEventMask;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventmodifierflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSEventModifierFlags(pub NSUInteger);
bitflags::bitflags! {
    impl NSEventModifierFlags: NSUInteger {
        #[doc(alias = "NSEventModifierFlagCapsLock")]
        const CapsLock = 1<<16;
        #[doc(alias = "NSEventModifierFlagShift")]
        const Shift = 1<<17;
        #[doc(alias = "NSEventModifierFlagControl")]
        const Control = 1<<18;
        #[doc(alias = "NSEventModifierFlagOption")]
        const Option = 1<<19;
        #[doc(alias = "NSEventModifierFlagCommand")]
        const Command = 1<<20;
        #[doc(alias = "NSEventModifierFlagNumericPad")]
        const NumericPad = 1<<21;
        #[doc(alias = "NSEventModifierFlagHelp")]
        const Help = 1<<22;
        #[doc(alias = "NSEventModifierFlagFunction")]
        const Function = 1<<23;
        #[doc(alias = "NSEventModifierFlagDeviceIndependentFlagsMask")]
        const DeviceIndependentFlagsMask = 0xffff0000;
    }
}

unsafe impl Encode for NSEventModifierFlags {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSEventModifierFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalphashiftkeymask?language=objc)
pub static NSAlphaShiftKeyMask: NSEventModifierFlags =
    NSEventModifierFlags(NSEventModifierFlags::CapsLock.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsshiftkeymask?language=objc)
pub static NSShiftKeyMask: NSEventModifierFlags =
    NSEventModifierFlags(NSEventModifierFlags::Shift.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolkeymask?language=objc)
pub static NSControlKeyMask: NSEventModifierFlags =
    NSEventModifierFlags(NSEventModifierFlags::Control.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalternatekeymask?language=objc)
pub static NSAlternateKeyMask: NSEventModifierFlags =
    NSEventModifierFlags(NSEventModifierFlags::Option.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscommandkeymask?language=objc)
pub static NSCommandKeyMask: NSEventModifierFlags =
    NSEventModifierFlags(NSEventModifierFlags::Command.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsnumericpadkeymask?language=objc)
pub static NSNumericPadKeyMask: NSEventModifierFlags =
    NSEventModifierFlags(NSEventModifierFlags::NumericPad.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nshelpkeymask?language=objc)
pub static NSHelpKeyMask: NSEventModifierFlags = NSEventModifierFlags(NSEventModifierFlags::Help.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfunctionkeymask?language=objc)
pub static NSFunctionKeyMask: NSEventModifierFlags =
    NSEventModifierFlags(NSEventModifierFlags::Function.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdeviceindependentmodifierflagsmask?language=objc)
pub static NSDeviceIndependentModifierFlagsMask: NSEventModifierFlags =
    NSEventModifierFlags(NSEventModifierFlags::DeviceIndependentFlagsMask.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspointingdevicetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSPointingDeviceType(pub NSUInteger);
impl NSPointingDeviceType {
    #[doc(alias = "NSPointingDeviceTypeUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "NSPointingDeviceTypePen")]
    pub const Pen: Self = Self(1);
    #[doc(alias = "NSPointingDeviceTypeCursor")]
    pub const Cursor: Self = Self(2);
    #[doc(alias = "NSPointingDeviceTypeEraser")]
    pub const Eraser: Self = Self(3);
}

unsafe impl Encode for NSPointingDeviceType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSPointingDeviceType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunknownpointingdevice?language=objc)
pub static NSUnknownPointingDevice: NSPointingDeviceType =
    NSPointingDeviceType(NSPointingDeviceType::Unknown.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspenpointingdevice?language=objc)
pub static NSPenPointingDevice: NSPointingDeviceType =
    NSPointingDeviceType(NSPointingDeviceType::Pen.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscursorpointingdevice?language=objc)
pub static NSCursorPointingDevice: NSPointingDeviceType =
    NSPointingDeviceType(NSPointingDeviceType::Cursor.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseraserpointingdevice?language=objc)
pub static NSEraserPointingDevice: NSPointingDeviceType =
    NSPointingDeviceType(NSPointingDeviceType::Eraser.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventbuttonmask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSEventButtonMask(pub NSUInteger);
bitflags::bitflags! {
    impl NSEventButtonMask: NSUInteger {
        #[doc(alias = "NSEventButtonMaskPenTip")]
        const PenTip = 1;
        #[doc(alias = "NSEventButtonMaskPenLowerSide")]
        const PenLowerSide = 2;
        #[doc(alias = "NSEventButtonMaskPenUpperSide")]
        const PenUpperSide = 4;
    }
}

unsafe impl Encode for NSEventButtonMask {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSEventButtonMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspentipmask?language=objc)
pub static NSPenTipMask: NSEventButtonMask = NSEventButtonMask(NSEventButtonMask::PenTip.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspenlowersidemask?language=objc)
pub static NSPenLowerSideMask: NSEventButtonMask =
    NSEventButtonMask(NSEventButtonMask::PenLowerSide.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspenuppersidemask?language=objc)
pub static NSPenUpperSideMask: NSEventButtonMask =
    NSEventButtonMask(NSEventButtonMask::PenUpperSide.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventphase?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSEventPhase(pub NSUInteger);
bitflags::bitflags! {
    impl NSEventPhase: NSUInteger {
        #[doc(alias = "NSEventPhaseNone")]
        const None = 0;
        #[doc(alias = "NSEventPhaseBegan")]
        const Began = 0x1<<0;
        #[doc(alias = "NSEventPhaseStationary")]
        const Stationary = 0x1<<1;
        #[doc(alias = "NSEventPhaseChanged")]
        const Changed = 0x1<<2;
        #[doc(alias = "NSEventPhaseEnded")]
        const Ended = 0x1<<3;
        #[doc(alias = "NSEventPhaseCancelled")]
        const Cancelled = 0x1<<4;
        #[doc(alias = "NSEventPhaseMayBegin")]
        const MayBegin = 0x1<<5;
    }
}

unsafe impl Encode for NSEventPhase {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSEventPhase {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventgestureaxis?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSEventGestureAxis(pub NSInteger);
impl NSEventGestureAxis {
    #[doc(alias = "NSEventGestureAxisNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSEventGestureAxisHorizontal")]
    pub const Horizontal: Self = Self(1);
    #[doc(alias = "NSEventGestureAxisVertical")]
    pub const Vertical: Self = Self(2);
}

unsafe impl Encode for NSEventGestureAxis {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSEventGestureAxis {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventswipetrackingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSEventSwipeTrackingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSEventSwipeTrackingOptions: NSUInteger {
        #[doc(alias = "NSEventSwipeTrackingLockDirection")]
        const LockDirection = 0x1<<0;
        #[doc(alias = "NSEventSwipeTrackingClampGestureAmount")]
        const ClampGestureAmount = 0x1<<1;
    }
}

unsafe impl Encode for NSEventSwipeTrackingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSEventSwipeTrackingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventsubtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSEventSubtype(pub c_short);
impl NSEventSubtype {
    #[doc(alias = "NSEventSubtypeWindowExposed")]
    pub const WindowExposed: Self = Self(0);
    #[doc(alias = "NSEventSubtypeApplicationActivated")]
    pub const ApplicationActivated: Self = Self(1);
    #[doc(alias = "NSEventSubtypeApplicationDeactivated")]
    pub const ApplicationDeactivated: Self = Self(2);
    #[doc(alias = "NSEventSubtypeWindowMoved")]
    pub const WindowMoved: Self = Self(4);
    #[doc(alias = "NSEventSubtypeScreenChanged")]
    pub const ScreenChanged: Self = Self(8);
    #[doc(alias = "NSEventSubtypePowerOff")]
    pub const PowerOff: Self = Self(1);
    #[doc(alias = "NSEventSubtypeMouseEvent")]
    pub const MouseEvent: Self = Self(0);
    #[doc(alias = "NSEventSubtypeTabletPoint")]
    pub const TabletPoint: Self = Self(1);
    #[doc(alias = "NSEventSubtypeTabletProximity")]
    pub const TabletProximity: Self = Self(2);
    #[doc(alias = "NSEventSubtypeTouch")]
    pub const Touch: Self = Self(3);
}

unsafe impl Encode for NSEventSubtype {
    const ENCODING: Encoding = c_short::ENCODING;
}

unsafe impl RefEncode for NSEventSubtype {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowexposedeventtype?language=objc)
pub static NSWindowExposedEventType: NSEventSubtype =
    NSEventSubtype(NSEventSubtype::WindowExposed.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsapplicationactivatedeventtype?language=objc)
pub static NSApplicationActivatedEventType: NSEventSubtype =
    NSEventSubtype(NSEventSubtype::ApplicationActivated.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsapplicationdeactivatedeventtype?language=objc)
pub static NSApplicationDeactivatedEventType: NSEventSubtype =
    NSEventSubtype(NSEventSubtype::ApplicationDeactivated.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowmovedeventtype?language=objc)
pub static NSWindowMovedEventType: NSEventSubtype = NSEventSubtype(NSEventSubtype::WindowMoved.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscreenchangedeventtype?language=objc)
pub static NSScreenChangedEventType: NSEventSubtype =
    NSEventSubtype(NSEventSubtype::ScreenChanged.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsawteventtype?language=objc)
pub static NSAWTEventType: NSEventSubtype = NSEventSubtype(16);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspoweroffeventtype?language=objc)
pub static NSPowerOffEventType: NSEventSubtype = NSEventSubtype(NSEventSubtype::PowerOff.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmouseeventsubtype?language=objc)
pub static NSMouseEventSubtype: NSEventSubtype = NSEventSubtype(NSEventSubtype::MouseEvent.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstabletpointeventsubtype?language=objc)
pub static NSTabletPointEventSubtype: NSEventSubtype =
    NSEventSubtype(NSEventSubtype::TabletPoint.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstabletproximityeventsubtype?language=objc)
pub static NSTabletProximityEventSubtype: NSEventSubtype =
    NSEventSubtype(NSEventSubtype::TabletProximity.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstoucheventsubtype?language=objc)
pub static NSTouchEventSubtype: NSEventSubtype = NSEventSubtype(NSEventSubtype::Touch.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspressurebehavior?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSPressureBehavior(pub NSInteger);
impl NSPressureBehavior {
    #[doc(alias = "NSPressureBehaviorUnknown")]
    pub const Unknown: Self = Self(-1);
    #[doc(alias = "NSPressureBehaviorPrimaryDefault")]
    pub const PrimaryDefault: Self = Self(0);
    #[doc(alias = "NSPressureBehaviorPrimaryClick")]
    pub const PrimaryClick: Self = Self(1);
    #[doc(alias = "NSPressureBehaviorPrimaryGeneric")]
    pub const PrimaryGeneric: Self = Self(2);
    #[doc(alias = "NSPressureBehaviorPrimaryAccelerator")]
    pub const PrimaryAccelerator: Self = Self(3);
    #[doc(alias = "NSPressureBehaviorPrimaryDeepClick")]
    pub const PrimaryDeepClick: Self = Self(5);
    #[doc(alias = "NSPressureBehaviorPrimaryDeepDrag")]
    pub const PrimaryDeepDrag: Self = Self(6);
}

unsafe impl Encode for NSPressureBehavior {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSPressureBehavior {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsevent?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSEvent;
);

unsafe impl NSCoding for NSEvent {}

unsafe impl NSCopying for NSEvent {}

unsafe impl CopyingHelper for NSEvent {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSEvent {}

impl NSEvent {
    extern_methods!(
        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub unsafe fn r#type(&self) -> NSEventType;

        #[unsafe(method(modifierFlags))]
        #[unsafe(method_family = none)]
        pub unsafe fn modifierFlags(&self) -> NSEventModifierFlags;

        #[unsafe(method(timestamp))]
        #[unsafe(method_family = none)]
        pub unsafe fn timestamp(&self) -> NSTimeInterval;

        #[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
        #[unsafe(method(window))]
        #[unsafe(method_family = none)]
        pub unsafe fn window(&self, mtm: MainThreadMarker) -> Option<Retained<NSWindow>>;

        #[unsafe(method(windowNumber))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowNumber(&self) -> NSInteger;

        #[cfg(feature = "NSGraphicsContext")]
        #[deprecated = "This method always returns nil. If you need access to the current drawing context, use [NSGraphicsContext currentContext] inside of a draw operation."]
        #[unsafe(method(context))]
        #[unsafe(method_family = none)]
        pub unsafe fn context(&self) -> Option<Retained<NSGraphicsContext>>;

        #[unsafe(method(clickCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn clickCount(&self) -> NSInteger;

        #[unsafe(method(buttonNumber))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonNumber(&self) -> NSInteger;

        #[unsafe(method(eventNumber))]
        #[unsafe(method_family = none)]
        pub unsafe fn eventNumber(&self) -> NSInteger;

        #[unsafe(method(pressure))]
        #[unsafe(method_family = none)]
        pub unsafe fn pressure(&self) -> c_float;

        #[unsafe(method(locationInWindow))]
        #[unsafe(method_family = none)]
        pub unsafe fn locationInWindow(&self) -> NSPoint;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(deltaX))]
        #[unsafe(method_family = none)]
        pub unsafe fn deltaX(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(deltaY))]
        #[unsafe(method_family = none)]
        pub unsafe fn deltaY(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(deltaZ))]
        #[unsafe(method_family = none)]
        pub unsafe fn deltaZ(&self) -> CGFloat;

        #[unsafe(method(hasPreciseScrollingDeltas))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasPreciseScrollingDeltas(&self) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(scrollingDeltaX))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollingDeltaX(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(scrollingDeltaY))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollingDeltaY(&self) -> CGFloat;

        #[unsafe(method(momentumPhase))]
        #[unsafe(method_family = none)]
        pub unsafe fn momentumPhase(&self) -> NSEventPhase;

        #[unsafe(method(isDirectionInvertedFromDevice))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDirectionInvertedFromDevice(&self) -> bool;

        #[unsafe(method(characters))]
        #[unsafe(method_family = none)]
        pub unsafe fn characters(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(charactersIgnoringModifiers))]
        #[unsafe(method_family = none)]
        pub unsafe fn charactersIgnoringModifiers(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(charactersByApplyingModifiers:))]
        #[unsafe(method_family = none)]
        pub unsafe fn charactersByApplyingModifiers(
            &self,
            modifiers: NSEventModifierFlags,
        ) -> Option<Retained<NSString>>;

        #[unsafe(method(isARepeat))]
        #[unsafe(method_family = none)]
        pub unsafe fn isARepeat(&self) -> bool;

        #[unsafe(method(keyCode))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyCode(&self) -> c_ushort;

        #[unsafe(method(trackingNumber))]
        #[unsafe(method_family = none)]
        pub unsafe fn trackingNumber(&self) -> NSInteger;

        #[unsafe(method(userData))]
        #[unsafe(method_family = none)]
        pub unsafe fn userData(&self) -> *mut c_void;

        #[cfg(feature = "NSTrackingArea")]
        #[unsafe(method(trackingArea))]
        #[unsafe(method_family = none)]
        pub unsafe fn trackingArea(&self) -> Option<Retained<NSTrackingArea>>;

        #[unsafe(method(subtype))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtype(&self) -> NSEventSubtype;

        #[unsafe(method(data1))]
        #[unsafe(method_family = none)]
        pub unsafe fn data1(&self) -> NSInteger;

        #[unsafe(method(data2))]
        #[unsafe(method_family = none)]
        pub unsafe fn data2(&self) -> NSInteger;

        #[unsafe(method(eventRef))]
        #[unsafe(method_family = none)]
        pub unsafe fn eventRef(&self) -> *const c_void;

        #[unsafe(method(eventWithEventRef:))]
        #[unsafe(method_family = none)]
        pub unsafe fn eventWithEventRef(event_ref: NonNull<c_void>) -> Option<Retained<NSEvent>>;

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(CGEvent))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGEvent(&self) -> Option<Retained<CGEvent>>;

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(eventWithCGEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn eventWithCGEvent(cg_event: &CGEvent) -> Option<Retained<NSEvent>>;

        #[unsafe(method(isMouseCoalescingEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isMouseCoalescingEnabled() -> bool;

        /// Setter for [`isMouseCoalescingEnabled`][Self::isMouseCoalescingEnabled].
        #[unsafe(method(setMouseCoalescingEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMouseCoalescingEnabled(mouse_coalescing_enabled: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(magnification))]
        #[unsafe(method_family = none)]
        pub unsafe fn magnification(&self) -> CGFloat;

        #[unsafe(method(deviceID))]
        #[unsafe(method_family = none)]
        pub unsafe fn deviceID(&self) -> NSUInteger;

        #[unsafe(method(rotation))]
        #[unsafe(method_family = none)]
        pub unsafe fn rotation(&self) -> c_float;

        #[unsafe(method(absoluteX))]
        #[unsafe(method_family = none)]
        pub unsafe fn absoluteX(&self) -> NSInteger;

        #[unsafe(method(absoluteY))]
        #[unsafe(method_family = none)]
        pub unsafe fn absoluteY(&self) -> NSInteger;

        #[unsafe(method(absoluteZ))]
        #[unsafe(method_family = none)]
        pub unsafe fn absoluteZ(&self) -> NSInteger;

        #[unsafe(method(buttonMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonMask(&self) -> NSEventButtonMask;

        #[unsafe(method(tilt))]
        #[unsafe(method_family = none)]
        pub unsafe fn tilt(&self) -> NSPoint;

        #[unsafe(method(tangentialPressure))]
        #[unsafe(method_family = none)]
        pub unsafe fn tangentialPressure(&self) -> c_float;

        #[unsafe(method(vendorDefined))]
        #[unsafe(method_family = none)]
        pub unsafe fn vendorDefined(&self) -> Retained<AnyObject>;

        #[unsafe(method(vendorID))]
        #[unsafe(method_family = none)]
        pub unsafe fn vendorID(&self) -> NSUInteger;

        #[unsafe(method(tabletID))]
        #[unsafe(method_family = none)]
        pub unsafe fn tabletID(&self) -> NSUInteger;

        #[unsafe(method(pointingDeviceID))]
        #[unsafe(method_family = none)]
        pub unsafe fn pointingDeviceID(&self) -> NSUInteger;

        #[unsafe(method(systemTabletID))]
        #[unsafe(method_family = none)]
        pub unsafe fn systemTabletID(&self) -> NSUInteger;

        #[unsafe(method(vendorPointingDeviceType))]
        #[unsafe(method_family = none)]
        pub unsafe fn vendorPointingDeviceType(&self) -> NSUInteger;

        #[unsafe(method(pointingDeviceSerialNumber))]
        #[unsafe(method_family = none)]
        pub unsafe fn pointingDeviceSerialNumber(&self) -> NSUInteger;

        #[unsafe(method(uniqueID))]
        #[unsafe(method_family = none)]
        pub unsafe fn uniqueID(&self) -> c_ulonglong;

        #[unsafe(method(capabilityMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn capabilityMask(&self) -> NSUInteger;

        #[unsafe(method(pointingDeviceType))]
        #[unsafe(method_family = none)]
        pub unsafe fn pointingDeviceType(&self) -> NSPointingDeviceType;

        #[unsafe(method(isEnteringProximity))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEnteringProximity(&self) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSTouch", feature = "NSView"))]
        #[unsafe(method(touchesMatchingPhase:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn touchesMatchingPhase_inView(
            &self,
            phase: NSTouchPhase,
            view: Option<&NSView>,
        ) -> Retained<NSSet<NSTouch>>;

        #[cfg(feature = "NSTouch")]
        #[unsafe(method(allTouches))]
        #[unsafe(method_family = none)]
        pub unsafe fn allTouches(&self) -> Retained<NSSet<NSTouch>>;

        #[cfg(all(feature = "NSResponder", feature = "NSTouch", feature = "NSView"))]
        #[unsafe(method(touchesForView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn touchesForView(&self, view: &NSView) -> Retained<NSSet<NSTouch>>;

        #[cfg(feature = "NSTouch")]
        #[unsafe(method(coalescedTouchesForTouch:))]
        #[unsafe(method_family = none)]
        pub unsafe fn coalescedTouchesForTouch(
            &self,
            touch: &NSTouch,
        ) -> Retained<NSArray<NSTouch>>;

        #[unsafe(method(phase))]
        #[unsafe(method_family = none)]
        pub unsafe fn phase(&self) -> NSEventPhase;

        #[unsafe(method(stage))]
        #[unsafe(method_family = none)]
        pub unsafe fn stage(&self) -> NSInteger;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(stageTransition))]
        #[unsafe(method_family = none)]
        pub unsafe fn stageTransition(&self) -> CGFloat;

        #[unsafe(method(associatedEventsMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn associatedEventsMask(&self) -> NSEventMask;

        #[unsafe(method(pressureBehavior))]
        #[unsafe(method_family = none)]
        pub unsafe fn pressureBehavior(&self) -> NSPressureBehavior;

        #[unsafe(method(isSwipeTrackingFromScrollEventsEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isSwipeTrackingFromScrollEventsEnabled() -> bool;

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        #[unsafe(method(trackSwipeEventWithOptions:dampenAmountThresholdMin:max:usingHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn trackSwipeEventWithOptions_dampenAmountThresholdMin_max_usingHandler(
            &self,
            options: NSEventSwipeTrackingOptions,
            min_dampen_threshold: CGFloat,
            max_dampen_threshold: CGFloat,
            tracking_handler: &block2::Block<dyn Fn(CGFloat, NSEventPhase, Bool, NonNull<Bool>)>,
        );

        #[unsafe(method(startPeriodicEventsAfterDelay:withPeriod:))]
        #[unsafe(method_family = none)]
        pub unsafe fn startPeriodicEventsAfterDelay_withPeriod(
            delay: NSTimeInterval,
            period: NSTimeInterval,
        );

        #[unsafe(method(stopPeriodicEvents))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopPeriodicEvents();

        #[cfg(feature = "NSGraphicsContext")]
        #[unsafe(method(mouseEventWithType:location:modifierFlags:timestamp:windowNumber:context:eventNumber:clickCount:pressure:))]
        #[unsafe(method_family = none)]
        pub unsafe fn mouseEventWithType_location_modifierFlags_timestamp_windowNumber_context_eventNumber_clickCount_pressure(
            r#type: NSEventType,
            location: NSPoint,
            flags: NSEventModifierFlags,
            time: NSTimeInterval,
            w_num: NSInteger,
            unused_pass_nil: Option<&NSGraphicsContext>,
            e_num: NSInteger,
            c_num: NSInteger,
            pressure: c_float,
        ) -> Option<Retained<NSEvent>>;

        #[cfg(feature = "NSGraphicsContext")]
        #[unsafe(method(keyEventWithType:location:modifierFlags:timestamp:windowNumber:context:characters:charactersIgnoringModifiers:isARepeat:keyCode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyEventWithType_location_modifierFlags_timestamp_windowNumber_context_characters_charactersIgnoringModifiers_isARepeat_keyCode(
            r#type: NSEventType,
            location: NSPoint,
            flags: NSEventModifierFlags,
            time: NSTimeInterval,
            w_num: NSInteger,
            unused_pass_nil: Option<&NSGraphicsContext>,
            keys: &NSString,
            ukeys: &NSString,
            flag: bool,
            code: c_ushort,
        ) -> Option<Retained<NSEvent>>;

        #[cfg(feature = "NSGraphicsContext")]
        #[unsafe(method(enterExitEventWithType:location:modifierFlags:timestamp:windowNumber:context:eventNumber:trackingNumber:userData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn enterExitEventWithType_location_modifierFlags_timestamp_windowNumber_context_eventNumber_trackingNumber_userData(
            r#type: NSEventType,
            location: NSPoint,
            flags: NSEventModifierFlags,
            time: NSTimeInterval,
            w_num: NSInteger,
            unused_pass_nil: Option<&NSGraphicsContext>,
            e_num: NSInteger,
            t_num: NSInteger,
            data: *mut c_void,
        ) -> Option<Retained<NSEvent>>;

        #[cfg(feature = "NSGraphicsContext")]
        #[unsafe(method(otherEventWithType:location:modifierFlags:timestamp:windowNumber:context:subtype:data1:data2:))]
        #[unsafe(method_family = none)]
        pub unsafe fn otherEventWithType_location_modifierFlags_timestamp_windowNumber_context_subtype_data1_data2(
            r#type: NSEventType,
            location: NSPoint,
            flags: NSEventModifierFlags,
            time: NSTimeInterval,
            w_num: NSInteger,
            unused_pass_nil: Option<&NSGraphicsContext>,
            subtype: c_short,
            d1: NSInteger,
            d2: NSInteger,
        ) -> Option<Retained<NSEvent>>;

        #[unsafe(method(mouseLocation))]
        #[unsafe(method_family = none)]
        pub unsafe fn mouseLocation() -> NSPoint;

        #[unsafe(method(modifierFlags))]
        #[unsafe(method_family = none)]
        pub unsafe fn modifierFlags_class() -> NSEventModifierFlags;

        #[unsafe(method(pressedMouseButtons))]
        #[unsafe(method_family = none)]
        pub unsafe fn pressedMouseButtons() -> NSUInteger;

        #[unsafe(method(doubleClickInterval))]
        #[unsafe(method_family = none)]
        pub unsafe fn doubleClickInterval() -> NSTimeInterval;

        #[unsafe(method(keyRepeatDelay))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyRepeatDelay() -> NSTimeInterval;

        #[unsafe(method(keyRepeatInterval))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyRepeatInterval() -> NSTimeInterval;

        #[cfg(feature = "block2")]
        #[unsafe(method(addGlobalMonitorForEventsMatchingMask:handler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addGlobalMonitorForEventsMatchingMask_handler(
            mask: NSEventMask,
            block: &block2::Block<dyn Fn(NonNull<NSEvent>)>,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(addLocalMonitorForEventsMatchingMask:handler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addLocalMonitorForEventsMatchingMask_handler(
            mask: NSEventMask,
            block: &block2::Block<dyn Fn(NonNull<NSEvent>) -> *mut NSEvent>,
        ) -> Option<Retained<AnyObject>>;

        #[unsafe(method(removeMonitor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeMonitor(event_monitor: &AnyObject);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSEvent {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsuparrowfunctionkey?language=objc)
pub const NSUpArrowFunctionKey: c_uint = 0xF700;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdownarrowfunctionkey?language=objc)
pub const NSDownArrowFunctionKey: c_uint = 0xF701;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsleftarrowfunctionkey?language=objc)
pub const NSLeftArrowFunctionKey: c_uint = 0xF702;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrightarrowfunctionkey?language=objc)
pub const NSRightArrowFunctionKey: c_uint = 0xF703;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf1functionkey?language=objc)
pub const NSF1FunctionKey: c_uint = 0xF704;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf2functionkey?language=objc)
pub const NSF2FunctionKey: c_uint = 0xF705;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf3functionkey?language=objc)
pub const NSF3FunctionKey: c_uint = 0xF706;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf4functionkey?language=objc)
pub const NSF4FunctionKey: c_uint = 0xF707;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf5functionkey?language=objc)
pub const NSF5FunctionKey: c_uint = 0xF708;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf6functionkey?language=objc)
pub const NSF6FunctionKey: c_uint = 0xF709;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf7functionkey?language=objc)
pub const NSF7FunctionKey: c_uint = 0xF70A;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf8functionkey?language=objc)
pub const NSF8FunctionKey: c_uint = 0xF70B;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf9functionkey?language=objc)
pub const NSF9FunctionKey: c_uint = 0xF70C;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf10functionkey?language=objc)
pub const NSF10FunctionKey: c_uint = 0xF70D;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf11functionkey?language=objc)
pub const NSF11FunctionKey: c_uint = 0xF70E;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf12functionkey?language=objc)
pub const NSF12FunctionKey: c_uint = 0xF70F;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf13functionkey?language=objc)
pub const NSF13FunctionKey: c_uint = 0xF710;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf14functionkey?language=objc)
pub const NSF14FunctionKey: c_uint = 0xF711;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf15functionkey?language=objc)
pub const NSF15FunctionKey: c_uint = 0xF712;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf16functionkey?language=objc)
pub const NSF16FunctionKey: c_uint = 0xF713;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf17functionkey?language=objc)
pub const NSF17FunctionKey: c_uint = 0xF714;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf18functionkey?language=objc)
pub const NSF18FunctionKey: c_uint = 0xF715;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf19functionkey?language=objc)
pub const NSF19FunctionKey: c_uint = 0xF716;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf20functionkey?language=objc)
pub const NSF20FunctionKey: c_uint = 0xF717;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf21functionkey?language=objc)
pub const NSF21FunctionKey: c_uint = 0xF718;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf22functionkey?language=objc)
pub const NSF22FunctionKey: c_uint = 0xF719;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf23functionkey?language=objc)
pub const NSF23FunctionKey: c_uint = 0xF71A;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf24functionkey?language=objc)
pub const NSF24FunctionKey: c_uint = 0xF71B;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf25functionkey?language=objc)
pub const NSF25FunctionKey: c_uint = 0xF71C;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf26functionkey?language=objc)
pub const NSF26FunctionKey: c_uint = 0xF71D;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf27functionkey?language=objc)
pub const NSF27FunctionKey: c_uint = 0xF71E;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf28functionkey?language=objc)
pub const NSF28FunctionKey: c_uint = 0xF71F;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf29functionkey?language=objc)
pub const NSF29FunctionKey: c_uint = 0xF720;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf30functionkey?language=objc)
pub const NSF30FunctionKey: c_uint = 0xF721;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf31functionkey?language=objc)
pub const NSF31FunctionKey: c_uint = 0xF722;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf32functionkey?language=objc)
pub const NSF32FunctionKey: c_uint = 0xF723;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf33functionkey?language=objc)
pub const NSF33FunctionKey: c_uint = 0xF724;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf34functionkey?language=objc)
pub const NSF34FunctionKey: c_uint = 0xF725;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsf35functionkey?language=objc)
pub const NSF35FunctionKey: c_uint = 0xF726;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsinsertfunctionkey?language=objc)
pub const NSInsertFunctionKey: c_uint = 0xF727;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdeletefunctionkey?language=objc)
pub const NSDeleteFunctionKey: c_uint = 0xF728;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nshomefunctionkey?language=objc)
pub const NSHomeFunctionKey: c_uint = 0xF729;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbeginfunctionkey?language=objc)
pub const NSBeginFunctionKey: c_uint = 0xF72A;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsendfunctionkey?language=objc)
pub const NSEndFunctionKey: c_uint = 0xF72B;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspageupfunctionkey?language=objc)
pub const NSPageUpFunctionKey: c_uint = 0xF72C;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspagedownfunctionkey?language=objc)
pub const NSPageDownFunctionKey: c_uint = 0xF72D;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsprintscreenfunctionkey?language=objc)
pub const NSPrintScreenFunctionKey: c_uint = 0xF72E;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrolllockfunctionkey?language=objc)
pub const NSScrollLockFunctionKey: c_uint = 0xF72F;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspausefunctionkey?language=objc)
pub const NSPauseFunctionKey: c_uint = 0xF730;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssysreqfunctionkey?language=objc)
pub const NSSysReqFunctionKey: c_uint = 0xF731;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbreakfunctionkey?language=objc)
pub const NSBreakFunctionKey: c_uint = 0xF732;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsresetfunctionkey?language=objc)
pub const NSResetFunctionKey: c_uint = 0xF733;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstopfunctionkey?language=objc)
pub const NSStopFunctionKey: c_uint = 0xF734;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmenufunctionkey?language=objc)
pub const NSMenuFunctionKey: c_uint = 0xF735;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsuserfunctionkey?language=objc)
pub const NSUserFunctionKey: c_uint = 0xF736;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssystemfunctionkey?language=objc)
pub const NSSystemFunctionKey: c_uint = 0xF737;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsprintfunctionkey?language=objc)
pub const NSPrintFunctionKey: c_uint = 0xF738;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsclearlinefunctionkey?language=objc)
pub const NSClearLineFunctionKey: c_uint = 0xF739;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscleardisplayfunctionkey?language=objc)
pub const NSClearDisplayFunctionKey: c_uint = 0xF73A;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsinsertlinefunctionkey?language=objc)
pub const NSInsertLineFunctionKey: c_uint = 0xF73B;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdeletelinefunctionkey?language=objc)
pub const NSDeleteLineFunctionKey: c_uint = 0xF73C;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsinsertcharfunctionkey?language=objc)
pub const NSInsertCharFunctionKey: c_uint = 0xF73D;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdeletecharfunctionkey?language=objc)
pub const NSDeleteCharFunctionKey: c_uint = 0xF73E;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsprevfunctionkey?language=objc)
pub const NSPrevFunctionKey: c_uint = 0xF73F;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsnextfunctionkey?language=objc)
pub const NSNextFunctionKey: c_uint = 0xF740;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsselectfunctionkey?language=objc)
pub const NSSelectFunctionKey: c_uint = 0xF741;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsexecutefunctionkey?language=objc)
pub const NSExecuteFunctionKey: c_uint = 0xF742;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsundofunctionkey?language=objc)
pub const NSUndoFunctionKey: c_uint = 0xF743;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsredofunctionkey?language=objc)
pub const NSRedoFunctionKey: c_uint = 0xF744;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfindfunctionkey?language=objc)
pub const NSFindFunctionKey: c_uint = 0xF745;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nshelpfunctionkey?language=objc)
pub const NSHelpFunctionKey: c_uint = 0xF746;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmodeswitchfunctionkey?language=objc)
pub const NSModeSwitchFunctionKey: c_uint = 0xF747;
