//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdocumentchangetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDocumentChangeType(pub NSUInteger);
impl NSDocumentChangeType {
    #[doc(alias = "NSChangeDone")]
    pub const ChangeDone: Self = Self(0);
    #[doc(alias = "NSChangeUndone")]
    pub const ChangeUndone: Self = Self(1);
    #[doc(alias = "NSChangeRedone")]
    pub const ChangeRedone: Self = Self(5);
    #[doc(alias = "NSChangeCleared")]
    pub const ChangeCleared: Self = Self(2);
    #[doc(alias = "NSChangeReadOtherContents")]
    pub const ChangeReadOtherContents: Self = Self(3);
    #[doc(alias = "NSChangeAutosaved")]
    pub const ChangeAutosaved: Self = Self(4);
    #[doc(alias = "NSChangeDiscardable")]
    pub const ChangeDiscardable: Self = Self(256);
}

unsafe impl Encode for NSDocumentChangeType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDocumentChangeType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssaveoperationtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSaveOperationType(pub NSUInteger);
impl NSSaveOperationType {
    #[doc(alias = "NSSaveOperation")]
    pub const SaveOperation: Self = Self(0);
    #[doc(alias = "NSSaveAsOperation")]
    pub const SaveAsOperation: Self = Self(1);
    #[doc(alias = "NSSaveToOperation")]
    pub const SaveToOperation: Self = Self(2);
    #[doc(alias = "NSAutosaveInPlaceOperation")]
    pub const AutosaveInPlaceOperation: Self = Self(4);
    #[doc(alias = "NSAutosaveElsewhereOperation")]
    pub const AutosaveElsewhereOperation: Self = Self(3);
    #[doc(alias = "NSAutosaveAsOperation")]
    pub const AutosaveAsOperation: Self = Self(5);
    #[deprecated = "Use NSAutosaveElsewhereOperation instead"]
    #[doc(alias = "NSAutosaveOperation")]
    pub const AutosaveOperation: Self = Self(3);
}

unsafe impl Encode for NSSaveOperationType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSSaveOperationType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdocument?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSDocument;
);

#[cfg(feature = "NSKeyValueBinding")]
unsafe impl NSEditorRegistration for NSDocument {}

unsafe impl NSFilePresenter for NSDocument {}

#[cfg(feature = "NSMenu")]
unsafe impl NSMenuItemValidation for NSDocument {}

unsafe impl NSObjectProtocol for NSDocument {}

#[cfg(feature = "NSUserInterfaceValidation")]
unsafe impl NSUserInterfaceValidations for NSDocument {}

impl NSDocument {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initWithType:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithType_error(
            this: Allocated<Self>,
            type_name: &NSString,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[unsafe(method(canConcurrentlyReadDocumentsOfType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canConcurrentlyReadDocumentsOfType(
            type_name: &NSString,
            mtm: MainThreadMarker,
        ) -> bool;

        #[unsafe(method(initWithContentsOfURL:ofType:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL_ofType_error(
            this: Allocated<Self>,
            url: &NSURL,
            type_name: &NSString,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[unsafe(method(initForURL:withContentsOfURL:ofType:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initForURL_withContentsOfURL_ofType_error(
            this: Allocated<Self>,
            url_or_nil: Option<&NSURL>,
            contents_url: &NSURL,
            type_name: &NSString,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[unsafe(method(fileType))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileType(&self) -> Option<Retained<NSString>>;

        /// Setter for [`fileType`][Self::fileType].
        #[unsafe(method(setFileType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFileType(&self, file_type: Option<&NSString>);

        #[unsafe(method(fileURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileURL(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`fileURL`][Self::fileURL].
        #[unsafe(method(setFileURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFileURL(&self, file_url: Option<&NSURL>);

        #[unsafe(method(fileModificationDate))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileModificationDate(&self) -> Option<Retained<NSDate>>;

        /// Setter for [`fileModificationDate`][Self::fileModificationDate].
        #[unsafe(method(setFileModificationDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFileModificationDate(&self, file_modification_date: Option<&NSDate>);

        #[unsafe(method(isDraft))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDraft(&self) -> bool;

        /// Setter for [`isDraft`][Self::isDraft].
        #[unsafe(method(setDraft:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDraft(&self, draft: bool);

        #[cfg(feature = "block2")]
        #[unsafe(method(performActivityWithSynchronousWaiting:usingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performActivityWithSynchronousWaiting_usingBlock(
            &self,
            wait_synchronously: bool,
            block: &block2::Block<dyn Fn(NonNull<block2::Block<dyn Fn()>>)>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(continueActivityUsingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn continueActivityUsingBlock(&self, block: &block2::Block<dyn Fn() + '_>);

        #[cfg(feature = "block2")]
        #[unsafe(method(continueAsynchronousWorkOnMainThreadUsingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn continueAsynchronousWorkOnMainThreadUsingBlock(
            &self,
            block: &block2::Block<dyn Fn()>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(performSynchronousFileAccessUsingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performSynchronousFileAccessUsingBlock(
            &self,
            block: &block2::Block<dyn Fn() + '_>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(performAsynchronousFileAccessUsingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performAsynchronousFileAccessUsingBlock(
            &self,
            block: &block2::Block<dyn Fn(NonNull<block2::Block<dyn Fn()>>)>,
        );

        #[unsafe(method(revertDocumentToSaved:))]
        #[unsafe(method_family = none)]
        pub unsafe fn revertDocumentToSaved(&self, sender: Option<&AnyObject>);

        #[unsafe(method(revertToContentsOfURL:ofType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn revertToContentsOfURL_ofType_error(
            &self,
            url: &NSURL,
            type_name: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(readFromURL:ofType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn readFromURL_ofType_error(
            &self,
            url: &NSURL,
            type_name: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(readFromFileWrapper:ofType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn readFromFileWrapper_ofType_error(
            &self,
            file_wrapper: &NSFileWrapper,
            type_name: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(readFromData:ofType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn readFromData_ofType_error(
            &self,
            data: &NSData,
            type_name: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(isEntireFileLoaded))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEntireFileLoaded(&self) -> bool;

        #[unsafe(method(writeToURL:ofType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToURL_ofType_error(
            &self,
            url: &NSURL,
            type_name: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(fileWrapperOfType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileWrapperOfType_error(
            &self,
            type_name: &NSString,
        ) -> Result<Retained<NSFileWrapper>, Retained<NSError>>;

        #[unsafe(method(dataOfType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataOfType_error(
            &self,
            type_name: &NSString,
        ) -> Result<Retained<NSData>, Retained<NSError>>;

        #[unsafe(method(unblockUserInteraction))]
        #[unsafe(method_family = none)]
        pub unsafe fn unblockUserInteraction(&self);

        #[unsafe(method(autosavingIsImplicitlyCancellable))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosavingIsImplicitlyCancellable(&self) -> bool;

        #[unsafe(method(writeSafelyToURL:ofType:forSaveOperation:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeSafelyToURL_ofType_forSaveOperation_error(
            &self,
            url: &NSURL,
            type_name: &NSString,
            save_operation: NSSaveOperationType,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(writeToURL:ofType:forSaveOperation:originalContentsURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToURL_ofType_forSaveOperation_originalContentsURL_error(
            &self,
            url: &NSURL,
            type_name: &NSString,
            save_operation: NSSaveOperationType,
            absolute_original_contents_url: Option<&NSURL>,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(fileAttributesToWriteToURL:ofType:forSaveOperation:originalContentsURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileAttributesToWriteToURL_ofType_forSaveOperation_originalContentsURL_error(
            &self,
            url: &NSURL,
            type_name: &NSString,
            save_operation: NSSaveOperationType,
            absolute_original_contents_url: Option<&NSURL>,
        ) -> Result<Retained<NSDictionary<NSString, AnyObject>>, Retained<NSError>>;

        #[unsafe(method(keepBackupFile))]
        #[unsafe(method_family = none)]
        pub unsafe fn keepBackupFile(&self) -> bool;

        #[unsafe(method(backupFileURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn backupFileURL(&self) -> Option<Retained<NSURL>>;

        #[unsafe(method(saveDocument:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveDocument(&self, sender: Option<&AnyObject>);

        #[unsafe(method(saveDocumentAs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveDocumentAs(&self, sender: Option<&AnyObject>);

        #[unsafe(method(saveDocumentTo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveDocumentTo(&self, sender: Option<&AnyObject>);

        #[unsafe(method(saveDocumentWithDelegate:didSaveSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveDocumentWithDelegate_didSaveSelector_contextInfo(
            &self,
            delegate: Option<&AnyObject>,
            did_save_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[unsafe(method(runModalSavePanelForSaveOperation:delegate:didSaveSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn runModalSavePanelForSaveOperation_delegate_didSaveSelector_contextInfo(
            &self,
            save_operation: NSSaveOperationType,
            delegate: Option<&AnyObject>,
            did_save_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[unsafe(method(savePanelShowsFileFormatsControl))]
        #[unsafe(method_family = none)]
        pub unsafe fn savePanelShowsFileFormatsControl(&self) -> bool;

        #[cfg(all(
            feature = "NSPanel",
            feature = "NSResponder",
            feature = "NSSavePanel",
            feature = "NSWindow"
        ))]
        #[unsafe(method(prepareSavePanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn prepareSavePanel(&self, save_panel: &NSSavePanel) -> bool;

        #[unsafe(method(fileNameExtensionWasHiddenInLastRunSavePanel))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileNameExtensionWasHiddenInLastRunSavePanel(&self) -> bool;

        #[unsafe(method(fileTypeFromLastRunSavePanel))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileTypeFromLastRunSavePanel(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(saveToURL:ofType:forSaveOperation:delegate:didSaveSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveToURL_ofType_forSaveOperation_delegate_didSaveSelector_contextInfo(
            &self,
            url: &NSURL,
            type_name: &NSString,
            save_operation: NSSaveOperationType,
            delegate: Option<&AnyObject>,
            did_save_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(saveToURL:ofType:forSaveOperation:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveToURL_ofType_forSaveOperation_completionHandler(
            &self,
            url: &NSURL,
            type_name: &NSString,
            save_operation: NSSaveOperationType,
            completion_handler: &block2::Block<dyn Fn(*mut NSError)>,
        );

        #[unsafe(method(canAsynchronouslyWriteToURL:ofType:forSaveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canAsynchronouslyWriteToURL_ofType_forSaveOperation(
            &self,
            url: &NSURL,
            type_name: &NSString,
            save_operation: NSSaveOperationType,
        ) -> bool;

        #[unsafe(method(checkAutosavingSafetyAndReturnError:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkAutosavingSafetyAndReturnError(&self) -> Result<(), Retained<NSError>>;

        #[unsafe(method(scheduleAutosaving))]
        #[unsafe(method_family = none)]
        pub unsafe fn scheduleAutosaving(&self);

        #[unsafe(method(hasUnautosavedChanges))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasUnautosavedChanges(&self) -> bool;

        #[unsafe(method(autosaveDocumentWithDelegate:didAutosaveSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosaveDocumentWithDelegate_didAutosaveSelector_contextInfo(
            &self,
            delegate: Option<&AnyObject>,
            did_autosave_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(autosaveWithImplicitCancellability:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosaveWithImplicitCancellability_completionHandler(
            &self,
            autosaving_is_implicitly_cancellable: bool,
            completion_handler: &block2::Block<dyn Fn(*mut NSError)>,
        );

        #[unsafe(method(autosavesInPlace))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosavesInPlace(mtm: MainThreadMarker) -> bool;

        #[unsafe(method(preservesVersions))]
        #[unsafe(method_family = none)]
        pub unsafe fn preservesVersions(mtm: MainThreadMarker) -> bool;

        #[unsafe(method(browseDocumentVersions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn browseDocumentVersions(&self, sender: Option<&AnyObject>);

        #[unsafe(method(isBrowsingVersions))]
        #[unsafe(method_family = none)]
        pub unsafe fn isBrowsingVersions(&self) -> bool;

        #[cfg(feature = "block2")]
        #[unsafe(method(stopBrowsingVersionsWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopBrowsingVersionsWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::Block<dyn Fn()>>,
        );

        #[unsafe(method(autosavesDrafts))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosavesDrafts(mtm: MainThreadMarker) -> bool;

        #[unsafe(method(autosavingFileType))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosavingFileType(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(autosavedContentsFileURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosavedContentsFileURL(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`autosavedContentsFileURL`][Self::autosavedContentsFileURL].
        #[unsafe(method(setAutosavedContentsFileURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutosavedContentsFileURL(
            &self,
            autosaved_contents_file_url: Option<&NSURL>,
        );

        #[unsafe(method(canCloseDocumentWithDelegate:shouldCloseSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canCloseDocumentWithDelegate_shouldCloseSelector_contextInfo(
            &self,
            delegate: &AnyObject,
            should_close_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[unsafe(method(close))]
        #[unsafe(method_family = none)]
        pub unsafe fn close(&self);

        #[unsafe(method(duplicateDocument:))]
        #[unsafe(method_family = none)]
        pub unsafe fn duplicateDocument(&self, sender: Option<&AnyObject>);

        #[unsafe(method(duplicateDocumentWithDelegate:didDuplicateSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn duplicateDocumentWithDelegate_didDuplicateSelector_contextInfo(
            &self,
            delegate: Option<&AnyObject>,
            did_duplicate_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[unsafe(method(duplicateAndReturnError:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn duplicateAndReturnError(
            &self,
        ) -> Result<Retained<NSDocument>, Retained<NSError>>;

        #[unsafe(method(renameDocument:))]
        #[unsafe(method_family = none)]
        pub unsafe fn renameDocument(&self, sender: Option<&AnyObject>);

        #[unsafe(method(moveDocumentToUbiquityContainer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveDocumentToUbiquityContainer(&self, sender: Option<&AnyObject>);

        #[unsafe(method(moveDocument:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveDocument(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "block2")]
        #[unsafe(method(moveDocumentWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveDocumentWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::Block<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(moveToURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveToURL_completionHandler(
            &self,
            url: &NSURL,
            completion_handler: Option<&block2::Block<dyn Fn(*mut NSError)>>,
        );

        #[unsafe(method(lockDocument:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockDocument(&self, sender: Option<&AnyObject>);

        #[unsafe(method(unlockDocument:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unlockDocument(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "block2")]
        #[unsafe(method(lockDocumentWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockDocumentWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::Block<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(lockWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::Block<dyn Fn(*mut NSError)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(unlockDocumentWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unlockDocumentWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::Block<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(unlockWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unlockWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::Block<dyn Fn(*mut NSError)>>,
        );

        #[unsafe(method(isLocked))]
        #[unsafe(method_family = none)]
        pub unsafe fn isLocked(&self) -> bool;

        #[unsafe(method(runPageLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn runPageLayout(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSPrintInfo")]
        #[unsafe(method(runModalPageLayoutWithPrintInfo:delegate:didRunSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn runModalPageLayoutWithPrintInfo_delegate_didRunSelector_contextInfo(
            &self,
            print_info: &NSPrintInfo,
            delegate: Option<&AnyObject>,
            did_run_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[cfg(feature = "NSPageLayout")]
        #[unsafe(method(preparePageLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn preparePageLayout(&self, page_layout: &NSPageLayout) -> bool;

        #[cfg(feature = "NSPrintInfo")]
        #[unsafe(method(shouldChangePrintInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldChangePrintInfo(&self, new_print_info: &NSPrintInfo) -> bool;

        #[cfg(feature = "NSPrintInfo")]
        #[unsafe(method(printInfo))]
        #[unsafe(method_family = none)]
        pub unsafe fn printInfo(&self) -> Retained<NSPrintInfo>;

        #[cfg(feature = "NSPrintInfo")]
        /// Setter for [`printInfo`][Self::printInfo].
        #[unsafe(method(setPrintInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPrintInfo(&self, print_info: &NSPrintInfo);

        #[unsafe(method(printDocument:))]
        #[unsafe(method_family = none)]
        pub unsafe fn printDocument(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSPrintInfo")]
        #[unsafe(method(printDocumentWithSettings:showPrintPanel:delegate:didPrintSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn printDocumentWithSettings_showPrintPanel_delegate_didPrintSelector_contextInfo(
            &self,
            print_settings: &NSDictionary<NSPrintInfoAttributeKey, AnyObject>,
            show_print_panel: bool,
            delegate: Option<&AnyObject>,
            did_print_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[cfg(all(feature = "NSPrintInfo", feature = "NSPrintOperation"))]
        #[unsafe(method(printOperationWithSettings:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn printOperationWithSettings_error(
            &self,
            print_settings: &NSDictionary<NSPrintInfoAttributeKey, AnyObject>,
        ) -> Result<Retained<NSPrintOperation>, Retained<NSError>>;

        #[cfg(feature = "NSPrintOperation")]
        #[unsafe(method(runModalPrintOperation:delegate:didRunSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn runModalPrintOperation_delegate_didRunSelector_contextInfo(
            &self,
            print_operation: &NSPrintOperation,
            delegate: Option<&AnyObject>,
            did_run_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[unsafe(method(saveDocumentToPDF:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveDocumentToPDF(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSPrintOperation")]
        #[unsafe(method(PDFPrintOperation))]
        #[unsafe(method_family = none)]
        pub unsafe fn PDFPrintOperation(&self) -> Retained<NSPrintOperation>;

        #[unsafe(method(allowsDocumentSharing))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsDocumentSharing(&self) -> bool;

        #[cfg(all(feature = "NSSharingService", feature = "block2"))]
        #[unsafe(method(shareDocumentWithSharingService:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shareDocumentWithSharingService_completionHandler(
            &self,
            sharing_service: &NSSharingService,
            completion_handler: Option<&block2::Block<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "NSSharingService")]
        #[unsafe(method(prepareSharingServicePicker:))]
        #[unsafe(method_family = none)]
        pub unsafe fn prepareSharingServicePicker(
            &self,
            sharing_service_picker: &NSSharingServicePicker,
        );

        #[cfg(feature = "NSPreviewRepresentingActivityItem")]
        #[unsafe(method(previewRepresentableActivityItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn previewRepresentableActivityItems(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn NSPreviewRepresentableActivityItem>>>>;

        #[cfg(feature = "NSPreviewRepresentingActivityItem")]
        /// Setter for [`previewRepresentableActivityItems`][Self::previewRepresentableActivityItems].
        #[unsafe(method(setPreviewRepresentableActivityItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreviewRepresentableActivityItems(
            &self,
            preview_representable_activity_items: Option<
                &NSArray<ProtocolObject<dyn NSPreviewRepresentableActivityItem>>,
            >,
        );

        #[unsafe(method(isDocumentEdited))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDocumentEdited(&self) -> bool;

        #[unsafe(method(isInViewingMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn isInViewingMode(&self) -> bool;

        #[unsafe(method(updateChangeCount:))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateChangeCount(&self, change: NSDocumentChangeType);

        #[unsafe(method(changeCountTokenForSaveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeCountTokenForSaveOperation(
            &self,
            save_operation: NSSaveOperationType,
        ) -> Retained<AnyObject>;

        #[unsafe(method(updateChangeCountWithToken:forSaveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateChangeCountWithToken_forSaveOperation(
            &self,
            change_count_token: &AnyObject,
            save_operation: NSSaveOperationType,
        );

        #[unsafe(method(undoManager))]
        #[unsafe(method_family = none)]
        pub unsafe fn undoManager(&self) -> Option<Retained<NSUndoManager>>;

        /// Setter for [`undoManager`][Self::undoManager].
        #[unsafe(method(setUndoManager:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUndoManager(&self, undo_manager: Option<&NSUndoManager>);

        #[unsafe(method(hasUndoManager))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasUndoManager(&self) -> bool;

        /// Setter for [`hasUndoManager`][Self::hasUndoManager].
        #[unsafe(method(setHasUndoManager:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHasUndoManager(&self, has_undo_manager: bool);

        #[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
        #[unsafe(method(presentError:modalForWindow:delegate:didPresentSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentError_modalForWindow_delegate_didPresentSelector_contextInfo(
            &self,
            error: &NSError,
            window: &NSWindow,
            delegate: Option<&AnyObject>,
            did_present_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[unsafe(method(presentError:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentError(&self, error: &NSError) -> bool;

        #[unsafe(method(willPresentError:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willPresentError(&self, error: &NSError) -> Retained<NSError>;

        #[unsafe(method(willNotPresentError:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willNotPresentError(&self, error: &NSError);

        #[unsafe(method(makeWindowControllers))]
        #[unsafe(method_family = none)]
        pub unsafe fn makeWindowControllers(&self);

        #[cfg(feature = "NSNib")]
        #[unsafe(method(windowNibName))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowNibName(&self) -> Option<Retained<NSNibName>>;

        #[cfg(all(feature = "NSResponder", feature = "NSWindowController"))]
        #[unsafe(method(windowControllerWillLoadNib:))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowControllerWillLoadNib(&self, window_controller: &NSWindowController);

        #[cfg(all(feature = "NSResponder", feature = "NSWindowController"))]
        #[unsafe(method(windowControllerDidLoadNib:))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowControllerDidLoadNib(&self, window_controller: &NSWindowController);

        #[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
        #[unsafe(method(setWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWindow(&self, window: Option<&NSWindow>);

        #[cfg(all(feature = "NSResponder", feature = "NSWindowController"))]
        #[unsafe(method(addWindowController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addWindowController(&self, window_controller: &NSWindowController);

        #[cfg(all(feature = "NSResponder", feature = "NSWindowController"))]
        #[unsafe(method(removeWindowController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeWindowController(&self, window_controller: &NSWindowController);

        #[unsafe(method(showWindows))]
        #[unsafe(method_family = none)]
        pub unsafe fn showWindows(&self);

        #[cfg(all(feature = "NSResponder", feature = "NSWindowController"))]
        #[unsafe(method(windowControllers))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowControllers(&self) -> Retained<NSArray<NSWindowController>>;

        #[cfg(all(feature = "NSResponder", feature = "NSWindowController"))]
        #[unsafe(method(shouldCloseWindowController:delegate:shouldCloseSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldCloseWindowController_delegate_shouldCloseSelector_contextInfo(
            &self,
            window_controller: &NSWindowController,
            delegate: Option<&AnyObject>,
            should_close_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[unsafe(method(displayName))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayName(&self) -> Retained<NSString>;

        #[unsafe(method(defaultDraftName))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultDraftName(&self) -> Retained<NSString>;

        #[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
        #[unsafe(method(windowForSheet))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowForSheet(&self) -> Option<Retained<NSWindow>>;

        #[unsafe(method(readableTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn readableTypes(mtm: MainThreadMarker) -> Retained<NSArray<NSString>>;

        #[unsafe(method(writableTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn writableTypes(mtm: MainThreadMarker) -> Retained<NSArray<NSString>>;

        #[unsafe(method(isNativeType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isNativeType(r#type: &NSString, mtm: MainThreadMarker) -> bool;

        #[unsafe(method(writableTypesForSaveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writableTypesForSaveOperation(
            &self,
            save_operation: NSSaveOperationType,
        ) -> Retained<NSArray<NSString>>;

        #[unsafe(method(fileNameExtensionForType:saveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileNameExtensionForType_saveOperation(
            &self,
            type_name: &NSString,
            save_operation: NSSaveOperationType,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSUserInterfaceValidation")]
        #[unsafe(method(validateUserInterfaceItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn validateUserInterfaceItem(
            &self,
            item: &ProtocolObject<dyn NSValidatedUserInterfaceItem>,
        ) -> bool;

        #[unsafe(method(usesUbiquitousStorage))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesUbiquitousStorage(mtm: MainThreadMarker) -> bool;

        #[unsafe(method(presentedItemURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentedItemURL(&self) -> Option<Retained<NSURL>>;

        #[unsafe(method(observedPresentedItemUbiquityAttributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn observedPresentedItemUbiquityAttributes(
            &self,
        ) -> Retained<NSSet<NSURLResourceKey>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(relinquishPresentedItemToReader:))]
        #[unsafe(method_family = none)]
        pub unsafe fn relinquishPresentedItemToReader(
            &self,
            reader: &block2::Block<dyn Fn(*mut block2::Block<dyn Fn()>)>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(relinquishPresentedItemToWriter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn relinquishPresentedItemToWriter(
            &self,
            writer: &block2::Block<dyn Fn(*mut block2::Block<dyn Fn()>)>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(savePresentedItemChangesWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn savePresentedItemChangesWithCompletionHandler(
            &self,
            completion_handler: &block2::Block<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accommodatePresentedItemDeletionWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn accommodatePresentedItemDeletionWithCompletionHandler(
            &self,
            completion_handler: &block2::Block<dyn Fn(*mut NSError)>,
        );

        #[unsafe(method(presentedItemDidMoveToURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentedItemDidMoveToURL(&self, new_url: &NSURL);

        #[unsafe(method(presentedItemDidChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentedItemDidChange(&self);

        #[unsafe(method(presentedItemDidChangeUbiquityAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentedItemDidChangeUbiquityAttributes(
            &self,
            attributes: &NSSet<NSURLResourceKey>,
        );

        #[unsafe(method(presentedItemDidGainVersion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentedItemDidGainVersion(&self, version: &NSFileVersion);

        #[unsafe(method(presentedItemDidLoseVersion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentedItemDidLoseVersion(&self, version: &NSFileVersion);

        #[unsafe(method(presentedItemDidResolveConflictVersion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentedItemDidResolveConflictVersion(&self, version: &NSFileVersion);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSDocument {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSDeprecated.
impl NSDocument {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(shouldRunSavePanelWithAccessoryView))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldRunSavePanelWithAccessoryView(&self) -> bool;

        #[deprecated = "Use -saveToURL:ofType:forSaveOperation:completionHandler: instead"]
        #[unsafe(method(saveToURL:ofType:forSaveOperation:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveToURL_ofType_forSaveOperation_error(
            &self,
            url: &NSURL,
            type_name: &NSString,
            save_operation: NSSaveOperationType,
        ) -> Result<(), Retained<NSError>>;

        #[deprecated]
        #[unsafe(method(dataRepresentationOfType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataRepresentationOfType(
            &self,
            r#type: &NSString,
        ) -> Option<Retained<NSData>>;

        #[deprecated]
        #[unsafe(method(fileAttributesToWriteToFile:ofType:saveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileAttributesToWriteToFile_ofType_saveOperation(
            &self,
            full_document_path: &NSString,
            document_type_name: &NSString,
            save_operation_type: NSSaveOperationType,
        ) -> Option<Retained<NSDictionary>>;

        #[deprecated]
        #[unsafe(method(fileName))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileName(&self) -> Option<Retained<NSString>>;

        #[deprecated]
        #[unsafe(method(fileWrapperRepresentationOfType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileWrapperRepresentationOfType(
            &self,
            r#type: &NSString,
        ) -> Option<Retained<NSFileWrapper>>;

        #[deprecated]
        #[unsafe(method(initWithContentsOfFile:ofType:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfFile_ofType(
            this: Allocated<Self>,
            absolute_path: &NSString,
            type_name: &NSString,
        ) -> Option<Retained<Self>>;

        #[deprecated]
        #[unsafe(method(initWithContentsOfURL:ofType:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL_ofType(
            this: Allocated<Self>,
            url: &NSURL,
            type_name: &NSString,
        ) -> Option<Retained<Self>>;

        #[deprecated]
        #[unsafe(method(loadDataRepresentation:ofType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadDataRepresentation_ofType(
            &self,
            data: &NSData,
            r#type: &NSString,
        ) -> bool;

        #[deprecated]
        #[unsafe(method(loadFileWrapperRepresentation:ofType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadFileWrapperRepresentation_ofType(
            &self,
            wrapper: &NSFileWrapper,
            r#type: &NSString,
        ) -> bool;

        #[deprecated]
        #[unsafe(method(printShowingPrintPanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn printShowingPrintPanel(&self, flag: bool);

        #[deprecated]
        #[unsafe(method(readFromFile:ofType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn readFromFile_ofType(&self, file_name: &NSString, r#type: &NSString) -> bool;

        #[deprecated]
        #[unsafe(method(readFromURL:ofType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn readFromURL_ofType(&self, url: &NSURL, r#type: &NSString) -> bool;

        #[deprecated]
        #[unsafe(method(revertToSavedFromFile:ofType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn revertToSavedFromFile_ofType(
            &self,
            file_name: &NSString,
            r#type: &NSString,
        ) -> bool;

        #[deprecated]
        #[unsafe(method(revertToSavedFromURL:ofType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn revertToSavedFromURL_ofType(&self, url: &NSURL, r#type: &NSString) -> bool;

        #[cfg(feature = "NSPrintInfo")]
        #[deprecated]
        #[unsafe(method(runModalPageLayoutWithPrintInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn runModalPageLayoutWithPrintInfo(&self, print_info: &NSPrintInfo)
            -> NSInteger;

        #[deprecated]
        #[unsafe(method(saveToFile:saveOperation:delegate:didSaveSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveToFile_saveOperation_delegate_didSaveSelector_contextInfo(
            &self,
            file_name: &NSString,
            save_operation: NSSaveOperationType,
            delegate: Option<&AnyObject>,
            did_save_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[deprecated]
        #[unsafe(method(setFileName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFileName(&self, file_name: Option<&NSString>);

        #[deprecated]
        #[unsafe(method(writeToFile:ofType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToFile_ofType(&self, file_name: &NSString, r#type: &NSString) -> bool;

        #[deprecated]
        #[unsafe(method(writeToFile:ofType:originalFile:saveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToFile_ofType_originalFile_saveOperation(
            &self,
            full_document_path: &NSString,
            document_type_name: &NSString,
            full_original_document_path: Option<&NSString>,
            save_operation_type: NSSaveOperationType,
        ) -> bool;

        #[deprecated]
        #[unsafe(method(writeToURL:ofType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToURL_ofType(&self, url: &NSURL, r#type: &NSString) -> bool;

        #[deprecated]
        #[unsafe(method(writeWithBackupToFile:ofType:saveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeWithBackupToFile_ofType_saveOperation(
            &self,
            full_document_path: &NSString,
            document_type_name: &NSString,
            save_operation_type: NSSaveOperationType,
        ) -> bool;
    );
}
