// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package supportapp

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateSlackChannelConfiguration = "CreateSlackChannelConfiguration"

// CreateSlackChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSlackChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSlackChannelConfiguration for more information on using the CreateSlackChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSlackChannelConfigurationRequest method.
//	req, resp := client.CreateSlackChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/CreateSlackChannelConfiguration
func (c *SupportApp) CreateSlackChannelConfigurationRequest(input *CreateSlackChannelConfigurationInput) (req *request.Request, output *CreateSlackChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateSlackChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/control/create-slack-channel-configuration",
	}

	if input == nil {
		input = &CreateSlackChannelConfigurationInput{}
	}

	output = &CreateSlackChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateSlackChannelConfiguration API operation for AWS Support App.
//
// Creates a Slack channel configuration for your Amazon Web Services account.
//
//   - You can add up to 5 Slack workspaces for your account.
//
//   - You can add up to 20 Slack channels for your account.
//
// A Slack channel can have up to 100 Amazon Web Services accounts. This means
// that only 100 accounts can add the same Slack channel to the Amazon Web Services
// Support App. We recommend that you only add the accounts that you need to
// manage support cases for your organization. This can reduce the notifications
// about case updates that you receive in the Slack channel.
//
// We recommend that you choose a private Slack channel so that only members
// in that channel have read and write access to your support cases. Anyone
// in your Slack channel can create, update, or resolve support cases for your
// account. Users require an invitation to join private channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation CreateSlackChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Your Service Quotas request exceeds the quota for the service. For example,
//     your Service Quotas request to Amazon Web Services Support App might exceed
//     the maximum number of workspaces or channels per account, or the maximum
//     number of accounts per Slack channel.
//
//   - ConflictException
//     Your request has a conflict. For example, you might receive this error if
//     you try the following:
//
//   - Add, update, or delete a Slack channel configuration before you add
//     a Slack workspace to your Amazon Web Services account.
//
//   - Add a Slack channel configuration that already exists in your Amazon
//     Web Services account.
//
//   - Delete a Slack channel configuration for a live chat channel.
//
//   - Delete a Slack workspace from your Amazon Web Services account that
//     has an active live chat channel.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from an Amazon Web
//     Services account that doesn't belong to an organization.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from a member account,
//     but the management account hasn't registered that workspace yet for the
//     organization.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ValidationException
//     Your request input doesn't meet the constraints that the Amazon Web Services
//     Support App specifies.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/CreateSlackChannelConfiguration
func (c *SupportApp) CreateSlackChannelConfiguration(input *CreateSlackChannelConfigurationInput) (*CreateSlackChannelConfigurationOutput, error) {
	req, out := c.CreateSlackChannelConfigurationRequest(input)
	return out, req.Send()
}

// CreateSlackChannelConfigurationWithContext is the same as CreateSlackChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSlackChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) CreateSlackChannelConfigurationWithContext(ctx aws.Context, input *CreateSlackChannelConfigurationInput, opts ...request.Option) (*CreateSlackChannelConfigurationOutput, error) {
	req, out := c.CreateSlackChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountAlias = "DeleteAccountAlias"

// DeleteAccountAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountAlias for more information on using the DeleteAccountAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountAliasRequest method.
//	req, resp := client.DeleteAccountAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteAccountAlias
func (c *SupportApp) DeleteAccountAliasRequest(input *DeleteAccountAliasInput) (req *request.Request, output *DeleteAccountAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/control/delete-account-alias",
	}

	if input == nil {
		input = &DeleteAccountAliasInput{}
	}

	output = &DeleteAccountAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccountAlias API operation for AWS Support App.
//
// Deletes an alias for an Amazon Web Services account ID. The alias appears
// in the Amazon Web Services Support App page of the Amazon Web Services Support
// Center. The alias also appears in Slack messages from the Amazon Web Services
// Support App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation DeleteAccountAlias for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource is missing or doesn't exist, such as an account alias,
//     Slack channel configuration, or Slack workspace configuration.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteAccountAlias
func (c *SupportApp) DeleteAccountAlias(input *DeleteAccountAliasInput) (*DeleteAccountAliasOutput, error) {
	req, out := c.DeleteAccountAliasRequest(input)
	return out, req.Send()
}

// DeleteAccountAliasWithContext is the same as DeleteAccountAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) DeleteAccountAliasWithContext(ctx aws.Context, input *DeleteAccountAliasInput, opts ...request.Option) (*DeleteAccountAliasOutput, error) {
	req, out := c.DeleteAccountAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlackChannelConfiguration = "DeleteSlackChannelConfiguration"

// DeleteSlackChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlackChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlackChannelConfiguration for more information on using the DeleteSlackChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlackChannelConfigurationRequest method.
//	req, resp := client.DeleteSlackChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteSlackChannelConfiguration
func (c *SupportApp) DeleteSlackChannelConfigurationRequest(input *DeleteSlackChannelConfigurationInput) (req *request.Request, output *DeleteSlackChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSlackChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/control/delete-slack-channel-configuration",
	}

	if input == nil {
		input = &DeleteSlackChannelConfigurationInput{}
	}

	output = &DeleteSlackChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlackChannelConfiguration API operation for AWS Support App.
//
// Deletes a Slack channel configuration from your Amazon Web Services account.
// This operation doesn't delete your Slack channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation DeleteSlackChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Your request has a conflict. For example, you might receive this error if
//     you try the following:
//
//   - Add, update, or delete a Slack channel configuration before you add
//     a Slack workspace to your Amazon Web Services account.
//
//   - Add a Slack channel configuration that already exists in your Amazon
//     Web Services account.
//
//   - Delete a Slack channel configuration for a live chat channel.
//
//   - Delete a Slack workspace from your Amazon Web Services account that
//     has an active live chat channel.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from an Amazon Web
//     Services account that doesn't belong to an organization.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from a member account,
//     but the management account hasn't registered that workspace yet for the
//     organization.
//
//   - ResourceNotFoundException
//     The specified resource is missing or doesn't exist, such as an account alias,
//     Slack channel configuration, or Slack workspace configuration.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ValidationException
//     Your request input doesn't meet the constraints that the Amazon Web Services
//     Support App specifies.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteSlackChannelConfiguration
func (c *SupportApp) DeleteSlackChannelConfiguration(input *DeleteSlackChannelConfigurationInput) (*DeleteSlackChannelConfigurationOutput, error) {
	req, out := c.DeleteSlackChannelConfigurationRequest(input)
	return out, req.Send()
}

// DeleteSlackChannelConfigurationWithContext is the same as DeleteSlackChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlackChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) DeleteSlackChannelConfigurationWithContext(ctx aws.Context, input *DeleteSlackChannelConfigurationInput, opts ...request.Option) (*DeleteSlackChannelConfigurationOutput, error) {
	req, out := c.DeleteSlackChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlackWorkspaceConfiguration = "DeleteSlackWorkspaceConfiguration"

// DeleteSlackWorkspaceConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlackWorkspaceConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlackWorkspaceConfiguration for more information on using the DeleteSlackWorkspaceConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlackWorkspaceConfigurationRequest method.
//	req, resp := client.DeleteSlackWorkspaceConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteSlackWorkspaceConfiguration
func (c *SupportApp) DeleteSlackWorkspaceConfigurationRequest(input *DeleteSlackWorkspaceConfigurationInput) (req *request.Request, output *DeleteSlackWorkspaceConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSlackWorkspaceConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/control/delete-slack-workspace-configuration",
	}

	if input == nil {
		input = &DeleteSlackWorkspaceConfigurationInput{}
	}

	output = &DeleteSlackWorkspaceConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlackWorkspaceConfiguration API operation for AWS Support App.
//
// Deletes a Slack workspace configuration from your Amazon Web Services account.
// This operation doesn't delete your Slack workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation DeleteSlackWorkspaceConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Your request has a conflict. For example, you might receive this error if
//     you try the following:
//
//   - Add, update, or delete a Slack channel configuration before you add
//     a Slack workspace to your Amazon Web Services account.
//
//   - Add a Slack channel configuration that already exists in your Amazon
//     Web Services account.
//
//   - Delete a Slack channel configuration for a live chat channel.
//
//   - Delete a Slack workspace from your Amazon Web Services account that
//     has an active live chat channel.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from an Amazon Web
//     Services account that doesn't belong to an organization.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from a member account,
//     but the management account hasn't registered that workspace yet for the
//     organization.
//
//   - ResourceNotFoundException
//     The specified resource is missing or doesn't exist, such as an account alias,
//     Slack channel configuration, or Slack workspace configuration.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ValidationException
//     Your request input doesn't meet the constraints that the Amazon Web Services
//     Support App specifies.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/DeleteSlackWorkspaceConfiguration
func (c *SupportApp) DeleteSlackWorkspaceConfiguration(input *DeleteSlackWorkspaceConfigurationInput) (*DeleteSlackWorkspaceConfigurationOutput, error) {
	req, out := c.DeleteSlackWorkspaceConfigurationRequest(input)
	return out, req.Send()
}

// DeleteSlackWorkspaceConfigurationWithContext is the same as DeleteSlackWorkspaceConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlackWorkspaceConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) DeleteSlackWorkspaceConfigurationWithContext(ctx aws.Context, input *DeleteSlackWorkspaceConfigurationInput, opts ...request.Option) (*DeleteSlackWorkspaceConfigurationOutput, error) {
	req, out := c.DeleteSlackWorkspaceConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountAlias = "GetAccountAlias"

// GetAccountAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountAlias for more information on using the GetAccountAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountAliasRequest method.
//	req, resp := client.GetAccountAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/GetAccountAlias
func (c *SupportApp) GetAccountAliasRequest(input *GetAccountAliasInput) (req *request.Request, output *GetAccountAliasOutput) {
	op := &request.Operation{
		Name:       opGetAccountAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/control/get-account-alias",
	}

	if input == nil {
		input = &GetAccountAliasInput{}
	}

	output = &GetAccountAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountAlias API operation for AWS Support App.
//
// Retrieves the alias from an Amazon Web Services account ID. The alias appears
// in the Amazon Web Services Support App page of the Amazon Web Services Support
// Center. The alias also appears in Slack messages from the Amazon Web Services
// Support App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation GetAccountAlias for usage and error information.
//
// Returned Error Types:
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/GetAccountAlias
func (c *SupportApp) GetAccountAlias(input *GetAccountAliasInput) (*GetAccountAliasOutput, error) {
	req, out := c.GetAccountAliasRequest(input)
	return out, req.Send()
}

// GetAccountAliasWithContext is the same as GetAccountAlias with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) GetAccountAliasWithContext(ctx aws.Context, input *GetAccountAliasInput, opts ...request.Option) (*GetAccountAliasOutput, error) {
	req, out := c.GetAccountAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSlackChannelConfigurations = "ListSlackChannelConfigurations"

// ListSlackChannelConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSlackChannelConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSlackChannelConfigurations for more information on using the ListSlackChannelConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSlackChannelConfigurationsRequest method.
//	req, resp := client.ListSlackChannelConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackChannelConfigurations
func (c *SupportApp) ListSlackChannelConfigurationsRequest(input *ListSlackChannelConfigurationsInput) (req *request.Request, output *ListSlackChannelConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListSlackChannelConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/control/list-slack-channel-configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSlackChannelConfigurationsInput{}
	}

	output = &ListSlackChannelConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSlackChannelConfigurations API operation for AWS Support App.
//
// Lists the Slack channel configurations for an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation ListSlackChannelConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackChannelConfigurations
func (c *SupportApp) ListSlackChannelConfigurations(input *ListSlackChannelConfigurationsInput) (*ListSlackChannelConfigurationsOutput, error) {
	req, out := c.ListSlackChannelConfigurationsRequest(input)
	return out, req.Send()
}

// ListSlackChannelConfigurationsWithContext is the same as ListSlackChannelConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSlackChannelConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) ListSlackChannelConfigurationsWithContext(ctx aws.Context, input *ListSlackChannelConfigurationsInput, opts ...request.Option) (*ListSlackChannelConfigurationsOutput, error) {
	req, out := c.ListSlackChannelConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSlackChannelConfigurationsPages iterates over the pages of a ListSlackChannelConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSlackChannelConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSlackChannelConfigurations operation.
//	pageNum := 0
//	err := client.ListSlackChannelConfigurationsPages(params,
//	    func(page *supportapp.ListSlackChannelConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SupportApp) ListSlackChannelConfigurationsPages(input *ListSlackChannelConfigurationsInput, fn func(*ListSlackChannelConfigurationsOutput, bool) bool) error {
	return c.ListSlackChannelConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSlackChannelConfigurationsPagesWithContext same as ListSlackChannelConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) ListSlackChannelConfigurationsPagesWithContext(ctx aws.Context, input *ListSlackChannelConfigurationsInput, fn func(*ListSlackChannelConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSlackChannelConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSlackChannelConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSlackChannelConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSlackWorkspaceConfigurations = "ListSlackWorkspaceConfigurations"

// ListSlackWorkspaceConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSlackWorkspaceConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSlackWorkspaceConfigurations for more information on using the ListSlackWorkspaceConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSlackWorkspaceConfigurationsRequest method.
//	req, resp := client.ListSlackWorkspaceConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackWorkspaceConfigurations
func (c *SupportApp) ListSlackWorkspaceConfigurationsRequest(input *ListSlackWorkspaceConfigurationsInput) (req *request.Request, output *ListSlackWorkspaceConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListSlackWorkspaceConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/control/list-slack-workspace-configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSlackWorkspaceConfigurationsInput{}
	}

	output = &ListSlackWorkspaceConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSlackWorkspaceConfigurations API operation for AWS Support App.
//
// Lists the Slack workspace configurations for an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation ListSlackWorkspaceConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/ListSlackWorkspaceConfigurations
func (c *SupportApp) ListSlackWorkspaceConfigurations(input *ListSlackWorkspaceConfigurationsInput) (*ListSlackWorkspaceConfigurationsOutput, error) {
	req, out := c.ListSlackWorkspaceConfigurationsRequest(input)
	return out, req.Send()
}

// ListSlackWorkspaceConfigurationsWithContext is the same as ListSlackWorkspaceConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSlackWorkspaceConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) ListSlackWorkspaceConfigurationsWithContext(ctx aws.Context, input *ListSlackWorkspaceConfigurationsInput, opts ...request.Option) (*ListSlackWorkspaceConfigurationsOutput, error) {
	req, out := c.ListSlackWorkspaceConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSlackWorkspaceConfigurationsPages iterates over the pages of a ListSlackWorkspaceConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSlackWorkspaceConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSlackWorkspaceConfigurations operation.
//	pageNum := 0
//	err := client.ListSlackWorkspaceConfigurationsPages(params,
//	    func(page *supportapp.ListSlackWorkspaceConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SupportApp) ListSlackWorkspaceConfigurationsPages(input *ListSlackWorkspaceConfigurationsInput, fn func(*ListSlackWorkspaceConfigurationsOutput, bool) bool) error {
	return c.ListSlackWorkspaceConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSlackWorkspaceConfigurationsPagesWithContext same as ListSlackWorkspaceConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) ListSlackWorkspaceConfigurationsPagesWithContext(ctx aws.Context, input *ListSlackWorkspaceConfigurationsInput, fn func(*ListSlackWorkspaceConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSlackWorkspaceConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSlackWorkspaceConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSlackWorkspaceConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAccountAlias = "PutAccountAlias"

// PutAccountAliasRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountAlias for more information on using the PutAccountAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccountAliasRequest method.
//	req, resp := client.PutAccountAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/PutAccountAlias
func (c *SupportApp) PutAccountAliasRequest(input *PutAccountAliasInput) (req *request.Request, output *PutAccountAliasOutput) {
	op := &request.Operation{
		Name:       opPutAccountAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/control/put-account-alias",
	}

	if input == nil {
		input = &PutAccountAliasInput{}
	}

	output = &PutAccountAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAccountAlias API operation for AWS Support App.
//
// Creates or updates an individual alias for each Amazon Web Services account
// ID. The alias appears in the Amazon Web Services Support App page of the
// Amazon Web Services Support Center. The alias also appears in Slack messages
// from the Amazon Web Services Support App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation PutAccountAlias for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ValidationException
//     Your request input doesn't meet the constraints that the Amazon Web Services
//     Support App specifies.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/PutAccountAlias
func (c *SupportApp) PutAccountAlias(input *PutAccountAliasInput) (*PutAccountAliasOutput, error) {
	req, out := c.PutAccountAliasRequest(input)
	return out, req.Send()
}

// PutAccountAliasWithContext is the same as PutAccountAlias with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) PutAccountAliasWithContext(ctx aws.Context, input *PutAccountAliasInput, opts ...request.Option) (*PutAccountAliasOutput, error) {
	req, out := c.PutAccountAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterSlackWorkspaceForOrganization = "RegisterSlackWorkspaceForOrganization"

// RegisterSlackWorkspaceForOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the RegisterSlackWorkspaceForOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterSlackWorkspaceForOrganization for more information on using the RegisterSlackWorkspaceForOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterSlackWorkspaceForOrganizationRequest method.
//	req, resp := client.RegisterSlackWorkspaceForOrganizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/RegisterSlackWorkspaceForOrganization
func (c *SupportApp) RegisterSlackWorkspaceForOrganizationRequest(input *RegisterSlackWorkspaceForOrganizationInput) (req *request.Request, output *RegisterSlackWorkspaceForOrganizationOutput) {
	op := &request.Operation{
		Name:       opRegisterSlackWorkspaceForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/control/register-slack-workspace-for-organization",
	}

	if input == nil {
		input = &RegisterSlackWorkspaceForOrganizationInput{}
	}

	output = &RegisterSlackWorkspaceForOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterSlackWorkspaceForOrganization API operation for AWS Support App.
//
// Registers a Slack workspace for your Amazon Web Services account. To call
// this API, your account must be part of an organization in Organizations.
//
// If you're the management account and you want to register Slack workspaces
// for your organization, you must complete the following tasks:
//
// Sign in to the Amazon Web Services Support Center (https://console.aws.amazon.com/support/app)
// and authorize the Slack workspaces where you want your organization to have
// access to. See Authorize a Slack workspace (https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html)
// in the Amazon Web Services Support User Guide.
//
// Call the RegisterSlackWorkspaceForOrganization API to authorize each Slack
// workspace for the organization.
//
// After the management account authorizes the Slack workspace, member accounts
// can call this API to authorize the same Slack workspace for their individual
// accounts. Member accounts don't need to authorize the Slack workspace manually
// through the Amazon Web Services Support Center (https://console.aws.amazon.com/support/app).
//
// To use the Amazon Web Services Support App, each account must then complete
// the following tasks:
//
//   - Create an Identity and Access Management (IAM) role with the required
//     permission. For more information, see Managing access to the Amazon Web
//     Services Support App (https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html).
//
//   - Configure a Slack channel to use the Amazon Web Services Support App
//     for support cases for that account. For more information, see Configuring
//     a Slack channel (https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation RegisterSlackWorkspaceForOrganization for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Your request has a conflict. For example, you might receive this error if
//     you try the following:
//
//   - Add, update, or delete a Slack channel configuration before you add
//     a Slack workspace to your Amazon Web Services account.
//
//   - Add a Slack channel configuration that already exists in your Amazon
//     Web Services account.
//
//   - Delete a Slack channel configuration for a live chat channel.
//
//   - Delete a Slack workspace from your Amazon Web Services account that
//     has an active live chat channel.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from an Amazon Web
//     Services account that doesn't belong to an organization.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from a member account,
//     but the management account hasn't registered that workspace yet for the
//     organization.
//
//   - ResourceNotFoundException
//     The specified resource is missing or doesn't exist, such as an account alias,
//     Slack channel configuration, or Slack workspace configuration.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ValidationException
//     Your request input doesn't meet the constraints that the Amazon Web Services
//     Support App specifies.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/RegisterSlackWorkspaceForOrganization
func (c *SupportApp) RegisterSlackWorkspaceForOrganization(input *RegisterSlackWorkspaceForOrganizationInput) (*RegisterSlackWorkspaceForOrganizationOutput, error) {
	req, out := c.RegisterSlackWorkspaceForOrganizationRequest(input)
	return out, req.Send()
}

// RegisterSlackWorkspaceForOrganizationWithContext is the same as RegisterSlackWorkspaceForOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterSlackWorkspaceForOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) RegisterSlackWorkspaceForOrganizationWithContext(ctx aws.Context, input *RegisterSlackWorkspaceForOrganizationInput, opts ...request.Option) (*RegisterSlackWorkspaceForOrganizationOutput, error) {
	req, out := c.RegisterSlackWorkspaceForOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSlackChannelConfiguration = "UpdateSlackChannelConfiguration"

// UpdateSlackChannelConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSlackChannelConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSlackChannelConfiguration for more information on using the UpdateSlackChannelConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSlackChannelConfigurationRequest method.
//	req, resp := client.UpdateSlackChannelConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/UpdateSlackChannelConfiguration
func (c *SupportApp) UpdateSlackChannelConfigurationRequest(input *UpdateSlackChannelConfigurationInput) (req *request.Request, output *UpdateSlackChannelConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateSlackChannelConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/control/update-slack-channel-configuration",
	}

	if input == nil {
		input = &UpdateSlackChannelConfigurationInput{}
	}

	output = &UpdateSlackChannelConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSlackChannelConfiguration API operation for AWS Support App.
//
// Updates the configuration for a Slack channel, such as case update notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Support App's
// API operation UpdateSlackChannelConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Your request has a conflict. For example, you might receive this error if
//     you try the following:
//
//   - Add, update, or delete a Slack channel configuration before you add
//     a Slack workspace to your Amazon Web Services account.
//
//   - Add a Slack channel configuration that already exists in your Amazon
//     Web Services account.
//
//   - Delete a Slack channel configuration for a live chat channel.
//
//   - Delete a Slack workspace from your Amazon Web Services account that
//     has an active live chat channel.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from an Amazon Web
//     Services account that doesn't belong to an organization.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from a member account,
//     but the management account hasn't registered that workspace yet for the
//     organization.
//
//   - ResourceNotFoundException
//     The specified resource is missing or doesn't exist, such as an account alias,
//     Slack channel configuration, or Slack workspace configuration.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
//   - InternalServerException
//     We can’t process your request right now because of a server issue. Try
//     again later.
//
//   - ValidationException
//     Your request input doesn't meet the constraints that the Amazon Web Services
//     Support App specifies.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/support-app-2021-08-20/UpdateSlackChannelConfiguration
func (c *SupportApp) UpdateSlackChannelConfiguration(input *UpdateSlackChannelConfigurationInput) (*UpdateSlackChannelConfigurationOutput, error) {
	req, out := c.UpdateSlackChannelConfigurationRequest(input)
	return out, req.Send()
}

// UpdateSlackChannelConfigurationWithContext is the same as UpdateSlackChannelConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSlackChannelConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SupportApp) UpdateSlackChannelConfigurationWithContext(ctx aws.Context, input *UpdateSlackChannelConfigurationInput, opts ...request.Option) (*UpdateSlackChannelConfigurationOutput, error) {
	req, out := c.UpdateSlackChannelConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient permission to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request has a conflict. For example, you might receive this error if
// you try the following:
//
//   - Add, update, or delete a Slack channel configuration before you add
//     a Slack workspace to your Amazon Web Services account.
//
//   - Add a Slack channel configuration that already exists in your Amazon
//     Web Services account.
//
//   - Delete a Slack channel configuration for a live chat channel.
//
//   - Delete a Slack workspace from your Amazon Web Services account that
//     has an active live chat channel.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from an Amazon Web
//     Services account that doesn't belong to an organization.
//
//   - Call the RegisterSlackWorkspaceForOrganization API from a member account,
//     but the management account hasn't registered that workspace yet for the
//     organization.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateSlackChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The channel ID in Slack. This ID identifies a channel within a Slack workspace.
	//
	// ChannelId is a required field
	ChannelId *string `locationName:"channelId" min:"1" type:"string" required:"true"`

	// The name of the Slack channel that you configure for the Amazon Web Services
	// Support App.
	ChannelName *string `locationName:"channelName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that you want to use to perform
	// operations on Amazon Web Services. For more information, see Managing access
	// to the Amazon Web Services Support App (https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html)
	// in the Amazon Web Services Support User Guide.
	//
	// ChannelRoleArn is a required field
	ChannelRoleArn *string `locationName:"channelRoleArn" min:"31" type:"string" required:"true"`

	// Whether you want to get notified when a support case has a new correspondence.
	NotifyOnAddCorrespondenceToCase *bool `locationName:"notifyOnAddCorrespondenceToCase" type:"boolean"`

	// The case severity for a support case that you want to receive notifications.
	//
	// If you specify high or all, you must specify true for at least one of the
	// following parameters:
	//
	//    * notifyOnAddCorrespondenceToCase
	//
	//    * notifyOnCreateOrReopenCase
	//
	//    * notifyOnResolveCase
	//
	// If you specify none, the following parameters must be null or false:
	//
	//    * notifyOnAddCorrespondenceToCase
	//
	//    * notifyOnCreateOrReopenCase
	//
	//    * notifyOnResolveCase
	//
	// If you don't specify these parameters in your request, they default to false.
	//
	// NotifyOnCaseSeverity is a required field
	NotifyOnCaseSeverity *string `locationName:"notifyOnCaseSeverity" type:"string" required:"true" enum:"NotificationSeverityLevel"`

	// Whether you want to get notified when a support case is created or reopened.
	NotifyOnCreateOrReopenCase *bool `locationName:"notifyOnCreateOrReopenCase" type:"boolean"`

	// Whether you want to get notified when a support case is resolved.
	NotifyOnResolveCase *bool `locationName:"notifyOnResolveCase" type:"boolean"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG.
	//
	// TeamId is a required field
	TeamId *string `locationName:"teamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSlackChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSlackChannelConfigurationInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ChannelRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelRoleArn"))
	}
	if s.ChannelRoleArn != nil && len(*s.ChannelRoleArn) < 31 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelRoleArn", 31))
	}
	if s.NotifyOnCaseSeverity == nil {
		invalidParams.Add(request.NewErrParamRequired("NotifyOnCaseSeverity"))
	}
	if s.TeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("TeamId"))
	}
	if s.TeamId != nil && len(*s.TeamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TeamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *CreateSlackChannelConfigurationInput) SetChannelId(v string) *CreateSlackChannelConfigurationInput {
	s.ChannelId = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateSlackChannelConfigurationInput) SetChannelName(v string) *CreateSlackChannelConfigurationInput {
	s.ChannelName = &v
	return s
}

// SetChannelRoleArn sets the ChannelRoleArn field's value.
func (s *CreateSlackChannelConfigurationInput) SetChannelRoleArn(v string) *CreateSlackChannelConfigurationInput {
	s.ChannelRoleArn = &v
	return s
}

// SetNotifyOnAddCorrespondenceToCase sets the NotifyOnAddCorrespondenceToCase field's value.
func (s *CreateSlackChannelConfigurationInput) SetNotifyOnAddCorrespondenceToCase(v bool) *CreateSlackChannelConfigurationInput {
	s.NotifyOnAddCorrespondenceToCase = &v
	return s
}

// SetNotifyOnCaseSeverity sets the NotifyOnCaseSeverity field's value.
func (s *CreateSlackChannelConfigurationInput) SetNotifyOnCaseSeverity(v string) *CreateSlackChannelConfigurationInput {
	s.NotifyOnCaseSeverity = &v
	return s
}

// SetNotifyOnCreateOrReopenCase sets the NotifyOnCreateOrReopenCase field's value.
func (s *CreateSlackChannelConfigurationInput) SetNotifyOnCreateOrReopenCase(v bool) *CreateSlackChannelConfigurationInput {
	s.NotifyOnCreateOrReopenCase = &v
	return s
}

// SetNotifyOnResolveCase sets the NotifyOnResolveCase field's value.
func (s *CreateSlackChannelConfigurationInput) SetNotifyOnResolveCase(v bool) *CreateSlackChannelConfigurationInput {
	s.NotifyOnResolveCase = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *CreateSlackChannelConfigurationInput) SetTeamId(v string) *CreateSlackChannelConfigurationInput {
	s.TeamId = &v
	return s
}

type CreateSlackChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlackChannelConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteAccountAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountAliasInput) GoString() string {
	return s.String()
}

type DeleteAccountAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountAliasOutput) GoString() string {
	return s.String()
}

type DeleteSlackChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The channel ID in Slack. This ID identifies a channel within a Slack workspace.
	//
	// ChannelId is a required field
	ChannelId *string `locationName:"channelId" min:"1" type:"string" required:"true"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG.
	//
	// TeamId is a required field
	TeamId *string `locationName:"teamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlackChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlackChannelConfigurationInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.TeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("TeamId"))
	}
	if s.TeamId != nil && len(*s.TeamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TeamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DeleteSlackChannelConfigurationInput) SetChannelId(v string) *DeleteSlackChannelConfigurationInput {
	s.ChannelId = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *DeleteSlackChannelConfigurationInput) SetTeamId(v string) *DeleteSlackChannelConfigurationInput {
	s.TeamId = &v
	return s
}

type DeleteSlackChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackChannelConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteSlackWorkspaceConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG.
	//
	// TeamId is a required field
	TeamId *string `locationName:"teamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlackWorkspaceConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlackWorkspaceConfigurationInput"}
	if s.TeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("TeamId"))
	}
	if s.TeamId != nil && len(*s.TeamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TeamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTeamId sets the TeamId field's value.
func (s *DeleteSlackWorkspaceConfigurationInput) SetTeamId(v string) *DeleteSlackWorkspaceConfigurationInput {
	s.TeamId = &v
	return s
}

type DeleteSlackWorkspaceConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlackWorkspaceConfigurationOutput) GoString() string {
	return s.String()
}

type GetAccountAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountAliasInput) GoString() string {
	return s.String()
}

type GetAccountAliasOutput struct {
	_ struct{} `type:"structure"`

	// An alias or short name for an Amazon Web Services account.
	AccountAlias *string `locationName:"accountAlias" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountAliasOutput) GoString() string {
	return s.String()
}

// SetAccountAlias sets the AccountAlias field's value.
func (s *GetAccountAliasOutput) SetAccountAlias(v string) *GetAccountAliasOutput {
	s.AccountAlias = &v
	return s
}

// We can’t process your request right now because of a server issue. Try
// again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListSlackChannelConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// If the results of a search are large, the API only returns a portion of the
	// results and includes a nextToken pagination token in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When the API returns the last set of results, the response doesn't
	// include a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSlackChannelConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSlackChannelConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSlackChannelConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSlackChannelConfigurationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListSlackChannelConfigurationsInput) SetNextToken(v string) *ListSlackChannelConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListSlackChannelConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The point where pagination should resume when the response returns only partial
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The configurations for a Slack channel.
	//
	// SlackChannelConfigurations is a required field
	SlackChannelConfigurations []*SlackChannelConfiguration `locationName:"slackChannelConfigurations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSlackChannelConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSlackChannelConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSlackChannelConfigurationsOutput) SetNextToken(v string) *ListSlackChannelConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetSlackChannelConfigurations sets the SlackChannelConfigurations field's value.
func (s *ListSlackChannelConfigurationsOutput) SetSlackChannelConfigurations(v []*SlackChannelConfiguration) *ListSlackChannelConfigurationsOutput {
	s.SlackChannelConfigurations = v
	return s
}

type ListSlackWorkspaceConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// If the results of a search are large, the API only returns a portion of the
	// results and includes a nextToken pagination token in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When the API returns the last set of results, the response doesn't
	// include a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSlackWorkspaceConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSlackWorkspaceConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSlackWorkspaceConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSlackWorkspaceConfigurationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListSlackWorkspaceConfigurationsInput) SetNextToken(v string) *ListSlackWorkspaceConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListSlackWorkspaceConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The point where pagination should resume when the response returns only partial
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The configurations for a Slack workspace.
	SlackWorkspaceConfigurations []*SlackWorkspaceConfiguration `locationName:"slackWorkspaceConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSlackWorkspaceConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSlackWorkspaceConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSlackWorkspaceConfigurationsOutput) SetNextToken(v string) *ListSlackWorkspaceConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetSlackWorkspaceConfigurations sets the SlackWorkspaceConfigurations field's value.
func (s *ListSlackWorkspaceConfigurationsOutput) SetSlackWorkspaceConfigurations(v []*SlackWorkspaceConfiguration) *ListSlackWorkspaceConfigurationsOutput {
	s.SlackWorkspaceConfigurations = v
	return s
}

type PutAccountAliasInput struct {
	_ struct{} `type:"structure"`

	// An alias or short name for an Amazon Web Services account.
	//
	// AccountAlias is a required field
	AccountAlias *string `locationName:"accountAlias" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccountAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccountAliasInput"}
	if s.AccountAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountAlias"))
	}
	if s.AccountAlias != nil && len(*s.AccountAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountAlias", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAlias sets the AccountAlias field's value.
func (s *PutAccountAliasInput) SetAccountAlias(v string) *PutAccountAliasInput {
	s.AccountAlias = &v
	return s
}

type PutAccountAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountAliasOutput) GoString() string {
	return s.String()
}

type RegisterSlackWorkspaceForOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG. Specify the Slack workspace that you want to use for your
	// organization.
	//
	// TeamId is a required field
	TeamId *string `locationName:"teamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterSlackWorkspaceForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterSlackWorkspaceForOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterSlackWorkspaceForOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterSlackWorkspaceForOrganizationInput"}
	if s.TeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("TeamId"))
	}
	if s.TeamId != nil && len(*s.TeamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TeamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTeamId sets the TeamId field's value.
func (s *RegisterSlackWorkspaceForOrganizationInput) SetTeamId(v string) *RegisterSlackWorkspaceForOrganizationInput {
	s.TeamId = &v
	return s
}

type RegisterSlackWorkspaceForOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// Whether the Amazon Web Services account is a management or member account
	// that's part of an organization in Organizations.
	AccountType *string `locationName:"accountType" type:"string" enum:"AccountType"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG.
	TeamId *string `locationName:"teamId" min:"1" type:"string"`

	// The name of the Slack workspace.
	TeamName *string `locationName:"teamName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterSlackWorkspaceForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterSlackWorkspaceForOrganizationOutput) GoString() string {
	return s.String()
}

// SetAccountType sets the AccountType field's value.
func (s *RegisterSlackWorkspaceForOrganizationOutput) SetAccountType(v string) *RegisterSlackWorkspaceForOrganizationOutput {
	s.AccountType = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *RegisterSlackWorkspaceForOrganizationOutput) SetTeamId(v string) *RegisterSlackWorkspaceForOrganizationOutput {
	s.TeamId = &v
	return s
}

// SetTeamName sets the TeamName field's value.
func (s *RegisterSlackWorkspaceForOrganizationOutput) SetTeamName(v string) *RegisterSlackWorkspaceForOrganizationOutput {
	s.TeamName = &v
	return s
}

// The specified resource is missing or doesn't exist, such as an account alias,
// Slack channel configuration, or Slack workspace configuration.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your Service Quotas request exceeds the quota for the service. For example,
// your Service Quotas request to Amazon Web Services Support App might exceed
// the maximum number of workspaces or channels per account, or the maximum
// number of accounts per Slack channel.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for a Slack channel that you added for your Amazon Web
// Services account.
type SlackChannelConfiguration struct {
	_ struct{} `type:"structure"`

	// The channel ID in Slack. This ID identifies a channel within a Slack workspace.
	//
	// ChannelId is a required field
	ChannelId *string `locationName:"channelId" min:"1" type:"string" required:"true"`

	// The name of the Slack channel that you configured with the Amazon Web Services
	// Support App for your Amazon Web Services account.
	ChannelName *string `locationName:"channelName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that you want to use to perform
	// operations on Amazon Web Services. For more information, see Managing access
	// to the Amazon Web Services Support App (https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html)
	// in the Amazon Web Services Support User Guide.
	ChannelRoleArn *string `locationName:"channelRoleArn" min:"31" type:"string"`

	// Whether you want to get notified when a support case has a new correspondence.
	NotifyOnAddCorrespondenceToCase *bool `locationName:"notifyOnAddCorrespondenceToCase" type:"boolean"`

	// The case severity for a support case that you want to receive notifications.
	NotifyOnCaseSeverity *string `locationName:"notifyOnCaseSeverity" type:"string" enum:"NotificationSeverityLevel"`

	// Whether you want to get notified when a support case is created or reopened.
	NotifyOnCreateOrReopenCase *bool `locationName:"notifyOnCreateOrReopenCase" type:"boolean"`

	// Whether you want to get notified when a support case is resolved.
	NotifyOnResolveCase *bool `locationName:"notifyOnResolveCase" type:"boolean"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG.
	//
	// TeamId is a required field
	TeamId *string `locationName:"teamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackChannelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackChannelConfiguration) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *SlackChannelConfiguration) SetChannelId(v string) *SlackChannelConfiguration {
	s.ChannelId = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *SlackChannelConfiguration) SetChannelName(v string) *SlackChannelConfiguration {
	s.ChannelName = &v
	return s
}

// SetChannelRoleArn sets the ChannelRoleArn field's value.
func (s *SlackChannelConfiguration) SetChannelRoleArn(v string) *SlackChannelConfiguration {
	s.ChannelRoleArn = &v
	return s
}

// SetNotifyOnAddCorrespondenceToCase sets the NotifyOnAddCorrespondenceToCase field's value.
func (s *SlackChannelConfiguration) SetNotifyOnAddCorrespondenceToCase(v bool) *SlackChannelConfiguration {
	s.NotifyOnAddCorrespondenceToCase = &v
	return s
}

// SetNotifyOnCaseSeverity sets the NotifyOnCaseSeverity field's value.
func (s *SlackChannelConfiguration) SetNotifyOnCaseSeverity(v string) *SlackChannelConfiguration {
	s.NotifyOnCaseSeverity = &v
	return s
}

// SetNotifyOnCreateOrReopenCase sets the NotifyOnCreateOrReopenCase field's value.
func (s *SlackChannelConfiguration) SetNotifyOnCreateOrReopenCase(v bool) *SlackChannelConfiguration {
	s.NotifyOnCreateOrReopenCase = &v
	return s
}

// SetNotifyOnResolveCase sets the NotifyOnResolveCase field's value.
func (s *SlackChannelConfiguration) SetNotifyOnResolveCase(v bool) *SlackChannelConfiguration {
	s.NotifyOnResolveCase = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *SlackChannelConfiguration) SetTeamId(v string) *SlackChannelConfiguration {
	s.TeamId = &v
	return s
}

// The configuration for a Slack workspace that you added to an Amazon Web Services
// account.
type SlackWorkspaceConfiguration struct {
	_ struct{} `type:"structure"`

	// Whether to allow member accounts to authorize Slack workspaces. Member accounts
	// must be part of an organization in Organizations.
	AllowOrganizationMemberAccount *bool `locationName:"allowOrganizationMemberAccount" type:"boolean"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG.
	//
	// TeamId is a required field
	TeamId *string `locationName:"teamId" min:"1" type:"string" required:"true"`

	// The name of the Slack workspace.
	TeamName *string `locationName:"teamName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackWorkspaceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlackWorkspaceConfiguration) GoString() string {
	return s.String()
}

// SetAllowOrganizationMemberAccount sets the AllowOrganizationMemberAccount field's value.
func (s *SlackWorkspaceConfiguration) SetAllowOrganizationMemberAccount(v bool) *SlackWorkspaceConfiguration {
	s.AllowOrganizationMemberAccount = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *SlackWorkspaceConfiguration) SetTeamId(v string) *SlackWorkspaceConfiguration {
	s.TeamId = &v
	return s
}

// SetTeamName sets the TeamName field's value.
func (s *SlackWorkspaceConfiguration) SetTeamName(v string) *SlackWorkspaceConfiguration {
	s.TeamName = &v
	return s
}

type UpdateSlackChannelConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The channel ID in Slack. This ID identifies a channel within a Slack workspace.
	//
	// ChannelId is a required field
	ChannelId *string `locationName:"channelId" min:"1" type:"string" required:"true"`

	// The Slack channel name that you want to update.
	ChannelName *string `locationName:"channelName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that you want to use to perform
	// operations on Amazon Web Services. For more information, see Managing access
	// to the Amazon Web Services Support App (https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html)
	// in the Amazon Web Services Support User Guide.
	ChannelRoleArn *string `locationName:"channelRoleArn" min:"31" type:"string"`

	// Whether you want to get notified when a support case has a new correspondence.
	NotifyOnAddCorrespondenceToCase *bool `locationName:"notifyOnAddCorrespondenceToCase" type:"boolean"`

	// The case severity for a support case that you want to receive notifications.
	//
	// If you specify high or all, at least one of the following parameters must
	// be true:
	//
	//    * notifyOnAddCorrespondenceToCase
	//
	//    * notifyOnCreateOrReopenCase
	//
	//    * notifyOnResolveCase
	//
	// If you specify none, any of the following parameters that you specify in
	// your request must be false:
	//
	//    * notifyOnAddCorrespondenceToCase
	//
	//    * notifyOnCreateOrReopenCase
	//
	//    * notifyOnResolveCase
	//
	// If you don't specify these parameters in your request, the Amazon Web Services
	// Support App uses the current values by default.
	NotifyOnCaseSeverity *string `locationName:"notifyOnCaseSeverity" type:"string" enum:"NotificationSeverityLevel"`

	// Whether you want to get notified when a support case is created or reopened.
	NotifyOnCreateOrReopenCase *bool `locationName:"notifyOnCreateOrReopenCase" type:"boolean"`

	// Whether you want to get notified when a support case is resolved.
	NotifyOnResolveCase *bool `locationName:"notifyOnResolveCase" type:"boolean"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG.
	//
	// TeamId is a required field
	TeamId *string `locationName:"teamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSlackChannelConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSlackChannelConfigurationInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ChannelRoleArn != nil && len(*s.ChannelRoleArn) < 31 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelRoleArn", 31))
	}
	if s.TeamId == nil {
		invalidParams.Add(request.NewErrParamRequired("TeamId"))
	}
	if s.TeamId != nil && len(*s.TeamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TeamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *UpdateSlackChannelConfigurationInput) SetChannelId(v string) *UpdateSlackChannelConfigurationInput {
	s.ChannelId = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateSlackChannelConfigurationInput) SetChannelName(v string) *UpdateSlackChannelConfigurationInput {
	s.ChannelName = &v
	return s
}

// SetChannelRoleArn sets the ChannelRoleArn field's value.
func (s *UpdateSlackChannelConfigurationInput) SetChannelRoleArn(v string) *UpdateSlackChannelConfigurationInput {
	s.ChannelRoleArn = &v
	return s
}

// SetNotifyOnAddCorrespondenceToCase sets the NotifyOnAddCorrespondenceToCase field's value.
func (s *UpdateSlackChannelConfigurationInput) SetNotifyOnAddCorrespondenceToCase(v bool) *UpdateSlackChannelConfigurationInput {
	s.NotifyOnAddCorrespondenceToCase = &v
	return s
}

// SetNotifyOnCaseSeverity sets the NotifyOnCaseSeverity field's value.
func (s *UpdateSlackChannelConfigurationInput) SetNotifyOnCaseSeverity(v string) *UpdateSlackChannelConfigurationInput {
	s.NotifyOnCaseSeverity = &v
	return s
}

// SetNotifyOnCreateOrReopenCase sets the NotifyOnCreateOrReopenCase field's value.
func (s *UpdateSlackChannelConfigurationInput) SetNotifyOnCreateOrReopenCase(v bool) *UpdateSlackChannelConfigurationInput {
	s.NotifyOnCreateOrReopenCase = &v
	return s
}

// SetNotifyOnResolveCase sets the NotifyOnResolveCase field's value.
func (s *UpdateSlackChannelConfigurationInput) SetNotifyOnResolveCase(v bool) *UpdateSlackChannelConfigurationInput {
	s.NotifyOnResolveCase = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *UpdateSlackChannelConfigurationInput) SetTeamId(v string) *UpdateSlackChannelConfigurationInput {
	s.TeamId = &v
	return s
}

type UpdateSlackChannelConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The channel ID in Slack. This ID identifies a channel within a Slack workspace.
	ChannelId *string `locationName:"channelId" min:"1" type:"string"`

	// The name of the Slack channel that you configure for the Amazon Web Services
	// Support App.
	ChannelName *string `locationName:"channelName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that you want to use to perform
	// operations on Amazon Web Services. For more information, see Managing access
	// to the Amazon Web Services Support App (https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html)
	// in the Amazon Web Services Support User Guide.
	ChannelRoleArn *string `locationName:"channelRoleArn" min:"31" type:"string"`

	// Whether you want to get notified when a support case has a new correspondence.
	NotifyOnAddCorrespondenceToCase *bool `locationName:"notifyOnAddCorrespondenceToCase" type:"boolean"`

	// The case severity for a support case that you want to receive notifications.
	NotifyOnCaseSeverity *string `locationName:"notifyOnCaseSeverity" type:"string" enum:"NotificationSeverityLevel"`

	// Whether you want to get notified when a support case is created or reopened.
	NotifyOnCreateOrReopenCase *bool `locationName:"notifyOnCreateOrReopenCase" type:"boolean"`

	// Whether you want to get notified when a support case is resolved.
	NotifyOnResolveCase *bool `locationName:"notifyOnResolveCase" type:"boolean"`

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such
	// as T012ABCDEFG.
	TeamId *string `locationName:"teamId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSlackChannelConfigurationOutput) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetChannelId(v string) *UpdateSlackChannelConfigurationOutput {
	s.ChannelId = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetChannelName(v string) *UpdateSlackChannelConfigurationOutput {
	s.ChannelName = &v
	return s
}

// SetChannelRoleArn sets the ChannelRoleArn field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetChannelRoleArn(v string) *UpdateSlackChannelConfigurationOutput {
	s.ChannelRoleArn = &v
	return s
}

// SetNotifyOnAddCorrespondenceToCase sets the NotifyOnAddCorrespondenceToCase field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetNotifyOnAddCorrespondenceToCase(v bool) *UpdateSlackChannelConfigurationOutput {
	s.NotifyOnAddCorrespondenceToCase = &v
	return s
}

// SetNotifyOnCaseSeverity sets the NotifyOnCaseSeverity field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetNotifyOnCaseSeverity(v string) *UpdateSlackChannelConfigurationOutput {
	s.NotifyOnCaseSeverity = &v
	return s
}

// SetNotifyOnCreateOrReopenCase sets the NotifyOnCreateOrReopenCase field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetNotifyOnCreateOrReopenCase(v bool) *UpdateSlackChannelConfigurationOutput {
	s.NotifyOnCreateOrReopenCase = &v
	return s
}

// SetNotifyOnResolveCase sets the NotifyOnResolveCase field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetNotifyOnResolveCase(v bool) *UpdateSlackChannelConfigurationOutput {
	s.NotifyOnResolveCase = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *UpdateSlackChannelConfigurationOutput) SetTeamId(v string) *UpdateSlackChannelConfigurationOutput {
	s.TeamId = &v
	return s
}

// Your request input doesn't meet the constraints that the Amazon Web Services
// Support App specifies.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AccountTypeManagement is a AccountType enum value
	AccountTypeManagement = "management"

	// AccountTypeMember is a AccountType enum value
	AccountTypeMember = "member"
)

// AccountType_Values returns all elements of the AccountType enum
func AccountType_Values() []string {
	return []string{
		AccountTypeManagement,
		AccountTypeMember,
	}
}

const (
	// NotificationSeverityLevelNone is a NotificationSeverityLevel enum value
	NotificationSeverityLevelNone = "none"

	// NotificationSeverityLevelAll is a NotificationSeverityLevel enum value
	NotificationSeverityLevelAll = "all"

	// NotificationSeverityLevelHigh is a NotificationSeverityLevel enum value
	NotificationSeverityLevelHigh = "high"
)

// NotificationSeverityLevel_Values returns all elements of the NotificationSeverityLevel enum
func NotificationSeverityLevel_Values() []string {
	return []string{
		NotificationSeverityLevelNone,
		NotificationSeverityLevelAll,
		NotificationSeverityLevelHigh,
	}
}
