package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDialogMessages invokes the sas.DescribeDialogMessages API synchronously
func (client *Client) DescribeDialogMessages(request *DescribeDialogMessagesRequest) (response *DescribeDialogMessagesResponse, err error) {
	response = CreateDescribeDialogMessagesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDialogMessagesWithChan invokes the sas.DescribeDialogMessages API asynchronously
func (client *Client) DescribeDialogMessagesWithChan(request *DescribeDialogMessagesRequest) (<-chan *DescribeDialogMessagesResponse, <-chan error) {
	responseChan := make(chan *DescribeDialogMessagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDialogMessages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDialogMessagesWithCallback invokes the sas.DescribeDialogMessages API asynchronously
func (client *Client) DescribeDialogMessagesWithCallback(request *DescribeDialogMessagesRequest, callback func(response *DescribeDialogMessagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDialogMessagesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDialogMessages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDialogMessagesRequest is the request struct for api DescribeDialogMessages
type DescribeDialogMessagesRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeDialogMessagesResponse is the response struct for api DescribeDialogMessages
type DescribeDialogMessagesResponse struct {
	*responses.BaseResponse
	RequestId  string                  `json:"RequestId" xml:"RequestId"`
	TotalCount int                     `json:"TotalCount" xml:"TotalCount"`
	DialogList []AegisDynamicDialogDTO `json:"DialogList" xml:"DialogList"`
}

// CreateDescribeDialogMessagesRequest creates a request to invoke DescribeDialogMessages API
func CreateDescribeDialogMessagesRequest() (request *DescribeDialogMessagesRequest) {
	request = &DescribeDialogMessagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeDialogMessages", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDialogMessagesResponse creates a response to parse from DescribeDialogMessages response
func CreateDescribeDialogMessagesResponse() (response *DescribeDialogMessagesResponse) {
	response = &DescribeDialogMessagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
