package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDelegatedServicesForAccount invokes the resourcemanager.ListDelegatedServicesForAccount API synchronously
func (client *Client) ListDelegatedServicesForAccount(request *ListDelegatedServicesForAccountRequest) (response *ListDelegatedServicesForAccountResponse, err error) {
	response = CreateListDelegatedServicesForAccountResponse()
	err = client.DoAction(request, response)
	return
}

// ListDelegatedServicesForAccountWithChan invokes the resourcemanager.ListDelegatedServicesForAccount API asynchronously
func (client *Client) ListDelegatedServicesForAccountWithChan(request *ListDelegatedServicesForAccountRequest) (<-chan *ListDelegatedServicesForAccountResponse, <-chan error) {
	responseChan := make(chan *ListDelegatedServicesForAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDelegatedServicesForAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDelegatedServicesForAccountWithCallback invokes the resourcemanager.ListDelegatedServicesForAccount API asynchronously
func (client *Client) ListDelegatedServicesForAccountWithCallback(request *ListDelegatedServicesForAccountRequest, callback func(response *ListDelegatedServicesForAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDelegatedServicesForAccountResponse
		var err error
		defer close(result)
		response, err = client.ListDelegatedServicesForAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDelegatedServicesForAccountRequest is the request struct for api ListDelegatedServicesForAccount
type ListDelegatedServicesForAccountRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// ListDelegatedServicesForAccountResponse is the response struct for api ListDelegatedServicesForAccount
type ListDelegatedServicesForAccountResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	DelegatedServices DelegatedServices `json:"DelegatedServices" xml:"DelegatedServices"`
}

// CreateListDelegatedServicesForAccountRequest creates a request to invoke ListDelegatedServicesForAccount API
func CreateListDelegatedServicesForAccountRequest() (request *ListDelegatedServicesForAccountRequest) {
	request = &ListDelegatedServicesForAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ListDelegatedServicesForAccount", "", "")
	request.Method = requests.POST
	return
}

// CreateListDelegatedServicesForAccountResponse creates a response to parse from ListDelegatedServicesForAccount response
func CreateListDelegatedServicesForAccountResponse() (response *ListDelegatedServicesForAccountResponse) {
	response = &ListDelegatedServicesForAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
