package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceLog invokes the eas.DeleteResourceLog API synchronously
func (client *Client) DeleteResourceLog(request *DeleteResourceLogRequest) (response *DeleteResourceLogResponse, err error) {
	response = CreateDeleteResourceLogResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceLogWithChan invokes the eas.DeleteResourceLog API asynchronously
func (client *Client) DeleteResourceLogWithChan(request *DeleteResourceLogRequest) (<-chan *DeleteResourceLogResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceLogWithCallback invokes the eas.DeleteResourceLog API asynchronously
func (client *Client) DeleteResourceLogWithCallback(request *DeleteResourceLogRequest, callback func(response *DeleteResourceLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceLogResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceLogRequest is the request struct for api DeleteResourceLog
type DeleteResourceLogRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	ClusterId  string `position:"Path" name:"ClusterId"`
}

// DeleteResourceLogResponse is the response struct for api DeleteResourceLog
type DeleteResourceLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteResourceLogRequest creates a request to invoke DeleteResourceLog API
func CreateDeleteResourceLogRequest() (request *DeleteResourceLogRequest) {
	request = &DeleteResourceLogRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DeleteResourceLog", "/api/v2/resources/[ClusterId]/[ResourceId]/log", "eas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteResourceLogResponse creates a response to parse from DeleteResourceLog response
func CreateDeleteResourceLogResponse() (response *DeleteResourceLogResponse) {
	response = &DeleteResourceLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
