package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDISyncTask invokes the dataworks_public.DeleteDISyncTask API synchronously
func (client *Client) DeleteDISyncTask(request *DeleteDISyncTaskRequest) (response *DeleteDISyncTaskResponse, err error) {
	response = CreateDeleteDISyncTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDISyncTaskWithChan invokes the dataworks_public.DeleteDISyncTask API asynchronously
func (client *Client) DeleteDISyncTaskWithChan(request *DeleteDISyncTaskRequest) (<-chan *DeleteDISyncTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteDISyncTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDISyncTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDISyncTaskWithCallback invokes the dataworks_public.DeleteDISyncTask API asynchronously
func (client *Client) DeleteDISyncTaskWithCallback(request *DeleteDISyncTaskRequest, callback func(response *DeleteDISyncTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDISyncTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteDISyncTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDISyncTaskRequest is the request struct for api DeleteDISyncTask
type DeleteDISyncTaskRequest struct {
	*requests.RpcRequest
	TaskType  string           `position:"Query" name:"TaskType"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
	FileId    requests.Integer `position:"Query" name:"FileId"`
}

// DeleteDISyncTaskResponse is the response struct for api DeleteDISyncTask
type DeleteDISyncTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteDISyncTaskRequest creates a request to invoke DeleteDISyncTask API
func CreateDeleteDISyncTaskRequest() (request *DeleteDISyncTaskRequest) {
	request = &DeleteDISyncTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteDISyncTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDISyncTaskResponse creates a response to parse from DeleteDISyncTask response
func CreateDeleteDISyncTaskResponse() (response *DeleteDISyncTaskResponse) {
	response = &DeleteDISyncTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
