package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAgentData invokes the cloudcallcenter.ListAgentData API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listagentdata.html
func (client *Client) ListAgentData(request *ListAgentDataRequest) (response *ListAgentDataResponse, err error) {
	response = CreateListAgentDataResponse()
	err = client.DoAction(request, response)
	return
}

// ListAgentDataWithChan invokes the cloudcallcenter.ListAgentData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listagentdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAgentDataWithChan(request *ListAgentDataRequest) (<-chan *ListAgentDataResponse, <-chan error) {
	responseChan := make(chan *ListAgentDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAgentData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAgentDataWithCallback invokes the cloudcallcenter.ListAgentData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listagentdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAgentDataWithCallback(request *ListAgentDataRequest, callback func(response *ListAgentDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAgentDataResponse
		var err error
		defer close(result)
		response, err = client.ListAgentData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAgentDataRequest is the request struct for api ListAgentData
type ListAgentDataRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	StartDay   string           `position:"Query" name:"StartDay"`
	EndDay     string           `position:"Query" name:"EndDay"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListAgentDataResponse is the response struct for api ListAgentData
type ListAgentDataResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DataList       DataList `json:"DataList" xml:"DataList"`
}

// CreateListAgentDataRequest creates a request to invoke ListAgentData API
func CreateListAgentDataRequest() (request *ListAgentDataRequest) {
	request = &ListAgentDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListAgentData", "", "")
	request.Method = requests.POST
	return
}

// CreateListAgentDataResponse creates a response to parse from ListAgentData response
func CreateListAgentDataResponse() (response *ListAgentDataResponse) {
	response = &ListAgentDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
