//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlattributestridestatic?language=objc)
pub static MTLAttributeStrideStatic: NSUInteger = NSUIntegerMax as _;

extern_protocol!(
    /// MTLArgumentEncoder encodes buffer, texture, sampler, and constant data into a buffer.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlargumentencoder?language=objc)
    pub unsafe trait MTLArgumentEncoder: NSObjectProtocol {
        #[cfg(feature = "MTLDevice")]
        /// The device this argument encoder was created against.
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        unsafe fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        unsafe fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        unsafe fn setLabel(&self, label: Option<&NSString>);

        /// The number of bytes required to store the encoded resource bindings.
        #[unsafe(method(encodedLength))]
        #[unsafe(method_family = none)]
        fn encodedLength(&self) -> NSUInteger;

        /// The alignment in bytes required to store the encoded resource bindings.
        #[unsafe(method(alignment))]
        #[unsafe(method_family = none)]
        fn alignment(&self) -> NSUInteger;

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Sets the destination buffer and offset at which the arguments will be encoded.
        #[unsafe(method(setArgumentBuffer:offset:))]
        #[unsafe(method_family = none)]
        unsafe fn setArgumentBuffer_offset(
            &self,
            argument_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Sets the destination buffer, starting offset and specific array element arguments will be encoded into. arrayElement represents
        /// the desired element of IAB array targetted by encoding
        #[unsafe(method(setArgumentBuffer:startOffset:arrayElement:))]
        #[unsafe(method_family = none)]
        unsafe fn setArgumentBuffer_startOffset_arrayElement(
            &self,
            argument_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            start_offset: NSUInteger,
            array_element: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set a buffer at the given bind point index.
        #[unsafe(method(setBuffer:offset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setBuffer_offset_atIndex(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set an array of buffers at the given bind point index range.
        #[unsafe(method(setBuffers:offsets:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setBuffers_offsets_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set a texture at the given bind point index.
        #[unsafe(method(setTexture:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTexture_atIndex(
            &self,
            texture: Option<&ProtocolObject<dyn MTLTexture>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set an array of textures at the given bind point index range.
        #[unsafe(method(setTextures:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setTextures_withRange(
            &self,
            textures: NonNull<*const ProtocolObject<dyn MTLTexture>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a sampler at the given bind point index.
        #[unsafe(method(setSamplerState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setSamplerState_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of samplers at the given bind point index range.
        #[unsafe(method(setSamplerStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setSamplerStates_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            range: NSRange,
        );

        /// Returns a pointer to the constant data at the given bind point index.
        #[unsafe(method(constantDataAtIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn constantDataAtIndex(&self, index: NSUInteger) -> NonNull<c_void>;

        #[cfg(feature = "MTLRenderPipeline")]
        /// Sets a render pipeline state at a given bind point index
        #[unsafe(method(setRenderPipelineState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setRenderPipelineState_atIndex(
            &self,
            pipeline: Option<&ProtocolObject<dyn MTLRenderPipelineState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLRenderPipeline")]
        /// Set an array of render pipeline states at a given bind point index range
        #[unsafe(method(setRenderPipelineStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setRenderPipelineStates_withRange(
            &self,
            pipelines: NonNull<*const ProtocolObject<dyn MTLRenderPipelineState>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLComputePipeline")]
        /// Sets a compute pipeline state at a given bind point index
        #[unsafe(method(setComputePipelineState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setComputePipelineState_atIndex(
            &self,
            pipeline: Option<&ProtocolObject<dyn MTLComputePipelineState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLComputePipeline")]
        /// Set an array of compute pipeline states at a given bind point index range
        #[unsafe(method(setComputePipelineStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setComputePipelineStates_withRange(
            &self,
            pipelines: NonNull<*const ProtocolObject<dyn MTLComputePipelineState>>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// Sets an indirect command buffer at a given bind point index
        #[unsafe(method(setIndirectCommandBuffer:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setIndirectCommandBuffer_atIndex(
            &self,
            indirect_command_buffer: Option<&ProtocolObject<dyn MTLIndirectCommandBuffer>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// Set an array of indirect command buffers at the given bind point index range.
        #[unsafe(method(setIndirectCommandBuffers:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setIndirectCommandBuffers_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLIndirectCommandBuffer>>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLResource"
        ))]
        #[unsafe(method(setAccelerationStructure:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccelerationStructure_atIndex(
            &self,
            acceleration_structure: Option<&ProtocolObject<dyn MTLAccelerationStructure>>,
            index: NSUInteger,
        );

        /// Returns a pointer to a new MTLArgumentEncoder that can be used to encode the an argument buffer
        /// in the buffer associated with a given index.
        /// Returns nil if the resource at the given index is not an argument buffer.
        #[unsafe(method(newArgumentEncoderForBufferAtIndex:))]
        #[unsafe(method_family = new)]
        unsafe fn newArgumentEncoderForBufferAtIndex(
            &self,
            index: NSUInteger,
        ) -> Option<Retained<ProtocolObject<dyn MTLArgumentEncoder>>>;

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set a visible function table at the given buffer index
        #[unsafe(method(setVisibleFunctionTable:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVisibleFunctionTable_atIndex(
            &self,
            visible_function_table: Option<&ProtocolObject<dyn MTLVisibleFunctionTable>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set visible function tables at the given buffer index range
        #[unsafe(method(setVisibleFunctionTables:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVisibleFunctionTables_withRange(
            &self,
            visible_function_tables: NonNull<*const ProtocolObject<dyn MTLVisibleFunctionTable>>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set an intersection function table at the given buffer index
        #[unsafe(method(setIntersectionFunctionTable:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setIntersectionFunctionTable_atIndex(
            &self,
            intersection_function_table: Option<&ProtocolObject<dyn MTLIntersectionFunctionTable>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set intersection function tables at the given buffer index range
        #[unsafe(method(setIntersectionFunctionTables:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setIntersectionFunctionTables_withRange(
            &self,
            intersection_function_tables: NonNull<
                *const ProtocolObject<dyn MTLIntersectionFunctionTable>,
            >,
            range: NSRange,
        );
    }
);
