/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.schema;

import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

import javax.xml.validation.SchemaFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

import static java.util.Comparator.comparing;
import static javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI;

public class SchemaTests {

	private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);

	@ParameterizedTest
	@MethodSource("schemas")
	void shouldBeValidXmlSchema(Path xsdFile) throws Exception {
		SCHEMA_FACTORY.newSchema(xsdFile.toFile());
	}

	@SuppressWarnings("resource") // JUnit will close the stream
	static Stream<Named<Path>> schemas() throws IOException {
		return Files.list(Path.of("src/main/resources/org/opentest4j/reporting/schema")) //
				.filter(path -> path.toString().endsWith(".xsd")) //
				.map(file -> Named.of(file.getFileName().toString(), file)) //
				.sorted(comparing(Named::getName));
	}

}
