<!--- This file is autogenerated. Do not edit manually! -->
# <code>[pixi](../../../pixi.md) [workspace](../../workspace.md) [channel](../channel.md) add</code>

## About
Adds a channel to the manifest and updates the lockfile

--8<-- "docs/reference/cli/pixi/workspace/channel/add_extender:description"

## Usage
```
pixi workspace channel add [OPTIONS] <CHANNEL>...
```

## Arguments
- <a id="arg-<CHANNEL>" href="#arg-<CHANNEL>">`<CHANNEL>`</a>
:  The channel name or URL
<br>May be provided more than once.
<br>**required**: `true`

## Options
- <a id="arg---priority" href="#arg---priority">`--priority <PRIORITY>`</a>
:  Specify the channel priority
- <a id="arg---prepend" href="#arg---prepend">`--prepend`</a>
:  Add the channel(s) to the beginning of the channels list, making them the highest priority
- <a id="arg---feature" href="#arg---feature">`--feature (-f) <FEATURE>`</a>
:  The name of the feature to modify

## Config Options
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`

## Update Options
- <a id="arg---no-install" href="#arg---no-install">`--no-install`</a>
:  Don't modify the environment, only modify the lock-file
- <a id="arg---revalidate" href="#arg---revalidate">`--revalidate`</a>
:  Run the complete environment validation. This will reinstall a broken environment
- <a id="arg---no-lockfile-update" href="#arg---no-lockfile-update">`--no-lockfile-update`</a>
:  Don't update lockfile, implies the no-install as well
- <a id="arg---frozen" href="#arg---frozen">`--frozen`</a>
:  Install the environment as defined in the lockfile, doesn't update lockfile if it isn't up-to-date with the manifest file
<br>**env**: `PIXI_FROZEN`
- <a id="arg---locked" href="#arg---locked">`--locked`</a>
:  Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn't up-to-date with the manifest file
<br>**env**: `PIXI_LOCKED`

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

--8<-- "docs/reference/cli/pixi/workspace/channel/add_extender:example"
