<!--- This file is autogenerated. Do not edit manually! -->
# <code>[pixi](../../pixi.md) [global](../global.md) list</code>

## About
Lists all packages previously installed into a globally accessible location via `pixi global install`.

--8<-- "docs/reference/cli/pixi/global/list_extender:description"

## Usage
```
pixi global list [OPTIONS] [REGEX]
```

## Arguments
- <a id="arg-<REGEX>" href="#arg-<REGEX>">`<REGEX>`</a>
:  List only packages matching a regular expression. Without regex syntax it acts like a `contains` filter

## Options
- <a id="arg---environment" href="#arg---environment">`--environment (-e) <ENVIRONMENT>`</a>
:  The name of the environment to list
- <a id="arg---sort-by" href="#arg---sort-by">`--sort-by <SORT_BY>`</a>
:  Sorting strategy for the package table of an environment
<br>**default**: `name`
<br>**options**: `size`, `name`

## Config Options
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`

## Description
Lists all packages previously installed into a globally accessible location via `pixi global install`.

All environments:

- Yellow: the binaries that are exposed.
- Green: the packages that are explicit dependencies of the environment.
- Blue: the version of the installed package.
- Cyan: the name of the environment.

Per environment:

- Green: packages that are explicitly installed.


--8<-- "docs/reference/cli/pixi/global/list_extender:example"
