// Copyright (c) Facebook, Inc. and its affiliates.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package schema

// Vulnerability struct
type Vulnerability struct {
	ThreatScape            []string `json:"ThreatScape"`
	AttackingEase          string   `json:"attackingEase"`
	Audience               []string `json:"audience"`
	CPE                    string   `json:"cpe"`
	CVEIds                 []string `json:"cveIds"`
	CVEOriginalReleaseDate int64    `json:"cveOriginalReleaseDate"`
	CvssBaseScore          string   `json:"cvssBaseScore"`
	CvssBaseScoreLink      string   `json:"cvssBaseScoreLink"`
	CvssBaseVector         string   `json:"cvssBaseVector"`
	CvssTemporalScore      string   `json:"cvssTemporalScore"`
	CvssTemporalScoreLink  string   `json:"cvssTemporalScoreLink"`
	CvssTemporalVector     string   `json:"cvssTemporalVector"`
	ExploitInTheWild       bool     `json:"exploitInTheWild"`
	ExploitRating          string   `json:"exploitRating"`
	IntelligenceType       string   `json:"intelligenceType"`
	Mitigations            []string `json:"mitigations"`
	PublishDate            int64    `json:"publishDate"`
	ReportID               string   `json:"reportId"`
	ReportLink             string   `json:"reportLink"`
	RiskRating             string   `json:"riskRating"`
	Title                  string   `json:"title"`
	Version                string   `json:"version"`
	Version1PublishDate    int64    `json:"version1PublishDate"`
	WebLink                string   `json:"webLink"`
}
