/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.prompt;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptFormatter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DefaultPromptFormatter
implements AIPromptFormatter {
    @Override
    @NotNull
    public String postProcessGeneratedQuery(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer mainObject, @NotNull DBCExecutionContext executionContext, @NotNull String completionText) {
        return completionText;
    }

    @Override
    @NotNull
    public List<String> getExtraInstructions() {
        return List.of();
    }

    @Override
    public void addExtraDescription(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity object, @NotNull StringBuilder description, @NotNull DBPObjectWithDescription lastAttr) throws DBException {
    }

    @Override
    public void addObjectDescriptionIfNeeded(@NotNull StringBuilder description, @NotNull DBPObjectWithDescription object, @NotNull DBRProgressMonitor monitor) {
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.description") && !CommonUtils.isEmptyTrimmed((String)object.getDescription())) {
            boolean attribute = object instanceof DBSEntityAttribute;
            String objectComment = object.getDescription().replace("\n", attribute ? "\n\t" : "\n");
            if (attribute) {
                description.append(" ");
            }
            description.append("-- ").append(objectComment);
            if (!attribute) {
                description.append("\n");
            }
        }
    }

    @Override
    public void addColumnTypeIfNeeded(@NotNull StringBuilder description, @NotNull DBSEntityAttribute attribute, @NotNull DBRProgressMonitor monitor) {
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.sendType")) {
            description.append(" ").append(attribute.getTypeName());
        }
    }

    @Override
    public void addDataSample(@NotNull DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull StringBuilder description) throws DBException {
    }

    @Override
    public boolean isDataSampleNeeded() {
        return false;
    }
}

