/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class VariablesHintLabel {
    private final String[][] variables;
    private final Control infoLabel;
    private IVariableResolver resolver;

    public VariablesHintLabel(Composite parent, String hintLabel, String hintTitle, String[][] vars) {
        this(parent, hintLabel, hintTitle, vars, true);
    }

    public VariablesHintLabel(Composite parent, String hintLabel, String hintTitle, String[][] vars, boolean stretch) {
        this.variables = vars;
        String varsText = GeneralUtils.generateVariablesLegend((String[][])vars);
        Layout layout = parent.getLayout();
        GridData gd = new GridData(768);
        if (stretch && layout instanceof GridLayout) {
            gd.horizontalSpan = ((GridLayout)layout).numColumns;
        }
        this.infoLabel = UIUtils.createInfoLabel(parent, hintLabel, () -> {
            if (this.resolver != null) {
                VariableListDialog dialog = new VariableListDialog(parent.getShell(), hintTitle);
                dialog.open();
            } else {
                EditTextDialog dialog = new EditTextDialog(parent.getShell(), hintTitle, varsText, true);
                dialog.setMonospaceFont(true);
                dialog.setAutoSize(true);
                dialog.open();
            }
        });
        this.infoLabel.setLayoutData((Object)gd);
        this.infoLabel.setToolTipText(varsText);
    }

    public Control getInfoLabel() {
        return this.infoLabel;
    }

    public void setResolver(IVariableResolver resolver) {
        this.resolver = resolver;
    }

    class VariableListDialog
    extends BaseDialog {
        VariableListDialog(Shell parentShell, String title) {
            super(parentShell, title, null);
        }

        @Override
        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            Table table = new Table(composite, 67584);
            table.setHeaderVisible(true);
            table.setLayoutData((Object)new GridData(1808));
            UIUtils.createTableColumn(table, 16384, "Variable");
            UIUtils.createTableColumn(table, 16384, "Description");
            UIUtils.createTableColumn(table, 16384, "Value");
            String[][] stringArray = VariablesHintLabel.this.variables;
            int n = VariablesHintLabel.this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                String[] var = stringArray[n2];
                String varName = var[0];
                boolean isSecure = "password".equals(varName);
                TableItem item = new TableItem(table, 0);
                item.setText(0, GeneralUtils.variablePattern((String)varName));
                item.setText(1, var[1]);
                item.setText(2, isSecure ? "********" : CommonUtils.notEmpty((String)VariablesHintLabel.this.resolver.get(varName)));
                ++n2;
            }
            UIUtils.packColumns(table);
            UIWidgets.setControlContextMenu((Control)table, manager -> UIWidgets.fillDefaultTableContextMenu((IContributionManager)manager, table));
            new TableEditor(table);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }
}

