/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQuerySourcesInfoCollection;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.Pair;

public class SQLQueryRowsSourceContext {
    private static final Log log = Log.getLog(SQLQueryRowsSourceContext.class);
    @NotNull
    private final SQLQueryConnectionContext connectionInfo;
    private final boolean hasUnresolvedSource;
    @NotNull
    private final Map<SQLQueryComplexName, KnownRowsSourceInfo> rowsSources;
    @NotNull
    private final Map<String, KnownRowsSourceInfo> dynamicTableSources;
    @NotNull
    private final Map<String, KnownRowsSourceInfo> sourcesByLoweredAlias;

    public SQLQueryRowsSourceContext(@NotNull SQLQueryConnectionContext connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.hasUnresolvedSource = false;
        this.rowsSources = Collections.emptyMap();
        this.dynamicTableSources = Collections.emptyMap();
        this.sourcesByLoweredAlias = Collections.emptyMap();
    }

    private SQLQueryRowsSourceContext(@NotNull SQLQueryConnectionContext connectionInfo, boolean hasUnresolvedSource, @NotNull Map<SQLQueryComplexName, KnownRowsSourceInfo> rowsSources, @NotNull Map<String, KnownRowsSourceInfo> dynamicTableSources, @NotNull Map<String, KnownRowsSourceInfo> sourcesByLoweredAlias) {
        this.connectionInfo = connectionInfo;
        this.hasUnresolvedSource = hasUnresolvedSource;
        this.rowsSources = rowsSources;
        this.dynamicTableSources = dynamicTableSources;
        this.sourcesByLoweredAlias = sourcesByLoweredAlias;
    }

    @NotNull
    public SQLDialect getDialect() {
        return this.connectionInfo.dialect;
    }

    @NotNull
    public SQLQueryConnectionContext getConnectionInfo() {
        return this.connectionInfo;
    }

    @NotNull
    public final SQLQueryRowsSourceContext reset() {
        return new SQLQueryRowsSourceContext(this.connectionInfo);
    }

    public boolean hasUnresolvedSource() {
        return this.hasUnresolvedSource;
    }

    @Nullable
    public KnownRowsSourceInfo findDynamicRowsSource(@NotNull SQLQueryComplexName name) {
        return name.getParts().size() == 1 ? this.dynamicTableSources.get(name.getParts().getFirst().toLowerCase()) : null;
    }

    @Nullable
    public KnownRowsSourceInfo findReferencedSource(@NotNull SQLQueryComplexName name) {
        KnownRowsSourceInfo result = null;
        SQLQueryComplexName namePart = name;
        while (namePart != null) {
            KnownRowsSourceInfo entry = this.rowsSources.get(namePart);
            if (entry != null) {
                result = entry;
                break;
            }
            namePart = namePart.trimEnd();
        }
        if (result == null && name.getParts().size() == 1) {
            result = this.findSourceByAlias(name.getParts().get(0));
        }
        return result;
    }

    @Nullable
    public KnownRowsSourceInfo findReferencedSourceExact(@NotNull SQLQueryComplexName name) {
        KnownRowsSourceInfo result = this.rowsSources.get(name);
        if (result == null && name.getParts().size() == 1) {
            result = this.findSourceByAlias(name.getParts().get(0));
        }
        return result;
    }

    @Nullable
    private KnownRowsSourceInfo findSourceByAlias(@NotNull String aliasName) {
        return this.sourcesByLoweredAlias.get(aliasName.toLowerCase());
    }

    @NotNull
    public SQLQueryRowsSourceContext combine(@NotNull SQLQueryRowsSourceContext other) {
        return this.setRowsSources((Map<SQLQueryComplexName, KnownRowsSourceInfo>)new HashMap<SQLQueryComplexName, KnownRowsSourceInfo>(other){
            {
                this.putAll(sQLQueryRowsSourceContext2.rowsSources);
                this.putAll(SQLQueryRowsSourceContext.this.rowsSources);
            }
        }, (Map<String, KnownRowsSourceInfo>)new HashMap<String, KnownRowsSourceInfo>(other){
            {
                this.putAll(sQLQueryRowsSourceContext2.sourcesByLoweredAlias);
                this.putAll(SQLQueryRowsSourceContext.this.sourcesByLoweredAlias);
            }
        });
    }

    @NotNull
    public final SQLQueryRowsSourceContext appendSource(@NotNull SQLQueryRowsSourceModel source, @NotNull SQLQueryComplexName name, @Nullable DBSEntity tableOrNull) {
        return this.setRowsSources((Map<SQLQueryComplexName, KnownRowsSourceInfo>)new HashMap<SQLQueryComplexName, KnownRowsSourceInfo>(name, source, tableOrNull){
            {
                this.putAll(SQLQueryRowsSourceContext.this.rowsSources);
                this.put(sQLQueryComplexName, new KnownRowsSourceInfo(sQLQueryRowsSourceModel, sQLQueryComplexName, dBSEntity, null));
            }
        }, this.sourcesByLoweredAlias);
    }

    @NotNull
    public final SQLQueryRowsSourceContext appendAlias(@NotNull SQLQueryRowsSourceModel source, @NotNull SQLQuerySymbol alias) {
        KnownRowsSourceInfo entry = this.rowsSources.values().stream().filter(s -> s.source == source).findFirst().orElse(null);
        KnownRowsSourceInfo newEntry = entry != null ? new KnownRowsSourceInfo(entry.source, entry.referenceName, entry.tableOrNull, alias) : new KnownRowsSourceInfo(source, null, null, alias);
        return this.setRowsSources((Map<SQLQueryComplexName, KnownRowsSourceInfo>)new HashMap<SQLQueryComplexName, KnownRowsSourceInfo>(entry, newEntry, alias){
            {
                this.putAll(SQLQueryRowsSourceContext.this.rowsSources);
                if (knownRowsSourceInfo != null) {
                    this.put(knownRowsSourceInfo.referenceName, knownRowsSourceInfo2);
                }
                this.put(new SQLQueryComplexName(sQLQuerySymbol.getName()), knownRowsSourceInfo2);
            }
        }, (Map<String, KnownRowsSourceInfo>)new HashMap<String, KnownRowsSourceInfo>(alias, newEntry){
            {
                this.putAll(SQLQueryRowsSourceContext.this.sourcesByLoweredAlias);
                this.put(sQLQuerySymbol.getName().toLowerCase(), knownRowsSourceInfo);
            }
        });
    }

    @NotNull
    public final SQLQueryRowsSourceContext appendCteSources(@NotNull List<Pair<SQLQuerySymbolEntry, SQLQueryRowsSourceModel>> sources) {
        return this.setDynamicRowsSources((Map<String, KnownRowsSourceInfo>)new HashMap<String, KnownRowsSourceInfo>(sources){
            {
                this.putAll(SQLQueryRowsSourceContext.this.dynamicTableSources);
                for (Pair entry : list) {
                    SQLQuerySymbolEntry alias = (SQLQuerySymbolEntry)entry.getFirst();
                    if (alias == null) continue;
                    SQLQueryRowsSourceModel sourceModel = (SQLQueryRowsSourceModel)entry.getSecond();
                    SQLQueryComplexName name = new SQLQueryComplexName(new SQLQueryQualifiedName(alias.getSyntaxNode(), Collections.emptyList(), alias, 0, null));
                    this.put(alias.getName().toLowerCase(), new KnownRowsSourceInfo(sourceModel, name, null, alias.getSymbol()));
                }
            }
        });
    }

    @NotNull
    public final SQLQueryRowsSourceContext setCteSourcesFrom(@NotNull SQLQueryRowsSourceContext context) {
        return this.setDynamicRowsSources(Map.copyOf(context.dynamicTableSources));
    }

    public SQLQueryRowsDataContext makeEmptyTuple() {
        return new SQLQueryRowsDataContext(this, Collections.emptyList(), Collections.emptyList());
    }

    public SQLQueryRowsDataContext makeTuple(@NotNull List<SQLQueryResultColumn> columns, @NotNull List<SQLQueryResultPseudoColumn> pseudoColumns) {
        return new SQLQueryRowsDataContext(this, columns, pseudoColumns);
    }

    public final SQLQueryRowsDataContext makeTuple(@Nullable SQLQueryRowsSourceModel source, @NotNull List<SQLQueryResultColumn> columns, @NotNull List<SQLQueryResultPseudoColumn> pseudoColumns) {
        List allPseudoColumns = source == null ? pseudoColumns : STMUtils.combineLists(this.connectionInfo.rowsetPseudoColumnsProvider.apply(source), pseudoColumns);
        return new SQLQueryRowsDataContext(this, columns, allPseudoColumns);
    }

    @NotNull
    public SQLQuerySourcesInfoCollection getKnownSources() {
        return new SQLQuerySourcesInfoCollection(){
            private final Map<SQLQueryRowsSourceModel, SourceResolutionResult> resolutionResults;
            private final Set<DBSObject> referencedTables;
            private final Set<String> aliasesInUse;
            {
                this.resolutionResults = Stream.of(SQLQueryRowsSourceContext.this.rowsSources.values(), SQLQueryRowsSourceContext.this.dynamicTableSources.values()).flatMap(Collection::stream).distinct().collect(Collectors.toMap(s -> s.source, Function.identity()));
                this.referencedTables = SQLQueryRowsSourceContext.this.rowsSources.values().stream().map(s -> s.tableOrNull).filter(Objects::nonNull).collect(Collectors.toSet());
                this.aliasesInUse = SQLQueryRowsSourceContext.this.rowsSources.values().stream().map(s -> s.aliasOrNull).filter(Objects::nonNull).map(SQLQuerySymbol::getName).collect(Collectors.toSet());
            }

            @Override
            @NotNull
            public Map<SQLQueryRowsSourceModel, SourceResolutionResult> getResolutionResults() {
                return this.resolutionResults;
            }

            @Override
            @NotNull
            public Set<DBSObject> getReferencedTables() {
                return this.referencedTables;
            }

            @Override
            @NotNull
            public Set<String> getAliasesInUse() {
                return this.aliasesInUse;
            }
        };
    }

    @NotNull
    private SQLQueryRowsSourceContext setRowsSources(@NotNull Map<SQLQueryComplexName, KnownRowsSourceInfo> rowsSources, @NotNull Map<String, KnownRowsSourceInfo> sourcesByLoweredAlias) {
        return new SQLQueryRowsSourceContext(this.connectionInfo, this.hasUnresolvedSource, rowsSources, this.dynamicTableSources, sourcesByLoweredAlias);
    }

    @NotNull
    private SQLQueryRowsSourceContext setDynamicRowsSources(@NotNull Map<String, KnownRowsSourceInfo> dynamicTableSources) {
        return new SQLQueryRowsSourceContext(this.connectionInfo, this.hasUnresolvedSource, this.rowsSources, dynamicTableSources, this.sourcesByLoweredAlias);
    }

    public static class KnownRowsSourceInfo
    extends SourceResolutionResult {
        @Nullable
        public final SQLQueryComplexName referenceName;

        protected KnownRowsSourceInfo(@NotNull SQLQueryRowsSourceModel source, @Nullable SQLQueryComplexName referenceName, @Nullable DBSEntity tableOrNull, @Nullable SQLQuerySymbol aliasOrNull) {
            super(source, tableOrNull, aliasOrNull);
            this.referenceName = referenceName;
        }
    }
}

