/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultTupleContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;

public class SQLQueryRowsDataContext {
    private static final Log log = Log.getLog(SQLQueryResultTupleContext.class);
    @NotNull
    private final SQLQueryRowsSourceContext rowsSources;
    @NotNull
    private final List<SQLQueryResultColumn> columns;
    @NotNull
    private final Set<DBSEntity> realSources;
    @NotNull
    private final List<SQLQueryResultPseudoColumn> pseudoColumns;

    public SQLQueryRowsDataContext(@NotNull SQLQueryRowsSourceContext rowsSources, @NotNull List<SQLQueryResultColumn> columns, @NotNull List<SQLQueryResultPseudoColumn> pseudoColumns) {
        this.rowsSources = rowsSources;
        this.columns = columns;
        this.realSources = columns.stream().map(c -> c.realSource).filter(Objects::nonNull).collect(Collectors.toSet());
        this.pseudoColumns = pseudoColumns;
    }

    @NotNull
    public SQLQueryConnectionContext getConnection() {
        return this.rowsSources.getConnectionInfo();
    }

    @NotNull
    public SQLQueryRowsSourceContext getRowsSources() {
        return this.rowsSources;
    }

    @NotNull
    public List<SQLQueryResultColumn> getColumnsList() {
        return this.columns;
    }

    @NotNull
    public List<SQLQueryResultPseudoColumn> getPseudoColumnsList() {
        return this.pseudoColumns;
    }

    @Nullable
    public SQLQueryResultColumn resolveColumn(@NotNull DBRProgressMonitor monitor, @NotNull String columnName) {
        SQLQueryResultColumn result = this.columns.stream().filter(c -> c.symbol.getSymbolClass() == SQLQuerySymbolClass.COLUMN_DERIVED ? c.symbol.getName().equalsIgnoreCase(columnName) : c.symbol.getName().equals(columnName)).findFirst().orElse(null);
        if (result != null) {
            return result;
        }
        String unquoted = this.getConnection().dialect.getUnquotedIdentifier(columnName);
        for (DBSEntity source : this.realSources) {
            try {
                DBSEntityAttribute attr = source.getAttribute(monitor, unquoted);
                if (attr != null) {
                    result = this.columns.stream().filter(c -> c.realAttr == attr).findFirst().orElse(null);
                }
            }
            catch (DBException e) {
                log.debug((Object)"Failed to resolve column", (Throwable)e);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public SQLQueryResultPseudoColumn resolvePseudoColumn(@NotNull String name) {
        SQLQueryResultPseudoColumn result = this.pseudoColumns.stream().filter(c -> c.symbol.getName().equals(name)).findFirst().orElse(null);
        return result;
    }

    public SQLQueryRowsDataContext combine(SQLQueryRowsDataContext other) {
        SQLQueryRowsSourceContext combinedSources = this.rowsSources.combine(other.rowsSources);
        return combinedSources.makeTuple(STMUtils.combineLists(this.getColumnsList(), other.getColumnsList()), STMUtils.combineLists(this.getPseudoColumnsList(), other.getPseudoColumnsList()));
    }
}

