/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQuerySyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;

public class SQLQueryAliasedRowsContext
extends SQLQuerySyntaxContext {
    private final SQLQuerySymbol alias;
    private final SQLQueryRowsSourceModel source;

    public SQLQueryAliasedRowsContext(@NotNull SQLQueryDataContext parent, @NotNull SQLQuerySymbol alias, @NotNull SQLQueryRowsSourceModel source) {
        super(parent);
        this.alias = alias;
        this.source = source;
    }

    @Override
    @Nullable
    public SourceResolutionResult resolveSource(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        return tableName.size() == 1 && tableName.get(0).equalsIgnoreCase(this.alias.getName()) ? SourceResolutionResult.forSourceByAlias(this.source, this.alias) : super.resolveSource(monitor, tableName);
    }

    @Override
    protected void collectKnownSourcesImpl(@NotNull SQLQueryDataContext.KnownSourcesInfo info) {
        super.collectKnownSourcesImpl(info);
        info.registerAlias(this.source, this.alias);
    }
}

