/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTableColumn;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class CubridTableManager
extends GenericTableManager
implements DBEObjectRenamer<GenericTableBase> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{CubridTableColumn.class, GenericUniqueKey.class, GenericTableForeignKey.class, GenericTableIndex.class});

    public boolean canCreateObject(@NotNull Object container) {
        return !(container instanceof CubridTable);
    }

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, GenericTableBase object, Class<? extends DBSObject> childType) throws DBException {
        if (childType == CubridTableColumn.class) {
            return object.getAttributes(monitor);
        }
        return super.getChildObjects(monitor, (DBSObject)object, childType);
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"schema") == null) {
            CubridTable table = (CubridTable)command.getObject();
            StringBuilder query = new StringBuilder("ALTER TABLE ");
            query.append(String.valueOf(table.getContainer()) + "." + table.getName());
            this.appendTableModifiers(monitor, (GenericTableBase)table, (SQLObjectEditor.NestedObjectCommand)command, query, true, options);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(query.toString()));
        }
    }

    protected void appendTableModifiers(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase genericTable, @NotNull SQLObjectEditor.NestedObjectCommand command, @NotNull StringBuilder query, @NotNull boolean alter, @NotNull Map<String, Object> options) {
        CubridTable table = (CubridTable)genericTable;
        String delimiter = CubridTableManager.getDelimiter(options);
        String suffix = alter ? "," : delimiter;
        query.append(delimiter);
        if (!alter || command.hasProperty((Object)"reuseOID")) {
            query.append(table.isReuseOID() ? "REUSE_OID" : "DONT_REUSE_OID").append(suffix);
        }
        if (!alter && table.getCollation().getName() != null || command.getProperty((Object)"charset") != null || command.getProperty((Object)"collation") != null) {
            query.append("COLLATE ").append(table.getCollation().getName()).append(suffix);
        }
        if (!(alter && command.getProperty((Object)"autoIncrement") == null || table.getAutoIncrement() <= 0)) {
            query.append("AUTO_INCREMENT = ").append(table.getAutoIncrement()).append(suffix);
        }
        if (!alter && table.getDescription() != null || command.hasProperty((Object)"description")) {
            query.append("COMMENT = ").append(SQLUtils.quoteString((DBSObject)table, (String)CommonUtils.notEmpty((String)table.getDescription()))).append(suffix);
        }
        if (!CubridTableManager.isCompact(options)) {
            query.deleteCharAt(query.length() - 1);
        }
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<GenericTableBase, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        CubridTable table = (CubridTable)command.getObject();
        if (table.isPersisted() && table.getContainer() != table.getSchema()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Change Owner", "ALTER TABLE " + String.valueOf(table.getContainer()) + "." + table.getName() + " OWNER TO " + String.valueOf(table.getSchema())));
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        CubridTable table = (CubridTable)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "RENAME TABLE " + String.valueOf(table.getContainer()) + "." + command.getOldName() + " TO " + command.getNewName()));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }
}

