/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2020-2021 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
; generated by igemm_codegen.py (6612fa4de68b883367c3388e88a0aa56d301a99e)
;
.include "igemm_bwd_gtcx3_nhwc_fp32_utils.inc"

;----------------------------------------------------------
; starting of kernel igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs
; tensor_layout              : 'nhwc'
; gemm_m_per_block           : 128
; gemm_n_per_block           : 64
; gemm_k_per_block           : 32
; wave_tile_m                : 32
; wave_step_m                : 1
; wave_repeat_m              : 1
; wave_tile_n                : 32
; wave_step_n                : 1
; wave_repeat_n              : 2
; wave_tile_k                : 2
; tensor_a_pass_through      : 1
; tensor_a_thread_lengths    : [1, 16, 1, 1]
; tensor_a_cluster_lengths   : [1, 2, 4, 32]
; tensor_b_thread_lengths    : [1, 4, 2, 1]
; tensor_b_cluster_lengths   : [1, 8, 1, 32]
; direction                  : 'bwd'
; precision                  : 'fp32'
; nxb                        : 0
; nxe                        : 1
; gemm_k_global_split        : 1
; vector_c                   : 1
; 
; block_size                 : 256
; lds_total                  : 8192
; lds_buffer_num             : 1
; 
.set k_p_in, 0
.set k_p_wei, 8
.set k_p_out, 16
.set k_hi, 24
.set k_wi, 28
.set k_n, 32
.set k_k, 36
.set k_c, 40
.set k_ho, 44
.set k_wo, 48
.set k_stride_h, 52
.set k_stride_w, 56
.set k_dilation_h, 60
.set k_dilation_w, 64
.set k_pad_h, 68
.set k_pad_w, 72
.set k_y, 76
.set k_x, 80
.set k_dtile_iy, 84
.set k_dtile_ix, 88
.set k_dtile_dy, 92
.set k_dtile_dx, 96
.set k_dtile_y, 100
.set k_dtile_x, 104
.set k_dtile_h, 108
.set k_dtile_w, 112
.set k_dslice_y, 116
.set k_dslice_x, 120
.set k_dslice_h, 124
.set k_dslice_w, 128
.set k_dslice_h_left, 132
.set k_dslice_w_left, 136
.set k_group, 140
.set k_magic_0, 144
.set k_magic_1, 148
.set k_magic_2, 152
.set k_magic_3, 156
.set k_shift_pack_0, 160
.set k_gemm_k_global_split, 164
.set k_end, 168
.set k_gload_out_k_stride, 32
.set k_gload_wei_c_stride, 128

.set s_ka, 0
.set s_bx, 2
.set s_by, 3
.set s_p_in, 4
.set s_p_wei, 8
.set s_p_out, 12
.set s_hi, 16
.set s_wi, 17
.set s_n, 18
.set s_k, 19
.set s_c, 20
.set s_ho, 21
.set s_wo, 22
.set s_stride_h, 23
.set s_stride_w, 24
.set s_dilation_h, 25
.set s_dilation_w, 26
.set s_pad_h, 27
.set s_pad_w, 28
.set s_y, 29
.set s_x, 30
.set s_dtile_iy, 31
.set s_dtile_ix, 32
.set s_dtile_dy, 33
.set s_dtile_dx, 34
.set s_dtile_y, 35
.set s_dtile_x, 36
.set s_dtile_h, 37
.set s_dtile_w, 38
.set s_dslice_y, 39
.set s_dslice_x, 40
.set s_dslice_h, 41
.set s_dslice_w, 42
.set s_dslice_h_left, 43
.set s_dslice_w_left, 44
.set s_group, 45
.set s_magic_0, 6
.set s_magic_1, 7
.set s_magic_2, 46
.set s_magic_3, 47
.set s_shift_m2, 37
.set s_shift_m3, 38
.set s_out_stride_wo, 48
.set s_out_stride_n, 49
.set s_wei_stride_k, 50
.set s_in_stride_wi, 51
.set s_in_stride_n, 52
.set s_block_gtc_ig, 53
.set s_block_gtc_ic, 54
.set s_block_gtc_inb, 55
.set s_move_slice_out_stride_k, 56
.set s_move_slice_wei_stride_k, 57
.set s_knum, 3
.set s_gemm_k_num_k, 58
.set s_dim_br, 59
.set s_dim_mp, 60
.set s_dim_mr, 61
.set s_dim_np, 62
.set s_wei_os_diff_acc_x_rst_k, 63
.set s_wei_os_diff_acc_y_rst_kx, 64
.set s_out_os_diff_acc_ho_rst_wo, 65
.set s_out_os_diff_acc_wo, 66
.set s_ho_diff_acc_y, 67
.set s_wo_diff_acc_x, 68
.set s_wo_diff_rst_x, 69
.set s_move_slice_k_ix, 70
.set s_flag_need_acc_yx, 71
.set s_shift_pack_0, 71
.set s_kitr, 1
.set s_out_k_itr, 2
.set s_wei_offset, 72
.set s_in_hi_sshift, 74
.set s_in_wi_sshift, 75
.set s_block_gtc_ik, 76
.set s_gemmk_split, 77
.set s_sub_k, 78
.set s_tmp, 80
.set s_end, 86

.set v_c, 0  ; coalescing:8, needed:6, resuable:2
.set v_b, 6
.set v_gld_a, 14
.set v_gld_a_gpf, 30
.set v_gld_b, 46
.set v_sst_b_os, 54
.set v_sld_b_os, 55
.set v_out_os, 56
.set v_out_iho_list, 57
.set v_out_iwo_list, 58
.set v_out_flag, 59
.set v_out_flag_n, 60
.set v_out_ik, 61
.set v_out_inb, 62
.set v_out_in, 63
.set v_wei_os, 64
.set v_wei_ic, 65
.set v_wei_ik, 66
.set v_in_os, 8
.set v_in_in, 9
.set v_in_ihi, 10
.set v_in_iwi, 11
.set v_in_flag, 12
.set v_in_flag_c, 65
.set v_in_inb, 62
.set v_co_sst, 63
.set v_co_sld, 67
.set v_gemm_in, 68
.set v_gemm_im, 69
.set v_co_sub_m_index, 69
.set v_co_sub_n_index, 68
.set v_tmp, 70
.set v_wei_tmp_pack, 13
.set v_wei_flag, 70
.set v_in_hi_sshift, 74
.set v_in_wi_sshift, 75
.set v_end, 108

.set a_c, 76
.set a_end, 108

.text
.globl igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs
.p2align 8
.type igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs,@function
igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs:
    s_load_dwordx2  s[s_p_in+0:s_p_in+1],       s[s_ka+0:s_ka+1],    0+k_p_in
    s_load_dwordx2  s[s_p_wei+0:s_p_wei+1],      s[s_ka+0:s_ka+1],    0+k_p_wei
    s_load_dwordx2  s[s_p_out+0:s_p_out+1],      s[s_ka+0:s_ka+1],    0+k_p_out
    s_load_dwordx16 s[s_hi+0:s_hi+15],        s[s_ka+0:s_ka+1],    0+k_hi
    s_load_dwordx8  s[s_dtile_ix+0:s_dtile_ix+7],   s[s_ka+0:s_ka+1],    0+k_dtile_ix
    s_load_dwordx4  s[s_dslice_x+0:s_dslice_x+3],   s[s_ka+0:s_ka+1],    0+k_dslice_x
    s_load_dwordx2  s[s_dslice_w_left+0:s_dslice_w_left+1],   s[s_ka+0:s_ka+1],    0+k_dslice_w_left
    s_load_dwordx2 s[s_magic_0+0:s_magic_0+1],  s[s_ka+0:s_ka+1],  0+k_magic_0
    s_load_dwordx2 s[s_magic_2+0:s_magic_2+1],  s[s_ka+0:s_ka+1],  0+k_magic_2
    s_load_dword s[s_shift_pack_0], s[s_ka+0:s_ka+1],  0+k_shift_pack_0
    s_load_dword s[s_gemmk_split], s[s_ka+0:s_ka+1],  0+k_gemm_k_global_split
    ; out(e, k, nb0, nb1) thread_lengths: 1x16x1x1, cluster_length: 1x2x4x32, k_pack:4
    ; wei(e, k, c0, c1) thread_length: 1x4x2x1, cluster_length: 1x8x1x32, k_pack:4
    v_mov_b32 v[v_tmp], v0
    v_and_b32 v[v_out_inb], 31, v[v_tmp]
    v_lshrrev_b32 v[v_tmp], 5, v[v_tmp]
    v_and_b32 v[v_out_ik], 1, v[v_tmp]
    v_lshlrev_b32 v[v_out_ik], 2, v[v_out_ik]
    v_lshrrev_b32 v[v_tmp], 1, v[v_tmp]
    v_and_b32 v[v_tmp+1], 3, v[v_tmp]
    v_lshl_or_b32 v[v_out_inb], v[v_tmp+1], 5, v[v_out_inb]
    v_mov_b32 v[v_tmp], v0
    v_and_b32 v[v_wei_ic], 31, v[v_tmp]
    v_lshrrev_b32 v[v_tmp], 5, v[v_tmp]
    v_and_b32 v[v_wei_ik], 7, v[v_tmp]
    v_lshlrev_b32 v[v_wei_ik], 2, v[v_wei_ik]

    s_waitcnt lgkmcnt(0)

    ; calculate index
    s_lshr_b32 s[s_sub_k], s[s_k], s[s_gemmk_split] ; add gkgs for k
    s_mul_i32 s[s_out_stride_wo], s[s_k], s[s_group]
    s_mul_i32 s[s_tmp+2], s[s_wo], s[s_out_stride_wo]
    s_mul_i32 s[s_out_stride_n], s[s_ho], s[s_tmp+2]
    s_mul_i32 s[s_tmp], s[s_x], s[s_c]
    s_mul_i32 s[s_wei_stride_k], s[s_tmp], s[s_y]
    s_mul_i32 s[s_in_stride_wi], s[s_c], s[s_group]
    s_mul_i32 s[s_tmp+1], s[s_wi], s[s_in_stride_wi]
    s_mul_i32 s[s_in_stride_n], s[s_hi], s[s_tmp+1]
    s_mul_i32  s[s_tmp], s[s_n], s[s_in_stride_n]
    s_mul_i32  s[s_tmp+1], s[s_n], s[s_out_stride_n]
    s_lshl_b32 s[s_tmp+4], s[s_tmp], 2
    s_lshl_b32 s[s_tmp+5], s[s_tmp+1], 2
    s_mul_i32 s[s_tmp], s[s_by], s[s_tmp+4]
    s_mul_hi_u32 s[s_tmp+1], s[s_by], s[s_tmp+4]
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], s[s_tmp+1]
    s_mul_i32 s[s_tmp], s[s_by], s[s_tmp+5]
    s_mul_hi_u32 s[s_tmp+1], s[s_by], s[s_tmp+5]
    s_add_u32 s[s_p_out], s[s_p_out], s[s_tmp]
    s_addc_u32 s[s_p_out+1], s[s_p_out+1], s[s_tmp+1]
    s_mul_i32 s[s_dim_br], s[s_dslice_h], s[s_dslice_w]
    s_mul_i32 s[s_dim_mr], s[s_n], s[s_dim_br]
    s_add_u32 s[s_tmp], 127, s[s_dim_mr]
    s_lshr_b32 s[s_tmp+1], s[s_tmp], 7
    s_lshl_b32 s[s_dim_mp], s[s_tmp+1], 7
    s_add_u32 s[s_tmp], 63, s[s_c]
    s_lshr_b32 s[s_tmp+1], s[s_tmp], 6
    s_lshl_b32 s[s_dim_np], s[s_tmp+1], 6

    ; gemm_m_per_block:128, gemm_n_per_block:64, source_access_order:0
    s_lshl_b32 s[s_tmp+3], 1, s[s_gemmk_split]
    s_sub_u32 s[s_tmp+3], s[s_tmp+3], 1
    s_and_b32 s[s_block_gtc_ik], s[s_bx], s[s_tmp+3]
    s_lshr_b32 s[s_bx], s[s_bx], s[s_gemmk_split]
    s_mul_i32 s[s_block_gtc_ik], s[s_block_gtc_ik], s[s_sub_k]
    s_cmp_lt_u32 s[s_block_gtc_ik], s[s_k]
    s_cbranch_scc0 L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_out
    s_lshr_b32 s[s_tmp], s[s_dim_mp], 7
    s_lshr_b32 s[s_tmp+1], s[s_dim_np], 6
    s_mul_i32 s[0], s[s_tmp+1], s[s_tmp]
    ; multihead dispatch code start
    s_mul_i32 s[s_tmp], s[s_dtile_y], s[s_dtile_x]
    s_cmp_eq_u32  1,  s[s_tmp]
    s_cbranch_scc1 L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_mh_dispatch_end
    s_mul_i32 s[s_tmp+2], s[0], s[s_group]
    .mdiv_u32_rem_ss s_tmp+4,s_tmp+5,s_bx,s_dtile_h,s_dtile_w,s_tmp+2,s_tmp
    s_mov_b32 s[s_bx], s[s_tmp+4]
    .mdiv_u32_rem_ss s_tmp+3,s_tmp+4,s_tmp+5,s_dtile_iy,s_dtile_ix,s_dtile_x,s_tmp
    s_add_u32 s[s_tmp+5], s[s_y], s[s_dtile_y]
    s_sub_u32 s[s_tmp+5], s[s_tmp+5], s[s_tmp+4]
    s_sub_u32 s[s_tmp+5], s[s_tmp+5], 1
    .mdiv_u32_ss s_dslice_y,s_tmp+5,s_dslice_y,s_dslice_x,s_tmp
    s_add_u32 s[s_tmp+5], s[s_x], s[s_dtile_x]
    s_sub_u32 s[s_tmp+5], s[s_tmp+5], s[s_tmp+3]
    s_sub_u32 s[s_tmp+5], s[s_tmp+5], 1
    .mdiv_u32_ss s_dslice_x,s_tmp+5,s_dtile_iy,s_dtile_ix,s_tmp
    s_mov_b32 s[s_dtile_iy],  s[s_tmp+4]
    s_mov_b32 s[s_dtile_ix],  s[s_tmp+3]
    s_cmp_lt_u32 s[s_dtile_iy], s[s_y]
    s_cbranch_scc0 L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_out
    s_cmp_lt_u32 s[s_dtile_ix], s[s_x]
    s_cbranch_scc0 L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_out
    ; multihead dispatch code end
L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_mh_dispatch_end:

    s_mul_i32 s[s_tmp], s[s_dslice_x], s[s_dslice_y]
    s_mul_i32 s[s_knum], s[s_tmp], s[s_k]
    s_lshr_b32 s[s_knum], s[s_knum], s[s_gemmk_split]
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080008 ; offset:8, width:8
    .mdiv_u32_rem_ss s_tmp+4,s_block_gtc_ig,s_bx,s_magic_1,s_tmp+3,0,s_tmp
    s_mov_b32 s[s_bx], s[s_tmp+4]
    s_lshr_b32 s[0], s[s_dim_np], 6
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080000 ; offset:0, width:8
    .mdiv_u32_rem_ss s_tmp+4,s_tmp+5,s_bx,s_magic_0,s_tmp+3,0,s_tmp
    ; s_tmp+4:block_gtc_in, s_tmp+5:block_gtc_im
    s_lshl_b32 s[s_block_gtc_ic], s[s_tmp+4], 6
    s_lshl_b32 s[s_block_gtc_inb], s[s_tmp+5], 7
    v_add_u32 v[v_tmp+5], s[s_block_gtc_inb], v[v_out_inb]
    s_bfe_u32 s[s_shift_m3], s[s_shift_pack_0], 0x00080018 ; offset:24, width:8
    .mdiv_u32_rem_vs v_tmp+4,v_out_in,v_tmp+5,s_magic_3,s_shift_m3,s_dim_br,v_tmp
    s_bfe_u32 s[s_shift_m2], s[s_shift_pack_0], 0x00080010 ; offset:16, width:8
    .mdiv_u32_rem_vs v_out_iwo_list,v_out_iho_list,v_tmp+4,s_magic_2,s_shift_m2,s_dslice_w,v_tmp
    v_add_u32 v[v_out_iho_list], s[s_dslice_h_left], v[v_out_iho_list]
    v_add_u32 v[v_out_iwo_list], s[s_dslice_w_left], v[v_out_iwo_list]

    s_lshl_b32 s[s_block_gtc_ig], s[s_block_gtc_ig], 2
    ; calculate wei offset
    s_mul_i32 s[s_tmp+2], s[s_k], s[s_wei_stride_k]
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_tmp+2]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_tmp+2]
    s_add_u32 s[s_p_wei], s[s_p_wei], s[s_tmp]
    s_addc_u32 s[s_p_wei+1], s[s_p_wei+1], s[s_tmp+1]
    v_add_u32 v[v_tmp+5], s[s_block_gtc_ic], v[v_wei_ic]
    s_mul_i32 s[s_tmp], s[s_dtile_iy], s[s_x] 
    v_add_u32 v[v_tmp], v[v_wei_ik], s[s_block_gtc_ik]
    v_mul_lo_u32 v[v_tmp+4], s[s_wei_stride_k], v[v_tmp]
    s_add_u32 s[s_tmp], s[s_tmp], s[s_dtile_ix]
    v_add_lshl_u32 v[v_wei_os], v[v_tmp+4], v[v_tmp+5], 2
    s_lshl_b32 s[s_tmp+1] s[s_c], 2
    v_cmp_gt_u32 vcc, s[s_c], v[v_tmp+5]
    s_mul_i32 s[s_tmp], s[s_tmp], s[s_tmp+1]
    v_cndmask_b32 v[v_wei_flag], 0, 1 vcc
    v_mov_b32 v[v_wei_tmp_pack], v[v_wei_flag]
    v_add_u32 v[v_wei_os], s[s_tmp], v[v_wei_os]
    s_mov_b32 s[s_tmp], 32
    v_add_u32 v[v_tmp+5], s[s_tmp], v[v_tmp+5]
    v_cmp_gt_u32 vcc, s[s_c], v[v_tmp+5]
    v_cndmask_b32 v[v_wei_flag+1], 0, 1 vcc
    v_lshl_or_b32 v[v_wei_tmp_pack], v[v_wei_flag+1], 1, v[v_wei_tmp_pack]

    s_lshl_b32 s[s_wei_stride_k], s[s_wei_stride_k], 2
    s_mul_i32 s[s_wei_offset], 2, s[s_wei_stride_k]
    s_mul_i32 s[s_wei_offset+1], 3, s[s_wei_stride_k]

    .v_clear_nc v_gld_b, 8
    s_mov_b32 s[s_p_wei+2], 0xffffffff
    s_mov_b32 s[s_p_wei+3], 0x27000
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dword v[v_gld_b], v[v_wei_os], s[s_p_wei:s_p_wei+3], 0 offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dword v[v_gld_b+4], v[v_wei_os], s[s_p_wei:s_p_wei+3], 0 offen offset:1 * k_gload_wei_c_stride
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dword v[v_gld_b+1], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_stride_k] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dword v[v_gld_b+5], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_stride_k] offen offset:1 * k_gload_wei_c_stride
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dword v[v_gld_b+2], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_offset] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dword v[v_gld_b+6], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_offset] offen offset:1 * k_gload_wei_c_stride
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dword v[v_gld_b+3], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_offset+1] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dword v[v_gld_b+7], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_offset+1] offen offset:1 * k_gload_wei_c_stride
    s_mov_b64 exec, -1

    v_cmp_gt_u32 vcc, s[s_n], v[v_out_in]
    v_cndmask_b32 v[v_tmp], 0, 1 vcc
    v_lshlrev_b32 v[v_out_flag_n], 0, v[v_tmp]
    ; calculate output offset
    s_mov_b32 s[s_out_k_itr], 0
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_k]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_k]
    s_add_u32 s[s_p_out], s[s_p_out], s[s_tmp]
    s_addc_u32 s[s_p_out+1], s[s_p_out+1], s[s_tmp+1]

    v_mul_lo_u32 v[v_tmp+1], s[s_out_stride_n], v[v_out_in]
    s_lshl_b32 s[s_out_stride_wo], s[s_out_stride_wo], 2
    v_add_u32 v[v_tmp+1], v[v_tmp+1], s[s_block_gtc_ik]
    v_add_lshl_u32 v[v_tmp+4], v[v_out_ik], v[v_tmp+1], 2
    v_mul_lo_u32 v[v_tmp], s[s_wo], v[v_out_iho_list]
    v_add_u32 v[v_tmp], v[v_out_iwo_list], v[v_tmp]
    v_mul_lo_u32 v[v_tmp], s[s_out_stride_wo], v[v_tmp]
    v_add_u32 v[v_out_os], v[v_tmp+4], v[v_tmp]
    v_bfe_u32 v[v_tmp+1], v[v_out_flag_n],  0, 1
    v_cmp_gt_u32 vcc, s[s_ho], v[v_out_iho_list]
    v_cndmask_b32 v[v_out_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wo], v[v_out_iwo_list]
    v_cndmask_b32 v[v_out_flag], 0, v[v_out_flag] vcc

    s_mov_b32 s[s_p_out+2], 0xffffffff
    s_mov_b32 s[s_p_out+3], 0x27000
    ; load output, nxe:1
    .v_clear_nc v_gld_a_gpf, 16
    v_cmpx_le_u32 vcc, 1, v[v_out_flag]
    buffer_load_dwordx4 v[v_gld_a_gpf:v_gld_a_gpf+3], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:0
    buffer_load_dwordx4 v[v_gld_a_gpf+4:v_gld_a_gpf+4+3], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:1 * k_gload_out_k_stride
    buffer_load_dwordx4 v[v_gld_a_gpf+8:v_gld_a_gpf+8+3], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:2 * k_gload_out_k_stride
    buffer_load_dwordx4 v[v_gld_a_gpf+12:v_gld_a_gpf+12+3], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:3 * k_gload_out_k_stride
    s_mov_b64 exec, -1

    v_mov_b32 v[v_tmp+5], v0
    ; xdlops mapping, get source matrix gemm index, k_pack:4, v_pack:4, k_pack_per_thread:4
    v_and_b32 v[v_gemm_in], 31, v[v_tmp+5]           ; block_n index 
    v_and_b32 v[v_gemm_im], 31, v[v_tmp+5]           ; block_m index 
    v_lshlrev_b32 v[v_gemm_in], 2, v[v_gemm_in]   ; shift left k_pack:4
    v_lshlrev_b32 v[v_gemm_im], 2, v[v_gemm_im]   ; shift left k_pack:4
    v_lshrrev_b32 v[v_tmp+5], 5, v[v_tmp+5]
    v_and_b32 v[v_tmp + 0], 1, v[v_tmp+5]          ; block_k_per_wave index
    v_lshl_or_b32 v[v_gemm_in], v[v_tmp + 0], 8, v[v_gemm_in]
    v_lshl_or_b32 v[v_gemm_im], v[v_tmp + 0], 9, v[v_gemm_im]
    v_lshrrev_b32 v[v_tmp+5], 1, v[v_tmp+5]
    v_and_b32 v[v_tmp + 3], 3, v[v_tmp+5]  ; waves_per_m index
    v_lshl_or_b32 v[v_gemm_im], v[v_tmp + 3], 7, v[v_gemm_im]

    v_mov_b32 v[v_tmp+5], v0
    ; xdlops mapping, get dst matrix gemm index
    v_and_b32 v[v_tmp+0], 31, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 5, v[v_tmp+5]
    v_and_b32 v[v_tmp+1], 1, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 1, v[v_tmp+5]
    v_mov_b32 v[v_co_sst], v[v_tmp+0]
    v_lshlrev_b32 v[v_co_sld], 2, v[v_tmp+1]
    v_and_b32 v[v_tmp+1], 3, v[v_tmp+5]
    v_lshl_or_b32 v[v_co_sld], v[v_tmp+1], 5, v[v_co_sld]

    ; LDS store, wei: e,k,c: 1x4x2x1, 1x8x1x32, k_pack:4, k_pack_gld_b:4, fp32
    v_lshlrev_b32 v[v_tmp+2], 2,  v[v_wei_ic]
    v_lshrrev_b32 v[v_tmp+1], 2,  v[v_wei_ik]
    v_lshl_or_b32 v[v_tmp], v[v_tmp+1], 8, v[v_tmp+2]
    v_lshlrev_b32 v[v_sst_b_os], 2, v[v_tmp]

    v_lshlrev_b32 v[v_sld_b_os], 2, v[v_gemm_in] ; LDS load wei
    v_mov_b32 v[v_gemm_in], v[v_co_sst]
    v_mov_b32 v[v_gemm_im], v[v_co_sld]
    ; init_co_lds_offset for xdlops
    v_lshrrev_b32 v[v_tmp], 2, v[v_gemm_im]
    v_and_b32 v[v_tmp],  1 v[v_tmp]   ; thread id of lanegroup_m_per_cluster
    v_lshlrev_b32 v[v_co_sst], 2, v[v_tmp]
    v_lshrrev_b32 v[v_tmp+2], 5, v[v_gemm_im]  ; thread id of waves_per_m
    v_lshl_or_b32 v[v_co_sst], v[v_tmp+2], 3, v[v_co_sst]
    v_lshrrev_b32 v[v_tmp], 2, v[v_co_sst]
    v_lshlrev_b32 v[v_tmp+1], 2, v[v_gemm_in]   ; implicit transpose with m granularity:4 while store
    v_lshl_or_b32 v[v_co_sst], v[v_tmp], 8, v[v_tmp+1]
    v_lshlrev_b32 v[v_co_sst], 2, v[v_co_sst]
    v_lshlrev_b32 v[v_co_sld], 4, v[0]
    ; init_co_sub_m_index xdlops, block_size:256, macro-tile:128x64 sub_m_index:[0, 4, 32, 36]
    ; g_mr:1, g_ms:1, g_mw:1, g_mb:4, g_mt:1 | l_mr:1, l_ms:1, l_mw:1, l_mb:1, l_mt:4 | n_mc:2, n_ml:1, n_mv:4
    ; nd_stride:[4, 2, 1, 4, 1, 1, 4, 1]
    v_lshrrev_b32 v[v_co_sub_m_index], 6, v[0]   ; get tid along m
    v_and_b32 v[v_tmp+0], 1, v[v_co_sub_m_index]                   ; => x_mc
    v_lshrrev_b32 v[v_co_sub_m_index], 1  ,v[v_co_sub_m_index]
    v_and_b32 v[v_tmp+1], 3, v[v_co_sub_m_index]                   ; => x_mv
    v_lshlrev_b32 v[v_co_sub_m_index], 2, v[v_tmp+0]      ; => accumulate x_mc
    v_lshl_or_b32 v[v_co_sub_m_index], v[v_tmp+1], 5, v[v_co_sub_m_index]      ; => accumulate x_mv
    ; init_co_sub_n_index xdlops
    v_and_b32 v[v_co_sub_n_index], 63, v[0]

    v_add_u32 v[v_tmp], s[s_block_gtc_ic], v[v_co_sub_n_index]
    v_cmp_gt_u32 vcc, s[s_c], v[v_tmp]
    v_cndmask_b32 v[v_in_flag_c], 0, 1 vcc
    ; input offset
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_c]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_c]
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], s[s_tmp+1]

    s_lshl_b32 s[s_tmp+3], s[s_block_gtc_ic], 2
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp+3]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], 0

    s_lshl_b32 s[s_in_stride_wi], s[s_in_stride_wi], 2
    v_add_u32 v[v_in_inb], s[s_block_gtc_inb], v[v_co_sub_m_index]
    s_mul_i32 s[s_tmp], s[s_dslice_h_left], s[s_stride_h]
    s_mul_i32 s[s_tmp+1], s[s_dtile_iy], s[s_dilation_h]
    s_add_i32 s[s_tmp+2], s[s_tmp], s[s_tmp+1]
    s_sub_i32 s[s_in_hi_sshift], s[s_tmp+2], s[s_pad_h]
    s_mul_i32 s[s_tmp], s[s_dslice_w_left], s[s_stride_w]
    s_mul_i32 s[s_tmp+1], s[s_dtile_ix], s[s_dilation_w]
    s_add_i32 s[s_tmp+2], s[s_tmp], s[s_tmp+1]
    s_sub_i32 s[s_in_wi_sshift], s[s_tmp+2], s[s_pad_w]
    v_lshlrev_b32 v[v_co_sub_n_index], 2, v[v_co_sub_n_index]
    s_lshl_b32 s[s_in_stride_n], s[s_in_stride_n], 2
    ; move slice stride
    s_lshl_b32 s[s_gemm_k_num_k], s[s_sub_k], 2
    s_mul_i32 s[s_tmp], s[s_sub_k], s[s_wei_stride_k]
    s_lshl_b32 s[s_tmp+3], s[s_c], 2
    s_mul_i32 s[s_tmp+1], s[s_dtile_x], s[s_tmp+3]
    s_sub_i32 s[s_wei_os_diff_acc_x_rst_k], s[s_tmp+1], s[s_tmp]
    s_sub_i32 s[s_tmp+2], s[s_dslice_x], 1
    s_mul_i32 s[s_tmp+2], s[s_tmp+2], s[s_tmp+3]
    s_mul_i32 s[s_tmp+2], s[s_tmp+2], s[s_dtile_x]
    s_mul_i32 s[s_tmp+3], s[s_x], s[s_tmp+3]
    s_mul_i32 s[s_tmp+1], s[s_dtile_y], s[s_tmp+3]
    s_sub_i32 s[s_tmp+1], s[s_tmp+1], s[s_tmp+2]
    s_sub_i32 s[s_wei_os_diff_acc_y_rst_kx], s[s_tmp+1], s[s_tmp]
    v_bfe_u32 v[v_wei_flag], v[v_wei_tmp_pack], 0, 1
    s_mov_b32 s[s_move_slice_out_stride_k], 128
    s_mul_i32 s[s_move_slice_wei_stride_k], 32, s[s_wei_stride_k]
    v_bfe_u32 v[v_wei_flag+1], v[v_wei_tmp_pack], 1, 1
    s_mov_b32 s[s_move_slice_k_ix], 0
    s_sub_i32 s[s_tmp+3], s[s_dslice_x], 1
    s_mul_i32 s[s_tmp], s[s_tmp+3], s[s_dtile_dx]
    s_mul_i32 s[s_out_os_diff_acc_ho_rst_wo], s[s_tmp], s[s_out_stride_wo]
    s_mul_i32 s[s_wo_diff_rst_x], s[s_dtile_dx], s[s_tmp+3]
    s_mul_i32 s[s_ho_diff_acc_y], -1, s[s_dtile_dy]
    s_mul_i32 s[s_wo_diff_acc_x], -1, s[s_dtile_dx]
    s_mul_i32 s[s_out_os_diff_acc_wo], s[s_wo_diff_acc_x], s[s_out_stride_wo]
    s_mul_i32 s[s_tmp+1], s[s_wo], s[s_out_stride_wo] ; s_out_stride_ho
    s_mul_i32 s[s_tmp], s[s_ho_diff_acc_y], s[s_tmp+1]
    s_add_i32 s[s_out_os_diff_acc_ho_rst_wo], s[s_out_os_diff_acc_ho_rst_wo], s[s_tmp]

    s_mov_b32 s[s_p_in+2], 0xffffffff
    s_mov_b32 s[s_p_in+3], 0x27000
    ; start MFMA loop, wave tile:32x32, repeat:1x2, step:1x1, k_pack:4, p_issue:1, q_issue:1, local_prefetch_num:1
    .v_clear_nc a_c, 32
    s_waitcnt vmcnt(4)
    ds_write_b128 v[v_sst_b_os], v[v_gld_b:v_gld_b+3] 
    ds_write_b128 v[v_sst_b_os], v[v_gld_b+4:v_gld_b+4+3] offset:512

    s_waitcnt lgkmcnt(0)
    s_barrier

    ds_read_b128 v[v_b:v_b+3], v[v_sld_b_os] offset:0
    s_sub_i32 s[s_kitr], s[s_knum], 32
    s_cmp_gt_i32 s[s_kitr], 0
    s_cbranch_scc0 L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_mfma_end

L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_mfma_body:
    ; do fma accumulate with unroll 32, mfma_v_pack_slot:8
    
    s_add_u32 s[s_p_out], s[s_move_slice_out_stride_k], s[s_p_out]
    s_addc_u32 s[s_p_out+1], 0, s[s_p_out+1]
    v_add_u32 v[v_wei_os], s[s_move_slice_wei_stride_k], v[v_wei_os]
    s_add_u32 s[s_out_k_itr],  s[s_move_slice_out_stride_k], s[s_out_k_itr]
    s_cmp_le_u32 s[s_gemm_k_num_k], s[s_out_k_itr]

    ds_read_b128 v[v_b+4:v_b+4+3], v[v_sld_b_os] offset:512
    s_cbranch_scc0 igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_acc_yx_end_1  ; no need do accumulate yx
igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_acc_yx_1:
    s_sub_u32 s[s_p_out], s[s_p_out], s[s_gemm_k_num_k]
    s_subb_u32 s[s_p_out+1], s[s_p_out+1], 0
    s_mov_b32 s[s_out_k_itr], 0
    s_add_u32 s[s_move_slice_k_ix], 1, s[s_move_slice_k_ix]
    s_cmp_le_u32 s[s_dslice_x], s[s_move_slice_k_ix]
    s_cselect_b32 s[s_tmp], s[s_wo_diff_rst_x], s[s_wo_diff_acc_x]
    v_add_u32 v[v_out_iwo_list], s[s_tmp], v[v_out_iwo_list]
    s_cselect_b32 s[s_tmp], s[s_out_os_diff_acc_ho_rst_wo], s[s_out_os_diff_acc_wo]
    v_add_u32 v[v_out_os], s[s_tmp], v[v_out_os]
    s_cselect_b32 s[s_tmp], s[s_wei_os_diff_acc_y_rst_kx], s[s_wei_os_diff_acc_x_rst_k]
    v_add_u32 v[v_wei_os], s[s_tmp], v[v_wei_os]
    s_cbranch_scc0 igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_acc_yx_x_end_1
    s_mov_b32 s[s_move_slice_k_ix], 0
    v_add_i32 v[v_out_iho_list], s[s_ho_diff_acc_y], v[v_out_iho_list]
igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_acc_yx_x_end_1:
    v_bfe_u32 v[v_tmp+5], v[v_out_flag_n], 0, 1   ; extract flag_n
    v_cmp_gt_u32 vcc, s[s_ho], v[v_out_iho_list]
    v_cndmask_b32 v[v_out_flag], 0, v[v_tmp+5] vcc
    v_cmp_gt_u32 vcc, s[s_wo], v[v_out_iwo_list]
    v_cndmask_b32 v[v_out_flag], 0, v[v_out_flag] vcc
igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_acc_yx_end_1:

    s_waitcnt lgkmcnt(1) vmcnt(0)
    v_mov_b32 v[v_gld_a], v[v_gld_a_gpf]
    v_mov_b32 v[v_gld_a+1], v[v_gld_a_gpf+1]
    v_mov_b32 v[v_gld_a+2], v[v_gld_a_gpf+2]
    v_mov_b32 v[v_gld_a+3], v[v_gld_a_gpf+3]
    v_mov_b32 v[v_gld_a+4], v[v_gld_a_gpf+4]
    v_mov_b32 v[v_gld_a+5], v[v_gld_a_gpf+5]
    v_mov_b32 v[v_gld_a+6], v[v_gld_a_gpf+6]
    v_mov_b32 v[v_gld_a+7], v[v_gld_a_gpf+7]
    v_mov_b32 v[v_gld_a+8], v[v_gld_a_gpf+8]
    v_mov_b32 v[v_gld_a+9], v[v_gld_a_gpf+9]
    v_mov_b32 v[v_gld_a+10], v[v_gld_a_gpf+10]
    v_mov_b32 v[v_gld_a+11], v[v_gld_a_gpf+11]
    v_mov_b32 v[v_gld_a+12], v[v_gld_a_gpf+12]
    v_mov_b32 v[v_gld_a+13], v[v_gld_a_gpf+13]
    v_mov_b32 v[v_gld_a+14], v[v_gld_a_gpf+14]
    v_mov_b32 v[v_gld_a+15], v[v_gld_a_gpf+15]
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a], v[v_b], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:0, v:0, num_a_c:16
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dword v[v_gld_b], v[v_wei_os], s[s_p_wei:s_p_wei+3], 0 offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dword v[v_gld_b+4], v[v_wei_os], s[s_p_wei:s_p_wei+3], 0 offen offset:1 * k_gload_wei_c_stride
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dword v[v_gld_b+1], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_stride_k] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dword v[v_gld_b+5], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_stride_k] offen offset:1 * k_gload_wei_c_stride
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dword v[v_gld_b+2], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_offset] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dword v[v_gld_b+6], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_offset] offen offset:1 * k_gload_wei_c_stride
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dword v[v_gld_b+3], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_offset+1] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dword v[v_gld_b+7], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_offset+1] offen offset:1 * k_gload_wei_c_stride
    s_mov_b64 exec, -1
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+1], v[v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:0, v:1, num_a_c:16
    .v_clear_nc v_gld_a_gpf, 16
    v_cmpx_le_u32 vcc, 1, v[v_out_flag]
    buffer_load_dwordx4 v[v_gld_a_gpf:v_gld_a_gpf+3], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:0
    buffer_load_dwordx4 v[v_gld_a_gpf+4:v_gld_a_gpf+4+3], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:1 * k_gload_out_k_stride
    buffer_load_dwordx4 v[v_gld_a_gpf+8:v_gld_a_gpf+8+3], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:2 * k_gload_out_k_stride
    buffer_load_dwordx4 v[v_gld_a_gpf+12:v_gld_a_gpf+12+3], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:3 * k_gload_out_k_stride
    s_mov_b64 exec, -1
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+2], v[v_b+2], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:0, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+3], v[v_b+3], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:0, v:3, num_a_c:16
    ds_read_b128 v[v_b:v_b+3], v[v_sld_b_os] offset:2048 ; i_r:0, i_b:0, i_k:1
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a], v[v_b+4], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:0, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+1], v[v_b+5], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:0, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+2], v[v_b+6], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:0, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+3], v[v_b+7], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:0, v:3, num_a_c:16
    ds_read_b128 v[v_b+4:v_b+4+3], v[v_sld_b_os] offset:2560 ; i_r:1, i_b:0, i_k:1
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+4], v[v_b], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:1, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+5], v[v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:1, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+6], v[v_b+2], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:1, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+7], v[v_b+3], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:1, v:3, num_a_c:16
    ds_read_b128 v[v_b:v_b+3], v[v_sld_b_os] offset:4096 ; i_r:0, i_b:0, i_k:2
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+4], v[v_b+4], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:1, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+5], v[v_b+5], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:1, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+6], v[v_b+6], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:1, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+7], v[v_b+7], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:1, v:3, num_a_c:16
    ds_read_b128 v[v_b+4:v_b+4+3], v[v_sld_b_os] offset:4608 ; i_r:1, i_b:0, i_k:2
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+8], v[v_b], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:2, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+9], v[v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:2, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+10], v[v_b+2], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:2, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+11], v[v_b+3], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:2, v:3, num_a_c:16
    ds_read_b128 v[v_b:v_b+3], v[v_sld_b_os] offset:6144 ; i_r:0, i_b:0, i_k:3
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+8], v[v_b+4], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:2, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+9], v[v_b+5], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:2, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+10], v[v_b+6], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:2, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+11], v[v_b+7], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:2, v:3, num_a_c:16
    ds_read_b128 v[v_b+4:v_b+4+3], v[v_sld_b_os] offset:6656 ; i_r:1, i_b:0, i_k:3
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+12], v[v_b], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:3, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+13], v[v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:3, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+14], v[v_b+2], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:3, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+15], v[v_b+3], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:3, v:3, num_a_c:16
    s_waitcnt lgkmcnt(0) vmcnt(4)
    s_barrier
    ds_write_b128 v[v_sst_b_os], v[v_gld_b:v_gld_b+3] 
    ds_write_b128 v[v_sst_b_os], v[v_gld_b+4:v_gld_b+4+3] offset:512
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+12], v[v_b+4], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:3, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+13], v[v_b+5], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:3, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+14], v[v_b+6], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:3, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+15], v[v_b+7], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:3, v:3, num_a_c:16
    s_waitcnt lgkmcnt(0)
    s_barrier
    ds_read_b128 v[v_b:v_b+3], v[v_sld_b_os] offset:0
    s_sub_i32 s[s_kitr], s[s_kitr], 32
    s_cmp_gt_i32 s[s_kitr], 0
    s_cbranch_scc1 L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_mfma_body
L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_mfma_end:
    ds_read_b128 v[v_b+4:v_b+4+3], v[v_sld_b_os] offset:512
    s_waitcnt lgkmcnt(1) vmcnt(0)
    v_mov_b32 v[v_gld_a], v[v_gld_a_gpf]
    v_mov_b32 v[v_gld_a+1], v[v_gld_a_gpf+1]
    v_mov_b32 v[v_gld_a+2], v[v_gld_a_gpf+2]
    v_mov_b32 v[v_gld_a+3], v[v_gld_a_gpf+3]
    v_mov_b32 v[v_gld_a+4], v[v_gld_a_gpf+4]
    v_mov_b32 v[v_gld_a+5], v[v_gld_a_gpf+5]
    v_mov_b32 v[v_gld_a+6], v[v_gld_a_gpf+6]
    v_mov_b32 v[v_gld_a+7], v[v_gld_a_gpf+7]
    v_mov_b32 v[v_gld_a+8], v[v_gld_a_gpf+8]
    v_mov_b32 v[v_gld_a+9], v[v_gld_a_gpf+9]
    v_mov_b32 v[v_gld_a+10], v[v_gld_a_gpf+10]
    v_mov_b32 v[v_gld_a+11], v[v_gld_a_gpf+11]
    v_mov_b32 v[v_gld_a+12], v[v_gld_a_gpf+12]
    v_mov_b32 v[v_gld_a+13], v[v_gld_a_gpf+13]
    v_mov_b32 v[v_gld_a+14], v[v_gld_a_gpf+14]
    v_mov_b32 v[v_gld_a+15], v[v_gld_a_gpf+15]
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a], v[v_b], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:0, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+1], v[v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:0, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+2], v[v_b+2], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:0, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+3], v[v_b+3], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:0, v:3, num_a_c:16
    ds_read_b128 v[v_b:v_b+3], v[v_sld_b_os] offset:2048 ; i_r:0, i_b:0, i_k:1
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a], v[v_b+4], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:0, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+1], v[v_b+5], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:0, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+2], v[v_b+6], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:0, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+3], v[v_b+7], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:0, v:3, num_a_c:16
    ds_read_b128 v[v_b+4:v_b+4+3], v[v_sld_b_os] offset:2560 ; i_r:1, i_b:0, i_k:1
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+4], v[v_b], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:1, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+5], v[v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:1, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+6], v[v_b+2], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:1, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+7], v[v_b+3], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:1, v:3, num_a_c:16
    ds_read_b128 v[v_b:v_b+3], v[v_sld_b_os] offset:4096 ; i_r:0, i_b:0, i_k:2
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+4], v[v_b+4], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:1, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+5], v[v_b+5], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:1, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+6], v[v_b+6], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:1, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+7], v[v_b+7], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:1, v:3, num_a_c:16
    ds_read_b128 v[v_b+4:v_b+4+3], v[v_sld_b_os] offset:4608 ; i_r:1, i_b:0, i_k:2
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+8], v[v_b], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:2, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+9], v[v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:2, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+10], v[v_b+2], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:2, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+11], v[v_b+3], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:2, v:3, num_a_c:16
    ds_read_b128 v[v_b:v_b+3], v[v_sld_b_os] offset:6144 ; i_r:0, i_b:0, i_k:3
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+8], v[v_b+4], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:2, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+9], v[v_b+5], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:2, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+10], v[v_b+6], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:2, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+11], v[v_b+7], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:2, v:3, num_a_c:16
    ds_read_b128 v[v_b+4:v_b+4+3], v[v_sld_b_os] offset:6656 ; i_r:1, i_b:0, i_k:3
    s_waitcnt lgkmcnt(1) 
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+12], v[v_b], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:3, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+13], v[v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:3, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+14], v[v_b+2], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:3, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+0:a_c+15], v[v_gld_a+15], v[v_b+3], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, k:3, v:3, num_a_c:16
    s_waitcnt lgkmcnt(0) 
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+12], v[v_b+4], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:3, v:0, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+13], v[v_b+5], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:3, v:1, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+14], v[v_b+6], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:3, v:2, num_a_c:16
    v_mfma_f32_32x32x2f32 v[a_c+16:a_c+31], v[v_gld_a+15], v[v_b+7], v[a_c+16:a_c+31]     ; repeat:0x1, step:0x0, k:3, v:3, num_a_c:16
    s_nop 15
    s_nop 2
    v_mov_b32 v[v_in_hi_sshift], s[s_in_hi_sshift]
    s_mov_b32 s[s_tmp], 0
    v_mov_b32 v[v_in_wi_sshift], s[s_in_wi_sshift]
    ; coalescing store, mapping:mt_m:128, mt_n:64, wt_m:32, wt_n:32, ws:4, r_m:1, r_n:2, s_m:1, s_n:1 | 32x32x2, lanegroup_m_tcbw:4x2x4x1, lanegroup_n_tcbw:1x32x1x1
    ; coalescing_groups:4, num_dword_per_group:8
    ; init_co_sub_m_index xdlops, block_size:256, macro-tile:128x64 sub_m_index:[0, 4, 32, 36]
    ; g_mr:1, g_ms:1, g_mw:1, g_mb:4, g_mt:1 | l_mr:1, l_ms:1, l_mw:1, l_mb:1, l_mt:4 | n_mc:2, n_ml:1, n_mv:4
    ; nd_stride:[2, 1, 4, 1, 1, 4, 1]
    ; start group 0, i_g_mr:0, i_g_ms:0, i_g_mw:0, i_g_mb:0, i_g_mt:0, m index start from 0
    s_barrier
    ds_write_b128 v[v_co_sst], v[a_c:a_c+3]    ; idword:0(0,0),  0x0 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b128 v[v_co_sst], v[a_c+16:a_c+16+3] offset:512   ; idword:32(0,32),  0x32 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    v_add_u32 v[v_tmp], 0, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    s_waitcnt lgkmcnt(0)
    s_barrier
    ;   load from lds, i_ssgroup:0, num_sld_per_ssgroup:2
    ds_read_b128 v[v_c:v_c+3], v[v_co_sld] offset:0
    ds_read_b128 v[v_c+4:v_c+4+3], v[v_co_sld] offset:4096
    ;   store to global, m index start from 0, m0:0, m1:0
    s_waitcnt lgkmcnt(1)
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 1, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+1], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 2, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+2], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 3, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+3], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 64, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    s_waitcnt lgkmcnt(0)
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+4], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 65, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+5], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 66, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+6], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 67, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+7], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    ; start group 1, i_g_mr:0, i_g_ms:0, i_g_mw:0, i_g_mb:1, i_g_mt:0, m index start from 8
    s_barrier
    ds_write_b128 v[v_co_sst], v[a_c+4:a_c+4+3]    ; idword:0(0,0),  0x0 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b128 v[v_co_sst], v[a_c+20:a_c+20+3] offset:512   ; idword:32(0,32),  0x32 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    v_add_u32 v[v_tmp], 8, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    s_waitcnt lgkmcnt(0)
    s_barrier
    ;   load from lds, i_ssgroup:0, num_sld_per_ssgroup:2
    ds_read_b128 v[v_c:v_c+3], v[v_co_sld] offset:0
    ds_read_b128 v[v_c+4:v_c+4+3], v[v_co_sld] offset:4096
    ;   store to global, m index start from 8, m0:0, m1:8
    s_waitcnt lgkmcnt(1)
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 9, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+1], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 10, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+2], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 11, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+3], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 72, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    s_waitcnt lgkmcnt(0)
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+4], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 73, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+5], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 74, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+6], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 75, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+7], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    ; start group 2, i_g_mr:0, i_g_ms:0, i_g_mw:0, i_g_mb:2, i_g_mt:0, m index start from 16
    s_barrier
    ds_write_b128 v[v_co_sst], v[a_c+8:a_c+8+3]    ; idword:0(0,0),  0x0 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b128 v[v_co_sst], v[a_c+24:a_c+24+3] offset:512   ; idword:32(0,32),  0x32 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    v_add_u32 v[v_tmp], 16, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    s_waitcnt lgkmcnt(0)
    s_barrier
    ;   load from lds, i_ssgroup:0, num_sld_per_ssgroup:2
    ds_read_b128 v[v_c:v_c+3], v[v_co_sld] offset:0
    ds_read_b128 v[v_c+4:v_c+4+3], v[v_co_sld] offset:4096
    ;   store to global, m index start from 16, m0:0, m1:16
    s_waitcnt lgkmcnt(1)
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 17, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+1], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 18, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+2], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 19, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+3], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 80, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    s_waitcnt lgkmcnt(0)
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+4], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 81, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+5], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 82, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+6], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 83, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+7], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    ; start group 3, i_g_mr:0, i_g_ms:0, i_g_mw:0, i_g_mb:3, i_g_mt:0, m index start from 24
    s_barrier
    ds_write_b128 v[v_co_sst], v[a_c+12:a_c+12+3]    ; idword:0(0,0),  0x0 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b128 v[v_co_sst], v[a_c+28:a_c+28+3] offset:512   ; idword:32(0,32),  0x32 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    v_add_u32 v[v_tmp], 24, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    s_waitcnt lgkmcnt(0)
    s_barrier
    ;   load from lds, i_ssgroup:0, num_sld_per_ssgroup:2
    ds_read_b128 v[v_c:v_c+3], v[v_co_sld] offset:0
    ds_read_b128 v[v_c+4:v_c+4+3], v[v_co_sld] offset:4096
    ;   store to global, m index start from 24, m0:0, m1:24
    s_waitcnt lgkmcnt(1)
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 25, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+1], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 26, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+2], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 27, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+3], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 88, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    s_waitcnt lgkmcnt(0)
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+4], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 89, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+5], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 90, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+6], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
    v_add_u32 v[v_tmp], 91, v[v_in_inb]
    .mdiv_u32_rem_vs v_tmp+2,v_in_in,v_tmp,s_magic_3,s_shift_m3,s_dim_br,v_tmp+1
    .mdiv_u32_rem_vs v_in_iwi,v_in_ihi,v_tmp+2,s_magic_2,s_shift_m2,s_dslice_w,v_tmp+1
    v_mad_u32_u24 v[v_in_ihi], v[v_in_ihi], s[s_stride_h], v[v_in_hi_sshift]
    v_mad_u32_u24 v[v_in_iwi], v[v_in_iwi], s[s_stride_w], v[v_in_wi_sshift]
    v_mad_u32_u24 v[v_tmp+1], v[v_in_ihi], s[s_wi], v[v_in_iwi]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_wi], v[v_tmp+1]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_co_sub_n_index]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_u32 v[v_in_os], v[v_tmp+1], v[v_in_os]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp+1], 0, v[v_in_flag_c] vcc
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1] vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag] vcc
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_atomic_add_f32_m v[v_c+7], v[v_in_os], s[s_p_in:s_p_in+3], s[s_tmp] offen offset:0
    s_mov_b64 exec, -1
L_igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs_out:
    s_endpgm
.rodata
.p2align 6
.amdhsa_kernel igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs
    .amdhsa_group_segment_fixed_size 8192
    .amdhsa_user_sgpr_kernarg_segment_ptr 1
    .amdhsa_system_sgpr_workgroup_id_x 1
    .amdhsa_system_sgpr_workgroup_id_y 1
    .amdhsa_system_vgpr_workitem_id 0
    .amdhsa_next_free_vgpr 108
    .amdhsa_next_free_sgpr 86
    .amdhsa_ieee_mode 1
    .amdhsa_dx10_clamp 1
    .amdhsa_float_round_mode_32 3
    .amdhsa_float_round_mode_16_64 3
    .amdhsa_tg_split 0
    .amdhsa_accum_offset 76
.end_amdhsa_kernel

.amdgpu_metadata
---
amdhsa.version: [ 1, 0 ]
amdhsa.kernels:
  - .name: igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs
    .symbol: igemm_bwd_gtcx3_nhwc_fp32_bx0_ex1_bt128x64x32_wt32x32x2_ws1x1_wr1x2_ta1x16x1x1_1x2x4x32_tb1x4x2x1_1x8x1x32_pta_mh_gkgs.kd
    .sgpr_count: 92
    .vgpr_count: 108
    .kernarg_segment_align: 8
    .kernarg_segment_size: 168
    .group_segment_fixed_size: 8192
    .private_segment_fixed_size: 0
    .wavefront_size: 64
    .reqd_workgroup_size : [256, 1, 1]
    .max_flat_workgroup_size: 256
    .args:
    - { .name: p_in_     , .size: 8, .offset:   0, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: false}
    - { .name: p_wei_    , .size: 8, .offset:   8, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: true}
    - { .name: p_out_    , .size: 8, .offset:  16, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: true}
    - { .name: hi_       , .size: 4, .offset:  24, .value_kind: by_value, .value_type: i32}
    - { .name: wi_       , .size: 4, .offset:  28, .value_kind: by_value, .value_type: i32}
    - { .name: n_        , .size: 4, .offset:  32, .value_kind: by_value, .value_type: i32}
    - { .name: k_        , .size: 4, .offset:  36, .value_kind: by_value, .value_type: i32}
    - { .name: c_        , .size: 4, .offset:  40, .value_kind: by_value, .value_type: i32}
    - { .name: ho_       , .size: 4, .offset:  44, .value_kind: by_value, .value_type: i32}
    - { .name: wo_       , .size: 4, .offset:  48, .value_kind: by_value, .value_type: i32}
    - { .name: stride_h_ , .size: 4, .offset:  52, .value_kind: by_value, .value_type: i32}
    - { .name: stride_w_ , .size: 4, .offset:  56, .value_kind: by_value, .value_type: i32}
    - { .name: dilation_h_, .size: 4, .offset:  60, .value_kind: by_value, .value_type: i32}
    - { .name: dilation_w_, .size: 4, .offset:  64, .value_kind: by_value, .value_type: i32}
    - { .name: pad_h_    , .size: 4, .offset:  68, .value_kind: by_value, .value_type: i32}
    - { .name: pad_w_    , .size: 4, .offset:  72, .value_kind: by_value, .value_type: i32}
    - { .name: y_        , .size: 4, .offset:  76, .value_kind: by_value, .value_type: i32}
    - { .name: x_        , .size: 4, .offset:  80, .value_kind: by_value, .value_type: i32}
    - { .name: dtile_iy_ , .size: 4, .offset:  84, .value_kind: by_value, .value_type: i32}
    - { .name: dtile_ix_ , .size: 4, .offset:  88, .value_kind: by_value, .value_type: i32}
    - { .name: dtile_dy_ , .size: 4, .offset:  92, .value_kind: by_value, .value_type: i32}
    - { .name: dtile_dx_ , .size: 4, .offset:  96, .value_kind: by_value, .value_type: i32}
    - { .name: dtile_y_  , .size: 4, .offset: 100, .value_kind: by_value, .value_type: i32}
    - { .name: dtile_x_  , .size: 4, .offset: 104, .value_kind: by_value, .value_type: i32}
    - { .name: dtile_h_  , .size: 4, .offset: 108, .value_kind: by_value, .value_type: i32}
    - { .name: dtile_w_  , .size: 4, .offset: 112, .value_kind: by_value, .value_type: i32}
    - { .name: dslice_y_ , .size: 4, .offset: 116, .value_kind: by_value, .value_type: i32}
    - { .name: dslice_x_ , .size: 4, .offset: 120, .value_kind: by_value, .value_type: i32}
    - { .name: dslice_h_ , .size: 4, .offset: 124, .value_kind: by_value, .value_type: i32}
    - { .name: dslice_w_ , .size: 4, .offset: 128, .value_kind: by_value, .value_type: i32}
    - { .name: dslice_h_left_, .size: 4, .offset: 132, .value_kind: by_value, .value_type: i32}
    - { .name: dslice_w_left_, .size: 4, .offset: 136, .value_kind: by_value, .value_type: i32}
    - { .name: group_    , .size: 4, .offset: 140, .value_kind: by_value, .value_type: i32}
    - { .name: magic_0_  , .size: 4, .offset: 144, .value_kind: by_value, .value_type: i32}
    - { .name: magic_1_  , .size: 4, .offset: 148, .value_kind: by_value, .value_type: i32}
    - { .name: magic_2_  , .size: 4, .offset: 152, .value_kind: by_value, .value_type: i32}
    - { .name: magic_3_  , .size: 4, .offset: 156, .value_kind: by_value, .value_type: i32}
    - { .name: shift_pack_0_, .size: 4, .offset: 160, .value_kind: by_value, .value_type: i32}
    - { .name: ks_       , .size: 4, .offset: 164, .value_kind: by_value, .value_type: i32}
...
.end_amdgpu_metadata
