/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class MemberExpressionNode
extends Node {
    public Node base;
    public SelectorNode selector;
    public ReferenceValue ref = null;
    int authOrigToken = -1;

    public void setOrigToken(int token) {
        this.authOrigToken = token;
    }

    public int getOrigToken() {
        return this.authOrigToken;
    }

    public MemberExpressionNode(Node base, SelectorNode selector, int pos) {
        super(pos);
        this.base = base;
        this.selector = selector;
    }

    @Override
    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public void voidResult() {
        this.selector.voidResult();
    }

    @Override
    public boolean isMemberExpression() {
        return true;
    }

    public boolean isIndexedMemberExpression() {
        return this.selector.getMode() == -29;
    }

    @Override
    public BitSet getGenBits() {
        return this.selector.getGenBits();
    }

    @Override
    public BitSet getKillBits() {
        return this.selector.getKillBits();
    }

    @Override
    public String toString() {
        return "MemberExpression";
    }

    @Override
    public boolean isAttribute() {
        return this.selector.isAttribute();
    }

    @Override
    public boolean isLabel() {
        return this.base == null && this.selector.isGetExpression() && !(this.selector.expr instanceof QualifiedIdentifierNode);
    }

    public boolean isAny() {
        return this.selector.isAny();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.base == null && this.selector.hasAttribute(name);
    }

    @Override
    public StringBuilder toCanonicalString(Context cx, StringBuilder buf) {
        buf.append(DocCommentNode.getRefName(cx, this.ref));
        return buf;
    }

    @Override
    public boolean hasSideEffect() {
        return this.selector.hasSideEffect();
    }

    @Override
    public boolean isLValue() {
        return this.selector.isLValue();
    }

    @Override
    public boolean isConfigurationName() {
        return this.selector.isConfigurationName();
    }
}

