/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import macromedia.abc.AbcData;
import macromedia.abc.BytecodeBuffer;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.FunctionBuilder;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ParameterizedName;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Decimal128;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

public final class AbcParser {
    private Context ctx;
    private AbcData abcData;
    private static final boolean debug = false;
    private final Map<String, Integer> fun_names = new HashMap<String, Integer>();
    private final ObjectList<ObjectList<ClassDefinitionNode>> clsdefs_sets = new ObjectList();
    private final ObjectList<String> region_name_stack = new ObjectList();
    private ObjectList<Set<ReferenceValue>> ce_unresolved_sets = new ObjectList();
    private static ObjectValue dummyFunc = null;

    public AbcParser(Context cx, String name) throws IOException {
        this.ctx = cx;
        this.abcData = new AbcData("");
        this.abcData.readAbc(new BytecodeBuffer(name));
    }

    public AbcParser(Context cx, byte[] bytes) {
        this.ctx = cx;
        this.abcData = new AbcData("");
        this.abcData.readAbc(new BytecodeBuffer(bytes));
    }

    public ProgramNode parseAbc() {
        return this.parseAbc(false, false);
    }

    public ProgramNode parseAbc(boolean collectTopLevel, boolean buildASTForClasses) {
        try {
            BinaryProgramNode program = this.ctx.getNodeFactory().binaryProgram(this.ctx, this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null));
            GlobalBuilder b = new GlobalBuilder();
            b.is_in_package = true;
            program.frame = new ObjectValue(this.ctx, b, this.ctx.noType());
            this.ctx.pushScope(program.frame);
            this.clsdefs_sets.add(new ObjectList());
            this.ce_unresolved_sets.push_back(program.ce_unresolved);
            this.region_name_stack.push_back("");
            for (int i = 0; i < this.abcData.getScriptInfoSize(); ++i) {
                this.parseScript(i, program, collectTopLevel, buildASTForClasses);
            }
            program.clsdefs = this.clsdefs_sets.last();
            this.clsdefs_sets.removeLast();
            this.ce_unresolved_sets.removeLast();
            this.region_name_stack.pop_back();
            this.ctx.popScope();
            ProgramNode prog = this.ctx.getNodeFactory().program(this.ctx, this.ctx.getNodeFactory().statementList(null, program));
            return prog;
        }
        catch (Exception t) {
            ObjectValue scope = this.ctx.scope();
            ObjectValue global = this.ctx.globalScope();
            while (scope != global) {
                this.ctx.popScope();
                scope = this.ctx.scope();
            }
            return null;
        }
    }

    private TypeValue getTypeFromQName(int typeID) {
        if (typeID == 0) {
            return this.ctx.noType();
        }
        QName typename = this.getFullName(this.getBinaryMNFromCPool(typeID));
        if (this.ctx.isBuiltin(typename.toString())) {
            return this.ctx.builtin(typename.toString());
        }
        TypeValue type = TypeValue.getTypeValue(this.ctx, typename);
        if (!type.resolved) {
            this.ce_unresolved_sets.last().add(new ReferenceValue(this.ctx, null, typename.name, typename.ns));
        }
        return TypeValue.getTypeValue(this.ctx, typename);
    }

    private DefAndSlot slotTrait(String name, ObjectValue ns, int slotID, int typeID, int valueID, int value_kind, boolean is_const, boolean build_ast) {
        ObjectValue obj = this.ctx.scope();
        DefAndSlot ret = new DefAndSlot();
        Namespaces nss = new Namespaces();
        nss.push_back(ns);
        TypeValue type = this.getTypeFromQName(typeID);
        int var_id = obj.builder.Variable(this.ctx, obj);
        int slot_id = obj.builder.ExplicitVar(this.ctx, obj, name, nss, type, -1, -1, var_id);
        Slot slot = obj.getSlot(this.ctx, slot_id);
        slot.setConst(is_const);
        slot.setImported(true);
        ret.slot = slot;
        IdentifierNode id = null;
        AttributeListNode attr = null;
        if (build_ast) {
            id = this.identifierNode(name, ns);
            attr = this.attributeList(false, false, false, ns, obj.builder);
        }
        if (value_kind == 8) {
            ObjectValue nsValue = this.getNamespace(valueID);
            slot.setObjectValue(nsValue);
            slot.setConst(true);
            if (build_ast) {
                ret.def = this.ctx.getNodeFactory().namespaceDefinition(attr, id, this.ctx.getNodeFactory().literalString(nsValue.name));
            }
            return ret;
        }
        if (valueID != 0) {
            slot.setObjectValue(this.getInitValue(valueID, value_kind));
        }
        if (build_ast) {
            MemberExpressionNode typeExpr = null;
            if (typeID != 0) {
                AbcData.BinaryMN t = this.getBinaryMNFromCPool(typeID);
                typeExpr = this.memberExprFromMN(t);
            }
            Node init = this.getInitValueNode(valueID, value_kind);
            TypedIdentifierNode ty = this.ctx.getNodeFactory().typedIdentifier(id, typeExpr);
            int tok = is_const ? -65 : -112;
            VariableBindingNode bind = this.ctx.getNodeFactory().variableBinding(attr, tok, ty, init);
            bind.ref = id.ref;
            if (typeExpr != null) {
                bind.typeref = typeExpr.ref;
            }
            ret.def = this.ctx.getNodeFactory().variableDefinition(attr, tok, this.ctx.getNodeFactory().list(null, bind));
        }
        return ret;
    }

    private MemberExpressionNode memberExprFromMN(AbcData.BinaryMN mn) {
        MemberExpressionNode typeExpr = null;
        QName typeName = this.getFullName(mn);
        NodeFactory nf = this.ctx.getNodeFactory();
        if (typeName instanceof ParameterizedName) {
            ParameterizedName pn = (ParameterizedName)typeName;
            IdentifierNode baseIdNode = this.identifierNode(pn.name, pn.ns);
            MemberExpressionNode param_node = this.memberExprFromMN(this.getBinaryMNFromCPool(mn.params[0]));
            ListNode list = nf.list(null, param_node);
            Node apply = nf.applyTypeExpr(baseIdNode, list, -1);
            typeExpr = nf.memberExpression(null, (SelectorNode)apply);
            typeExpr.ref = baseIdNode.ref;
            typeExpr.ref.addTypeParam(param_node.ref);
        } else {
            IdentifierNode typeIdNode = this.identifierNode(typeName.name, typeName.ns);
            GetExpressionNode getNode = nf.getExpression(typeIdNode);
            typeExpr = nf.memberExpression(null, getNode);
            typeExpr.ref = typeIdNode.ref;
        }
        return typeExpr;
    }

    private IdentifierNode identifierNode(String simpleName, ObjectValue ns) {
        IdentifierNode id = this.ctx.getNodeFactory().identifier(simpleName);
        id.ref = new ReferenceValue(this.ctx, null, id.name, ns);
        return id;
    }

    private DefAndSlot methodTrait(String methodName, ObjectValue ns, int dispID, int methInfo, int attrs, int kind, boolean build_ast) {
        int functionKind;
        int method_slot;
        ObjectValue obj = this.ctx.scope();
        DefAndSlot ret = new DefAndSlot();
        boolean isFinal = (attrs & 1) != 0;
        boolean isOverride = (attrs & 2) != 0;
        Namespaces names = new Namespaces(ns);
        int method_id = obj.builder.Method(this.ctx, obj, methodName, names, false);
        NodeFactory nf = this.ctx.getNodeFactory();
        switch (kind) {
            case 3: {
                method_slot = obj.builder.ExplicitSet(this.ctx, obj, methodName, names, this.ctx.noType(), isFinal, isOverride, -1, method_id, -1);
                break;
            }
            case 2: {
                method_slot = obj.builder.ExplicitGet(this.ctx, obj, methodName, names, this.ctx.noType(), isFinal, isOverride, -1, method_id, -1);
                break;
            }
            default: {
                method_slot = obj.builder.ExplicitCall(this.ctx, obj, methodName, names, this.ctx.noType(), isFinal, isOverride, -1, method_id, -1);
            }
        }
        ObjectValue funcObj = this.getFunctionObject();
        Slot slot = obj.getSlot(this.ctx, method_slot);
        slot.setValue(funcObj);
        slot.setImported(true);
        StringBuilder internal_name = new StringBuilder(methodName.length() + 5);
        if (!this.fun_names.containsKey(methodName)) {
            this.fun_names.put(methodName, 0);
        }
        internal_name.append(methodName).append('$');
        int num = this.fun_names.get(methodName);
        internal_name.append(num);
        this.fun_names.put(methodName, ++num);
        int slot_id = obj.getImplicitIndex(this.ctx, method_slot, -133);
        Slot implied_slot = obj.getSlot(this.ctx, slot_id);
        implied_slot.setImported(true);
        String n = internal_name.toString();
        implied_slot.setMethodName(n);
        ret.slot = implied_slot;
        switch (kind) {
            case 2: {
                functionKind = -79;
                break;
            }
            case 3: {
                functionKind = -99;
                break;
            }
            default: {
                functionKind = -133;
            }
        }
        AbcData.Method m_info = this.abcData.getMethod(methInfo);
        int returnTypeID = m_info.getReturnType();
        int[] paramTypeIDs = m_info.getParamTypes();
        int paramCount = paramTypeIDs.length;
        ObjectList<Node> optional_nodes = null;
        int optional_count = 0;
        if (m_info.getHasOptional()) {
            if (build_ast) {
                optional_nodes = this.parseOptionalParams(m_info);
            }
            optional_count = m_info.getOptionalParamTypes().length;
        }
        String[] param_names = m_info.getParamNames();
        implied_slot.setType(this.getTypeFromQName(returnTypeID).getDefaultTypeInfo());
        ParameterListNode paramList = null;
        ObjectList<TypeInfo> param_types = new ObjectList<TypeInfo>(paramCount);
        ByteList decl_styles = new ByteList(1);
        int cur_optional = 0;
        for (int i = 0; i < paramCount; ++i) {
            ParameterNode param = null;
            if (build_ast) {
                AbcData.BinaryMN typeMN = null;
                if (paramTypeIDs[i] != 0) {
                    typeMN = this.getBinaryMNFromCPool(paramTypeIDs[i]);
                }
                String simple_param_name = i < param_names.length && param_names[i] != null ? param_names[i] : ("param" + (i + 1)).intern();
                param = this.parameterNode(simple_param_name, typeMN);
                paramList = nf.parameterList(paramList, param);
            }
            param_types.push_back(this.getTypeFromQName(paramTypeIDs[i]).getDefaultTypeInfo());
            if (i >= paramCount - optional_count) {
                if (build_ast) {
                    param.init = (Node)optional_nodes.get(cur_optional++);
                }
                decl_styles.push_back((byte)1);
                continue;
            }
            decl_styles.push_back((byte)0);
        }
        if (m_info.getNeedsRest()) {
            if (build_ast) {
                ParameterNode param = this.parameterNode("rest", this.ctx.arrayType().name);
                RestParameterNode restNode = this.ctx.getNodeFactory().restParameter(param, -1);
                restNode.ref = param.ref;
                restNode.typeref = param.typeref;
                paramList = nf.parameterList(paramList, restNode);
                this.ctx.getNodeFactory().has_rest = false;
            }
            param_types.push_back(this.ctx.arrayType().getDefaultTypeInfo());
            decl_styles.push_back((byte)2);
        }
        if (param_types.size() > 0) {
            implied_slot.setTypes(param_types);
            implied_slot.setDeclStyles(decl_styles);
        } else {
            param_types.push_back(this.ctx.voidType().getDefaultTypeInfo());
            implied_slot.setTypes(param_types);
            implied_slot.addDeclStyle(3);
        }
        if (build_ast) {
            MemberExpressionNode retTypeNode = null;
            if (returnTypeID != 0) {
                AbcData.BinaryMN retMN = this.getBinaryMNFromCPool(returnTypeID);
                retTypeNode = this.memberExprFromMN(retMN);
            }
            FunctionSignatureNode fsn = nf.functionSignature(paramList, retTypeNode);
            if (retTypeNode != null) {
                fsn.typeref = retTypeNode.ref;
            }
            IdentifierNode id = this.identifierNode(methodName, ns);
            FunctionCommonNode fcn = nf.functionCommon(this.ctx, id, fsn, null);
            fcn.kind = functionKind;
            fcn.ref = id.ref;
            FunctionNameNode fn = nf.functionName(functionKind, id);
            AttributeListNode attr = this.attributeList(isFinal, isOverride, false, ns, obj.builder);
            BinaryFunctionDefinitionNode fdn = nf.binaryFunctionDefinition(this.ctx, attr, fn, fcn, -1);
            ret.def = fdn;
        }
        return ret;
    }

    private ObjectValue getFunctionObject() {
        if (dummyFunc == null) {
            dummyFunc = new ObjectValue(this.ctx, new FunctionBuilder(), this.ctx.functionType());
        }
        return dummyFunc;
    }

    private Node getInitValueNode(int valueID, int kind) {
        Node t;
        NodeFactory nf = this.ctx.getNodeFactory();
        switch (kind) {
            case 0: {
                t = nf.unaryExpression(-113, nf.literalNumber("0", -1), -1);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                double val = this.getNumberFromCPool(valueID, kind);
                t = nf.literalNumber(String.valueOf(val));
                break;
            }
            case 2: {
                Decimal128 dval = this.getDecimalFromCPool(valueID);
                String sval = dval.toString();
                if (this.ctx.statics.es4_numerics) {
                    sval = sval + "m";
                }
                t = nf.literalNumber(sval);
                break;
            }
            case 11: {
                t = nf.literalBoolean(true);
                break;
            }
            case 10: {
                t = nf.literalBoolean(false);
                break;
            }
            case 1: {
                t = nf.literalString(this.getStringFromCPool(valueID));
                break;
            }
            case 12: {
                t = nf.literalNull();
                break;
            }
            case 8: {
                ObjectValue ns = this.getNamespace(valueID);
                t = nf.literalString(ns.name);
                break;
            }
            default: {
                t = nf.literalString("");
            }
        }
        return t;
    }

    private ObjectValue getInitValue(int valueID, int kind) {
        ObjectValue ov;
        switch (kind) {
            case 0: {
                ov = this.ctx.voidType().prototype;
                break;
            }
            case 3: {
                double intval = this.getNumberFromCPool(valueID, kind);
                ov = new ObjectValue(String.valueOf(intval), this.ctx.intType());
                break;
            }
            case 4: {
                double uintval = this.getNumberFromCPool(valueID, kind);
                ov = new ObjectValue(String.valueOf(uintval), this.ctx.uintType());
                break;
            }
            case 6: {
                double val = this.getNumberFromCPool(valueID, kind);
                ov = new ObjectValue(String.valueOf(val), this.ctx.doubleType());
                break;
            }
            case 2: {
                Decimal128 dval = this.getDecimalFromCPool(valueID);
                String sval = dval.toString();
                if (this.ctx.statics.es4_numerics) {
                    sval = sval + "m";
                }
                ov = new ObjectValue(sval, this.ctx.decimalType());
                break;
            }
            case 11: {
                ov = this.ctx.booleanTrue();
                break;
            }
            case 10: {
                ov = this.ctx.booleanFalse();
                break;
            }
            case 1: {
                ov = new ObjectValue(this.getStringFromCPool(valueID), this.ctx.stringType());
                break;
            }
            case 12: {
                ov = this.ctx.nullType().prototype;
                break;
            }
            case 8: {
                ObjectValue ns;
                ov = ns = this.getNamespace(valueID);
                break;
            }
            default: {
                ov = null;
            }
        }
        return ov;
    }

    private ObjectList<Node> parseOptionalParams(AbcData.Method method_info) {
        int[] optional_values = method_info.getOptionalParamTypes();
        int[] optional_kinds = method_info.getOptionalParamKinds();
        ObjectList<Node> optionals = new ObjectList<Node>(optional_values.length);
        for (int i = 0; i < optional_values.length; ++i) {
            int value_index = optional_values[i];
            int value_kind = optional_kinds[i];
            Node current_node = this.getInitValueNode(value_index, value_kind);
            optionals.push_back(current_node);
        }
        return optionals;
    }

    private ParameterNode parameterNode(String simpleParamName, QName typeName) {
        IdentifierNode id = this.identifierNode(simpleParamName, this.ctx.publicNamespace());
        IdentifierNode ty = null;
        MemberExpressionNode paramType = null;
        if (typeName != null) {
            ty = this.identifierNode(typeName.name, typeName.ns);
            GetExpressionNode getNode = this.ctx.getNodeFactory().getExpression(ty);
            paramType = this.ctx.getNodeFactory().memberExpression(null, getNode);
        }
        ParameterNode param = this.ctx.getNodeFactory().parameter(-112, id, paramType);
        if (ty != null) {
            param.typeref = ty.ref;
        }
        param.ref = id.ref;
        return param;
    }

    private ParameterNode parameterNode(String simpleParamName, AbcData.BinaryMN typeMN) {
        IdentifierNode id = this.identifierNode(simpleParamName, this.ctx.publicNamespace());
        MemberExpressionNode paramType = null;
        if (typeMN != null) {
            paramType = this.memberExprFromMN(typeMN);
        }
        ParameterNode param = this.ctx.getNodeFactory().parameter(-112, id, paramType);
        if (paramType != null) {
            param.typeref = paramType.ref;
        }
        param.ref = id.ref;
        return param;
    }

    private AttributeListNode attributeList(boolean isFinal, boolean isOverride, boolean isDynamic, ObjectValue ns, Builder builder) {
        AttributeListNode attr = this.ctx.getNodeFactory().attributeList(this.ctx.getNodeFactory().literalString(""), null);
        attr.hasFinal = isFinal;
        attr.hasOverride = isOverride;
        attr.hasDynamic = isDynamic;
        if (builder instanceof ClassBuilder) {
            attr.hasStatic = true;
        }
        if (ns == null) {
            return attr;
        }
        if (ns == this.ctx.publicNamespace() || ns.getNamespaceKind() == 0 && ns.isPackage()) {
            attr.hasPublic = true;
        } else if (ns.isInternal()) {
            attr.hasInternal = true;
        } else if (ns.isProtected()) {
            attr.hasProtected = true;
        } else if (ns.isPrivate()) {
            attr.hasPrivate = true;
        } else if (builder.classname != null && ns == builder.classname.ns) {
            attr.hasPublic = true;
        } else {
            attr.namespaces.add(ns);
        }
        return attr;
    }

    private QName getFullName(AbcData.BinaryMN mn) {
        if (mn.kind == 29) {
            AbcData.BinaryMN base = this.getBinaryMNFromCPool(mn.baseMN);
            QName base_qn = this.getFullName(base);
            ObjectList<QName> params = new ObjectList<QName>(mn.params.length);
            for (int i = 0; i < mn.params.length; ++i) {
                params.add(this.getFullName(this.getBinaryMNFromCPool(mn.params[i])));
            }
            ParameterizedName pn = new ParameterizedName(params, base_qn.ns, base_qn.name);
            return pn;
        }
        assert (!mn.nsIsSet) : "expected a single namespace";
        String fullName = this.getStringFromCPool(mn.nameID);
        ObjectValue ns = this.getNamespace(mn.nsID);
        return this.ctx.computeQualifiedName("", fullName, ns, -133);
    }

    private DefAndSlot classTrait(String className, ObjectValue ns, int slotID, int classID, boolean build_ast) {
        int implied_idx;
        Slot class_slot;
        ObjectValue iframe;
        TypeValue cframe;
        if (classID >= this.abcData.getClassInfoSize() || classID < 0) {
            return null;
        }
        DefAndSlot ret = new DefAndSlot();
        ObjectValue current_scope = this.ctx.scope();
        String region_name = this.region_name_stack.back();
        if (region_name.length() > 0) {
            region_name = region_name + "/";
            ns = this.ctx.getNamespace(region_name + ns.name);
        }
        NodeFactory nf = this.ctx.getNodeFactory();
        AbcData.InstanceInfo iinfo = this.abcData.getInstanceInfo(classID);
        AbcData.BinaryMN instanceMN = this.getBinaryMNFromCPool(iinfo.getInstanceNameID());
        QName fullName = this.getFullName(instanceMN);
        String fullNameString = fullName.toString();
        int superID = iinfo.getSuperID();
        boolean hasSuper = superID != 0;
        QName superName = null;
        String simpleSuperName = "";
        ObjectValue superNamespace = null;
        if (hasSuper) {
            AbcData.BinaryMN superMN = this.getBinaryMNFromCPool(superID);
            assert (!superMN.nsIsSet) : "expected a single namespace";
            superNamespace = this.getNamespace(superMN.nsID);
            superName = this.getFullName(superMN);
            simpleSuperName = this.getStringFromCPool(superMN.nameID);
        }
        int flags = iinfo.getFlags();
        int[] interfaces = iinfo.getInterfaces();
        ListNode interface_nodes = null;
        for (int i = 0; i < interfaces.length; ++i) {
            Namespaces intNamespaces;
            int int_index = interfaces[i];
            AbcData.BinaryMN intMN = this.getBinaryMNFromCPool(int_index);
            String simpleIntName = this.getStringFromCPool(intMN.nameID);
            if (intMN.nsIsSet) {
                intNamespaces = this.getNamespaces(intMN.nsID);
            } else {
                intNamespaces = new Namespaces(1);
                intNamespaces.add(this.getNamespace(intMN.nsID));
            }
            IdentifierNode ident = nf.identifier(simpleIntName);
            ident.ref = new ReferenceValue(this.ctx, null, simpleIntName, intNamespaces);
            GetExpressionNode getNode = nf.getExpression(ident);
            MemberExpressionNode interface_node = nf.memberExpression(null, getNode);
            interface_node.ref = ident.ref;
            interface_nodes = nf.list(interface_nodes, interface_node);
            interface_nodes.values.push_back(ident.ref);
        }
        boolean isFinal = (flags & 2) != 0;
        boolean isDynamic = (flags & 1) == 0;
        boolean isInterface = (flags & 4) != 0;
        BinaryClassDefNode cdn = null;
        IdentifierNode idNode = nf.identifier(className);
        idNode.ref = new ReferenceValue(this.ctx, null, idNode.name, ns);
        AttributeListNode attr = this.attributeList(isFinal, false, isDynamic, ns, current_scope.builder);
        StatementListNode stmtList = nf.statementList((StatementListNode)null, (StatementListNode)null);
        cdn = isInterface ? nf.binaryInterfaceDefinition(this.ctx, attr, idNode, null, stmtList) : nf.binaryClassDefinition(this.ctx, attr, idNode, null, stmtList);
        cdn.ref = idNode.ref;
        cdn.interfaces = interface_nodes;
        cdn.public_namespace = this.ctx.publicNamespace();
        cdn.protected_namespace = this.ctx.getNamespace(fullNameString, (byte)3);
        cdn.static_protected_namespace = this.ctx.getNamespace(fullNameString, (byte)5);
        cdn.private_namespace = this.ctx.getNamespace(fullNameString, (byte)2);
        cdn.default_namespace = this.ctx.getNamespace(fullName.ns.name, (byte)1);
        boolean is_builtin = this.ctx.isBuiltin(fullNameString);
        if (is_builtin) {
            cframe = this.ctx.builtin(fullNameString);
            iframe = cframe.prototype;
        } else {
            ClassBuilder cb = new ClassBuilder(fullName, cdn.protected_namespace, cdn.static_protected_namespace);
            cframe = TypeValue.defineTypeValue(this.ctx, cb, fullName, 8192);
            InstanceBuilder ib = new InstanceBuilder(fullName);
            ib.canEarlyBind = false;
            cframe.prototype = iframe = new ObjectValue(this.ctx, ib, cframe);
            cdn.debug_name = fullNameString;
            cdn.owns_cframe = true;
        }
        cdn.cframe = cframe;
        cdn.iframe = iframe;
        if (isInterface) {
            ((ClassBuilder)cframe.builder).is_interface = true;
        }
        cframe.builder.is_dynamic = iframe.builder.is_dynamic = isDynamic;
        cframe.builder.is_final = iframe.builder.is_final = isFinal;
        this.clsdefs_sets.last().add(cdn);
        if (hasSuper) {
            cdn.baseclass = nf.literalString(superName.toString(), -1);
            if (this.ctx.isBuiltin(superName.toString())) {
                TypeValue superType;
                cframe.baseclass = superType = this.ctx.builtin(superName.toString());
                cdn.baseref = new ReferenceValue(this.ctx, null, superName.toString(), this.ctx.publicNamespace());
            } else {
                cdn.baseref = new ReferenceValue(this.ctx, null, simpleSuperName, superNamespace);
                cdn.baseref.getSlot(this.ctx);
                cframe.baseclass = this.getTypeFromQName(superID);
            }
        } else if (cdn.cframe != this.ctx.objectType()) {
            cdn.baseclass = nf.memberExpression(null, nf.getExpression(nf.identifier("Object")));
            cframe.baseclass = this.ctx.objectType();
        } else {
            cdn.baseclass = null;
            cframe.baseclass = null;
        }
        int var_id = current_scope.builder.Variable(this.ctx, current_scope);
        int slot_id = current_scope.builder.ExplicitVar(this.ctx, current_scope, className, ns, this.ctx.typeType(), -1, -1, var_id);
        Slot slot = current_scope.getSlot(this.ctx, slot_id);
        slot.setObjectValue(cframe);
        slot.setImported(true);
        slot.setConst(true);
        ret.slot = slot;
        current_scope.builder.ImplicitCall(this.ctx, current_scope, slot_id, cframe, 16, -1, -1);
        current_scope.builder.ImplicitConstruct(this.ctx, current_scope, slot_id, cframe, 16, -1, -1);
        if (isInterface) {
            ((ClassBuilder)cframe.builder).is_interface = true;
            slot.setImplNode(cdn);
        }
        this.clsdefs_sets.add(new ObjectList());
        this.region_name_stack.push_back(fullNameString);
        this.ctx.pushStaticClassScopes(cdn);
        this.ctx.pushScope(iframe);
        StatementListNode instance_stmts = nf.statementList((StatementListNode)null, (StatementListNode)null);
        this.parseTraits(iinfo.getITraits(), instance_stmts, build_ast, null, build_ast);
        cdn.instanceinits = new ObjectList(instance_stmts.items.size());
        if (instance_stmts.items.size() > 0) {
            cdn.instanceinits.addAll(instance_stmts.items);
        }
        DefAndSlot d = this.methodTrait("$construct", this.ctx.publicNamespace(), 0, iinfo.getInitIndex(), 0, 0, build_ast);
        DefinitionNode iinit_node = d.def;
        if (build_ast) {
            cdn.instanceinits.add(iinit_node);
        }
        if ((class_slot = current_scope.getSlot(this.ctx, implied_idx = current_scope.getImplicitIndex(this.ctx, slot_id, -92))) != null) {
            class_slot.setTypes(d.slot.getTypes());
            class_slot.setDeclStyles(d.slot.getDeclStyles());
        }
        this.ctx.popScope();
        AbcData.ClassInfo cinfo = this.abcData.getClassInfo(classID);
        this.parseTraits(cinfo.getCTraits(), cdn.statements, build_ast, null, build_ast);
        this.ctx.popStaticClassScopes(cdn);
        this.clsdefs_sets.removeLast();
        this.region_name_stack.pop_back();
        ret.def = cdn;
        return ret;
    }

    private void parseTraits(AbcData.Trait[] traits, StatementListNode statements, boolean build_ast, BinaryProgramNode prog, boolean buildASTForClasses) {
        for (AbcData.Trait t : traits) {
            int[] metadata;
            AbcData.BinaryMN mn = this.getBinaryMNFromCPool(t.getNameIndex());
            String name = this.getStringFromCPool(mn.nameID);
            ObjectValue ns = this.getNamespaceFromMultiname(mn);
            DefAndSlot d = null;
            switch (t.getTag()) {
                case 0: 
                case 6: {
                    d = this.slotTrait(name, ns, t.getSlotId(), t.getTypeName(), t.getValueIndex(), t.getValueKind(), t.isConstTrait(), build_ast);
                    if (build_ast) {
                        statements.items.add(d.def);
                    }
                    if (prog == null) break;
                    prog.toplevelDefinitions.add(new QName(ns, name));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    d = this.methodTrait(name, ns, t.getDispId(), t.getMethodId(), t.getAttrs(), t.getTag(), build_ast);
                    if (build_ast) {
                        statements.items.add(d.def);
                    }
                    if (prog == null) break;
                    prog.toplevelDefinitions.add(new QName(ns, name));
                    break;
                }
                case 4: {
                    d = this.classTrait(name, ns, t.getSlotId(), t.getClassId(), buildASTForClasses);
                    if (prog == null) break;
                    prog.toplevelDefinitions.add(new QName(ns, name));
                    break;
                }
                case 5: {
                    break;
                }
            }
            if (!t.hasMetadata() || d == null) continue;
            for (int metaIndex : metadata = t.getMetadata()) {
                String md_id;
                MetaDataNode metaNode = this.parseMetadataInfo(metaIndex);
                if (d.def != null) {
                    metaNode.def = d.def;
                    d.def.addMetaDataNode(metaNode);
                    if (build_ast) {
                        statements.items.add(metaNode);
                    }
                }
                if (d.slot == null || "__go_to_ctor_definition_help" == (md_id = metaNode.getId()) || "__go_to_definition_help" == md_id) continue;
                d.slot.addMetadata(metaNode);
            }
        }
    }

    private ObjectValue getNamespaceFromMultiname(AbcData.BinaryMN mn) {
        ObjectValue ns;
        if (mn.nsIsSet) {
            Namespaces ns_set = this.getNamespaces(mn.nsID);
            if (ns_set.size() > 1) {
                ns = null;
                for (ObjectValue t : ns_set) {
                    if (ns != null && t.name.length() >= ns.name.length()) continue;
                    ns = t;
                }
            } else {
                ns = (ObjectValue)ns_set.at(0);
            }
        } else {
            ns = this.getNamespace(mn.nsID);
        }
        return ns;
    }

    private void parseScript(int scriptIndex, BinaryProgramNode program, boolean collectTopLevel, boolean buildASTForClasses) {
        if (scriptIndex < 0 || scriptIndex >= this.abcData.getScriptInfoSize()) {
            return;
        }
        AbcData.ScriptInfo s = this.abcData.getScriptInfo(scriptIndex);
        this.parseTraits(s.getScriptTraits(), program.statements, true, collectTopLevel ? program : null, buildASTForClasses);
    }

    private MetaDataNode parseMetadataInfo(int index) {
        MetaDataNode metaNode = this.ctx.getNodeFactory().metaData(null, -1);
        metaNode.setMetadata(this.abcData.getMetadata(index, metaNode));
        return metaNode;
    }

    private String getStringFromCPool(int id) {
        return this.abcData.getString(id);
    }

    private Decimal128 getDecimalFromCPool(int id) {
        return this.abcData.getDecimal(id);
    }

    private double getNumberFromCPool(int id, int kind) {
        double ret = 0.0;
        switch (kind) {
            case 3: {
                ret = this.abcData.getInt(id);
                return ret;
            }
            case 4: {
                ret = this.abcData.getUint(id) & 0xFFFFFFFFL;
                return ret;
            }
            case 6: {
                ret = this.abcData.getDouble(id);
                return ret;
            }
        }
        return ret;
    }

    private AbcData.BinaryMN getBinaryMNFromCPool(int index) {
        return this.abcData.getName(index);
    }

    Namespaces getNamespaces(int namespaceSetID) {
        int[] ns_ids = this.abcData.getNamespaceSet(namespaceSetID).getNamespaceIds();
        Namespaces val = new Namespaces(ns_ids.length);
        for (int i = 0; i < ns_ids.length; ++i) {
            val.add(this.getNamespace(ns_ids[i]));
        }
        return val;
    }

    ObjectValue getNamespace(int namespaceID) {
        ObjectValue ns = null;
        if (namespaceID == 0) {
            ns = this.ctx.anyNamespace();
        } else {
            byte kind = this.abcData.getNamespace((int)namespaceID).nsKind;
            String uri = this.abcData.getNamespace(namespaceID).getName();
            int ver = -1;
            switch (kind) {
                case 8: {
                    boolean ns_kind = false;
                    ns = this.ctx.getNamespace(uri);
                    break;
                }
                case 22: {
                    boolean ns_kind = false;
                    ns = this.ctx.getNamespace(uri);
                    ns.setPackage(true);
                    break;
                }
                case 24: {
                    byte ns_kind = 3;
                    ns = this.ctx.getNamespace(uri, ns_kind);
                    break;
                }
                case 23: {
                    byte ns_kind = 1;
                    ns = this.ctx.getNamespace(uri, ns_kind);
                    break;
                }
                case 5: {
                    byte ns_kind = 2;
                    ns = this.ctx.getNamespace(uri, ns_kind);
                    break;
                }
                case 25: {
                    byte ns_kind = 4;
                    ns = this.ctx.getNamespace(uri, ns_kind);
                    break;
                }
                case 26: {
                    byte ns_kind = 5;
                    ns = this.ctx.getNamespace(uri, ns_kind);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid kind:" + Integer.toString(kind));
                }
            }
        }
        return ns;
    }

    public static void main(String[] args) throws Throwable {
        File abcFile = new File(args[0]);
        byte[] bytes = AbcParser.getBytesFromFile(abcFile);
        TypeValue.init();
        ObjectValue.init();
        Context ctx = new Context(new ContextStatics());
        AbcParser abcParser = new AbcParser(ctx, bytes);
        ProgramNode programNode = abcParser.parseAbc();
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        is.close();
        return bytes;
    }

    private static class DefAndSlot {
        public DefinitionNode def;
        public Slot slot;

        private DefAndSlot() {
        }
    }
}

