/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.GlobalOptimizer;

class Namespace
implements Comparable<Namespace> {
    final int kind;
    final String uri;
    private final String comparableUri;

    Namespace(String uri) {
        this(8, uri);
    }

    Namespace(int kind, String uri) {
        this.kind = kind;
        this.uri = uri;
        this.comparableUri = this.isPrivate() ? GlobalOptimizer.unique() : uri;
    }

    boolean isPublic() {
        return (this.kind == 8 || this.kind == 22) && "".equals(this.uri);
    }

    boolean isInternal() {
        return this.kind == 23;
    }

    boolean isPrivate() {
        return this.kind == 5;
    }

    boolean isPrivateOrInternal() {
        return this.isPrivate() || this.isInternal();
    }

    boolean isProtected() {
        return this.kind == 24 || this.kind == 26;
    }

    public String toString() {
        return this.uri.length() > 0 ? this.uri : "public";
    }

    public int hashCode() {
        return this.kind ^ this.uri.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace)o;
        return this.kind == other.kind && this.comparableUri.equals(other.comparableUri);
    }

    @Override
    public int compareTo(Namespace other) {
        if (other == null) {
            return 1;
        }
        int i = this.kind - other.kind;
        if (i != 0) {
            return i;
        }
        return this.comparableUri.compareTo(other.comparableUri);
    }
}

