/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 95158055904821L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1239528990 - 17116, -1239528990 - -32173, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1239528990 - 17115, 1239528990 - 20576, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 19168905365716L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.t();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-466347060 - -16853, -466347060 + -5795, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-466347060 - -16852, 466347060 - 12160, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-466347060 - -16859, 466347060 - 7668, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String[] stringArray;
                l2 = 39333379523212L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    stringArray = SshAgentIpcService.t();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-69073890 - -((char)-27680), -69073890 - -((char)-1835), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-69073890 - -((char)-27681), -69073890 - -((char)-16675), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-69073890 - -((char)-27682), -69073890 - -((char)-17922), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-69073890 - -((char)-27691), -69073890 - -((char)-5683), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-69073890 - -((char)-27692), 69073890 - (char)-3867, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-69073890 - -((char)-27693), -69073890 - -((char)-15768), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-69073890 - -((char)-27691), -69073890 - -((char)-5683), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-69073890 - -((char)-27694), 69073890 - (char)-21151, (int)l2));
            if (ActionTimestamp.t() == null) {
                SshAgentIpcService.t(new String[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 56278412857001L;
                    stringArray = SshAgentIpcService.t();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 53455125041213L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                stringArray = SshAgentIpcService.t();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(37879230 + (char)-30840, -37879230 + -((char)-14407), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(37879230 + (char)-30844, 38010300 - (char)-414, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(37879230 + (char)-30839, 37879230 + (char)-1183, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(37879230 + (char)-30844, 38010300 - (char)-414, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(37879230 + (char)-30842, -37879230 + -((char)-1081), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(37879230 + (char)-30840, -37879230 + -((char)-14407), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(37879230 + (char)-30844, 38010300 - (char)-414, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(37879230 + (char)-30841, -37879230 + -((char)-15294), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(37879230 + (char)-30840, -37879230 + -((char)-14407), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(37879230 + (char)-30844, 38010300 - (char)-414, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(37879230 + (char)-30820, -37879230 + -((char)-14482), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(37879230 + (char)-30844, 38010300 - (char)-414, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(37879230 + (char)-30819, 37879230 + (char)-16962, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(37879230 + (char)-30844, 38010300 - (char)-414, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(37879230 + (char)-30842, -37879230 + -((char)-1081), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(37879230 + (char)-30840, -37879230 + -((char)-14407), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(37879230 + (char)-30844, 38010300 - (char)-414, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(37879230 + (char)-30822, -37879230 + -((char)-28396), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 136861345638913L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-2082178020 + -((char)-19885), 2082178020 + (char)-9913, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 53385162848572L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1280684970 - -((char)-29025), -1280684970 - -((char)-22844), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\r\u00b8_z+u\u00d7\u00cc\u0092=\u00f4\u000f\u00e9!0*/m\u0010\u0014\"h\u00baf\u008c4^a!\u008eG\u00ad]\u008cg\u0014(l\u00f7e";
                        var4_3 = "\r\u00b8_z+u\u00d7\u00cc\u0092=\u00f4\u000f\u00e9!0*/m\u0010\u0014\"h\u00baf\u008c4^a!\u008eG\u00ad]\u008cg\u0014(l\u00f7e".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 16;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 24;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 53;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 59;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 89;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 66;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 19;
                                        break;
                                    }
                                    default: {
                                        v11 = 62;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x23C8) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 184;
                            case 1 -> 65;
                            case 2 -> 231;
                            case 3 -> 58;
                            case 4 -> 119;
                            case 5 -> 191;
                            case 6 -> 152;
                            case 7 -> 122;
                            case 8 -> 148;
                            case 9 -> 96;
                            case 10 -> 50;
                            case 11 -> 29;
                            case 12 -> 111;
                            case 13 -> 12;
                            case 14 -> 104;
                            case 15 -> 66;
                            case 16 -> 48;
                            case 17 -> 11;
                            case 18 -> 254;
                            case 19 -> 125;
                            case 20 -> 165;
                            case 21 -> 213;
                            case 22 -> 44;
                            case 23 -> 208;
                            case 24 -> 33;
                            case 25 -> 115;
                            case 26 -> 175;
                            case 27 -> 112;
                            case 28 -> 116;
                            case 29 -> 234;
                            case 30 -> 53;
                            case 31 -> 224;
                            case 32 -> 182;
                            case 33 -> 9;
                            case 34 -> 52;
                            case 35 -> 174;
                            case 36 -> 71;
                            case 37 -> 217;
                            case 38 -> 173;
                            case 39 -> 121;
                            case 40 -> 221;
                            case 41 -> 99;
                            case 42 -> 226;
                            case 43 -> 7;
                            case 44 -> 25;
                            case 45 -> 179;
                            case 46 -> 95;
                            case 47 -> 252;
                            case 48 -> 187;
                            case 49 -> 176;
                            case 50 -> 209;
                            case 51 -> 92;
                            case 52 -> 90;
                            case 53 -> 255;
                            case 54 -> 14;
                            case 55 -> 34;
                            case 56 -> 136;
                            case 57 -> 91;
                            case 58 -> 248;
                            case 59 -> 6;
                            case 60 -> 223;
                            case 61 -> 143;
                            case 62 -> 8;
                            case 63 -> 118;
                            case 64 -> 205;
                            case 65 -> 236;
                            case 66 -> 87;
                            case 67 -> 100;
                            case 68 -> 31;
                            case 69 -> 245;
                            case 70 -> 169;
                            case 71 -> 164;
                            case 72 -> 78;
                            case 73 -> 127;
                            case 74 -> 79;
                            case 75 -> 149;
                            case 76 -> 98;
                            case 77 -> 126;
                            case 78 -> 166;
                            case 79 -> 194;
                            case 80 -> 41;
                            case 81 -> 85;
                            case 82 -> 203;
                            case 83 -> 75;
                            case 84 -> 128;
                            case 85 -> 241;
                            case 86 -> 225;
                            case 87 -> 244;
                            case 88 -> 57;
                            case 89 -> 46;
                            case 90 -> 68;
                            case 91 -> 163;
                            case 92 -> 180;
                            case 93 -> 232;
                            case 94 -> 109;
                            case 95 -> 238;
                            case 96 -> 219;
                            case 97 -> 86;
                            case 98 -> 93;
                            case 99 -> 222;
                            case 100 -> 2;
                            case 101 -> 20;
                            case 102 -> 1;
                            case 103 -> 5;
                            case 104 -> 246;
                            case 105 -> 4;
                            case 106 -> 220;
                            case 107 -> 186;
                            case 108 -> 38;
                            case 109 -> 101;
                            case 110 -> 22;
                            case 111 -> 146;
                            case 112 -> 207;
                            case 113 -> 216;
                            case 114 -> 229;
                            case 115 -> 77;
                            case 116 -> 42;
                            case 117 -> 132;
                            case 118 -> 17;
                            case 119 -> 123;
                            case 120 -> 117;
                            case 121 -> 131;
                            case 122 -> 51;
                            case 123 -> 105;
                            case 124 -> 251;
                            case 125 -> 124;
                            case 126 -> 200;
                            case 127 -> 250;
                            case 128 -> 183;
                            case 129 -> 26;
                            case 130 -> 240;
                            case 131 -> 242;
                            case 132 -> 192;
                            case 133 -> 113;
                            case 134 -> 37;
                            case 135 -> 151;
                            case 136 -> 170;
                            case 137 -> 23;
                            case 138 -> 30;
                            case 139 -> 154;
                            case 140 -> 88;
                            case 141 -> 190;
                            case 142 -> 142;
                            case 143 -> 61;
                            case 144 -> 73;
                            case 145 -> 16;
                            case 146 -> 107;
                            case 147 -> 228;
                            case 148 -> 69;
                            case 149 -> 204;
                            case 150 -> 40;
                            case 151 -> 74;
                            case 152 -> 197;
                            case 153 -> 130;
                            case 154 -> 134;
                            case 155 -> 15;
                            case 156 -> 10;
                            case 157 -> 215;
                            case 158 -> 114;
                            case 159 -> 106;
                            case 160 -> 141;
                            case 161 -> 137;
                            case 162 -> 243;
                            case 163 -> 21;
                            case 164 -> 162;
                            case 165 -> 167;
                            case 166 -> 3;
                            case 167 -> 18;
                            case 168 -> 24;
                            case 169 -> 235;
                            case 170 -> 189;
                            case 171 -> 178;
                            case 172 -> 94;
                            case 173 -> 198;
                            case 174 -> 196;
                            case 175 -> 237;
                            case 176 -> 89;
                            case 177 -> 253;
                            case 178 -> 158;
                            case 179 -> 202;
                            case 180 -> 199;
                            case 181 -> 97;
                            case 182 -> 212;
                            case 183 -> 43;
                            case 184 -> 227;
                            case 185 -> 145;
                            case 186 -> 108;
                            case 187 -> 32;
                            case 188 -> 138;
                            case 189 -> 27;
                            case 190 -> 49;
                            case 191 -> 239;
                            case 192 -> 62;
                            case 193 -> 84;
                            case 194 -> 156;
                            case 195 -> 147;
                            case 196 -> 83;
                            case 197 -> 60;
                            case 198 -> 0;
                            case 199 -> 144;
                            case 200 -> 185;
                            case 201 -> 211;
                            case 202 -> 188;
                            case 203 -> 155;
                            case 204 -> 120;
                            case 205 -> 72;
                            case 206 -> 59;
                            case 207 -> 54;
                            case 208 -> 55;
                            case 209 -> 218;
                            case 210 -> 135;
                            case 211 -> 81;
                            case 212 -> 153;
                            case 213 -> 45;
                            case 214 -> 177;
                            case 215 -> 201;
                            case 216 -> 181;
                            case 217 -> 233;
                            case 218 -> 195;
                            case 219 -> 171;
                            case 220 -> 210;
                            case 221 -> 168;
                            case 222 -> 28;
                            case 223 -> 129;
                            case 224 -> 64;
                            case 225 -> 157;
                            case 226 -> 161;
                            case 227 -> 150;
                            case 228 -> 102;
                            case 229 -> 67;
                            case 230 -> 63;
                            case 231 -> 247;
                            case 232 -> 80;
                            case 233 -> 110;
                            case 234 -> 76;
                            case 235 -> 47;
                            case 236 -> 230;
                            case 237 -> 249;
                            case 238 -> 35;
                            case 239 -> 70;
                            case 240 -> 19;
                            case 241 -> 139;
                            case 242 -> 36;
                            case 243 -> 39;
                            case 244 -> 214;
                            case 245 -> 193;
                            case 246 -> 172;
                            case 247 -> 160;
                            case 248 -> 206;
                            case 249 -> 13;
                            case 250 -> 133;
                            case 251 -> 140;
                            case 252 -> 82;
                            case 253 -> 103;
                            case 254 -> 159;
                            default -> 56;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray != null) {
                ActionTimestamp.t("NjBpsc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 27162776425730L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.t();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1403235420 + -21291, 1403235420 + 4954, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1403235420 + -21287, -1403235420 - -9921, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1403235420 + -21310, -1403235420 + -10809, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1403235420 + -21291, 1403235420 + 4954, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1403235420 + -21287, -1403235420 - -9921, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1403235420 + -21315, 1403235420 - 9366, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 108831466774760L;
                        String[] stringArray2 = SshAgentIpcService.t();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1290515220 - -((char)-5986), -1290515220 - -((char)-15356), (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1290515220 - -((char)-5987), -1290384150 + -((char)-3403), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 32226417428917L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    stringArray = SshAgentIpcService.t();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1277801430 + -12124, 1277801430 - 4309, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1277801430 + -12128, -1277801430 - -6824, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1277801430 + -12117, -1277801430 - -5024, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1277801430 + -12128, -1277801430 - -6824, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1277801430 + -12126, 1277801430 - 5091, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1277801430 + -12124, 1277801430 - 4309, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1277801430 + -12128, -1277801430 - -6824, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1277801430 + -12112, 1277801430 + 5227, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1277801430 + -12124, 1277801430 - 4309, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1277801430 + -12128, -1277801430 - -6824, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1277801430 + -12111, 1277801430 + 750, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1277801430 + -12124, 1277801430 - 4309, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1277801430 + -12128, -1277801430 - -6824, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1277801430 + -12114, -1277801430 + -18823, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 81283157953622L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                stringArray = SshAgentIpcService.t();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-901892670 - -9067, 901892670 + 7332, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-901892670 - -9063, -901892670 + -4753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-901892670 - -9080, -901892670 - -6303, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-901892670 - -9083, -901892670 - -1665, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-901892670 - -9067, 901892670 + 7332, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-901892670 - -9063, -901892670 + -4753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-901892670 - -9082, -901892670 + -9437, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-901892670 - -9067, 901892670 + 7332, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-901892670 - -9063, -901892670 + -4753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-901892670 - -9085, 901892670 + 1842, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-901892670 - -9067, 901892670 + 7332, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-901892670 - -9063, -901892670 + -4753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-901892670 - -9084, -901892670 - -16038, (int)l2));
                    if (stringArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-901892670 - -9067, 901892670 + 7332, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-901892670 - -9063, -901892670 + -4753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-901892670 - -9023, -901892670 - -2513, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-901892670 - -9022, -901892670 - -13659, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0082X\u00bd\u00d0q\u008aJb\u0014\u0005 u8\u0096\u001f\u0019\u00ca\u00f4Ok,\u009eF_ \u00fd.k}\u0006I\u00aa\u00c4\u008e4\u0000\u0018\u008e\u00dfd\u00f76#\u000f\u008d\u00fe\u00da%\u00ee1\u00e1\u00f8V\u00a0\u0089\u00ee\u0014*\u00fe\u0088\u00c8\t!\r\u000f\u001c0\u00c1\u00d7\u0099\u00d9\u0005d\u00d6a\u0001\u009a\b\u00b4;{\u00cd\u00fb\u000f\u001d0\u0014%\u0012\t\u00e5t\u00acp+\u00b7\u00ae\u00a8\u00a4\u00ac\u00f4\u00a2\u009bP\u008a'\u00ab\u0005\u009c\u0097~)y\u001eT\u00cdr\u0006e\u00d9\u00c7\u00a8Bj\u00f9\u007f\u00e6\u00f3\u00a0pJ\u00dcaJw\u001a/\u0099GSOs\u00b1\u0082\u0010\u0090\u0086\u000e\u00aa\u00bd~*\u00a5\u0082yl\u00e0RU\u0099;\t\u00b7\u00c8\u000b\u00b5\u00e3\u00d3\u008bD\u00bc\u0010\u00e0\u00d2\u0000 |/\u0012\u008f\u0085<\u008cHN@\u001a\u0099?\u007f\u0088\u001f\u00ae\u00c5\u00c5VG\u0001F\u00d4\u0001\u00fc\u00ca\u00den@z][~ju\u00f1\u001c\u00b6){J\u00d5-\u0016\u00ef\u00a5\u00ff\u00c2>PN\u00c1~\u00d9\u0013-\u00e0|8`\u00ef\u0081\u00e9\u00fd\u00ad(0\u001f\u00ca(\u00ea\u0083;`\u00ea\b\u008e\u00ee<w\u0013X\u0000\u00da\f\u009e=.\u0016L\u0016\u0005\u0014N\u0007\u00a7+F\u00f5\u0004C1\u00e1\u00f2\u00b0\u0088\u00f8\u0098{\u001c\u009fa\u00ad=\u00d2w\u000fU&\u00f9}\u00b1+\u0095<\u0014W\u0011\u00b4\u00b2\u00e0\u0087\u00dc\u00a7\u0080\u00b129b\u00d3\u001b\u0097?\u00ae\u0097G\u00fd\u009d\u00cd\u00d4\u00c6\u009bKr:\u00f1b\u0004\u0019\u00f9\u00f2\u00c3%?\u00c7\u008e\u00ea\u00ba\u001f7\u001d\u001e\u001c\u00e8\u009av\u00c0tg?\u00de>\u00da\u00b0\u00e43\u00a63\u00cf\u00f6*\u00c84\u00da6\u00eb\u00138\u007f[\u000b\u000fq\u001c\u009f\n'\u00cd2W\u00cf\u008e\u0015\u00b5\u00b2K\u00e4\u00e7 \u009c\u00afC\u009c\u00c4j\u00ff\u00e0\u0095\u00f5l\u0010\u0005`\u0006)\u00c9+\u00c1\u00da\u0013B\t\u00db\u009b\u0004\u00c2\u00b2\u0085]Y\u0011Q\u0090\u00a4\u00ae\u00f4~N\u00a6e-\u00cb\b\u0013\u00e8\u00bc\u00b3\u001f\u0002E\u009a\u00ad\u000b\u001c\u00c7\u0004\u0007\u00bc\u00fce:\u00a3\u0003\u0084\u0007\u00f3\u00be\u00e8\u001e\u00f5hX(\u00f8\u00b2\u00ab\u00c8\u00eej@\u00f9\u00c2\u0097\u00c3\u00f6\u0086T{\u00b3\u0012ib\u00d2M\u00cf\u0016[\u00fe.\u000e\u0013\u009c\u00eb\u0096\u00ca\u00a1F\f\u00bf>\u00d2\u00fd\u000f\u000f\u0001d\u00da;(x=x\u0018*9\u0010y\u00dc\u001a\"T\u0016r}e\u00b6\u00c7EB\u00d7\u00f9\u00c8\u00e1\u001e\u00b1\u00b7\u00a7m\u00f0S\u0094\u00c1\u00e2\u0001c\u008d\u00c6\u00c2\u0096\u0083\u00ae\u00d9s\u00bc\u000e\u001f:\u0019\u00f0P\u00012W\u00f9\u00cf\u0005\u00ac\u00f2A\u001b\u00c8-\u00e4\u0017\u0014H/\"\r\u00e6\u0016\u0088\u00c0\u00f3\u00b3\u001cO\u00b2P4\u00bb\u0019t\u00bc\u00faW\u00a0\n\u008dP\u0088\u00bf\u008d\u00b9\u00cf6\u00ba\u0006\u0018&m9\u0012\u00aeTY\u00ff\u00dd\u0094\u00ceYb\u009a\u001b\u0010-2\u00cb]\u00b0\u007fN#)\u0018\u00b1\u00fb\u0089T(\u00e1\u0096\u0086\u00ada\u0087\u00f5\u00f2\u00c8\u009f\u001d4\u00f2\u00ff\u0004D\u0019\u00ed\u00fa\u00d6\u00a5\u009b\u008d\u00c6\u00d4\u00e77V\u0095\u0084i\u00ec\u0084;\u0017\tA\u00f7\u00d5L2#\u00e7\u0001\u008c";
                var4_3 = "\u0082X\u00bd\u00d0q\u008aJb\u0014\u0005 u8\u0096\u001f\u0019\u00ca\u00f4Ok,\u009eF_ \u00fd.k}\u0006I\u00aa\u00c4\u008e4\u0000\u0018\u008e\u00dfd\u00f76#\u000f\u008d\u00fe\u00da%\u00ee1\u00e1\u00f8V\u00a0\u0089\u00ee\u0014*\u00fe\u0088\u00c8\t!\r\u000f\u001c0\u00c1\u00d7\u0099\u00d9\u0005d\u00d6a\u0001\u009a\b\u00b4;{\u00cd\u00fb\u000f\u001d0\u0014%\u0012\t\u00e5t\u00acp+\u00b7\u00ae\u00a8\u00a4\u00ac\u00f4\u00a2\u009bP\u008a'\u00ab\u0005\u009c\u0097~)y\u001eT\u00cdr\u0006e\u00d9\u00c7\u00a8Bj\u00f9\u007f\u00e6\u00f3\u00a0pJ\u00dcaJw\u001a/\u0099GSOs\u00b1\u0082\u0010\u0090\u0086\u000e\u00aa\u00bd~*\u00a5\u0082yl\u00e0RU\u0099;\t\u00b7\u00c8\u000b\u00b5\u00e3\u00d3\u008bD\u00bc\u0010\u00e0\u00d2\u0000 |/\u0012\u008f\u0085<\u008cHN@\u001a\u0099?\u007f\u0088\u001f\u00ae\u00c5\u00c5VG\u0001F\u00d4\u0001\u00fc\u00ca\u00den@z][~ju\u00f1\u001c\u00b6){J\u00d5-\u0016\u00ef\u00a5\u00ff\u00c2>PN\u00c1~\u00d9\u0013-\u00e0|8`\u00ef\u0081\u00e9\u00fd\u00ad(0\u001f\u00ca(\u00ea\u0083;`\u00ea\b\u008e\u00ee<w\u0013X\u0000\u00da\f\u009e=.\u0016L\u0016\u0005\u0014N\u0007\u00a7+F\u00f5\u0004C1\u00e1\u00f2\u00b0\u0088\u00f8\u0098{\u001c\u009fa\u00ad=\u00d2w\u000fU&\u00f9}\u00b1+\u0095<\u0014W\u0011\u00b4\u00b2\u00e0\u0087\u00dc\u00a7\u0080\u00b129b\u00d3\u001b\u0097?\u00ae\u0097G\u00fd\u009d\u00cd\u00d4\u00c6\u009bKr:\u00f1b\u0004\u0019\u00f9\u00f2\u00c3%?\u00c7\u008e\u00ea\u00ba\u001f7\u001d\u001e\u001c\u00e8\u009av\u00c0tg?\u00de>\u00da\u00b0\u00e43\u00a63\u00cf\u00f6*\u00c84\u00da6\u00eb\u00138\u007f[\u000b\u000fq\u001c\u009f\n'\u00cd2W\u00cf\u008e\u0015\u00b5\u00b2K\u00e4\u00e7 \u009c\u00afC\u009c\u00c4j\u00ff\u00e0\u0095\u00f5l\u0010\u0005`\u0006)\u00c9+\u00c1\u00da\u0013B\t\u00db\u009b\u0004\u00c2\u00b2\u0085]Y\u0011Q\u0090\u00a4\u00ae\u00f4~N\u00a6e-\u00cb\b\u0013\u00e8\u00bc\u00b3\u001f\u0002E\u009a\u00ad\u000b\u001c\u00c7\u0004\u0007\u00bc\u00fce:\u00a3\u0003\u0084\u0007\u00f3\u00be\u00e8\u001e\u00f5hX(\u00f8\u00b2\u00ab\u00c8\u00eej@\u00f9\u00c2\u0097\u00c3\u00f6\u0086T{\u00b3\u0012ib\u00d2M\u00cf\u0016[\u00fe.\u000e\u0013\u009c\u00eb\u0096\u00ca\u00a1F\f\u00bf>\u00d2\u00fd\u000f\u000f\u0001d\u00da;(x=x\u0018*9\u0010y\u00dc\u001a\"T\u0016r}e\u00b6\u00c7EB\u00d7\u00f9\u00c8\u00e1\u001e\u00b1\u00b7\u00a7m\u00f0S\u0094\u00c1\u00e2\u0001c\u008d\u00c6\u00c2\u0096\u0083\u00ae\u00d9s\u00bc\u000e\u001f:\u0019\u00f0P\u00012W\u00f9\u00cf\u0005\u00ac\u00f2A\u001b\u00c8-\u00e4\u0017\u0014H/\"\r\u00e6\u0016\u0088\u00c0\u00f3\u00b3\u001cO\u00b2P4\u00bb\u0019t\u00bc\u00faW\u00a0\n\u008dP\u0088\u00bf\u008d\u00b9\u00cf6\u00ba\u0006\u0018&m9\u0012\u00aeTY\u00ff\u00dd\u0094\u00ceYb\u009a\u001b\u0010-2\u00cb]\u00b0\u007fN#)\u0018\u00b1\u00fb\u0089T(\u00e1\u0096\u0086\u00ada\u0087\u00f5\u00f2\u00c8\u009f\u001d4\u00f2\u00ff\u0004D\u0019\u00ed\u00fa\u00d6\u00a5\u009b\u008d\u00c6\u00d4\u00e77V\u0095\u0084i\u00ec\u0084;\u0017\tA\u00f7\u00d5L2#\u00e7\u0001\u008c".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 123;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "~x\u00cdJh\u00aa\u009c<\u00d3\u00021\u0088\u0005\u00e9,\u0006{\u00f1\u00949gY|j\u0007\u00c0q\u00e6}\u0014x\u00e9 \u00fb\u00c6\u009d\u00e9`\u0010\u00e0\r#\u00a8]c\u00b9\u0080\u00e7>\u00be";
                    var4_3 = "~x\u00cdJh\u00aa\u009c<\u00d3\u00021\u0088\u0005\u00e9,\u0006{\u00f1\u00949gY|j\u0007\u00c0q\u00e6}\u0014x\u00e9 \u00fb\u00c6\u009d\u00e9`\u0010\u00e0\r#\u00a8]c\u00b9\u0080\u00e7>\u00be".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 15;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 14;
                            break;
                        }
                        case 1: {
                            v15 = 100;
                            break;
                        }
                        case 2: {
                            v15 = 54;
                            break;
                        }
                        case 3: {
                            v15 = 98;
                            break;
                        }
                        case 4: {
                            v15 = 58;
                            break;
                        }
                        case 5: {
                            v15 = 96;
                            break;
                        }
                        default: {
                            v15 = 25;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFD577) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 12;
                case 1 -> 185;
                case 2 -> 228;
                case 3 -> 214;
                case 4 -> 81;
                case 5 -> 252;
                case 6 -> 36;
                case 7 -> 93;
                case 8 -> 63;
                case 9 -> 52;
                case 10 -> 242;
                case 11 -> 109;
                case 12 -> 57;
                case 13 -> 230;
                case 14 -> 246;
                case 15 -> 139;
                case 16 -> 134;
                case 17 -> 30;
                case 18 -> 172;
                case 19 -> 187;
                case 20 -> 203;
                case 21 -> 43;
                case 22 -> 180;
                case 23 -> 195;
                case 24 -> 60;
                case 25 -> 182;
                case 26 -> 222;
                case 27 -> 127;
                case 28 -> 155;
                case 29 -> 114;
                case 30 -> 7;
                case 31 -> 66;
                case 32 -> 132;
                case 33 -> 86;
                case 34 -> 121;
                case 35 -> 216;
                case 36 -> 205;
                case 37 -> 213;
                case 38 -> 37;
                case 39 -> 145;
                case 40 -> 84;
                case 41 -> 67;
                case 42 -> 26;
                case 43 -> 248;
                case 44 -> 234;
                case 45 -> 46;
                case 46 -> 88;
                case 47 -> 116;
                case 48 -> 150;
                case 49 -> 152;
                case 50 -> 91;
                case 51 -> 126;
                case 52 -> 48;
                case 53 -> 69;
                case 54 -> 163;
                case 55 -> 240;
                case 56 -> 87;
                case 57 -> 199;
                case 58 -> 223;
                case 59 -> 113;
                case 60 -> 177;
                case 61 -> 189;
                case 62 -> 70;
                case 63 -> 229;
                case 64 -> 197;
                case 65 -> 32;
                case 66 -> 201;
                case 67 -> 6;
                case 68 -> 61;
                case 69 -> 20;
                case 70 -> 173;
                case 71 -> 159;
                case 72 -> 221;
                case 73 -> 68;
                case 74 -> 71;
                case 75 -> 202;
                case 76 -> 89;
                case 77 -> 14;
                case 78 -> 35;
                case 79 -> 79;
                case 80 -> 125;
                case 81 -> 212;
                case 82 -> 158;
                case 83 -> 74;
                case 84 -> 28;
                case 85 -> 80;
                case 86 -> 72;
                case 87 -> 217;
                case 88 -> 33;
                case 89 -> 161;
                case 90 -> 239;
                case 91 -> 254;
                case 92 -> 15;
                case 93 -> 104;
                case 94 -> 146;
                case 95 -> 24;
                case 96 -> 78;
                case 97 -> 90;
                case 98 -> 151;
                case 99 -> 110;
                case 100 -> 144;
                case 101 -> 142;
                case 102 -> 2;
                case 103 -> 25;
                case 104 -> 157;
                case 105 -> 97;
                case 106 -> 198;
                case 107 -> 235;
                case 108 -> 0;
                case 109 -> 207;
                case 110 -> 1;
                case 111 -> 101;
                case 112 -> 82;
                case 113 -> 153;
                case 114 -> 174;
                case 115 -> 29;
                case 116 -> 166;
                case 117 -> 42;
                case 118 -> 156;
                case 119 -> 103;
                case 120 -> 41;
                case 121 -> 27;
                case 122 -> 211;
                case 123 -> 191;
                case 124 -> 135;
                case 125 -> 56;
                case 126 -> 16;
                case 127 -> 128;
                case 128 -> 47;
                case 129 -> 31;
                case 130 -> 227;
                case 131 -> 245;
                case 132 -> 92;
                case 133 -> 253;
                case 134 -> 232;
                case 135 -> 244;
                case 136 -> 140;
                case 137 -> 55;
                case 138 -> 94;
                case 139 -> 38;
                case 140 -> 179;
                case 141 -> 210;
                case 142 -> 147;
                case 143 -> 226;
                case 144 -> 178;
                case 145 -> 255;
                case 146 -> 19;
                case 147 -> 186;
                case 148 -> 247;
                case 149 -> 194;
                case 150 -> 218;
                case 151 -> 138;
                case 152 -> 183;
                case 153 -> 181;
                case 154 -> 123;
                case 155 -> 102;
                case 156 -> 231;
                case 157 -> 175;
                case 158 -> 129;
                case 159 -> 184;
                case 160 -> 204;
                case 161 -> 54;
                case 162 -> 220;
                case 163 -> 73;
                case 164 -> 219;
                case 165 -> 106;
                case 166 -> 143;
                case 167 -> 8;
                case 168 -> 96;
                case 169 -> 215;
                case 170 -> 13;
                case 171 -> 122;
                case 172 -> 137;
                case 173 -> 160;
                case 174 -> 100;
                case 175 -> 131;
                case 176 -> 188;
                case 177 -> 236;
                case 178 -> 237;
                case 179 -> 4;
                case 180 -> 168;
                case 181 -> 119;
                case 182 -> 167;
                case 183 -> 75;
                case 184 -> 39;
                case 185 -> 58;
                case 186 -> 224;
                case 187 -> 169;
                case 188 -> 62;
                case 189 -> 176;
                case 190 -> 162;
                case 191 -> 98;
                case 192 -> 111;
                case 193 -> 124;
                case 194 -> 21;
                case 195 -> 130;
                case 196 -> 154;
                case 197 -> 170;
                case 198 -> 53;
                case 199 -> 251;
                case 200 -> 105;
                case 201 -> 95;
                case 202 -> 164;
                case 203 -> 200;
                case 204 -> 22;
                case 205 -> 44;
                case 206 -> 250;
                case 207 -> 99;
                case 208 -> 171;
                case 209 -> 40;
                case 210 -> 112;
                case 211 -> 243;
                case 212 -> 83;
                case 213 -> 148;
                case 214 -> 208;
                case 215 -> 241;
                case 216 -> 192;
                case 217 -> 59;
                case 218 -> 3;
                case 219 -> 17;
                case 220 -> 225;
                case 221 -> 209;
                case 222 -> 34;
                case 223 -> 165;
                case 224 -> 18;
                case 225 -> 141;
                case 226 -> 233;
                case 227 -> 118;
                case 228 -> 45;
                case 229 -> 136;
                case 230 -> 76;
                case 231 -> 50;
                case 232 -> 49;
                case 233 -> 206;
                case 234 -> 193;
                case 235 -> 108;
                case 236 -> 117;
                case 237 -> 190;
                case 238 -> 5;
                case 239 -> 9;
                case 240 -> 64;
                case 241 -> 149;
                case 242 -> 120;
                case 243 -> 11;
                case 244 -> 85;
                case 245 -> 107;
                case 246 -> 196;
                case 247 -> 51;
                case 248 -> 65;
                case 249 -> 249;
                case 250 -> 77;
                case 251 -> 133;
                case 252 -> 115;
                case 253 -> 10;
                case 254 -> 23;
                default -> 238;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 59121425237157L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1200470130 - (char)-13171, -1200339060 + -((char)-3354), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 95348795285886L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.t();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(521265390 + (char)-21167, -521265390 + -((char)-13968), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(521265390 + (char)-21170, -521396460 - -((char)-406), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(521265390 + (char)-21169, 521265390 + (char)-20216, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00ce\u0007\u001c\u00e4\u0004\u00da\u00b5\u00b7\u0010oh\u00d9\u00a8\u0006\u00e8\f\u00a8>\u00f0$\u0090\u008d\n\u00bd\u00a8";
                    var4_3 = "\u00ce\u0007\u001c\u00e4\u0004\u00da\u00b5\u00b7\u0010oh\u00d9\u00a8\u0006\u00e8\f\u00a8>\u00f0$\u0090\u008d\n\u00bd\u00a8".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 119;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0092\u00a2\u00fd:\"5\u00c2\u001d\u00e0\u00a1S\u009a\u00d4'8\u00d0\u001c>\u0017_\u0081\u00e2\u00f7\u0097\u0017\u00cb\u0010H\u0006\u00a3\u00a6x\u00dd\u00b3\u00f1\u00ee\u00c9\u0083\u00a4\u0017\u00a9`#l\u001c\u000685\u00f9J\u00aa\u00ce\u00a8\u0018r\u00cd[\u0013\u000b";
                        var4_3 = "\u0092\u00a2\u00fd:\"5\u00c2\u001d\u00e0\u00a1S\u009a\u00d4'8\u00d0\u001c>\u0017_\u0081\u00e2\u00f7\u0097\u0017\u00cb\u0010H\u0006\u00a3\u00a6x\u00dd\u00b3\u00f1\u00ee\u00c9\u0083\u00a4\u0017\u00a9`#l\u001c\u000685\u00f9J\u00aa\u00ce\u00a8\u0018r\u00cd[\u0013\u000b".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 124;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 83;
                                break;
                            }
                            case 1: {
                                v15 = 62;
                                break;
                            }
                            case 2: {
                                v15 = 56;
                                break;
                            }
                            case 3: {
                                v15 = 123;
                                break;
                            }
                            case 4: {
                                v15 = 55;
                                break;
                            }
                            case 5: {
                                v15 = 24;
                                break;
                            }
                            default: {
                                v15 = 100;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2F40) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 94;
                    case 1 -> 136;
                    case 2 -> 203;
                    case 3 -> 87;
                    case 4 -> 191;
                    case 5 -> 46;
                    case 6 -> 212;
                    case 7 -> 20;
                    case 8 -> 110;
                    case 9 -> 227;
                    case 10 -> 206;
                    case 11 -> 30;
                    case 12 -> 66;
                    case 13 -> 231;
                    case 14 -> 159;
                    case 15 -> 18;
                    case 16 -> 21;
                    case 17 -> 63;
                    case 18 -> 134;
                    case 19 -> 184;
                    case 20 -> 113;
                    case 21 -> 254;
                    case 22 -> 56;
                    case 23 -> 167;
                    case 24 -> 223;
                    case 25 -> 84;
                    case 26 -> 120;
                    case 27 -> 183;
                    case 28 -> 198;
                    case 29 -> 218;
                    case 30 -> 36;
                    case 31 -> 192;
                    case 32 -> 245;
                    case 33 -> 5;
                    case 34 -> 49;
                    case 35 -> 107;
                    case 36 -> 93;
                    case 37 -> 15;
                    case 38 -> 19;
                    case 39 -> 246;
                    case 40 -> 140;
                    case 41 -> 164;
                    case 42 -> 174;
                    case 43 -> 121;
                    case 44 -> 240;
                    case 45 -> 11;
                    case 46 -> 221;
                    case 47 -> 83;
                    case 48 -> 68;
                    case 49 -> 185;
                    case 50 -> 77;
                    case 51 -> 106;
                    case 52 -> 23;
                    case 53 -> 243;
                    case 54 -> 6;
                    case 55 -> 162;
                    case 56 -> 157;
                    case 57 -> 37;
                    case 58 -> 100;
                    case 59 -> 165;
                    case 60 -> 247;
                    case 61 -> 74;
                    case 62 -> 251;
                    case 63 -> 43;
                    case 64 -> 135;
                    case 65 -> 64;
                    case 66 -> 9;
                    case 67 -> 102;
                    case 68 -> 65;
                    case 69 -> 54;
                    case 70 -> 133;
                    case 71 -> 91;
                    case 72 -> 92;
                    case 73 -> 202;
                    case 74 -> 154;
                    case 75 -> 176;
                    case 76 -> 111;
                    case 77 -> 25;
                    case 78 -> 12;
                    case 79 -> 219;
                    case 80 -> 178;
                    case 81 -> 67;
                    case 82 -> 82;
                    case 83 -> 123;
                    case 84 -> 73;
                    case 85 -> 186;
                    case 86 -> 160;
                    case 87 -> 175;
                    case 88 -> 209;
                    case 89 -> 28;
                    case 90 -> 95;
                    case 91 -> 127;
                    case 92 -> 7;
                    case 93 -> 141;
                    case 94 -> 88;
                    case 95 -> 215;
                    case 96 -> 249;
                    case 97 -> 252;
                    case 98 -> 172;
                    case 99 -> 181;
                    case 100 -> 104;
                    case 101 -> 119;
                    case 102 -> 214;
                    case 103 -> 79;
                    case 104 -> 103;
                    case 105 -> 204;
                    case 106 -> 233;
                    case 107 -> 238;
                    case 108 -> 31;
                    case 109 -> 34;
                    case 110 -> 89;
                    case 111 -> 86;
                    case 112 -> 47;
                    case 113 -> 208;
                    case 114 -> 13;
                    case 115 -> 213;
                    case 116 -> 17;
                    case 117 -> 149;
                    case 118 -> 148;
                    case 119 -> 109;
                    case 120 -> 239;
                    case 121 -> 26;
                    case 122 -> 143;
                    case 123 -> 90;
                    case 124 -> 207;
                    case 125 -> 190;
                    case 126 -> 29;
                    case 127 -> 241;
                    case 128 -> 137;
                    case 129 -> 188;
                    case 130 -> 128;
                    case 131 -> 35;
                    case 132 -> 201;
                    case 133 -> 53;
                    case 134 -> 173;
                    case 135 -> 70;
                    case 136 -> 138;
                    case 137 -> 130;
                    case 138 -> 62;
                    case 139 -> 211;
                    case 140 -> 50;
                    case 141 -> 38;
                    case 142 -> 129;
                    case 143 -> 131;
                    case 144 -> 4;
                    case 145 -> 48;
                    case 146 -> 108;
                    case 147 -> 14;
                    case 148 -> 78;
                    case 149 -> 22;
                    case 150 -> 132;
                    case 151 -> 85;
                    case 152 -> 1;
                    case 153 -> 60;
                    case 154 -> 255;
                    case 155 -> 33;
                    case 156 -> 58;
                    case 157 -> 98;
                    case 158 -> 152;
                    case 159 -> 55;
                    case 160 -> 114;
                    case 161 -> 197;
                    case 162 -> 156;
                    case 163 -> 145;
                    case 164 -> 3;
                    case 165 -> 32;
                    case 166 -> 180;
                    case 167 -> 232;
                    case 168 -> 161;
                    case 169 -> 8;
                    case 170 -> 81;
                    case 171 -> 69;
                    case 172 -> 194;
                    case 173 -> 116;
                    case 174 -> 228;
                    case 175 -> 195;
                    case 176 -> 146;
                    case 177 -> 155;
                    case 178 -> 222;
                    case 179 -> 199;
                    case 180 -> 118;
                    case 181 -> 27;
                    case 182 -> 237;
                    case 183 -> 242;
                    case 184 -> 229;
                    case 185 -> 80;
                    case 186 -> 112;
                    case 187 -> 42;
                    case 188 -> 10;
                    case 189 -> 51;
                    case 190 -> 210;
                    case 191 -> 230;
                    case 192 -> 196;
                    case 193 -> 224;
                    case 194 -> 117;
                    case 195 -> 16;
                    case 196 -> 193;
                    case 197 -> 166;
                    case 198 -> 170;
                    case 199 -> 226;
                    case 200 -> 44;
                    case 201 -> 189;
                    case 202 -> 244;
                    case 203 -> 59;
                    case 204 -> 200;
                    case 205 -> 125;
                    case 206 -> 205;
                    case 207 -> 72;
                    case 208 -> 220;
                    case 209 -> 40;
                    case 210 -> 75;
                    case 211 -> 147;
                    case 212 -> 124;
                    case 213 -> 101;
                    case 214 -> 236;
                    case 215 -> 71;
                    case 216 -> 76;
                    case 217 -> 163;
                    case 218 -> 171;
                    case 219 -> 61;
                    case 220 -> 153;
                    case 221 -> 142;
                    case 222 -> 248;
                    case 223 -> 96;
                    case 224 -> 182;
                    case 225 -> 216;
                    case 226 -> 250;
                    case 227 -> 253;
                    case 228 -> 217;
                    case 229 -> 52;
                    case 230 -> 151;
                    case 231 -> 122;
                    case 232 -> 126;
                    case 233 -> 158;
                    case 234 -> 105;
                    case 235 -> 187;
                    case 236 -> 45;
                    case 237 -> 177;
                    case 238 -> 0;
                    case 239 -> 57;
                    case 240 -> 150;
                    case 241 -> 168;
                    case 242 -> 225;
                    case 243 -> 139;
                    case 244 -> 41;
                    case 245 -> 24;
                    case 246 -> 97;
                    case 247 -> 144;
                    case 248 -> 234;
                    case 249 -> 235;
                    case 250 -> 115;
                    case 251 -> 39;
                    case 252 -> 99;
                    case 253 -> 169;
                    case 254 -> 179;
                    default -> 2;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 55182074824164L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = " Y\\6\u0015\u001c8y\t'SO<X^%e\u0015";
                    var5_4 = " Y\\6\u0015\u001c8y\t'SO<X^%e\u0015".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 71;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 12;
                                    break;
                                }
                                case 1: {
                                    v11 = 123;
                                    break;
                                }
                                case 2: {
                                    v11 = 105;
                                    break;
                                }
                                case 3: {
                                    v11 = 31;
                                    break;
                                }
                                case 4: {
                                    v11 = 55;
                                    break;
                                }
                                case 5: {
                                    v11 = 55;
                                    break;
                                }
                                default: {
                                    v11 = 76;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 130394497754329L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "<Nh/~{#\u0004:Pd5\n6Oo5ry;\u001cNf\t6Oo5ry;\u0010D\r1Ir8xt!\u0010Cu2y}";
                    var5_4 = "<Nh/~{#\u0004:Pd5\n6Oo5ry;\u001cNf\t6Oo5ry;\u0010D\r1Ir8xt!\u0010Cu2y}".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 116;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "w\r/i?5i\u0006w\r/i3?";
                        var5_4 = "w\r/i?5i\u0006w\r/i3?".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 53;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 1;
                                break;
                            }
                            case 1: {
                                v15 = 84;
                                break;
                            }
                            case 2: {
                                v15 = 117;
                                break;
                            }
                            case 3: {
                                v15 = 47;
                                break;
                            }
                            case 4: {
                                v15 = 99;
                                break;
                            }
                            case 5: {
                                v15 = 110;
                                break;
                            }
                            default: {
                                v15 = 59;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 9739620960910L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1364831910 + (char)-16798, 1364831910 + 26398, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 11511897320893L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "d\u008d/\u0018\u00f9\u0003\"xS\u0005IL\u00ac\u00e4j\r4\r5\u0086\u00ac\u008a\u001a\u00d5G\u009b\u0081\u00b8\u00ed\u0010\u00eaV)\u0006\u0010\u000f\u00a6X\u0019\u00ae\u00a9S\u000e\u001a\u00c1\u00d8\u0005'\u00dca\u00f6\u00d33\u0095\n&[$\u00e0\u0010\u00b1\u00b2nWb\u0017m\u00ce)\u0004\u00f6|\u00bf\u00d8\u00a6a\u00dc\u0082j\u00e8\u00a5\u008f\u0080\u0013\u0010\\\u009bT\u00fc~\u0097\u0004\u0011\u00fe\u008fV7\u0004\u0010q\u00b1\u00c2\u00ae\u00a5";
                    var4_3 = "d\u008d/\u0018\u00f9\u0003\"xS\u0005IL\u00ac\u00e4j\r4\r5\u0086\u00ac\u008a\u001a\u00d5G\u009b\u0081\u00b8\u00ed\u0010\u00eaV)\u0006\u0010\u000f\u00a6X\u0019\u00ae\u00a9S\u000e\u001a\u00c1\u00d8\u0005'\u00dca\u00f6\u00d33\u0095\n&[$\u00e0\u0010\u00b1\u00b2nWb\u0017m\u00ce)\u0004\u00f6|\u00bf\u00d8\u00a6a\u00dc\u0082j\u00e8\u00a5\u008f\u0080\u0013\u0010\\\u009bT\u00fc~\u0097\u0004\u0011\u00fe\u008fV7\u0004\u0010q\u00b1\u00c2\u00ae\u00a5".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 67;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00edJ\u00bd\u00f1\u00f6\u0085\u000e}x~\u00f1=q\u00a3Z\u009bLX\u001c\u00fc\u00f1\u00f4M \n4\u0003\u00d4+\u00db\u00ef\u009ck?\u001b\u0090\u0080YQ\u000f\u00f4\u0018\u00f0\u00eaDA\u0081Q+pf\u00d4+(\u00c7\u0080\t,\u0005\u00b7oY\u00b1e\u00c9\u00c6\u00e1\u00b9\\J\u00f8\u00a3\u00ba\u001b6\u0003\u00bb\u000f\u008f\u0089\u00dfA\u00a0s!EU\u0019\u00ec`\u00d4v\u00ee";
                        var4_3 = "\u00edJ\u00bd\u00f1\u00f6\u0085\u000e}x~\u00f1=q\u00a3Z\u009bLX\u001c\u00fc\u00f1\u00f4M \n4\u0003\u00d4+\u00db\u00ef\u009ck?\u001b\u0090\u0080YQ\u000f\u00f4\u0018\u00f0\u00eaDA\u0081Q+pf\u00d4+(\u00c7\u0080\t,\u0005\u00b7oY\u00b1e\u00c9\u00c6\u00e1\u00b9\\J\u00f8\u00a3\u00ba\u001b6\u0003\u00bb\u000f\u008f\u0089\u00dfA\u00a0s!EU\u0019\u00ec`\u00d4v\u00ee".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 113;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 37;
                                break;
                            }
                            case 1: {
                                v15 = 81;
                                break;
                            }
                            case 2: {
                                v15 = 4;
                                break;
                            }
                            case 3: {
                                v15 = 77;
                                break;
                            }
                            case 4: {
                                v15 = 10;
                                break;
                            }
                            case 5: {
                                v15 = 94;
                                break;
                            }
                            default: {
                                v15 = 25;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA786) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 213;
                    case 1 -> 77;
                    case 2 -> 231;
                    case 3 -> 26;
                    case 4 -> 252;
                    case 5 -> 204;
                    case 6 -> 139;
                    case 7 -> 128;
                    case 8 -> 65;
                    case 9 -> 80;
                    case 10 -> 244;
                    case 11 -> 74;
                    case 12 -> 118;
                    case 13 -> 111;
                    case 14 -> 140;
                    case 15 -> 190;
                    case 16 -> 11;
                    case 17 -> 141;
                    case 18 -> 120;
                    case 19 -> 17;
                    case 20 -> 242;
                    case 21 -> 178;
                    case 22 -> 98;
                    case 23 -> 85;
                    case 24 -> 60;
                    case 25 -> 191;
                    case 26 -> 119;
                    case 27 -> 40;
                    case 28 -> 154;
                    case 29 -> 130;
                    case 30 -> 228;
                    case 31 -> 131;
                    case 32 -> 177;
                    case 33 -> 53;
                    case 34 -> 49;
                    case 35 -> 99;
                    case 36 -> 38;
                    case 37 -> 145;
                    case 38 -> 224;
                    case 39 -> 108;
                    case 40 -> 33;
                    case 41 -> 86;
                    case 42 -> 235;
                    case 43 -> 187;
                    case 44 -> 158;
                    case 45 -> 146;
                    case 46 -> 67;
                    case 47 -> 123;
                    case 48 -> 161;
                    case 49 -> 133;
                    case 50 -> 106;
                    case 51 -> 43;
                    case 52 -> 233;
                    case 53 -> 73;
                    case 54 -> 243;
                    case 55 -> 175;
                    case 56 -> 155;
                    case 57 -> 199;
                    case 58 -> 142;
                    case 59 -> 196;
                    case 60 -> 226;
                    case 61 -> 207;
                    case 62 -> 64;
                    case 63 -> 57;
                    case 64 -> 112;
                    case 65 -> 71;
                    case 66 -> 105;
                    case 67 -> 234;
                    case 68 -> 215;
                    case 69 -> 70;
                    case 70 -> 174;
                    case 71 -> 132;
                    case 72 -> 194;
                    case 73 -> 45;
                    case 74 -> 245;
                    case 75 -> 136;
                    case 76 -> 167;
                    case 77 -> 88;
                    case 78 -> 10;
                    case 79 -> 200;
                    case 80 -> 159;
                    case 81 -> 19;
                    case 82 -> 188;
                    case 83 -> 138;
                    case 84 -> 172;
                    case 85 -> 95;
                    case 86 -> 229;
                    case 87 -> 121;
                    case 88 -> 56;
                    case 89 -> 58;
                    case 90 -> 165;
                    case 91 -> 251;
                    case 92 -> 202;
                    case 93 -> 163;
                    case 94 -> 63;
                    case 95 -> 59;
                    case 96 -> 32;
                    case 97 -> 46;
                    case 98 -> 203;
                    case 99 -> 8;
                    case 100 -> 220;
                    case 101 -> 4;
                    case 102 -> 223;
                    case 103 -> 50;
                    case 104 -> 34;
                    case 105 -> 92;
                    case 106 -> 153;
                    case 107 -> 189;
                    case 108 -> 84;
                    case 109 -> 0;
                    case 110 -> 72;
                    case 111 -> 3;
                    case 112 -> 201;
                    case 113 -> 89;
                    case 114 -> 210;
                    case 115 -> 176;
                    case 116 -> 81;
                    case 117 -> 162;
                    case 118 -> 23;
                    case 119 -> 124;
                    case 120 -> 21;
                    case 121 -> 7;
                    case 122 -> 6;
                    case 123 -> 100;
                    case 124 -> 13;
                    case 125 -> 156;
                    case 126 -> 225;
                    case 127 -> 184;
                    case 128 -> 219;
                    case 129 -> 22;
                    case 130 -> 134;
                    case 131 -> 78;
                    case 132 -> 218;
                    case 133 -> 168;
                    case 134 -> 248;
                    case 135 -> 227;
                    case 136 -> 90;
                    case 137 -> 152;
                    case 138 -> 68;
                    case 139 -> 122;
                    case 140 -> 150;
                    case 141 -> 107;
                    case 142 -> 36;
                    case 143 -> 14;
                    case 144 -> 25;
                    case 145 -> 82;
                    case 146 -> 212;
                    case 147 -> 94;
                    case 148 -> 222;
                    case 149 -> 75;
                    case 150 -> 15;
                    case 151 -> 76;
                    case 152 -> 143;
                    case 153 -> 110;
                    case 154 -> 157;
                    case 155 -> 137;
                    case 156 -> 151;
                    case 157 -> 192;
                    case 158 -> 206;
                    case 159 -> 216;
                    case 160 -> 125;
                    case 161 -> 129;
                    case 162 -> 37;
                    case 163 -> 217;
                    case 164 -> 236;
                    case 165 -> 250;
                    case 166 -> 208;
                    case 167 -> 127;
                    case 168 -> 27;
                    case 169 -> 9;
                    case 170 -> 2;
                    case 171 -> 247;
                    case 172 -> 147;
                    case 173 -> 186;
                    case 174 -> 239;
                    case 175 -> 31;
                    case 176 -> 126;
                    case 177 -> 179;
                    case 178 -> 198;
                    case 179 -> 164;
                    case 180 -> 42;
                    case 181 -> 69;
                    case 182 -> 135;
                    case 183 -> 48;
                    case 184 -> 185;
                    case 185 -> 181;
                    case 186 -> 205;
                    case 187 -> 237;
                    case 188 -> 114;
                    case 189 -> 83;
                    case 190 -> 182;
                    case 191 -> 241;
                    case 192 -> 104;
                    case 193 -> 173;
                    case 194 -> 62;
                    case 195 -> 16;
                    case 196 -> 29;
                    case 197 -> 1;
                    case 198 -> 28;
                    case 199 -> 253;
                    case 200 -> 170;
                    case 201 -> 221;
                    case 202 -> 195;
                    case 203 -> 5;
                    case 204 -> 41;
                    case 205 -> 149;
                    case 206 -> 249;
                    case 207 -> 35;
                    case 208 -> 47;
                    case 209 -> 97;
                    case 210 -> 91;
                    case 211 -> 183;
                    case 212 -> 54;
                    case 213 -> 254;
                    case 214 -> 66;
                    case 215 -> 197;
                    case 216 -> 96;
                    case 217 -> 103;
                    case 218 -> 51;
                    case 219 -> 109;
                    case 220 -> 102;
                    case 221 -> 116;
                    case 222 -> 171;
                    case 223 -> 214;
                    case 224 -> 55;
                    case 225 -> 18;
                    case 226 -> 209;
                    case 227 -> 117;
                    case 228 -> 232;
                    case 229 -> 87;
                    case 230 -> 113;
                    case 231 -> 169;
                    case 232 -> 52;
                    case 233 -> 30;
                    case 234 -> 180;
                    case 235 -> 44;
                    case 236 -> 230;
                    case 237 -> 79;
                    case 238 -> 61;
                    case 239 -> 101;
                    case 240 -> 160;
                    case 241 -> 115;
                    case 242 -> 24;
                    case 243 -> 93;
                    case 244 -> 12;
                    case 245 -> 193;
                    case 246 -> 211;
                    case 247 -> 255;
                    case 248 -> 39;
                    case 249 -> 148;
                    case 250 -> 166;
                    case 251 -> 20;
                    case 252 -> 246;
                    case 253 -> 238;
                    case 254 -> 144;
                    default -> 240;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 72274735466753L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(974112240 + (char)-911, -974243310 - -((char)-12565), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 8286042677782L;
                    String[] stringArray = SshAgentIpcService.t();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1050788190 - -27349, -1050788190 - -((char)-17957), (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 17071534733954L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0095\u00db\u00adH\u0004\u0003}\u00fe\u00e6";
                var4_3 = "\u0095\u00db\u00adH\u0004\u0003}\u00fe\u00e6".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 117;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 31;
                                break;
                            }
                            case 1: {
                                v11 = 106;
                                break;
                            }
                            case 2: {
                                v11 = 15;
                                break;
                            }
                            case 3: {
                                v11 = 64;
                                break;
                            }
                            case 4: {
                                v11 = 54;
                                break;
                            }
                            case 5: {
                                v11 = 126;
                                break;
                            }
                            default: {
                                v11 = 37;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCB60) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 165;
                    case 1 -> 3;
                    case 2 -> 163;
                    case 3 -> 243;
                    case 4 -> 124;
                    case 5 -> 250;
                    case 6 -> 239;
                    case 7 -> 73;
                    case 8 -> 254;
                    case 9 -> 10;
                    case 10 -> 142;
                    case 11 -> 127;
                    case 12 -> 126;
                    case 13 -> 236;
                    case 14 -> 128;
                    case 15 -> 95;
                    case 16 -> 69;
                    case 17 -> 46;
                    case 18 -> 208;
                    case 19 -> 233;
                    case 20 -> 175;
                    case 21 -> 136;
                    case 22 -> 203;
                    case 23 -> 7;
                    case 24 -> 230;
                    case 25 -> 114;
                    case 26 -> 146;
                    case 27 -> 204;
                    case 28 -> 171;
                    case 29 -> 25;
                    case 30 -> 36;
                    case 31 -> 153;
                    case 32 -> 196;
                    case 33 -> 131;
                    case 34 -> 50;
                    case 35 -> 129;
                    case 36 -> 118;
                    case 37 -> 145;
                    case 38 -> 2;
                    case 39 -> 164;
                    case 40 -> 143;
                    case 41 -> 103;
                    case 42 -> 180;
                    case 43 -> 223;
                    case 44 -> 185;
                    case 45 -> 173;
                    case 46 -> 113;
                    case 47 -> 144;
                    case 48 -> 90;
                    case 49 -> 172;
                    case 50 -> 174;
                    case 51 -> 21;
                    case 52 -> 96;
                    case 53 -> 101;
                    case 54 -> 134;
                    case 55 -> 65;
                    case 56 -> 0;
                    case 57 -> 59;
                    case 58 -> 195;
                    case 59 -> 31;
                    case 60 -> 32;
                    case 61 -> 14;
                    case 62 -> 198;
                    case 63 -> 255;
                    case 64 -> 100;
                    case 65 -> 207;
                    case 66 -> 158;
                    case 67 -> 105;
                    case 68 -> 151;
                    case 69 -> 135;
                    case 70 -> 197;
                    case 71 -> 137;
                    case 72 -> 161;
                    case 73 -> 234;
                    case 74 -> 120;
                    case 75 -> 71;
                    case 76 -> 168;
                    case 77 -> 33;
                    case 78 -> 43;
                    case 79 -> 238;
                    case 80 -> 193;
                    case 81 -> 72;
                    case 82 -> 119;
                    case 83 -> 160;
                    case 84 -> 67;
                    case 85 -> 40;
                    case 86 -> 66;
                    case 87 -> 15;
                    case 88 -> 81;
                    case 89 -> 228;
                    case 90 -> 89;
                    case 91 -> 226;
                    case 92 -> 27;
                    case 93 -> 162;
                    case 94 -> 170;
                    case 95 -> 199;
                    case 96 -> 221;
                    case 97 -> 154;
                    case 98 -> 132;
                    case 99 -> 178;
                    case 100 -> 84;
                    case 101 -> 182;
                    case 102 -> 9;
                    case 103 -> 104;
                    case 104 -> 249;
                    case 105 -> 63;
                    case 106 -> 35;
                    case 107 -> 79;
                    case 108 -> 242;
                    case 109 -> 29;
                    case 110 -> 210;
                    case 111 -> 30;
                    case 112 -> 138;
                    case 113 -> 231;
                    case 114 -> 179;
                    case 115 -> 200;
                    case 116 -> 78;
                    case 117 -> 55;
                    case 118 -> 235;
                    case 119 -> 186;
                    case 120 -> 4;
                    case 121 -> 155;
                    case 122 -> 111;
                    case 123 -> 156;
                    case 124 -> 192;
                    case 125 -> 110;
                    case 126 -> 80;
                    case 127 -> 62;
                    case 128 -> 26;
                    case 129 -> 115;
                    case 130 -> 240;
                    case 131 -> 38;
                    case 132 -> 214;
                    case 133 -> 206;
                    case 134 -> 201;
                    case 135 -> 60;
                    case 136 -> 93;
                    case 137 -> 11;
                    case 138 -> 75;
                    case 139 -> 217;
                    case 140 -> 152;
                    case 141 -> 53;
                    case 142 -> 247;
                    case 143 -> 227;
                    case 144 -> 85;
                    case 145 -> 218;
                    case 146 -> 169;
                    case 147 -> 47;
                    case 148 -> 91;
                    case 149 -> 252;
                    case 150 -> 116;
                    case 151 -> 82;
                    case 152 -> 141;
                    case 153 -> 77;
                    case 154 -> 5;
                    case 155 -> 19;
                    case 156 -> 70;
                    case 157 -> 58;
                    case 158 -> 41;
                    case 159 -> 39;
                    case 160 -> 74;
                    case 161 -> 191;
                    case 162 -> 183;
                    case 163 -> 23;
                    case 164 -> 229;
                    case 165 -> 177;
                    case 166 -> 18;
                    case 167 -> 125;
                    case 168 -> 68;
                    case 169 -> 92;
                    case 170 -> 112;
                    case 171 -> 6;
                    case 172 -> 61;
                    case 173 -> 150;
                    case 174 -> 86;
                    case 175 -> 108;
                    case 176 -> 76;
                    case 177 -> 133;
                    case 178 -> 202;
                    case 179 -> 251;
                    case 180 -> 49;
                    case 181 -> 51;
                    case 182 -> 176;
                    case 183 -> 222;
                    case 184 -> 237;
                    case 185 -> 219;
                    case 186 -> 224;
                    case 187 -> 147;
                    case 188 -> 194;
                    case 189 -> 244;
                    case 190 -> 28;
                    case 191 -> 42;
                    case 192 -> 88;
                    case 193 -> 45;
                    case 194 -> 34;
                    case 195 -> 99;
                    case 196 -> 246;
                    case 197 -> 83;
                    case 198 -> 102;
                    case 199 -> 16;
                    case 200 -> 8;
                    case 201 -> 117;
                    case 202 -> 1;
                    case 203 -> 97;
                    case 204 -> 209;
                    case 205 -> 189;
                    case 206 -> 190;
                    case 207 -> 212;
                    case 208 -> 106;
                    case 209 -> 220;
                    case 210 -> 248;
                    case 211 -> 245;
                    case 212 -> 216;
                    case 213 -> 184;
                    case 214 -> 215;
                    case 215 -> 64;
                    case 216 -> 159;
                    case 217 -> 167;
                    case 218 -> 211;
                    case 219 -> 44;
                    case 220 -> 107;
                    case 221 -> 20;
                    case 222 -> 181;
                    case 223 -> 13;
                    case 224 -> 213;
                    case 225 -> 87;
                    case 226 -> 130;
                    case 227 -> 241;
                    case 228 -> 253;
                    case 229 -> 121;
                    case 230 -> 109;
                    case 231 -> 187;
                    case 232 -> 98;
                    case 233 -> 37;
                    case 234 -> 17;
                    case 235 -> 54;
                    case 236 -> 57;
                    case 237 -> 52;
                    case 238 -> 149;
                    case 239 -> 225;
                    case 240 -> 205;
                    case 241 -> 122;
                    case 242 -> 48;
                    case 243 -> 157;
                    case 244 -> 148;
                    case 245 -> 22;
                    case 246 -> 139;
                    case 247 -> 232;
                    case 248 -> 56;
                    case 249 -> 188;
                    case 250 -> 166;
                    case 251 -> 140;
                    case 252 -> 12;
                    case 253 -> 123;
                    case 254 -> 24;
                    default -> 94;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

