/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.FindInFilesOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;
import org.jetbrains.annotations.NotNull;

public class CompileContext {
    private final OptimizingSearchHelper mySearchHelper;
    private final CompiledPattern myPattern;
    private final MatchOptions myOptions;
    private final Project myProject;

    public CompileContext(@NotNull CompiledPattern pattern, @NotNull MatchOptions options, @NotNull Project project) {
        if (pattern == null) {
            CompileContext.$$$reportNull$$$0(0);
        }
        if (options == null) {
            CompileContext.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CompileContext.$$$reportNull$$$0(2);
        }
        this.myPattern = pattern;
        this.myOptions = options;
        this.myProject = project;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.mySearchHelper = new TestModeOptimizingSearchHelper();
        } else {
            SearchScope scope = this.myOptions.getScope();
            LanguageFileType fileType = this.myOptions.getFileType();
            if (!this.myOptions.isSearchInjectedCode() && scope instanceof GlobalSearchScope && fileType != null) {
                scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope), (FileType[])new FileType[]{fileType});
            }
            this.mySearchHelper = new FindInFilesOptimizingSearchHelper(scope, options.isCaseSensitiveMatch(), project);
        }
    }

    public void clear() {
        this.mySearchHelper.clear();
    }

    @NotNull
    public OptimizingSearchHelper getSearchHelper() {
        OptimizingSearchHelper optimizingSearchHelper = this.mySearchHelper;
        if (optimizingSearchHelper == null) {
            CompileContext.$$$reportNull$$$0(3);
        }
        return optimizingSearchHelper;
    }

    @NotNull
    public CompiledPattern getPattern() {
        CompiledPattern compiledPattern = this.myPattern;
        if (compiledPattern == null) {
            CompileContext.$$$reportNull$$$0(4);
        }
        return compiledPattern;
    }

    @NotNull
    public MatchOptions getOptions() {
        MatchOptions matchOptions = this.myOptions;
        if (matchOptions == null) {
            CompileContext.$$$reportNull$$$0(5);
        }
        return matchOptions;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CompileContext.$$$reportNull$$$0(6);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/CompileContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/CompileContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

