/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.HtmlCodeStylePanelExtension;
import com.intellij.application.options.codeStyle.RightMarginForm;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlHighlighterFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.ui.PresentableEnumUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class CodeStyleHtmlPanel
extends CodeStyleAbstractPanel {
    private JTextField myKeepBlankLines;
    private JComboBox<CodeStyleSettings.WrapStyle> myWrapAttributes;
    private JCheckBox myAlignAttributes;
    private JCheckBox myKeepWhiteSpaces;
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private JCheckBox mySpacesAroundEquality;
    private JCheckBox mySpacesAroundTagName;
    private JCheckBox myAlignText;
    private ExpandableTextField myInsertNewLineTagNames;
    private ExpandableTextField myRemoveNewLineTagNames;
    private ExpandableTextField myDoNotAlignChildrenTagNames;
    private ExpandableTextField myKeepWhiteSpacesTagNames;
    private ExpandableTextField myInlineElementsTagNames;
    private JTextField myDoNotAlignChildrenMinSize;
    private JCheckBox myShouldKeepBlankLines;
    private JCheckBox mySpaceInEmptyTag;
    private JCheckBox myWrapText;
    private JCheckBox myShouldKeepLineBreaksInText;
    private ExpandableTextField myDontBreakIfInlineContent;
    private JBScrollPane myJBScrollPane;
    private JPanel myRightMarginPanel;
    private JComboBox<CodeStyleSettings.QuoteStyle> myQuotesCombo;
    private JBCheckBox myEnforceQuotesBox;
    private ComboBox<CodeStyleSettings.HtmlTagNewLineStyle> myBeforeFirstAttributeCombo;
    private ComboBox<CodeStyleSettings.HtmlTagNewLineStyle> myAfterLastAttributeCombo;
    private JPanel mySettingsPanel;
    private RightMarginForm myRightMarginForm;
    private final List<HtmlCodeStylePanelExtension.HtmlPanelCustomizer> myPanelCustomizers;

    public CodeStyleHtmlPanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        CodeStyleHtmlPanel.fillWrappingCombo(this.myWrapAttributes);
        PresentableEnumUtil.fill(this.myQuotesCombo, CodeStyleSettings.QuoteStyle.class);
        PresentableEnumUtil.fill(this.myBeforeFirstAttributeCombo, CodeStyleSettings.HtmlTagNewLineStyle.class);
        PresentableEnumUtil.fill(this.myAfterLastAttributeCombo, CodeStyleSettings.HtmlTagNewLineStyle.class);
        this.myInsertNewLineTagNames.setColumns(5);
        this.myRemoveNewLineTagNames.setColumns(5);
        this.myDoNotAlignChildrenTagNames.setColumns(5);
        this.myKeepWhiteSpacesTagNames.setColumns(5);
        this.myInlineElementsTagNames.setColumns(5);
        this.myDontBreakIfInlineContent.setColumns(5);
        this.myQuotesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean quotesRequired = !CodeStyleSettings.QuoteStyle.None.equals(CodeStyleHtmlPanel.this.myQuotesCombo.getSelectedItem());
                CodeStyleHtmlPanel.this.myEnforceQuotesBox.setEnabled(quotesRequired);
                if (!quotesRequired) {
                    CodeStyleHtmlPanel.this.myEnforceQuotesBox.setSelected(false);
                }
            }
        });
        this.addPanelToWatch(this.myPanel);
        this.myPanelCustomizers = HtmlCodeStylePanelExtension.getCustomizers();
        for (HtmlCodeStylePanelExtension.HtmlPanelCustomizer customizer : this.myPanelCustomizers) {
            customizer.customizeSettingsPanel(this.mySettingsPanel);
        }
    }

    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            CodeStyleHtmlPanel.$$$reportNull$$$0(0);
        }
        return XmlHighlighterFactory.createXMLHighlighter((EditorColorsScheme)scheme);
    }

    private void createUIComponents() {
        this.myRightMarginForm = new RightMarginForm(HtmlFileType.INSTANCE.getLanguage(), this.getSettings());
        this.myRightMarginPanel = this.myRightMarginForm.getTopPanel();
        this.myJBScrollPane = new JBScrollPane(){

            public Dimension getPreferredSize() {
                Dimension prefSize = super.getPreferredSize();
                return new Dimension(prefSize.width + 15, prefSize.height);
            }
        };
        Function parser = list -> Arrays.asList(list.split(","));
        Function joiner = list -> StringUtil.join((Collection)list, (String)",");
        this.myInsertNewLineTagNames = new ExpandableTextField(parser, joiner);
        this.myRemoveNewLineTagNames = new ExpandableTextField(parser, joiner);
        this.myDoNotAlignChildrenTagNames = new ExpandableTextField(parser, joiner);
        this.myInlineElementsTagNames = new ExpandableTextField(parser, joiner);
        this.myKeepWhiteSpacesTagNames = new ExpandableTextField(parser, joiner);
        this.myDontBreakIfInlineContent = new ExpandableTextField(parser, joiner);
    }

    protected int getRightMargin() {
        return 60;
    }

    public void apply(@NotNull CodeStyleSettings rootSettings) throws ConfigurationException {
        if (rootSettings == null) {
            CodeStyleHtmlPanel.$$$reportNull$$$0(1);
        }
        HtmlCodeStyleSettings settings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
        settings.HTML_KEEP_BLANK_LINES = CodeStyleHtmlPanel.getIntValue(this.myKeepBlankLines);
        settings.HTML_ATTRIBUTE_WRAP = CodeStyleSettings.WrapStyle.getId((CodeStyleSettings.WrapStyle)((CodeStyleSettings.WrapStyle)this.myWrapAttributes.getSelectedItem()));
        settings.HTML_TEXT_WRAP = this.myWrapText.isSelected() ? 1 : 0;
        settings.HTML_SPACE_INSIDE_EMPTY_TAG = this.mySpaceInEmptyTag.isSelected();
        settings.HTML_ALIGN_ATTRIBUTES = this.myAlignAttributes.isSelected();
        settings.HTML_ALIGN_TEXT = this.myAlignText.isSelected();
        settings.HTML_KEEP_WHITESPACES = this.myKeepWhiteSpaces.isSelected();
        settings.HTML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE = this.mySpacesAroundEquality.isSelected();
        settings.HTML_SPACE_AFTER_TAG_NAME = this.mySpacesAroundTagName.isSelected();
        settings.HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE = this.myInsertNewLineTagNames.getText();
        settings.HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE = this.myRemoveNewLineTagNames.getText();
        settings.HTML_DO_NOT_INDENT_CHILDREN_OF = this.myDoNotAlignChildrenTagNames.getText();
        settings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES = CodeStyleHtmlPanel.getIntValue(this.myDoNotAlignChildrenMinSize);
        settings.HTML_INLINE_ELEMENTS = this.myInlineElementsTagNames.getText();
        settings.HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT = this.myDontBreakIfInlineContent.getText();
        settings.HTML_KEEP_WHITESPACES_INSIDE = this.myKeepWhiteSpacesTagNames.getText();
        settings.HTML_KEEP_LINE_BREAKS = this.myShouldKeepBlankLines.isSelected();
        settings.HTML_KEEP_LINE_BREAKS_IN_TEXT = this.myShouldKeepLineBreaksInText.isSelected();
        settings.HTML_QUOTE_STYLE = (CodeStyleSettings.QuoteStyle)this.myQuotesCombo.getSelectedItem();
        settings.HTML_ENFORCE_QUOTES = this.myEnforceQuotesBox.isSelected();
        settings.HTML_NEWLINE_BEFORE_FIRST_ATTRIBUTE = (CodeStyleSettings.HtmlTagNewLineStyle)this.myBeforeFirstAttributeCombo.getSelectedItem();
        settings.HTML_NEWLINE_AFTER_LAST_ATTRIBUTE = (CodeStyleSettings.HtmlTagNewLineStyle)this.myAfterLastAttributeCombo.getSelectedItem();
        this.myRightMarginForm.apply(rootSettings);
        this.myPanelCustomizers.forEach(el -> el.apply(rootSettings));
    }

    private static int getIntValue(JTextField keepBlankLines) {
        try {
            return Integer.parseInt(keepBlankLines.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected void resetImpl(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            CodeStyleHtmlPanel.$$$reportNull$$$0(2);
        }
        HtmlCodeStyleSettings settings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
        this.myKeepBlankLines.setText(String.valueOf(settings.HTML_KEEP_BLANK_LINES));
        this.myWrapAttributes.setSelectedItem(CodeStyleSettings.WrapStyle.forWrapping((int)settings.HTML_ATTRIBUTE_WRAP));
        this.myWrapText.setSelected(settings.HTML_TEXT_WRAP != 0);
        this.mySpaceInEmptyTag.setSelected(settings.HTML_SPACE_INSIDE_EMPTY_TAG);
        this.myAlignAttributes.setSelected(settings.HTML_ALIGN_ATTRIBUTES);
        this.myAlignText.setSelected(settings.HTML_ALIGN_TEXT);
        this.myKeepWhiteSpaces.setSelected(settings.HTML_KEEP_WHITESPACES);
        this.mySpacesAroundTagName.setSelected(settings.HTML_SPACE_AFTER_TAG_NAME);
        this.mySpacesAroundEquality.setSelected(settings.HTML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE);
        this.myShouldKeepBlankLines.setSelected(settings.HTML_KEEP_LINE_BREAKS);
        this.myShouldKeepLineBreaksInText.setSelected(settings.HTML_KEEP_LINE_BREAKS_IN_TEXT);
        this.myInsertNewLineTagNames.setText(settings.HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE);
        this.myRemoveNewLineTagNames.setText(settings.HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE);
        this.myDoNotAlignChildrenTagNames.setText(settings.HTML_DO_NOT_INDENT_CHILDREN_OF);
        this.myDoNotAlignChildrenMinSize.setText(settings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES == 0 ? "" : String.valueOf(settings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES));
        this.myInlineElementsTagNames.setText(settings.HTML_INLINE_ELEMENTS);
        this.myDontBreakIfInlineContent.setText(settings.HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT);
        this.myKeepWhiteSpacesTagNames.setText(settings.HTML_KEEP_WHITESPACES_INSIDE);
        this.myRightMarginForm.reset(rootSettings);
        this.myQuotesCombo.setSelectedItem(settings.HTML_QUOTE_STYLE);
        this.myEnforceQuotesBox.setSelected(settings.HTML_ENFORCE_QUOTES);
        this.myBeforeFirstAttributeCombo.setSelectedItem((Object)settings.HTML_NEWLINE_BEFORE_FIRST_ATTRIBUTE);
        this.myAfterLastAttributeCombo.setSelectedItem((Object)settings.HTML_NEWLINE_AFTER_LAST_ATTRIBUTE);
        this.myPanelCustomizers.forEach(el -> el.reset(rootSettings));
    }

    public boolean isModified(CodeStyleSettings rootSettings) {
        HtmlCodeStyleSettings settings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
        if (settings.HTML_KEEP_BLANK_LINES != CodeStyleHtmlPanel.getIntValue(this.myKeepBlankLines)) {
            return true;
        }
        if (settings.HTML_ATTRIBUTE_WRAP != CodeStyleSettings.WrapStyle.getId((CodeStyleSettings.WrapStyle)((CodeStyleSettings.WrapStyle)this.myWrapAttributes.getSelectedItem()))) {
            return true;
        }
        if (settings.HTML_TEXT_WRAP == 1 != this.myWrapText.isSelected()) {
            return true;
        }
        if (settings.HTML_SPACE_INSIDE_EMPTY_TAG != this.mySpaceInEmptyTag.isSelected()) {
            return true;
        }
        if (settings.HTML_ALIGN_ATTRIBUTES != this.myAlignAttributes.isSelected()) {
            return true;
        }
        if (settings.HTML_ALIGN_TEXT != this.myAlignText.isSelected()) {
            return true;
        }
        if (settings.HTML_KEEP_WHITESPACES != this.myKeepWhiteSpaces.isSelected()) {
            return true;
        }
        if (settings.HTML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE != this.mySpacesAroundEquality.isSelected()) {
            return true;
        }
        if (settings.HTML_SPACE_AFTER_TAG_NAME != this.mySpacesAroundTagName.isSelected()) {
            return true;
        }
        if (!Objects.equals(settings.HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE, this.myInsertNewLineTagNames.getText().trim())) {
            return true;
        }
        if (!Objects.equals(settings.HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE, this.myRemoveNewLineTagNames.getText().trim())) {
            return true;
        }
        if (!Objects.equals(settings.HTML_DO_NOT_INDENT_CHILDREN_OF, this.myDoNotAlignChildrenTagNames.getText().trim())) {
            return true;
        }
        if (settings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES != CodeStyleHtmlPanel.getIntValue(this.myDoNotAlignChildrenMinSize)) {
            return true;
        }
        if (!Objects.equals(settings.HTML_INLINE_ELEMENTS, this.myInlineElementsTagNames.getText().trim())) {
            return true;
        }
        if (!Objects.equals(settings.HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT, this.myDontBreakIfInlineContent.getText().trim())) {
            return true;
        }
        if (!Objects.equals(settings.HTML_KEEP_WHITESPACES_INSIDE, this.myKeepWhiteSpacesTagNames.getText().trim())) {
            return true;
        }
        if (this.myShouldKeepBlankLines.isSelected() != settings.HTML_KEEP_LINE_BREAKS) {
            return true;
        }
        if (this.myShouldKeepLineBreaksInText.isSelected() != settings.HTML_KEEP_LINE_BREAKS_IN_TEXT) {
            return true;
        }
        if (this.myQuotesCombo.getSelectedItem() != settings.HTML_QUOTE_STYLE) {
            return true;
        }
        if (this.myBeforeFirstAttributeCombo.getSelectedItem() != settings.HTML_NEWLINE_BEFORE_FIRST_ATTRIBUTE) {
            return true;
        }
        if (this.myAfterLastAttributeCombo.getSelectedItem() != settings.HTML_NEWLINE_AFTER_LAST_ATTRIBUTE) {
            return true;
        }
        if (this.myRightMarginForm.isModified(rootSettings) || this.myEnforceQuotesBox.isSelected() != settings.HTML_ENFORCE_QUOTES) {
            return true;
        }
        return this.myPanelCustomizers.stream().anyMatch(el -> el.isModified(rootSettings));
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    protected String getPreviewText() {
        return CodeStyleHtmlPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"preview.html.template");
    }

    @NotNull
    protected FileType getFileType() {
        HtmlFileType htmlFileType = HtmlFileType.INSTANCE;
        if (htmlFileType == null) {
            CodeStyleHtmlPanel.$$$reportNull$$$0(3);
        }
        return htmlFileType;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        ComboBox comboBox;
        ComboBox comboBox2;
        JBCheckBox jBCheckBox;
        JTextField jTextField2;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 4, -1, false, false));
        this.myPreviewPanel = jPanel2 = new JPanel();
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = this.myJBScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel5);
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("label.or.if.tag.size.more.than"));
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myDoNotAlignChildrenMinSize = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 0, 1, 0, null, new Dimension(50, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("label.lines"));
        jPanel.add((Component)jLabel2, new GridConstraints(3, 2, 1, 1, 0, 1, 4, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("label.insert.new.line.before"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("label.remove.new.line.before"));
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("label.do.not.indent.children.of"));
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ExpandableTextField expandableTextField = this.myInsertNewLineTagNames;
        expandableTextField.setText("");
        jPanel.add((Component)expandableTextField, new GridConstraints(0, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        ExpandableTextField expandableTextField2 = this.myRemoveNewLineTagNames;
        expandableTextField2.setText("");
        jPanel.add((Component)expandableTextField2, new GridConstraints(1, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        ExpandableTextField expandableTextField3 = this.myDoNotAlignChildrenTagNames;
        expandableTextField3.setText("");
        jPanel.add((Component)expandableTextField3, new GridConstraints(2, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        ExpandableTextField expandableTextField4 = this.myInlineElementsTagNames;
        expandableTextField4.setText("");
        jPanel.add((Component)expandableTextField4, new GridConstraints(4, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("inline.elements"));
        jPanel.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("label.keep.white.spaces.inside"));
        jPanel.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("don.t.break.if.inline.content"));
        jPanel.add((Component)jLabel8, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ExpandableTextField expandableTextField5 = this.myKeepWhiteSpacesTagNames;
        expandableTextField5.setText("");
        jPanel.add((Component)expandableTextField5, new GridConstraints(5, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        ExpandableTextField expandableTextField6 = this.myDontBreakIfInlineContent;
        expandableTextField6.setText("");
        jPanel.add((Component)expandableTextField6, new GridConstraints(6, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, DynamicBundle.getBundle((String)"messages/ApplicationBundle", CodeStyleHtmlPanel.class).getString("generated.quote.marks"));
        jPanel.add((Component)jLabel9, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myQuotesCombo = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(9, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myEnforceQuotesBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("generated.quote.enforce.format"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(10, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("html.label.new.line.before.first.attribute"));
        jPanel.add((Component)jBLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBeforeFirstAttributeCombo = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(7, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("html.label.new.line.after.last.attribute"));
        jPanel.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAfterLastAttributeCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(8, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myAlignAttributes = jCheckBox9 = new JCheckBox();
        jCheckBox9.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox9, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.align.attributes"));
        jPanel7.add((Component)jCheckBox9, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignText = jCheckBox8 = new JCheckBox();
        jCheckBox8.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox8, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.align.text"));
        jPanel7.add((Component)jCheckBox8, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepWhiteSpaces = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.keep.white.spaces"));
        jPanel7.add((Component)jCheckBox7, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWrapText = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.wrap.text"));
        jPanel7.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 1, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/ApplicationBundle", CodeStyleHtmlPanel.class).getString("title.spaces"), (int)0, (int)0, null, null));
        this.mySpacesAroundEquality = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.spaces.around.equals.in.attribute"));
        jPanel8.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpacesAroundTagName = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.spaces.around.tag.name"));
        jPanel8.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpaceInEmptyTag = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.spaces.in.empty.tag"));
        jPanel8.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShouldKeepBlankLines = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.keep.line.breaks"));
        jPanel9.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, DynamicBundle.getBundle((String)"messages/ApplicationBundle", CodeStyleHtmlPanel.class).getString("label.wrap.attributes"));
        jPanel9.add((Component)jLabel10, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("editbox.keep.blank.lines"));
        jPanel9.add((Component)jLabel11, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeepBlankLines = jTextField = new JTextField();
        jTextField.setColumns(3);
        jPanel9.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        JComboBox jComboBox2 = new JComboBox();
        this.myWrapAttributes = jComboBox2;
        ((Component)jComboBox2).setEnabled(true);
        jPanel9.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myShouldKeepLineBreaksInText = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/XmlBundle", CodeStyleHtmlPanel.class).getString("checkbox.keep.line.breaks.in.text"));
        jPanel9.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = this.myRightMarginPanel;
        jPanel5.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox2);
        jBLabel2.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleHtmlPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleHtmlPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

