/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.relevance;

import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.catboost.CatBoostJarCompletionModelProvider;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\tH\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/inline/completion/impl/relevance/MLCompletionRelevanceModelProvider;", "Lcom/intellij/internal/ml/catboost/CatBoostJarCompletionModelProvider;", "displayName", "", "resourceDirectory", "modelDirectory", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "threshold", "", "getThreshold", "()D", "threshold$delegate", "Lkotlin/Lazy;", "multilineThreshold", "getMultilineThreshold", "multilineThreshold$delegate", "readThresholdFromFile", "multiline", "", "(Z)Ljava/lang/Double;", "assertModelThresholdConsistent", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\nMLCompletionRelevanceModelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionRelevanceModelProvider.kt\ncom/intellij/ml/inline/completion/impl/relevance/MLCompletionRelevanceModelProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n1#2:34\n*E\n"})
public abstract class MLCompletionRelevanceModelProvider
extends CatBoostJarCompletionModelProvider {
    @NotNull
    private final Lazy threshold$delegate;
    @NotNull
    private final Lazy multilineThreshold$delegate;

    public MLCompletionRelevanceModelProvider(@Nls @NotNull String displayName, @NotNull String resourceDirectory, @NotNull String modelDirectory) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)resourceDirectory, (String)"resourceDirectory");
        Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
        super(displayName, resourceDirectory, modelDirectory);
        this.threshold$delegate = LazyKt.lazy(() -> MLCompletionRelevanceModelProvider.threshold_delegate$lambda$0(this));
        this.multilineThreshold$delegate = LazyKt.lazy(() -> MLCompletionRelevanceModelProvider.multilineThreshold_delegate$lambda$1(this));
    }

    public final double getThreshold() {
        Lazy lazy = this.threshold$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    public final double getMultilineThreshold() {
        Lazy lazy = this.multilineThreshold$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Double readThresholdFromFile(boolean multiline) {
        InputStream fileStream;
        String resource = multiline ? this.getModelDirectory() + "/threshold_multiline.txt" : this.getModelDirectory() + "/threshold.txt";
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
        if (inputStream == null) {
            if (multiline) {
                return null;
            }
            throw new InconsistentMetadataException("Metadata file not found: " + resource + ". Resources holder: " + ((Object)((Object)this)).getClass().getName());
        }
        Closeable closeable = fileStream = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            String string = it.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
            object2 = Double.parseDouble(string);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    @TestOnly
    public final double assertModelThresholdConsistent() {
        double d;
        try {
            d = this.getThreshold();
        }
        catch (InconsistentMetadataException e) {
            throw new AssertionError("Model threshold inconsistent", e);
        }
        return d;
    }

    private static final double threshold_delegate$lambda$0(MLCompletionRelevanceModelProvider this$0) {
        Double d = this$0.readThresholdFromFile(false);
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    private static final double multilineThreshold_delegate$lambda$1(MLCompletionRelevanceModelProvider this$0) {
        Double d = this$0.readThresholdFromFile(true);
        return d != null ? d.doubleValue() : this$0.getThreshold();
    }
}

