/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManagerKt;
import com.intellij.jupyter.core.extensions.JupyterPsiCellExt;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterExecutionException;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterMessageResultWaiter;
import com.intellij.jupyter.core.jupyter.debugger.common.DebugConnectionNotifier;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugRunnerProvider;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionManager;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterSessionPath;
import com.intellij.jupyter.core.jupyter.debugger.common.NotebookDebugRunner;
import com.intellij.jupyter.core.jupyter.debugger.common.OutputConsumer;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.helper.JupyterPsiFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.py.debugger.JupyterDebugAction;
import com.intellij.jupyter.py.debugger.JupyterDebugCellIdManager;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.PythonLanguage;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "Companion", "intellij.jupyter.py"})
public final class JupyterDebugAction
extends JupyterEditorActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    private JupyterDebugAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        JupyterCellType jupyterCellType;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (project2.isDisposed()) {
            return;
        }
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor((DataContext)dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        JupyterPsiCell jupyterPsiCell = JupyterHelper.INSTANCE.getSelectedPsiCell(dataContext2);
        if (jupyterPsiCell == null) {
            return;
        }
        JupyterPsiCell jupyterPsiCell2 = jupyterPsiCell;
        NotebookIntervalPointer notebookIntervalPointer = NotebookMarkdownEditorManagerKt.getIntervalPointer((Editor)((Editor)editor), (JupyterPsiCell)jupyterPsiCell2);
        if (notebookIntervalPointer == null) {
            return;
        }
        NotebookIntervalPointer cellPointer = notebookIntervalPointer;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiFileExtensionsKt.getVirtualFile((JupyterPsiCell)jupyterPsiCell2);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile3 = JupyterHelper.INSTANCE.getJupyterFile((Editor)editor);
        if (backedNotebookVirtualFile3 == null) {
            return;
        }
        BackedNotebookVirtualFile jupyterFile = backedNotebookVirtualFile3;
        DataContext dataContext3 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext3);
        if (interval != null) {
            DocumentEx documentEx = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            jupyterCellType = JupyterCellLinesExtensionsKt.toJupyterCellType((NotebookCellLines.Interval)interval, (Document)((Document)documentEx));
        } else {
            jupyterCellType = null;
        }
        if (jupyterCellType != JupyterCellType.CODE) {
            return;
        }
        if (JupyterDebugger.INSTANCE.showWarningIfUnderDebugger(project2, jupyterFile)) {
            return;
        }
        JupyterDebugCellIdManager.Companion.getInstance(project2).updatePositions(project2, backedNotebookVirtualFile2, jupyterPsiCell2);
        String sessionPath = JupyterSessionPath.constructor-impl((BackedNotebookVirtualFile)backedNotebookVirtualFile2);
        try {
            JupyterDebugSessionManager.Companion.getInstance(project2).debugInSessionStarted-MgfaZcY(sessionPath);
            NotebookDebugRunner debugRunner = JupyterDebugRunnerProvider.Companion.getSuitableDebugRunner(project2, backedNotebookVirtualFile2);
            VirtualFile virtualFile = backedNotebookVirtualFile2.getFile();
            DebugConnectionNotifier debugConnectionNotifier = debugRunner.getConnectionNotifier();
            debugRunner.createDebugSession(project2, jupyterPsiCell2, cellPointer, virtualFile, debugConnectionNotifier, null, () -> JupyterDebugAction.actionPerformed$lambda$0(project2, sessionPath));
        }
        catch (JupyterExecutionException e) {
            JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, e, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ JupyterExecutionException $e;
                {
                    this.$project = $project;
                    this.$e = $e;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = JupyterNotification.INSTANCE.displayAndLogError(this.$project, (Throwable)this.$e, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    protected JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive(JupyterDebugAction::createActionUpdater$lambda$2);
    }

    private static final Unit actionPerformed$lambda$0(Project $project, String $sessionPath) {
        JupyterDebugSessionManager.Companion.getInstance($project).debugInSessionFinished-MgfaZcY($sessionPath);
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createActionUpdater$lambda$2$lambda$1(JupyterEditorAction action, AnActionEvent event) {
        NotebookCellLines.Interval interval;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval2 = interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (!Intrinsics.areEqual((Object)(interval2 != null ? interval2.getLanguage() : null), (Object)PythonLanguage.INSTANCE)) return false;
        Object[] objectArray = new JupyterCellType[]{JupyterCellType.DATA_INPUT, JupyterCellType.SQL};
        NotebookCellLines.Interval interval3 = interval;
        if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)(interval3 != null ? JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(interval3) : null))) return false;
        return true;
    }

    private static final Unit createActionUpdater$lambda$2(JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider(JupyterDebugAction::createActionUpdater$lambda$2$lambda$1);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugAction$Companion;", "", "<init>", "()V", "executeCell", "", "project", "Lcom/intellij/openapi/project/Project;", "jupyterCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "output", "Lcom/intellij/jupyter/core/jupyter/debugger/common/OutputConsumer;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public final void executeCell(@NotNull Project project, @NotNull JupyterPsiCell jupyterCell, @NotNull NotebookIntervalPointer cellPointer, @NotNull XDebugSession debugSession, @Nullable OutputConsumer output) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)jupyterCell, (String)"jupyterCell");
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
            XDebugProcess xDebugProcess = debugSession.getDebugProcess();
            JupyterDebugProcess jupyterDebugProcess = xDebugProcess instanceof JupyterDebugProcess ? (JupyterDebugProcess)xDebugProcess : null;
            if (jupyterDebugProcess == null) {
                return;
            }
            JupyterDebugProcess jupyterDebugProcess2 = jupyterDebugProcess;
            jupyterDebugProcess2.setLatestExecutedCell((Pair<? extends JupyterPsiCell, ? extends NotebookIntervalPointer>)new Pair((Object)jupyterCell, (Object)cellPointer));
            ExecutorService executorService = JupyterDebugSessionManager.Companion.getInstance(project).getExecutorService();
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFile(jupyterCell);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
            String sessionPath = JupyterSessionPath.constructor-impl((BackedNotebookVirtualFile)notebookVirtualFile);
            BackedNotebookVirtualFile backedNotebookVirtualFile2 = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFile(jupyterCell);
            if (backedNotebookVirtualFile2 == null) {
                return;
            }
            BackedNotebookVirtualFile jupyterFile = backedNotebookVirtualFile2;
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)NotebookDisposable.Companion.forProject(project)), (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(cellPointer, jupyterCell, jupyterDebugProcess2, project, sessionPath, jupyterFile, output, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ NotebookIntervalPointer $cellPointer;
                final /* synthetic */ JupyterPsiCell $jupyterCell;
                final /* synthetic */ JupyterDebugProcess $jupyterDebugProcess;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $sessionPath;
                final /* synthetic */ BackedNotebookVirtualFile $jupyterFile;
                final /* synthetic */ OutputConsumer $output;
                {
                    this.$cellPointer = $cellPointer;
                    this.$jupyterCell = $jupyterCell;
                    this.$jupyterDebugProcess = $jupyterDebugProcess;
                    this.$project = $project;
                    this.$sessionPath = $sessionPath;
                    this.$jupyterFile = $jupyterFile;
                    this.$output = $output;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            silentDebugOptions = new JupyterExecutionTask.Options(JupyterExecutionTask.Purpose.DEBUG, this.$cellPointer, false, true, true, true, null, 64, null);
                            interactingDebugOptions = JupyterExecutionTask.Options.copy$default((JupyterExecutionTask.Options)silentDebugOptions, null, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (int)87, null);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)silentDebugOptions);
                            this.L$1 = interactingDebugOptions;
                            this.label = 1;
                            v0 = executeCell.1.invokeSuspend$executeAndWait(this.$project, this.$jupyterFile, this.$output, JupyterDebugProcess.Companion.enableTracingCommand(), JupyterExecutionTask.Options.Companion.silentExecution(), (Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            interactingDebugOptions = (JupyterExecutionTask.Options)this.L$1;
                            silentDebugOptions = (JupyterExecutionTask.Options)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)silentDebugOptions);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)interactingDebugOptions);
                            this.label = 2;
                            v1 = executeCell.1.invokeSuspend$executeAndWait(this.$project, this.$jupyterFile, this.$output, JupyterDebugCellIdManager.Companion.extractCellTextAndRemoveFirstEmptyLine$intellij_jupyter_py(this.$jupyterCell), interactingDebugOptions, (Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl31
                        }
                        case 2: {
                            interactingDebugOptions = (JupyterExecutionTask.Options)this.L$1;
                            silentDebugOptions = (JupyterExecutionTask.Options)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl31:
                            // 2 sources

                            if (this.$jupyterDebugProcess.isConnected()) {
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)silentDebugOptions);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)interactingDebugOptions);
                                this.label = 3;
                                v2 = executeCell.1.invokeSuspend$executeAndWait(this.$project, this.$jupyterFile, this.$output, JupyterDebugProcess.Companion.disableTracingCommand(), JupyterExecutionTask.Options.Companion.silentExecution(), (Continuation<? super Unit>)((Continuation)this));
                                if (v2 == var4_2) {
                                    return var4_2;
                                }
                            }
                            ** GOTO lbl44
                        }
                        case 3: {
                            interactingDebugOptions = (JupyterExecutionTask.Options)this.L$1;
                            silentDebugOptions = (JupyterExecutionTask.Options)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl44:
                            // 2 sources

                            JupyterDebugSessionManager.Companion.getInstance(this.$project).debugInSessionFinished-MgfaZcY(this.$sessionPath);
                            if (this.$jupyterDebugProcess.isConnected()) {
                                this.$jupyterDebugProcess.stop();
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)silentDebugOptions);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)interactingDebugOptions);
                                this.label = 4;
                                v3 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.project.Project com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile ), ()Lkotlin/Unit;)((Project)this.$project, (BackedNotebookVirtualFile)this.$jupyterFile), (Continuation)((Continuation)this));
                                if (v3 == var4_2) {
                                    return var4_2;
                                }
                            }
                            ** GOTO lbl59
                        }
                        case 4: {
                            interactingDebugOptions = (JupyterExecutionTask.Options)this.L$1;
                            silentDebugOptions = (JupyterExecutionTask.Options)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl59:
                            // 2 sources

                            this.$jupyterDebugProcess.executeAfterCell();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Object invokeSuspend$executeAndWait(Project $project, BackedNotebookVirtualFile jupyterFile, OutputConsumer $output, String command, JupyterExecutionTask.Options options, Continuation<? super Unit> $completion) {
                    Object object = new JupyterMessageResultWaiter($project, jupyterFile, command, $output).executeAndWait(options, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$0(Project $project, BackedNotebookVirtualFile $jupyterFile) {
                    if (JupyterDebugger.INSTANCE.isUnderDebugger($project, $jupyterFile)) {
                        return Unit.INSTANCE;
                    }
                    ((JupyterCellExecutionListener)$project.getMessageBus().syncPublisher(JupyterCellExecutionListener.Companion.getTOPIC())).executionFinished($jupyterFile);
                    return Unit.INSTANCE;
                }

                public static final /* synthetic */ Object access$invokeSuspend$executeAndWait(Project $project, BackedNotebookVirtualFile jupyterFile, OutputConsumer $output, String command, JupyterExecutionTask.Options options, Continuation $completion) {
                    return executeCell.1.invokeSuspend$executeAndWait($project, jupyterFile, $output, command, options, (Continuation<? super Unit>)$completion);
                }
            }), (int)2, null);
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

