/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.UpdateScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0014J\b\u0010\u0016\u001a\u00020\u0005H\u0004J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/SingleUpdateScheduler;", "Lcom/intellij/kotlin/jupyter/core/util/UpdateScheduler;", "Lcom/intellij/openapi/Disposable;", "scheduledAction", "Lkotlin/Function0;", "", "parentDisposable", "delay", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/Disposable;J)V", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "isUpdateRequested", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "updateRunnable", "Ljava/lang/Runnable;", "requestUpdate", "scheduleUpdate", "actionInvocationDone", "fireActionFinished", "dispose", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nthreading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 threading.kt\ncom/intellij/kotlin/jupyter/core/util/SingleUpdateScheduler\n+ 2 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,175:1\n13#2:176\n*S KotlinDebug\n*F\n+ 1 threading.kt\ncom/intellij/kotlin/jupyter/core/util/SingleUpdateScheduler\n*L\n172#1:176\n*E\n"})
public class SingleUpdateScheduler
extends UpdateScheduler
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final AtomicBoolean isUpdateRequested;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    @NotNull
    private final Runnable updateRunnable;
    @NotNull
    private static final Logger LOG;

    public SingleUpdateScheduler(@NotNull Function0<Unit> scheduledAction, @NotNull Disposable parentDisposable, long delay) {
        Intrinsics.checkNotNullParameter(scheduledAction, (String)"scheduledAction");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(scheduledAction, delay, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"UpdateRequestor");
        Intrinsics.checkNotNullExpressionValue((Object)scheduledThreadPoolExecutor, (String)"newSingleScheduledThreadExecutor(...)");
        this.scheduler = scheduledThreadPoolExecutor;
        this.isUpdateRequested = new AtomicBoolean(false);
        this.updateRunnable = () -> SingleUpdateScheduler.updateRunnable$lambda$0(this);
    }

    public /* synthetic */ SingleUpdateScheduler(Function0 function0, Disposable disposable, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 300L;
        }
        this((Function0<Unit>)function0, disposable, l);
    }

    @Override
    public synchronized void requestUpdate() {
        if (!this.isUpdateRequested.getAndSet(true)) {
            LOG.debug("Update scheduled");
            this.scheduleUpdate();
        } else {
            LOG.debug("Ignoring update as have scheduled");
        }
    }

    private final void scheduleUpdate() {
        this.scheduledFuture = this.scheduler.schedule(this.updateRunnable, this.getDelay(), TimeUnit.MILLISECONDS);
    }

    protected void actionInvocationDone() {
        this.fireActionFinished();
    }

    protected final void fireActionFinished() {
        LOG.debug("Update is done");
        if (this.isUpdateRequested.compareAndSet(true, false)) {
            LOG.debug("Someone requested update, rescheduled");
            this.scheduleUpdate();
        } else {
            LOG.debug("No updates are requested right now");
        }
    }

    public void dispose() {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.scheduledFuture = null;
        this.scheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void updateRunnable$lambda$0(SingleUpdateScheduler this$0) {
        try {
            this$0.getUpdateAction().invoke();
        }
        finally {
            this$0.actionInvocationDone();
        }
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/SingleUpdateScheduler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

