/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.expression.editor;

import com.intellij.lang.Language;
import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionContributor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.vcs.github.ultimate.features.expression.editor.GithubExpressionInjection;
import com.intellij.vcs.github.ultimate.features.expression.editor.GithubExpressionLanguageInjectionContributorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/github/ultimate/features/expression/editor/GithubExpressionLanguageInjectionContributor;", "Lcom/intellij/lang/injection/general/LanguageInjectionContributor;", "<init>", "()V", "getInjection", "Lcom/intellij/lang/injection/general/Injection;", "context", "Lcom/intellij/psi/PsiElement;", "isSuitableElementType", "", "hasGithubLanguageMarkers", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "intellij.vcs.github.ultimate.features"})
public final class GithubExpressionLanguageInjectionContributor
implements LanguageInjectionContributor {
    @Nullable
    public Injection getInjection(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.isSuitableElementType(context)) {
            return null;
        }
        return (Injection)GithubExpressionInjection.INSTANCE;
    }

    private final boolean isSuitableElementType(PsiElement context) {
        return context instanceof YAMLScalar && GithubYamlFileDetectionKt.isGithubActionsFile(((YAMLScalar)context).getContainingFile().getOriginalFile()) && this.hasGithubLanguageMarkers((YAMLScalar)context);
    }

    private final boolean hasGithubLanguageMarkers(YAMLScalar context) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)context), () -> GithubExpressionLanguageInjectionContributor.hasGithubLanguageMarkers$lambda$0(context));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    private static final CachedValueProvider.Result hasGithubLanguageMarkers$lambda$0(YAMLScalar $context) {
        Regex regex = GithubExpressionLanguageInjectionContributorKt.getInjectedGithubExpressionLanguageSegmentPattern();
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)$context.getText(), (long)100L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        boolean hasGithubLanguageMarkers = regex.containsMatchIn(charSequence) || GithubExpressionLanguageInjectionContributorKt.shouldInjectIntoEntireElementRange((PsiElement)$context);
        Object[] objectArray = new Object[]{$context.getManager().getModificationTracker().forLanguage((Language)YAMLLanguage.INSTANCE)};
        return CachedValueProvider.Result.create((Object)hasGithubLanguageMarkers, (Object[])objectArray);
    }
}

