/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.analyzers;

import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiRecord;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.impl.HprofObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\"\b\b\u0000\u0010\u0007*\u00020\b\"\b\b\u0001\u0010\t*\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ultimate/hprof/analyzers/StringDuplicatesAnalyzer;", "", "<init>", "()V", "calculateDuplicatedStrings", "", "Lcom/intellij/profiler/ultimate/hprof/analyzers/StringDuplicatesAnalyzer$DuplicatedString;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "minWasteBytes", "", "DuplicatedString", "CountAndWaste", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nStringDuplicatesAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringDuplicatesAnalyzer.kt\ncom/intellij/profiler/ultimate/hprof/analyzers/StringDuplicatesAnalyzer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n136#2,9:46\n216#2:55\n217#2:57\n145#2:58\n1#3:56\n*S KotlinDebug\n*F\n+ 1 StringDuplicatesAnalyzer.kt\ncom/intellij/profiler/ultimate/hprof/analyzers/StringDuplicatesAnalyzer\n*L\n35#1:46,9\n35#1:55\n35#1:57\n35#1:58\n35#1:56\n*E\n"})
public final class StringDuplicatesAnalyzer {
    @NotNull
    public static final StringDuplicatesAnalyzer INSTANCE = new StringDuplicatesAnalyzer();

    private StringDuplicatesAnalyzer() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends MuiType, I extends MuiInstance> List<DuplicatedString> calculateDuplicatedStrings(@NotNull MuiSnapshot<T, I> snapshot, @NotNull ProgressIndicator indicator, long minWasteBytes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!(snapshot instanceof HprofDump)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        HprofDump hprofDump = (HprofDump)snapshot;
        String string = String.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        MuiType muiType = hprofDump.getTypeByName(string);
        if (muiType == null) {
            return CollectionsKt.emptyList();
        }
        MuiType stringClass = muiType;
        Ref.IntRef processedInstancesCount = new Ref.IntRef();
        HashMap stringsStats = new HashMap();
        ((HprofDump)snapshot).runParser(arg_0 -> StringDuplicatesAnalyzer.calculateDuplicatedStrings$lambda$2(snapshot, stringClass, indicator, stringsStats, processedInstancesCount, arg_0));
        Map $this$mapNotNull$iv = stringsStats;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            DuplicatedString it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            long wastedBytes = ((CountAndWaste)it.getValue()).getWastedBytes() - ((CountAndWaste)it.getValue()).getWastedBytes() / ((CountAndWaste)it.getValue()).getCount();
            if ((((CountAndWaste)it.getValue()).getCount() < 2L || wastedBytes < minWasteBytes ? null : new DuplicatedString((String)it.getKey(), ((CountAndWaste)it.getValue()).getCount() - 1L, wastedBytes)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List calculateDuplicatedStrings$default(StringDuplicatesAnalyzer stringDuplicatesAnalyzer, MuiSnapshot muiSnapshot, ProgressIndicator progressIndicator, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 1024L;
        }
        return stringDuplicatesAnalyzer.calculateDuplicatedStrings(muiSnapshot, progressIndicator, l);
    }

    private static final boolean calculateDuplicatedStrings$lambda$2$lambda$1(ProgressIndicator $indicator, HProfEventBasedParser $this_runParser, HashMap $stringsStats, Ref.IntRef $processedInstancesCount, MuiType $stringClass, HprofObject it) {
        String stringValue;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($indicator.isCanceled()) {
            throw new ProcessCanceledException();
        }
        MuiRecord muiRecord = it instanceof MuiRecord ? (MuiRecord)((Object)it) : null;
        String string = stringValue = muiRecord != null ? MuiRecord.getStringValue$default(muiRecord, "value", 0, $this_runParser, 2, null) : null;
        if (stringValue != null && !Intrinsics.areEqual((Object)stringValue, (Object)"<unknown coder>")) {
            CountAndWaste countAndWaste = $stringsStats.putIfAbsent(stringValue, new CountAndWaste(1L, ((MuiInstance)it).getInstanceSize()));
            if (countAndWaste != null) {
                CountAndWaste countAndWaste2;
                CountAndWaste $this$calculateDuplicatedStrings_u24lambda_u242_u24lambda_u241_u24lambda_u240 = countAndWaste2 = countAndWaste;
                boolean bl = false;
                $this$calculateDuplicatedStrings_u24lambda_u242_u24lambda_u241_u24lambda_u240.setCount($this$calculateDuplicatedStrings_u24lambda_u242_u24lambda_u241_u24lambda_u240.getCount() + 1L);
                $this$calculateDuplicatedStrings_u24lambda_u242_u24lambda_u241_u24lambda_u240.setWastedBytes($this$calculateDuplicatedStrings_u24lambda_u242_u24lambda_u241_u24lambda_u240.getWastedBytes() + ((MuiInstance)it).getInstanceSize());
            }
        }
        ++$processedInstancesCount.element;
        $indicator.setFraction((double)$processedInstancesCount.element / (double)((HprofClass)$stringClass).getInstanceCount());
        return true;
    }

    private static final Unit calculateDuplicatedStrings$lambda$2(MuiSnapshot $snapshot, MuiType $stringClass, ProgressIndicator $indicator, HashMap $stringsStats, Ref.IntRef $processedInstancesCount, HProfEventBasedParser $this$runParser) {
        Intrinsics.checkNotNullParameter((Object)$this$runParser, (String)"$this$runParser");
        ((HprofDump)$snapshot).forEachInstance((HprofClass)$stringClass, arg_0 -> StringDuplicatesAnalyzer.calculateDuplicatedStrings$lambda$2$lambda$1($indicator, $this$runParser, $stringsStats, $processedInstancesCount, $stringClass, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ultimate/hprof/analyzers/StringDuplicatesAnalyzer$CountAndWaste;", "", "count", "", "wastedBytes", "<init>", "(JJ)V", "getCount", "()J", "setCount", "(J)V", "getWastedBytes", "setWastedBytes", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.ultimate"})
    private static final class CountAndWaste {
        private long count;
        private long wastedBytes;

        public CountAndWaste(long count, long wastedBytes) {
            this.count = count;
            this.wastedBytes = wastedBytes;
        }

        public final long getCount() {
            return this.count;
        }

        public final void setCount(long l) {
            this.count = l;
        }

        public final long getWastedBytes() {
            return this.wastedBytes;
        }

        public final void setWastedBytes(long l) {
            this.wastedBytes = l;
        }

        public final long component1() {
            return this.count;
        }

        public final long component2() {
            return this.wastedBytes;
        }

        @NotNull
        public final CountAndWaste copy(long count, long wastedBytes) {
            return new CountAndWaste(count, wastedBytes);
        }

        public static /* synthetic */ CountAndWaste copy$default(CountAndWaste countAndWaste, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = countAndWaste.count;
            }
            if ((n & 2) != 0) {
                l2 = countAndWaste.wastedBytes;
            }
            return countAndWaste.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "CountAndWaste(count=" + this.count + ", wastedBytes=" + this.wastedBytes + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.count);
            result = result * 31 + Long.hashCode(this.wastedBytes);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CountAndWaste)) {
                return false;
            }
            CountAndWaste countAndWaste = (CountAndWaste)other;
            if (this.count != countAndWaste.count) {
                return false;
            }
            return this.wastedBytes == countAndWaste.wastedBytes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/ultimate/hprof/analyzers/StringDuplicatesAnalyzer$DuplicatedString;", "", "value", "", "duplicatesCount", "", "wastedBytes", "<init>", "(Ljava/lang/String;JJ)V", "getValue", "()Ljava/lang/String;", "getDuplicatesCount", "()J", "getWastedBytes", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.profiler.ultimate"})
    public static final class DuplicatedString {
        @NotNull
        private final String value;
        private final long duplicatesCount;
        private final long wastedBytes;

        public DuplicatedString(@NotNull String value, long duplicatesCount, long wastedBytes) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.duplicatesCount = duplicatesCount;
            this.wastedBytes = wastedBytes;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public final long getDuplicatesCount() {
            return this.duplicatesCount;
        }

        public final long getWastedBytes() {
            return this.wastedBytes;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        public final long component2() {
            return this.duplicatesCount;
        }

        public final long component3() {
            return this.wastedBytes;
        }

        @NotNull
        public final DuplicatedString copy(@NotNull String value, long duplicatesCount, long wastedBytes) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new DuplicatedString(value, duplicatesCount, wastedBytes);
        }

        public static /* synthetic */ DuplicatedString copy$default(DuplicatedString duplicatedString, String string, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = duplicatedString.value;
            }
            if ((n & 2) != 0) {
                l = duplicatedString.duplicatesCount;
            }
            if ((n & 4) != 0) {
                l2 = duplicatedString.wastedBytes;
            }
            return duplicatedString.copy(string, l, l2);
        }

        @NotNull
        public String toString() {
            return "DuplicatedString(value=" + this.value + ", duplicatesCount=" + this.duplicatesCount + ", wastedBytes=" + this.wastedBytes + ")";
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + Long.hashCode(this.duplicatesCount);
            result = result * 31 + Long.hashCode(this.wastedBytes);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DuplicatedString)) {
                return false;
            }
            DuplicatedString duplicatedString = (DuplicatedString)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)duplicatedString.value)) {
                return false;
            }
            if (this.duplicatesCount != duplicatedString.duplicatesCount) {
                return false;
            }
            return this.wastedBytes == duplicatedString.wastedBytes;
        }
    }
}

