/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.CommonSearchUtilsKt;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.OverloadReducer;
import org.jetbrains.kotlin.j2k.OverloadReducerKt;
import org.jetbrains.kotlin.j2k.PropertyInfo;
import org.jetbrains.kotlin.j2k.SpecialExpressionConverter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.AnnotationUseTarget;
import org.jetbrains.kotlin.j2k.ast.Annotations;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.CommentsAndSpacesInheritance;
import org.jetbrains.kotlin.j2k.ast.Constructor;
import org.jetbrains.kotlin.j2k.ast.DeferredElement;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.FunctionParameter;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Modifiers;
import org.jetbrains.kotlin.j2k.ast.ParameterList;
import org.jetbrains.kotlin.j2k.ast.PrimaryConstructor;
import org.jetbrains.kotlin.j2k.ast.PrototypeInfo;
import org.jetbrains.kotlin.j2k.ast.SecondaryConstructor;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00015B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0013H\u0002JB\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J:\u0010*\u001a\u00020+2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0\u0007H\u0002J&\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020.\u0018\u00010-2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\f\u00101\u001a\u000202*\u000203H\u0002J\f\u00104\u001a\u000202*\u000203H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u001a\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0018\u00010\u000f2\u0014\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/j2k/ConstructorConverter;", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "fieldToPropertyInfo", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiField;", "Lorg/jetbrains/kotlin/j2k/PropertyInfo;", "overloadReducer", "Lorg/jetbrains/kotlin/j2k/OverloadReducer;", "<init>", "(Lcom/intellij/psi/PsiClass;Lorg/jetbrains/kotlin/j2k/Converter;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/j2k/OverloadReducer;)V", "constructors", "", "Lcom/intellij/psi/PsiMethod;", "kotlin.jvm.PlatformType", "toTargetConstructorMap", "", "primaryConstructor", "choosePrimaryConstructor", "buildToTargetConstructorMap", "value", "Lorg/jetbrains/kotlin/j2k/ast/DeferredElement;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "baseClassParams", "getBaseClassParams", "()Ljava/util/List;", "convertConstructor", "Lorg/jetbrains/kotlin/j2k/ast/Constructor;", "constructor", "annotations", "Lorg/jetbrains/kotlin/j2k/ast/Annotations;", "modifiers", "Lorg/jetbrains/kotlin/j2k/ast/Modifiers;", "fieldsToDrop", "", "postProcessBody", "Lorg/jetbrains/kotlin/j2k/ast/Block;", "findThisOrSuperCall", "Lcom/intellij/psi/PsiExpressionStatement;", "convertPrimaryConstructor", "Lorg/jetbrains/kotlin/j2k/ast/PrimaryConstructor;", "findBackingFieldForConstructorParameter", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiStatement;", "parameter", "Lcom/intellij/psi/PsiParameter;", "isSuperConstructorCall", "", "Lcom/intellij/psi/PsiExpression;", "isThisConstructorCall", "ReplacingExpressionConverter", "kotlin.j2k.k1.old"})
@SourceDebugExtension(value={"SMAP\nConstructorConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructorConverter.kt\norg/jetbrains/kotlin/j2k/ConstructorConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,265:1\n774#2:266\n865#2,2:267\n1761#2,3:269\n1761#2,3:276\n1761#2,3:279\n11228#3:272\n11563#3,3:273\n*S KotlinDebug\n*F\n+ 1 ConstructorConverter.kt\norg/jetbrains/kotlin/j2k/ConstructorConverter\n*L\n26#1:266\n26#1:267,2\n29#1:269,3\n216#1:276,3\n233#1:279,3\n166#1:272\n166#1:273,3\n*E\n"})
public final class ConstructorConverter {
    @NotNull
    private final PsiClass psiClass;
    @NotNull
    private final Converter converter;
    @NotNull
    private final Function1<PsiField, PropertyInfo> fieldToPropertyInfo;
    @NotNull
    private final OverloadReducer overloadReducer;
    @NotNull
    private final List<PsiMethod> constructors;
    @NotNull
    private final Map<PsiMethod, PsiMethod> toTargetConstructorMap;
    @Nullable
    private final PsiMethod primaryConstructor;
    @Nullable
    private List<DeferredElement<Expression>> baseClassParams;

    public ConstructorConverter(@NotNull PsiClass psiClass, @NotNull Converter converter, @NotNull Function1<? super PsiField, PropertyInfo> fieldToPropertyInfo, @NotNull OverloadReducer overloadReducer) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        Intrinsics.checkNotNullParameter(fieldToPropertyInfo, (String)"fieldToPropertyInfo");
        Intrinsics.checkNotNullParameter((Object)overloadReducer, (String)"overloadReducer");
        this.psiClass = psiClass;
        this.converter = converter;
        this.fieldToPropertyInfo = fieldToPropertyInfo;
        this.overloadReducer = overloadReducer;
        PsiMethod[] psiMethodArray = this.psiClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
        this.constructors = ArraysKt.asList((Object[])psiMethodArray);
        this.toTargetConstructorMap = this.buildToTargetConstructorMap();
        this.primaryConstructor = switch (this.constructors.size()) {
            case 0 -> null;
            case 1 -> (PsiMethod)CollectionsKt.single(this.constructors);
            default -> this.choosePrimaryConstructor();
        };
        this.baseClassParams = this.constructors.isEmpty() ? CollectionsKt.emptyList() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiMethod choosePrimaryConstructor() {
        boolean bl;
        PsiMethod primary;
        block6: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.constructors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiMethod it = (PsiMethod)element$iv$iv;
                boolean bl2 = false;
                if (!(!this.toTargetConstructorMap.containsKey(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List candidates2 = (List)destination$iv$iv;
            if (candidates2.size() != 1) {
                return null;
            }
            primary = (PsiMethod)CollectionsKt.single((List)candidates2);
            Iterable $this$any$iv = this.toTargetConstructorMap.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiMethod it = (PsiMethod)element$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)primary))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return primary;
    }

    private final Map<PsiMethod, PsiMethod> buildToTargetConstructorMap() {
        HashMap toTargetConstructorMap = new HashMap();
        for (PsiMethod constructor : this.constructors) {
            PsiElement psiElement;
            PsiMethod target;
            PsiReferenceExpression refExpr;
            Object[] objectArray = constructor.getBody();
            PsiStatement firstStatement = objectArray != null && (objectArray = objectArray.getStatements()) != null ? (PsiStatement)ArraysKt.firstOrNull((Object[])objectArray) : null;
            PsiExpressionStatement psiExpressionStatement = firstStatement instanceof PsiExpressionStatement ? (PsiExpressionStatement)firstStatement : null;
            Object object = psiExpressionStatement != null ? psiExpressionStatement.getExpression() : null;
            PsiMethodCallExpression methodCall = object instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)object : null;
            if (methodCall == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)methodCall.getMethodExpression(), (String)"getMethodExpression(...)");
            if (!Intrinsics.areEqual((Object)refExpr.getCanonicalText(), (Object)"this") || (target = (psiElement = refExpr.resolve()) instanceof PsiMethod ? (PsiMethod)psiElement : null) == null || !target.isConstructor()) continue;
            PsiMethod psiMethod = (PsiMethod)toTargetConstructorMap.get(target);
            if (psiMethod == null) {
                psiMethod = target;
            }
            PsiMethod finalTarget = psiMethod;
            ((Map)toTargetConstructorMap).put(constructor, finalTarget);
            Iterator iterator2 = toTargetConstructorMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                if (!Intrinsics.areEqual(entry.getValue(), (Object)constructor)) continue;
                entry.setValue(finalTarget);
            }
        }
        return toTargetConstructorMap;
    }

    @Nullable
    public final List<DeferredElement<Expression>> getBaseClassParams() {
        return this.baseClassParams;
    }

    @Nullable
    public final Constructor convertConstructor(@NotNull PsiMethod constructor, @NotNull Annotations annotations2, @NotNull Modifiers modifiers, @NotNull Set<PsiField> fieldsToDrop, @NotNull Function1<? super Block, Block> postProcessBody) {
        Constructor constructor2;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        Intrinsics.checkNotNullParameter(fieldsToDrop, (String)"fieldsToDrop");
        Intrinsics.checkNotNullParameter(postProcessBody, (String)"postProcessBody");
        if (Intrinsics.areEqual((Object)constructor, (Object)this.primaryConstructor)) {
            constructor2 = this.convertPrimaryConstructor(annotations2, modifiers, fieldsToDrop, postProcessBody);
        } else {
            if (this.overloadReducer.shouldDropMethod(constructor)) {
                return null;
            }
            ParameterList params = OverloadReducerKt.convertParameterList$default(this.converter, constructor, this.overloadReducer, null, null, 12, null);
            PsiExpressionStatement thisOrSuper = this.findThisOrSuperCall(constructor);
            DeferredElement<Expression> thisOrSuperDeferred = thisOrSuper != null ? this.converter.deferredElement(arg_0 -> ConstructorConverter.convertConstructor$lambda$2(thisOrSuper, arg_0)) : null;
            constructor2 = new SecondaryConstructor(annotations2, modifiers, params, this.converter.deferredElement((Function1)new Function1<CodeConverter, Block>(postProcessBody, constructor, this){
                final /* synthetic */ Function1<Block, Block> $postProcessBody;
                final /* synthetic */ PsiMethod $constructor;
                final /* synthetic */ ConstructorConverter this$0;
                {
                    this.$postProcessBody = $postProcessBody;
                    this.$constructor = $constructor;
                    this.this$0 = $receiver;
                    super(1, Intrinsics.Kotlin.class, "convertBody", "convertConstructor$convertBody(Lkotlin/jvm/functions/Function1;Lcom/intellij/psi/PsiMethod;Lorg/jetbrains/kotlin/j2k/ConstructorConverter;Lorg/jetbrains/kotlin/j2k/CodeConverter;)Lorg/jetbrains/kotlin/j2k/ast/Block;", 0);
                }

                public final Block invoke(CodeConverter p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ConstructorConverter.access$convertConstructor$convertBody(this.$postProcessBody, this.$constructor, this.this$0, p0);
                }
            }), thisOrSuperDeferred);
        }
        return constructor2;
    }

    private final PsiExpressionStatement findThisOrSuperCall(PsiMethod constructor) {
        Object[] objectArray = constructor.getBody();
        PsiStatement psiStatement = objectArray != null && (objectArray = objectArray.getStatements()) != null ? (PsiStatement)ArraysKt.firstOrNull((Object[])objectArray) : null;
        PsiExpressionStatement psiExpressionStatement = psiStatement instanceof PsiExpressionStatement ? (PsiExpressionStatement)psiStatement : null;
        if (psiExpressionStatement == null) {
            return null;
        }
        PsiExpressionStatement statement = psiExpressionStatement;
        PsiExpression psiExpression = statement.getExpression();
        PsiMethodCallExpression psiMethodCallExpression = psiExpression instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)psiExpression : null;
        if (psiMethodCallExpression == null) {
            return null;
        }
        PsiMethodCallExpression methodCall = psiMethodCallExpression;
        String text = methodCall.getMethodExpression().getText();
        return Intrinsics.areEqual((Object)text, (Object)"this") || Intrinsics.areEqual((Object)text, (Object)"super") ? statement : null;
    }

    /*
     * WARNING - void declaration
     */
    private final PrimaryConstructor convertPrimaryConstructor(Annotations annotations2, Modifiers modifiers, Set<PsiField> fieldsToDrop, Function1<? super Block, Block> postProcessBody) {
        List list2;
        Function1 function1;
        PropertyInfo propertyInfo;
        Pair<PsiField, PsiStatement> pair;
        PsiMethod psiMethod = this.primaryConstructor;
        Intrinsics.checkNotNull((Object)psiMethod);
        PsiParameter[] psiParameterArray = psiMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] params = psiParameterArray;
        HashMap<PsiParameter, Pair> parameterToField = new HashMap<PsiParameter, Pair>();
        PsiCodeBlock body2 = this.primaryConstructor.getBody();
        HashMap<String, String> parameterUsageReplacementMap = new HashMap<String, String>();
        if (body2 != null) {
            HashSet<PsiStatement> statementsToRemove = new HashSet<PsiStatement>();
            for (PsiParameter parameter : params) {
                Type type2;
                Type parameterType;
                Intrinsics.checkNotNull((Object)parameter);
                if (this.findBackingFieldForConstructorParameter(parameter, this.primaryConstructor) == null) continue;
                PsiField field2 = (PsiField)pair.component1();
                PsiStatement initializationStatement = (PsiStatement)pair.component2();
                Type fieldType = this.converter.getTypeConverter().convertVariableType((PsiVariable)field2);
                if (Intrinsics.areEqual((Object)fieldType, (Object)(parameterType = this.converter.getTypeConverter().convertVariableType((PsiVariable)parameter)))) {
                    type2 = fieldType;
                } else {
                    if (!Intrinsics.areEqual((Object)fieldType.toNotNullType(), (Object)parameterType.toNotNullType())) continue;
                    type2 = fieldType.isNullable() ? fieldType : parameterType;
                }
                Type type3 = type2;
                propertyInfo = (PropertyInfo)this.fieldToPropertyInfo.invoke((Object)field2);
                if (propertyInfo.getNeedExplicitGetter() || propertyInfo.getNeedExplicitSetter()) continue;
                parameterToField.put(parameter, TuplesKt.to((Object)field2, (Object)type3));
                statementsToRemove.add(initializationStatement);
                fieldsToDrop.add(field2);
                String fieldName = propertyInfo.getName();
                if (Intrinsics.areEqual((Object)fieldName, (Object)parameter.getName())) continue;
                parameterUsageReplacementMap.put(parameter.getName(), fieldName);
            }
            function1 = arg_0 -> ConstructorConverter.convertPrimaryConstructor$lambda$4(postProcessBody, body2, this, parameterUsageReplacementMap, statementsToRemove, arg_0);
        } else {
            function1 = ConstructorConverter::convertPrimaryConstructor$lambda$5;
        }
        Function1 bodyGenerator2 = function1;
        Object[] objectArray = this.primaryConstructor.getBody();
        PsiStatement statement = objectArray != null && (objectArray = objectArray.getStatements()) != null ? (PsiStatement)ArraysKt.firstOrNull((Object[])objectArray) : null;
        PsiExpressionStatement psiExpressionStatement = statement instanceof PsiExpressionStatement ? (PsiExpressionStatement)statement : null;
        Object[] objectArray2 = psiExpressionStatement != null ? psiExpressionStatement.getExpression() : null;
        PsiMethodCallExpression methodCall = objectArray2 instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)objectArray2 : null;
        ConstructorConverter constructorConverter = this;
        if (methodCall != null && this.isSuperConstructorCall((PsiExpression)methodCall)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PsiExpression[] psiExpressionArray = methodCall.getArgumentList().getExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)psiExpressionArray, (String)"getExpressions(...)");
            objectArray2 = psiExpressionArray;
            ConstructorConverter constructorConverter2 = constructorConverter;
            boolean $i$f$map = false;
            pair = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                propertyInfo = (PsiExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.converter.deferredElement(arg_0 -> ConstructorConverter.convertPrimaryConstructor$lambda$7$lambda$6((PsiExpression)it, this, parameterUsageReplacementMap, arg_0)));
            }
            list2 = (List)destination$iv$iv;
            constructorConverter = constructorConverter2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        constructorConverter.baseClassParams = list2;
        ParameterList parameterList = OverloadReducerKt.convertParameterList(this.converter, this.primaryConstructor, this.overloadReducer, (Function2<? super PsiParameter, ? super DeferredElement<Expression>, FunctionParameter>)((Function2)(arg_0, arg_1) -> ConstructorConverter.convertPrimaryConstructor$lambda$8(parameterToField, this, arg_0, arg_1)), (Function1<? super CodeConverter, CodeConverter>)((Function1)arg_0 -> ConstructorConverter.convertPrimaryConstructor$lambda$9(this, parameterUsageReplacementMap, arg_0)));
        return (PrimaryConstructor)ElementKt.assignPrototype$default(new PrimaryConstructor(annotations2, modifiers, parameterList, this.converter.deferredElement(bodyGenerator2)), (PsiElement)this.primaryConstructor, null, 2, null);
    }

    private final Pair<PsiField, PsiStatement> findBackingFieldForConstructorParameter(PsiParameter parameter, PsiMethod constructor) {
        PsiReferenceExpression it;
        boolean bl;
        Collection<PsiReferenceExpression> refs;
        PsiCodeBlock body2;
        block9: {
            PsiCodeBlock psiCodeBlock = constructor.getBody();
            if (psiCodeBlock == null) {
                return null;
            }
            body2 = psiCodeBlock;
            refs = CommonSearchUtilsKt.findVariableUsages(this.converter.getReferenceSearcher(), (PsiVariable)parameter, (PsiElement)body2);
            Iterable $this$any$iv = refs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PsiReferenceExpression)element$iv;
                    boolean bl2 = false;
                    if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)it))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        for (PsiReferenceExpression ref : refs) {
            boolean bl3;
            PsiExpressionStatement statement;
            PsiField field2;
            block10: {
                PsiReferenceExpression assignee;
                PsiAssignmentExpression assignment2;
                it = ref.getParent();
                PsiAssignmentExpression psiAssignmentExpression = it instanceof PsiAssignmentExpression ? (PsiAssignmentExpression)it : null;
                if (psiAssignmentExpression == null || !Intrinsics.areEqual((Object)(assignment2 = psiAssignmentExpression).getOperationSign().getTokenType(), (Object)JavaTokenType.EQ)) continue;
                PsiExpression bl2 = assignment2.getLExpression();
                PsiReferenceExpression psiReferenceExpression = bl2 instanceof PsiReferenceExpression ? (PsiReferenceExpression)bl2 : null;
                if (psiReferenceExpression == null || !UtilsKt.isQualifierEmptyOrThis(assignee = psiReferenceExpression)) continue;
                PsiElement psiElement = assignee.resolve();
                PsiField psiField2 = psiElement instanceof PsiField ? (PsiField)psiElement : null;
                if (psiField2 == null || !Intrinsics.areEqual((Object)(field2 = psiField2).getContainingClass(), (Object)constructor.getContainingClass()) || field2.hasModifierProperty("static") || field2.getInitializer() != null) continue;
                PsiElement psiElement2 = assignment2.getParent();
                PsiExpressionStatement psiExpressionStatement = psiElement2 instanceof PsiExpressionStatement ? (PsiExpressionStatement)psiElement2 : null;
                if (psiExpressionStatement == null || !Intrinsics.areEqual((Object)(statement = psiExpressionStatement).getParent(), (Object)body2)) continue;
                Iterable $this$any$iv = CommonSearchUtilsKt.findVariableUsages(this.converter.getReferenceSearcher(), (PsiVariable)field2, (PsiElement)body2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiReferenceExpression it2 = (PsiReferenceExpression)element$iv;
                        boolean bl4 = false;
                        if (!(!Intrinsics.areEqual((Object)it2, (Object)assignee) && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)it2)) && UtilsKt.isQualifierEmptyOrThis(it2))) continue;
                        bl3 = true;
                        break block10;
                    }
                    bl3 = false;
                }
            }
            if (bl3) continue;
            return TuplesKt.to((Object)field2, (Object)statement);
        }
        return null;
    }

    private final boolean isSuperConstructorCall(PsiExpression $this$isSuperConstructorCall) {
        PsiMethodCallExpression psiMethodCallExpression = $this$isSuperConstructorCall instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)$this$isSuperConstructorCall : null;
        return Intrinsics.areEqual((Object)(psiMethodCallExpression != null && (psiMethodCallExpression = psiMethodCallExpression.getMethodExpression()) != null ? psiMethodCallExpression.getText() : null), (Object)"super");
    }

    private final boolean isThisConstructorCall(PsiExpression $this$isThisConstructorCall) {
        PsiMethodCallExpression psiMethodCallExpression = $this$isThisConstructorCall instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)$this$isThisConstructorCall : null;
        return Intrinsics.areEqual((Object)(psiMethodCallExpression != null && (psiMethodCallExpression = psiMethodCallExpression.getMethodExpression()) != null ? psiMethodCallExpression.getText() : null), (Object)"this");
    }

    private static final Expression convertConstructor$lambda$2(PsiExpressionStatement $thisOrSuper, CodeConverter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CodeConverter.convertExpression$default(it, $thisOrSuper.getExpression(), false, 2, null);
    }

    private static final Block convertConstructor$convertBody(Function1<? super Block, Block> $postProcessBody, PsiMethod $constructor, ConstructorConverter this$0, CodeConverter codeConverter) {
        return (Block)$postProcessBody.invoke((Object)CodeConverter.convertBlock$default(codeConverter.withSpecialExpressionConverter(new SpecialExpressionConverter(this$0){
            final /* synthetic */ ConstructorConverter this$0;
            {
                this.this$0 = $receiver;
            }

            public Expression convertExpression(PsiExpression expression, CodeConverter codeConverter) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
                if (ConstructorConverter.access$isThisConstructorCall(this.this$0, expression) || ConstructorConverter.access$isSuperConstructorCall(this.this$0, expression)) {
                    return Expression.Empty.INSTANCE;
                }
                return null;
            }
        }), $constructor.getBody(), false, null, 6, null));
    }

    private static final boolean convertPrimaryConstructor$lambda$4$lambda$3(HashSet $statementsToRemove, PsiStatement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$statementsToRemove.contains(it);
    }

    private static final Block convertPrimaryConstructor$lambda$4(Function1 $postProcessBody, PsiCodeBlock $body, ConstructorConverter this$0, HashMap $parameterUsageReplacementMap, HashSet $statementsToRemove, CodeConverter codeConverter) {
        Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
        CodeConverter bodyConverter2 = codeConverter.withSpecialExpressionConverter(new ReplacingExpressionConverter(this$0, $parameterUsageReplacementMap){
            final /* synthetic */ ConstructorConverter this$0;
            {
                this.this$0 = $receiver;
                super((Map<String, String>)$parameterUsageReplacementMap);
            }

            public Expression convertExpression(PsiExpression expression, CodeConverter codeConverter) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
                if (ConstructorConverter.access$isSuperConstructorCall(this.this$0, expression)) {
                    return Expression.Empty.INSTANCE;
                }
                return super.convertExpression(expression, codeConverter);
            }
        });
        return (Block)$postProcessBody.invoke((Object)bodyConverter2.convertBlock($body, false, (Function1<? super PsiStatement, Boolean>)((Function1)arg_0 -> ConstructorConverter.convertPrimaryConstructor$lambda$4$lambda$3($statementsToRemove, arg_0))));
    }

    private static final Block convertPrimaryConstructor$lambda$5(CodeConverter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Block.Companion.getEmpty();
    }

    private static final CodeConverter convertPrimaryConstructor$correct(CodeConverter $this$convertPrimaryConstructor_u24correct, ConstructorConverter this$0, HashMap<String, String> parameterUsageReplacementMap) {
        return $this$convertPrimaryConstructor_u24correct.withSpecialExpressionConverter(this$0.new ReplacingExpressionConverter((Map<String, String>)parameterUsageReplacementMap));
    }

    private static final Expression convertPrimaryConstructor$lambda$7$lambda$6(PsiExpression $it, ConstructorConverter this$0, HashMap $parameterUsageReplacementMap, CodeConverter codeConverter) {
        Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
        return CodeConverter.convertExpression$default(ConstructorConverter.convertPrimaryConstructor$correct(codeConverter, this$0, $parameterUsageReplacementMap), $it, false, 2, null);
    }

    private static final FunctionParameter convertPrimaryConstructor$lambda$8(HashMap $parameterToField, ConstructorConverter this$0, PsiParameter parameter, DeferredElement deferredElement) {
        FunctionParameter functionParameter;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        if (!$parameterToField.containsKey(parameter)) {
            functionParameter = Converter.convertParameter$default(this$0.converter, parameter, null, null, null, deferredElement, 14, null);
        } else {
            Object v = $parameterToField.get(parameter);
            Intrinsics.checkNotNull(v);
            Pair pair = (Pair)v;
            PsiField field2 = (PsiField)pair.component1();
            Type type2 = (Type)pair.component2();
            PropertyInfo propertyInfo = (PropertyInfo)this$0.fieldToPropertyInfo.invoke((Object)field2);
            Annotations paramAnnotations = this$0.converter.convertAnnotations((PsiModifierListOwner)parameter, AnnotationUseTarget.Param).plus(this$0.converter.convertAnnotations((PsiModifierListOwner)field2, AnnotationUseTarget.Field));
            if (propertyInfo.getGetMethod() != null) {
                paramAnnotations = paramAnnotations.plus(this$0.converter.convertAnnotations((PsiModifierListOwner)propertyInfo.getGetMethod(), AnnotationUseTarget.Get));
            }
            if (propertyInfo.getSetMethod() != null) {
                paramAnnotations = paramAnnotations.plus(this$0.converter.convertAnnotations((PsiModifierListOwner)propertyInfo.getSetMethod(), AnnotationUseTarget.Set));
            }
            PrototypeInfo[] prototypeInfoArray = new PrototypeInfo[]{new PrototypeInfo((PsiElement)parameter, CommentsAndSpacesInheritance.Companion.getLINE_BREAKS()), new PrototypeInfo((PsiElement)field2, CommentsAndSpacesInheritance.Companion.getNO_SPACES())};
            functionParameter = (FunctionParameter)ElementKt.assignPrototypes((Element)new FunctionParameter(propertyInfo.getIdentifier(), type2, propertyInfo.isVar() ? FunctionParameter.VarValModifier.Var : FunctionParameter.VarValModifier.Val, paramAnnotations, propertyInfo.getModifiers(), deferredElement), prototypeInfoArray);
        }
        return functionParameter;
    }

    private static final CodeConverter convertPrimaryConstructor$lambda$9(ConstructorConverter this$0, HashMap $parameterUsageReplacementMap, CodeConverter $this$convertParameterList) {
        Intrinsics.checkNotNullParameter((Object)$this$convertParameterList, (String)"$this$convertParameterList");
        return ConstructorConverter.convertPrimaryConstructor$correct($this$convertParameterList, this$0, $parameterUsageReplacementMap);
    }

    public static final /* synthetic */ Block access$convertConstructor$convertBody(Function1 $postProcessBody, PsiMethod $constructor, ConstructorConverter this$0, CodeConverter codeConverter) {
        return ConstructorConverter.convertConstructor$convertBody((Function1<? super Block, Block>)$postProcessBody, $constructor, this$0, codeConverter);
    }

    public static final /* synthetic */ boolean access$isThisConstructorCall(ConstructorConverter $this, PsiExpression $receiver) {
        return $this.isThisConstructorCall($receiver);
    }

    public static final /* synthetic */ boolean access$isSuperConstructorCall(ConstructorConverter $this, PsiExpression $receiver) {
        return $this.isSuperConstructorCall($receiver);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/j2k/ConstructorConverter$ReplacingExpressionConverter;", "Lorg/jetbrains/kotlin/j2k/SpecialExpressionConverter;", "parameterUsageReplacementMap", "", "", "<init>", "(Lorg/jetbrains/kotlin/j2k/ConstructorConverter;Ljava/util/Map;)V", "getParameterUsageReplacementMap", "()Ljava/util/Map;", "convertExpression", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expression", "Lcom/intellij/psi/PsiExpression;", "codeConverter", "Lorg/jetbrains/kotlin/j2k/CodeConverter;", "kotlin.j2k.k1.old"})
    private class ReplacingExpressionConverter
    implements SpecialExpressionConverter {
        @NotNull
        private final Map<String, String> parameterUsageReplacementMap;

        public ReplacingExpressionConverter(Map<String, String> parameterUsageReplacementMap) {
            Intrinsics.checkNotNullParameter(parameterUsageReplacementMap, (String)"parameterUsageReplacementMap");
            this.parameterUsageReplacementMap = parameterUsageReplacementMap;
        }

        @NotNull
        public final Map<String, String> getParameterUsageReplacementMap() {
            return this.parameterUsageReplacementMap;
        }

        @Override
        @Nullable
        public Expression convertExpression(@NotNull PsiExpression expression, @NotNull CodeConverter codeConverter) {
            PsiElement target;
            String replacement;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
            if (expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).getQualifier() == null && (replacement = this.parameterUsageReplacementMap.get(((PsiReferenceExpression)expression).getReferenceName())) != null && (target = ((PsiReferenceExpression)expression).resolve()) instanceof PsiParameter) {
                PsiElement psiElement = ((PsiParameter)target).getDeclarationScope();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDeclarationScope(...)");
                PsiElement scope = psiElement;
                if (scope instanceof PsiMember && UtilsKt.isConstructor((PsiMember)scope) && Intrinsics.areEqual((Object)((PsiMember)scope).getParent(), (Object)ConstructorConverter.this.psiClass)) {
                    return new Identifier(replacement, TypesKt.isNullable(codeConverter.getTypeConverter().variableNullability((PsiVariable)target), codeConverter.getSettings()), false, null, 12, null);
                }
            }
            return null;
        }
    }
}

