/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch;

import com.intellij.openapi.diagnostic.ControlFlowException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ExplainInfo;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputHandlerAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\rH&J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExecutor;", "", "file", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;)V", "getFile", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "handler", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExecutor$CompositeOutputHandler;", "getHandler", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExecutor$CompositeOutputHandler;", "execute", "", "stop", "addOutputHandler", "outputHandler", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandler;", "errorOccurs", "message", "", "e", "", "isFatal", "", "CompositeOutputHandler", "kotlin.jvm.shared"})
public abstract class ScratchExecutor {
    @NotNull
    private final ScratchFile file;
    @NotNull
    private final CompositeOutputHandler handler;

    public ScratchExecutor(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.handler = new CompositeOutputHandler();
        this.addOutputHandler(new ScratchOutputHandlerAdapter(){

            @Override
            public void onStart(ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchCompilationSupport.INSTANCE.start(file, this);
            }

            @Override
            public void onFinish(ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchCompilationSupport.INSTANCE.stop();
            }
        });
    }

    @NotNull
    protected ScratchFile getFile() {
        return this.file;
    }

    @NotNull
    protected final CompositeOutputHandler getHandler() {
        return this.handler;
    }

    public abstract void execute();

    public abstract void stop();

    public final void addOutputHandler(@NotNull ScratchOutputHandler outputHandler) {
        Intrinsics.checkNotNullParameter((Object)outputHandler, (String)"outputHandler");
        this.handler.add(outputHandler);
    }

    public final void errorOccurs(@NotNull String message2, @Nullable Throwable e, boolean isFatal) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.handler.error(this.getFile(), message2);
        if (isFatal) {
            this.handler.onFinish(this.getFile());
        }
        if (e != null && !(e instanceof ControlFlowException)) {
            ScratchUtilsKt.getLOG().error(e);
        }
    }

    public static /* synthetic */ void errorOccurs$default(ScratchExecutor scratchExecutor, String string, Throwable throwable, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: errorOccurs");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        scratchExecutor.errorOccurs(string, throwable, bl);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExecutor$CompositeOutputHandler;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutputHandler;", "<init>", "()V", "handlers", "", "add", "", "handler", "remove", "onStart", "file", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "handle", "explanations", "", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ExplainInfo;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "expression", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/output/ScratchOutput;", "error", "message", "", "onFinish", "clear", "kotlin.jvm.shared"})
    @SourceDebugExtension(value={"SMAP\nScratchExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchExecutor.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExecutor$CompositeOutputHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1869#2,2:105\n1869#2,2:107\n1869#2,2:109\n1869#2,2:111\n1869#2,2:113\n1869#2,2:115\n1869#2,2:117\n*S KotlinDebug\n*F\n+ 1 ScratchExecutor.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExecutor$CompositeOutputHandler\n*L\n75#1:105,2\n79#1:107,2\n83#1:109,2\n87#1:111,2\n91#1:113,2\n95#1:115,2\n99#1:117,2\n*E\n"})
    public static final class CompositeOutputHandler
    implements ScratchOutputHandler {
        @NotNull
        private final Set<ScratchOutputHandler> handlers = new LinkedHashSet();

        public final void add(@NotNull ScratchOutputHandler handler2) {
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            this.handlers.add(handler2);
        }

        public final void remove(@NotNull ScratchOutputHandler handler2) {
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            this.handlers.remove(handler2);
        }

        @Override
        public void onStart(@NotNull ScratchFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.onStart(file);
            }
        }

        @Override
        public void handle(@NotNull ScratchFile file, @NotNull List<ExplainInfo> explanations, @NotNull CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(explanations, (String)"explanations");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.handle(file, explanations, scope);
            }
        }

        @Override
        public void handle(@NotNull ScratchFile file, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.handle(file, expression, output);
            }
        }

        @Override
        public void handle(@NotNull ScratchFile file, @NotNull ScratchOutput output) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.handle(file, output);
            }
        }

        @Override
        public void error(@NotNull ScratchFile file, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.error(file, message2);
            }
        }

        @Override
        public void onFinish(@NotNull ScratchFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.onFinish(file);
            }
        }

        @Override
        public void clear(@NotNull ScratchFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.clear(file);
            }
        }
    }
}

