/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared.branchedTransformations;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.inspections.CreateReturnExpressionKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0002H\u0016J\r\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0014\u0010\u001a\u001a\u00020\u0003*\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/branchedTransformations/UnfoldReturnToIfIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "", "<init>", "()V", "invoke", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "element", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtReturnExpression;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "returnExpression", "isApplicableByPsi", "", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nUnfoldReturnToIfIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnfoldReturnToIfIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/branchedTransformations/UnfoldReturnToIfIntention\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,67:1\n25#2:68\n*S KotlinDebug\n*F\n+ 1 UnfoldReturnToIfIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/branchedTransformations/UnfoldReturnToIfIntention\n*L\n33#1:68\n*E\n"})
public final class UnfoldReturnToIfIntention
extends KotlinApplicableModCommandAction<KtReturnExpression, Unit> {
    public UnfoldReturnToIfIntention() {
        super(Reflection.getOrCreateKotlinClass(KtReturnExpression.class));
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtReturnExpression element, @NotNull Unit elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtExpression ktExpression = element.getReturnedExpression();
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        KtIfExpression ifExpression2 = (KtIfExpression)ktExpression;
        KtExpression ktExpression2 = ifExpression2.getThen();
        if (ktExpression2 == null || (ktExpression2 = KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)ktExpression2)) == null) {
            return;
        }
        KtExpression thenExpr = ktExpression2;
        KtExpression ktExpression3 = ifExpression2.getElse();
        KtExpression elseExpr = ktExpression3 != null ? KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)ktExpression3) : null;
        PsiElement $this$copied$iv = (PsiElement)ifExpression2;
        boolean $i$f$copied = false;
        PsiElement psiElement = $this$copied$iv.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        KtIfExpression newIfExpression = (KtIfExpression)((PsiElement)((KtIfExpression)psiElement));
        KtExpression ktExpression4 = newIfExpression.getThen();
        if (ktExpression4 == null || (ktExpression4 = KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)ktExpression4)) == null) {
            return;
        }
        KtExpression newThenExpr = ktExpression4;
        KtExpression ktExpression5 = newIfExpression.getElse();
        KtExpression newElseExpr = ktExpression5 != null ? KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)ktExpression5) : null;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        String labelName = element.getLabelName();
        newThenExpr.replace((PsiElement)CreateReturnExpressionKt.createReturnExpression(thenExpr, labelName, psiFactory));
        if (elseExpr != null) {
            KtExpression ktExpression6 = newElseExpr;
            if (ktExpression6 != null) {
                ktExpression6.replace((PsiElement)CreateReturnExpressionKt.createReturnExpression(elseExpr, labelName, psiFactory));
            }
        }
        element.replace((PsiElement)newIfExpression);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtReturnExpression returnExpression) {
        Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
        KtExpression ktExpression = returnExpression.getReturnedExpression();
        KtIfExpression ktIfExpression = ktExpression instanceof KtIfExpression ? (KtIfExpression)ktExpression : null;
        if (ktIfExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtIfExpression ifExpression2 = ktIfExpression;
        if (ifExpression2.getThen() == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement = returnExpression.getReturnKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getReturnKeyword(...)");
        TextRange returnKeywordRange = TextRangeUtilsKt.textRangeIn(psiElement, (PsiElement)returnExpression);
        PsiElement psiElement2 = ifExpression2.getIfKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getIfKeyword(...)");
        TextRange ifKeywordRange = TextRangeUtilsKt.textRangeIn(psiElement2, (PsiElement)returnExpression);
        return CollectionsKt.listOf((Object)returnKeywordRange.union(ifKeywordRange));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtReturnExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getReturnedExpression() instanceof KtIfExpression;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"replace.return.with.if.expression", (Object[])new Object[0]);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull KtReturnExpression element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Presentation presentation = Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.LOW);
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"withPriority(...)");
        return presentation;
    }

    @Override
    public void prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtReturnExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }
}

