/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.catboost;

import ai.catboost.CatBoostModel;
import ai.catboost.CatBoostPredictions;
import com.jetbrains.ml.tools.model.DatasetColumns;
import com.jetbrains.ml.tools.model.Regressor;
import com.jetbrains.ml.tools.model.catboost.CatBoostRegressorKt;
import com.jetbrains.ml.tools.model.catboost.CatBoostRow;
import com.jetbrains.ml.tools.model.catboost.CatBoostRows;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016\u00a2\u0006\u0002\u0010\rJ0\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/ml/tools/model/catboost/CatBoostRegressor;", "Lcom/jetbrains/ml/tools/model/Regressor;", "model", "Lai/catboost/CatBoostModel;", "(Lai/catboost/CatBoostModel;)V", "predict", "", "row", "Lcom/jetbrains/ml/tools/model/DatasetColumns;", "parameters", "", "", "", "(Lcom/jetbrains/ml/tools/model/DatasetColumns;Ljava/util/Map;)Ljava/lang/Double;", "predictBatch", "", "rows", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nCatBoostRegressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatBoostRegressor.kt\ncom/jetbrains/ml/tools/model/catboost/CatBoostRegressor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1#2:98\n1549#3:99\n1620#3,3:100\n*S KotlinDebug\n*F\n+ 1 CatBoostRegressor.kt\ncom/jetbrains/ml/tools/model/catboost/CatBoostRegressor\n*L\n94#1:99\n94#1:100,3\n*E\n"})
public final class CatBoostRegressor
implements Regressor {
    @NotNull
    private final CatBoostModel model;

    public CatBoostRegressor(@NotNull CatBoostModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
    }

    @Override
    @NotNull
    public Double predict(@NotNull DatasetColumns row, @NotNull Map<String, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        CatBoostRow cbRow = CatBoostRegressorKt.toCatBoostFormat(row, this.model);
        CatBoostPredictions catBoostPredictions = this.model.predict(cbRow.getNumerical(), cbRow.getCategorical(), cbRow.getText(), cbRow.getEmbeddings());
        if (catBoostPredictions == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        CatBoostPredictions prediction = catBoostPredictions;
        if (!(prediction.getPredictionDimension() == 1)) {
            boolean $i$a$-check-CatBoostRegressor$predict$32 = false;
            String $i$a$-check-CatBoostRegressor$predict$32 = String.valueOf(prediction.getPredictionDimension());
            throw new IllegalStateException($i$a$-check-CatBoostRegressor$predict$32.toString());
        }
        if (!(prediction.getObjectCount() == 1)) {
            boolean bl = false;
            String string = String.valueOf(prediction.getObjectCount());
            throw new IllegalStateException(string.toString());
        }
        return prediction.get(0, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Double> predictBatch(@NotNull List<DatasetColumns> rows, @NotNull Map<String, ? extends Object> parameters) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        if (!(!((Collection)rows).isEmpty())) {
            boolean $i$a$-require-CatBoostRegressor$predictBatch$22 = false;
            String $i$a$-require-CatBoostRegressor$predictBatch$22 = "A rows batch can't be empty";
            throw new IllegalArgumentException($i$a$-require-CatBoostRegressor$predictBatch$22.toString());
        }
        CatBoostRows cbRows = CatBoostRegressorKt.toCatBoostFormat(rows, this.model);
        CatBoostPredictions catBoostPredictions = this.model.predict(cbRows.getNumerical(), cbRows.getCategorical(), cbRows.getText(), cbRows.getEmbeddings());
        if (catBoostPredictions == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        CatBoostPredictions prediction = catBoostPredictions;
        if (!(prediction.getPredictionDimension() == 1)) {
            boolean $i$a$-check-CatBoostRegressor$predictBatch$42 = false;
            String $i$a$-check-CatBoostRegressor$predictBatch$42 = String.valueOf(prediction.getPredictionDimension());
            throw new IllegalStateException($i$a$-check-CatBoostRegressor$predictBatch$42.toString());
        }
        if (!(prediction.getObjectCount() == rows.size())) {
            boolean $i$a$-check-CatBoostRegressor$predictBatch$52 = false;
            String $i$a$-check-CatBoostRegressor$predictBatch$52 = String.valueOf(prediction.getObjectCount());
            throw new IllegalStateException($i$a$-check-CatBoostRegressor$predictBatch$52.toString());
        }
        Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)rows);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(prediction.get((int)it, 0));
        }
        return (List)destination$iv$iv;
    }
}

