/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.jupyter.data.input.JupyterAttachNewFileAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.NotebookInsertDataInputCellAction;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/NotebookInsertDataInputCellAndSetFileAction;", "Lcom/intellij/jupyter/core/jupyter/data/input/NotebookInsertDataInputCellAction;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "onCellInserted", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookInsertDataInputCellBelowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookInsertDataInputCellBelowAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/NotebookInsertDataInputCellAndSetFileAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
final class NotebookInsertDataInputCellAndSetFileAction
extends NotebookInsertDataInputCellAction {
    @NotNull
    private final VirtualFile file;

    public NotebookInsertDataInputCellAndSetFileAction(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    @Override
    protected void onCellInserted(@NotNull EditorImpl editor, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        super.onCellInserted(editor, interval);
        Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
        if (object == null || (object = object.getNotebookOrNull()) == null || (object = object.getCell(interval.getOrdinal())) == null) {
            return;
        }
        Object cell = object;
        Path path = editor.getVirtualFile().getParent().toNioPath().toAbsolutePath().relativize(this.file.toNioPath().toAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        Path relativePath = path;
        JupyterDataInputCellMetadataKt.setFileInfo((JupyterCell)cell, ((Object)relativePath).toString());
    }

    @Override
    @NotNull
    public JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive((Function1<? super JupyterActonUpdater.Builder, Unit>)((Function1)arg_0 -> NotebookInsertDataInputCellAndSetFileAction.createActionUpdater$lambda$2(this, arg_0)));
    }

    private static final Unit createActionUpdater$lambda$2$lambda$1(NotebookInsertDataInputCellAndSetFileAction this$0, JupyterEditorAction action, AnActionEvent event) {
        EditorImpl editor;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setText(this$0.file.getName(), false);
        event.getPresentation().setIcon(JupyterCoreIcons.ImportDataCell);
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
        if (editorImpl != null) {
            EditorImpl editorImpl2;
            EditorImpl it = editorImpl2 = editorImpl;
            boolean bl = false;
            v2 = NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it)) ? editorImpl2 : null;
        } else {
            v2 = editor = null;
        }
        if (editor != null) {
            Path path = editor.getVirtualFile().getParent().toNioPath().toAbsolutePath().relativize(this$0.file.toNioPath().toAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
            Path relativePath = path;
            Object object = relativePath.getParent();
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            Object parentPath = object;
            event.getPresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, parentPath);
        }
        event.getPresentation().setEnabled(ArraysKt.contains((Object[])JupyterAttachNewFileAction.Companion.getSUPPORTED_EXTENSIONS$intellij_jupyter_core(), (Object)this$0.file.getExtension()));
        return Unit.INSTANCE;
    }

    private static final Unit createActionUpdater$lambda$2(NotebookInsertDataInputCellAndSetFileAction this$0, JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addVisualCustomizer((Function2<? super JupyterEditorAction, ? super AnActionEvent, Unit>)((Function2)(arg_0, arg_1) -> NotebookInsertDataInputCellAndSetFileAction.createActionUpdater$lambda$2$lambda$1(this$0, arg_0, arg_1)));
        return Unit.INSTANCE;
    }
}

