/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.openapi.util.NlsSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputTableInfo;", "", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;)V", "setTableInfo", "", "tableObjectPath", "", "tableName", "dataSourceUniqueId", "getTableName", "hasData", "", "intellij.jupyter.core"})
public final class JupyterDataInputTableInfo {
    @NotNull
    private final JupyterCell cell;

    public JupyterDataInputTableInfo(@NotNull JupyterCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.cell = cell;
    }

    public final void setTableInfo(@NotNull String tableObjectPath, @NotNull String tableName, @NotNull String dataSourceUniqueId) {
        Intrinsics.checkNotNullParameter((Object)tableObjectPath, (String)"tableObjectPath");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)dataSourceUniqueId, (String)"dataSourceUniqueId");
        JupyterDataInputCellTableMetadataKt.setTableInfo(this.cell, dataSourceUniqueId, tableObjectPath, tableName);
    }

    @NlsSafe
    @Nullable
    public final String getTableName() {
        JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(this.cell);
        return jupyterDataInputCellTableMetadata != null ? jupyterDataInputCellTableMetadata.getTableName() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasData() {
        if (JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(this.cell) == null) return false;
        JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(this.cell);
        if (jupyterDataInputCellTableMetadata == null) return false;
        String string = jupyterDataInputCellTableMetadata.getTableObjectPath();
        if (string == null) return false;
        JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata2 = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(this.cell);
        if (jupyterDataInputCellTableMetadata2 == null) return false;
        String string2 = jupyterDataInputCellTableMetadata2.getDataSourceUniqueId();
        if (string2 == null) return false;
        JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata3 = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(this.cell);
        if (jupyterDataInputCellTableMetadata3 == null) return false;
        String string3 = jupyterDataInputCellTableMetadata3.getTableName();
        if (string3 == null) return false;
        return true;
    }
}

