/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.scrolling;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.SpringSpec;
import androidx.compose.foundation.ScrollState;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.text.TextLayoutResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.foundation.util.JewelLogger;
import org.jetbrains.jewel.markdown.MarkdownBlock;
import org.jetbrains.jewel.markdown.WithChildBlocks;

@ExperimentalJewelApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00a6@\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0005H$J\b\u0010\u0012\u001a\u00020\u0005H$J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH&\u00a8\u0006!"}, d2={"Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer;", "", "<init>", "()V", "scrollToLine", "", "sourceLine", "", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "", "(ILandroidx/compose/animation/core/AnimationSpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "process", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "beforeProcessing", "afterProcessing", "acceptBlockSpans", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "block", "sourceRange", "Lkotlin/ranges/IntRange;", "acceptGlobalPosition", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "acceptTextLayout", "textLayout", "Landroidx/compose/ui/text/TextLayoutResult;", "Companion", "LocatableMarkdownBlock", "PerLine", "intellij.platform.jewel.markdown.core"})
@StabilityInferred(parameters=1)
public abstract class ScrollingSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Nullable
    public abstract Object scrollToLine(int var1, @NotNull AnimationSpec<Float> var2, @NotNull Continuation<? super Unit> var3);

    public static /* synthetic */ Object scrollToLine$default(ScrollingSynchronizer scrollingSynchronizer, int n, AnimationSpec animationSpec, Continuation continuation, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollToLine");
        }
        if ((n2 & 2) != 0) {
            animationSpec = (AnimationSpec)new SpringSpec(0.0f, 0.0f, null, 7, null);
        }
        return scrollingSynchronizer.scrollToLine(n, (AnimationSpec<Float>)animationSpec, (Continuation<? super Unit>)continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T process(@NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.beforeProcessing();
        try {
            object = action.invoke();
        }
        finally {
            this.afterProcessing();
        }
        return (T)object;
    }

    protected abstract void beforeProcessing();

    protected abstract void afterProcessing();

    @NotNull
    public abstract MarkdownBlock acceptBlockSpans(@NotNull MarkdownBlock var1, @NotNull IntRange var2);

    public abstract void acceptGlobalPosition(@NotNull MarkdownBlock var1, @NotNull LayoutCoordinates var2);

    public abstract void acceptTextLayout(@NotNull MarkdownBlock var1, @NotNull TextLayoutResult var2);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer;", "scrollState", "Landroidx/compose/foundation/gestures/ScrollableState;", "intellij.platform.jewel.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nScrollingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollingSynchronizer.kt\norg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$Companion\n+ 2 JewelLogger.kt\norg/jetbrains/jewel/foundation/util/JewelLoggerKt\n*L\n1#1,386:1\n9#2:387\n*S KotlinDebug\n*F\n+ 1 ScrollingSynchronizer.kt\norg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$Companion\n*L\n135#1:387\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ScrollingSynchronizer create(@NotNull ScrollableState scrollState) {
            ScrollingSynchronizer scrollingSynchronizer;
            Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
            ScrollableState scrollableState = scrollState;
            if (scrollableState instanceof ScrollState) {
                scrollingSynchronizer = new PerLine((ScrollState)scrollState);
            } else if (scrollableState instanceof LazyListState) {
                Companion $this$myLogger$iv = this;
                boolean $i$f$myLogger = false;
                JewelLogger.Companion.getInstance(Companion.class).warn("Synchronization for LazyListState is not supported yet");
                scrollingSynchronizer = null;
            } else {
                scrollingSynchronizer = null;
            }
            return scrollingSynchronizer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$LocatableMarkdownBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CustomBlock;", "originalBlock", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "lines", "Lkotlin/ranges/IntRange;", "<init>", "(Lorg/jetbrains/jewel/markdown/MarkdownBlock;Lkotlin/ranges/IntRange;)V", "getOriginalBlock", "()Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "getLines", "()Lkotlin/ranges/IntRange;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.jewel.markdown.core"})
    @StabilityInferred(parameters=0)
    public static final class LocatableMarkdownBlock
    implements MarkdownBlock.CustomBlock {
        @NotNull
        private final MarkdownBlock originalBlock;
        @NotNull
        private final IntRange lines;
        public static final int $stable = 8;

        public LocatableMarkdownBlock(@NotNull MarkdownBlock originalBlock, @NotNull IntRange lines) {
            Intrinsics.checkNotNullParameter((Object)originalBlock, (String)"originalBlock");
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            this.originalBlock = originalBlock;
            this.lines = lines;
        }

        @NotNull
        public final MarkdownBlock getOriginalBlock() {
            return this.originalBlock;
        }

        @NotNull
        public final IntRange getLines() {
            return this.lines;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof LocatableMarkdownBlock && Intrinsics.areEqual((Object)this.originalBlock, (Object)((LocatableMarkdownBlock)other).originalBlock) && Intrinsics.areEqual((Object)this.lines, (Object)((LocatableMarkdownBlock)other).lines);
        }

        public int hashCode() {
            return this.originalBlock.hashCode() * 31 + this.lines.hashCode() * 31;
        }

        @NotNull
        public String toString() {
            return "LocatableMarkdownBlock(originalBlock=" + this.originalBlock + ", lines=" + this.lines + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0014J\b\u0010\u001d\u001a\u00020\u0014H\u0014J\u0014\u0010\u001e\u001a\u00020\u001f*\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0002J9\u0010!\u001a\u00020\u0014\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#*\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#0\u000b2\u0006\u0010$\u001a\u0002H\"2\u0006\u0010%\u001a\u0002H\"H\u0002\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0002J\u0018\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\t2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\t2\u0006\u00102\u001a\u000203H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$PerLine;", "Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer;", "scrollState", "Landroidx/compose/foundation/ScrollState;", "<init>", "(Landroidx/compose/foundation/ScrollState;)V", "lines2Blocks", "Ljava/util/TreeMap;", "", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "blocks2Top", "", "previousPositions", "lastBlocks", "", "Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$LocatableMarkdownBlock;", "currentBlocks", "", "blocks2TextOffsets", "scrollToLine", "", "sourceLine", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "", "(ILandroidx/compose/animation/core/AnimationSpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBestBlockForLine", "line", "beforeProcessing", "afterProcessing", "originallyEquals", "", "other", "replaceKey", "K", "V", "oldKey", "newKey", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "replace", "oldBlock", "newBlock", "acceptBlockSpans", "block", "sourceRange", "Lkotlin/ranges/IntRange;", "acceptGlobalPosition", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "acceptTextLayout", "textLayout", "Landroidx/compose/ui/text/TextLayoutResult;", "intellij.platform.jewel.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nScrollingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollingSynchronizer.kt\norg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$PerLine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,386:1\n1740#2,3:387\n1#3:390\n69#4:391\n70#5:392\n22#6:393\n*S KotlinDebug\n*F\n+ 1 ScrollingSynchronizer.kt\norg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$PerLine\n*L\n284#1:387,3\n311#1:391\n311#1:392\n311#1:393\n*E\n"})
    private static final class PerLine
    extends ScrollingSynchronizer {
        @NotNull
        private final ScrollState scrollState;
        @NotNull
        private final TreeMap<Integer, MarkdownBlock> lines2Blocks;
        @NotNull
        private final Map<MarkdownBlock, Integer> blocks2Top;
        @NotNull
        private final Map<MarkdownBlock, Integer> previousPositions;
        @NotNull
        private List<LocatableMarkdownBlock> lastBlocks;
        @NotNull
        private final List<LocatableMarkdownBlock> currentBlocks;
        @NotNull
        private final Map<MarkdownBlock, List<Integer>> blocks2TextOffsets;

        public PerLine(@NotNull ScrollState scrollState) {
            Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
            this.scrollState = scrollState;
            this.lines2Blocks = new TreeMap();
            this.blocks2Top = new LinkedHashMap();
            this.previousPositions = new LinkedHashMap();
            this.lastBlocks = CollectionsKt.emptyList();
            this.currentBlocks = new ArrayList();
            this.blocks2TextOffsets = new LinkedHashMap();
        }

        @Override
        @Nullable
        public Object scrollToLine(int sourceLine, @NotNull AnimationSpec<Float> animationSpec, @NotNull Continuation<? super Unit> $completion) {
            MarkdownBlock markdownBlock = this.findBestBlockForLine(sourceLine);
            if (markdownBlock == null) {
                return Unit.INSTANCE;
            }
            MarkdownBlock block = markdownBlock;
            Integer n = this.blocks2Top.get(block);
            if (n == null) {
                return Unit.INSTANCE;
            }
            int y = n;
            if (y < 0) {
                return Unit.INSTANCE;
            }
            LocatableMarkdownBlock locatableMarkdownBlock = block instanceof LocatableMarkdownBlock ? (LocatableMarkdownBlock)block : null;
            if (locatableMarkdownBlock == null || (locatableMarkdownBlock = locatableMarkdownBlock.getLines()) == null) {
                return Unit.INSTANCE;
            }
            LocatableMarkdownBlock lineRange = locatableMarkdownBlock;
            List<Integer> textOffsets = this.blocks2TextOffsets.get(block);
            int lineIndexInBlock = Math.max(0, sourceLine - lineRange.getStart());
            List<Integer> list = textOffsets;
            int lineOffset = list != null ? ((Number)list.get(lineIndexInBlock)).intValue() : 0;
            Object object = this.scrollState.animateScrollTo(y + lineOffset, animationSpec, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        private final MarkdownBlock findBestBlockForLine(int line) {
            SortedMap<Integer, MarkdownBlock> sm = this.lines2Blocks.subMap(line, Integer.MAX_VALUE);
            if (sm.isEmpty()) {
                return null;
            }
            Intrinsics.checkNotNull(sm);
            return (MarkdownBlock)MapsKt.getValue((Map)sm, (Object)sm.firstKey());
        }

        @Override
        protected void beforeProcessing() {
            this.lines2Blocks.clear();
        }

        @Override
        protected void afterProcessing() {
            int lastI;
            int firstChangedIndex = -1;
            int i = 0;
            int n = Math.min(CollectionsKt.getLastIndex(this.lastBlocks), CollectionsKt.getLastIndex(this.currentBlocks));
            if (i <= n) {
                while (true) {
                    LocatableMarkdownBlock last;
                    LocatableMarkdownBlock current;
                    if (!this.originallyEquals(current = this.currentBlocks.get(i), last = this.lastBlocks.get(i))) {
                        firstChangedIndex = i;
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)current.getLines(), (Object)last.getLines())) {
                        this.replace(last, current);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if ((n = firstChangedIndex + 1) <= (lastI = CollectionsKt.getLastIndex(this.lastBlocks))) {
                LocatableMarkdownBlock last;
                LocatableMarkdownBlock current;
                int currI;
                while ((currI = CollectionsKt.getLastIndex(this.currentBlocks) - (CollectionsKt.getLastIndex(this.lastBlocks) - lastI)) >= 0 && this.originallyEquals(current = this.currentBlocks.get(currI), last = this.lastBlocks.get(lastI))) {
                    if (current.getOriginalBlock() instanceof MarkdownBlock.CodeBlock) {
                        this.replaceKey(this.blocks2TextOffsets, last, current);
                    }
                    if (lastI == n) break;
                    --lastI;
                }
            }
            if (firstChangedIndex >= 0 && (i = firstChangedIndex) <= (n = CollectionsKt.getLastIndex(this.lastBlocks))) {
                while (true) {
                    this.blocks2Top.remove(this.lastBlocks.get(i));
                    this.previousPositions.remove(this.lastBlocks.get(i));
                    if (i == n) break;
                    ++i;
                }
            }
            this.lastBlocks = new ArrayList(this.currentBlocks);
            this.currentBlocks.clear();
        }

        private final boolean originallyEquals(MarkdownBlock $this$originallyEquals, MarkdownBlock other) {
            boolean bl;
            block8: {
                MarkdownBlock otherOriginalBlock;
                MarkdownBlock markdownBlock;
                MarkdownBlock originalBlock;
                if ($this$originallyEquals instanceof LocatableMarkdownBlock && other instanceof LocatableMarkdownBlock && ((LocatableMarkdownBlock)$this$originallyEquals).getLines().getEndInclusive() - ((LocatableMarkdownBlock)$this$originallyEquals).getLines().getStart() != ((LocatableMarkdownBlock)other).getLines().getEndInclusive() - ((LocatableMarkdownBlock)other).getLines().getStart()) {
                    return false;
                }
                MarkdownBlock markdownBlock2 = $this$originallyEquals instanceof LocatableMarkdownBlock ? (LocatableMarkdownBlock)$this$originallyEquals : null;
                if (markdownBlock2 == null || (markdownBlock2 = markdownBlock2.getOriginalBlock()) == null) {
                    markdownBlock2 = originalBlock = $this$originallyEquals;
                }
                if ((markdownBlock = other instanceof LocatableMarkdownBlock ? (LocatableMarkdownBlock)other : null) == null || (markdownBlock = markdownBlock.getOriginalBlock()) == null) {
                    markdownBlock = otherOriginalBlock = other;
                }
                if (!(originalBlock instanceof WithChildBlocks) || !(otherOriginalBlock instanceof WithChildBlocks)) {
                    return Intrinsics.areEqual((Object)originalBlock, (Object)otherOriginalBlock);
                }
                if (((WithChildBlocks)((Object)originalBlock)).getChildren().size() != ((WithChildBlocks)((Object)otherOriginalBlock)).getChildren().size()) {
                    return false;
                }
                Iterable $this$all$iv = CollectionsKt.zip((Iterable)((WithChildBlocks)((Object)originalBlock)).getChildren(), (Iterable)((WithChildBlocks)((Object)otherOriginalBlock)).getChildren());
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        MarkdownBlock b;
                        Pair pair = (Pair)element$iv;
                        boolean bl2 = false;
                        MarkdownBlock a = (MarkdownBlock)pair.component1();
                        if (this.originallyEquals(a, b = (MarkdownBlock)pair.component2())) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private final <K, V> void replaceKey(Map<K, V> $this$replaceKey, K oldKey, K newKey) {
            block0: {
                V v = $this$replaceKey.remove(oldKey);
                if (v == null) break block0;
                V it = v;
                boolean bl = false;
                $this$replaceKey.put(newKey, it);
            }
        }

        private final void replace(MarkdownBlock oldBlock, MarkdownBlock newBlock) {
            this.replaceKey(this.blocks2Top, oldBlock, newBlock);
            this.replaceKey(this.blocks2TextOffsets, oldBlock, newBlock);
            this.replaceKey(this.previousPositions, oldBlock, newBlock);
        }

        @Override
        @NotNull
        public MarkdownBlock acceptBlockSpans(@NotNull MarkdownBlock block, @NotNull IntRange sourceRange) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)sourceRange, (String)"sourceRange");
            LocatableMarkdownBlock block2 = new LocatableMarkdownBlock(block, sourceRange);
            int line = sourceRange.getFirst();
            int n = sourceRange.getLast();
            if (line <= n) {
                while (true) {
                    this.lines2Blocks.putIfAbsent(line, block2);
                    if (line == n) break;
                    ++line;
                }
            }
            ((Collection)this.currentBlocks).add(block2);
            return block2;
        }

        @Override
        public void acceptGlobalPosition(@NotNull MarkdownBlock block, @NotNull LayoutCoordinates coordinates) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            long arg0$iv = LayoutCoordinatesKt.positionInRoot((LayoutCoordinates)coordinates);
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits = false;
            int y = (int)Float.intBitsToFloat(bits$iv$iv$iv) + this.scrollState.getValue();
            Integer oldY = this.previousPositions.get(block);
            if (oldY == null || y != oldY) {
                this.blocks2Top.put(block, y);
                this.previousPositions.put(block, y);
            }
        }

        @Override
        public void acceptTextLayout(@NotNull MarkdownBlock block, @NotNull TextLayoutResult textLayout) {
            int n;
            int i;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)textLayout, (String)"textLayout");
            MarkdownBlock markdownBlock = block instanceof LocatableMarkdownBlock ? (LocatableMarkdownBlock)block : null;
            if (markdownBlock == null || (markdownBlock = markdownBlock.getOriginalBlock()) == null) {
                return;
            }
            MarkdownBlock originalBlock = markdownBlock;
            if (!(originalBlock instanceof MarkdownBlock.CodeBlock)) {
                return;
            }
            IntRange sourceLines = ((LocatableMarkdownBlock)block).getLines();
            int y = 0;
            List list = new ArrayList();
            if (originalBlock instanceof MarkdownBlock.CodeBlock.FencedCodeBlock) {
                int openingLine = RangesKt.first((IntProgression)((IntProgression)sourceLines));
                int firstSourceLine = openingLine + 1;
                int closingLine = RangesKt.last((IntProgression)((IntProgression)sourceLines));
                ((Collection)list).add(y);
                for (int i2 = firstSourceLine; i2 < closingLine; ++i2) {
                    ((Collection)list).add(y);
                    float lineHeight = textLayout.getLineBottom(i2 - firstSourceLine) - textLayout.getLineTop(i2 - firstSourceLine);
                    y += (int)lineHeight;
                }
                ((Collection)list).add(y);
            } else if (originalBlock instanceof MarkdownBlock.CodeBlock.IndentedCodeBlock && (i = sourceLines.getFirst()) <= (n = sourceLines.getLast())) {
                while (true) {
                    ((Collection)list).add(y);
                    float lineHeight = textLayout.getLineBottom(i - sourceLines.getFirst()) - textLayout.getLineTop(i - sourceLines.getFirst());
                    y += (int)lineHeight;
                    if (i == n) break;
                    ++i;
                }
            }
            this.blocks2TextOffsets.put(block, list);
        }
    }
}

