/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.utils;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0080@\u00a2\u0006\u0004\b\u001b\u0010\u001cJ \u0010\u001d\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u000fH\u0080@\u00a2\u0006\u0004\b\u001f\u0010 J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0080@\u00a2\u0006\u0004\b\"\u0010#J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0%2\u0006\u0010&\u001a\u00020'H\u0002J \u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0002R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u000e\u0010\u0016\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/intellij/images/scientific/utils/ScientificUtils;", "", "<init>", "()V", "SCIENTIFIC_MODE_KEY", "Lcom/intellij/openapi/util/Key;", "", "ORIGINAL_IMAGE_KEY", "Ljava/awt/image/BufferedImage;", "getORIGINAL_IMAGE_KEY", "()Lcom/intellij/openapi/util/Key;", "DATA_TYPE_KEY", "", "getDATA_TYPE_KEY", "ROTATION_ANGLE_KEY", "", "getROTATION_ANGLE_KEY", "CURRENT_NOT_NORMALIZED_IMAGE_KEY", "getCURRENT_NOT_NORMALIZED_IMAGE_KEY", "NORMALIZATION_APPLIED_KEY", "", "getNORMALIZATION_APPLIED_KEY", "DEFAULT_IMAGE_FORMAT", "saveImageToFile", "imageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "image", "saveImageToFile$intellij_platform_images", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rotateImage", "angle", "rotateImage$intellij_platform_images", "(Ljava/awt/image/BufferedImage;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "normalizeImage", "normalizeImage$intellij_platform_images", "(Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findMinMax", "Lkotlin/Pair;", "array", "", "normalizeChannel", "value", "min", "max", "intellij.platform.images"})
public final class ScientificUtils {
    @NotNull
    public static final ScientificUtils INSTANCE = new ScientificUtils();
    @JvmField
    @NotNull
    public static Key<Unit> SCIENTIFIC_MODE_KEY = new Key("SCIENTIFIC_MODE");
    @NotNull
    private static final Key<BufferedImage> ORIGINAL_IMAGE_KEY = new Key("ORIGINAL_IMAGE");
    @NotNull
    private static final Key<String> DATA_TYPE_KEY = new Key("DATA_TYPE");
    @NotNull
    private static final Key<Integer> ROTATION_ANGLE_KEY;
    @NotNull
    private static final Key<BufferedImage> CURRENT_NOT_NORMALIZED_IMAGE_KEY;
    @NotNull
    private static final Key<Boolean> NORMALIZATION_APPLIED_KEY;
    @NotNull
    public static final String DEFAULT_IMAGE_FORMAT = "png";

    private ScientificUtils() {
    }

    @NotNull
    public final Key<BufferedImage> getORIGINAL_IMAGE_KEY() {
        return ORIGINAL_IMAGE_KEY;
    }

    @NotNull
    public final Key<String> getDATA_TYPE_KEY() {
        return DATA_TYPE_KEY;
    }

    @NotNull
    public final Key<Integer> getROTATION_ANGLE_KEY() {
        return ROTATION_ANGLE_KEY;
    }

    @NotNull
    public final Key<BufferedImage> getCURRENT_NOT_NORMALIZED_IMAGE_KEY() {
        return CURRENT_NOT_NORMALIZED_IMAGE_KEY;
    }

    @NotNull
    public final Key<Boolean> getNORMALIZATION_APPLIED_KEY() {
        return NORMALIZATION_APPLIED_KEY;
    }

    @Nullable
    public final Object saveImageToFile$intellij_platform_images(@NotNull VirtualFile imageFile, @NotNull BufferedImage image, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(image, imageFile, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ VirtualFile $imageFile;
            {
                this.$image = $image;
                this.$imageFile = $imageFile;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)this.$image, "png", byteArrayOutputStream);
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                        VirtualFileUtil.writeBytes((VirtualFile)this.$imageFile, (byte[])byArray);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object rotateImage$intellij_platform_images(@NotNull BufferedImage image, int angle, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, angle, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ int $angle;
            {
                this.$image = $image;
                this.$angle = $angle;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        int width = this.$image.getWidth();
                        int height = this.$image.getHeight();
                        boolean isRightAngle = this.$angle % 180 == 90;
                        int targetWidth = isRightAngle ? height : width;
                        int targetHeight = isRightAngle ? width : height;
                        AffineTransform transform = new AffineTransform();
                        transform.translate((double)targetWidth / 2.0, (double)targetHeight / 2.0);
                        transform.rotate(Math.toRadians(this.$angle));
                        transform.translate((double)(-width) / 2.0, (double)(-height) / 2.0);
                        BufferedImage rotatedImage = new BufferedImage(targetWidth, targetHeight, this.$image.getType());
                        Graphics2D graphics = rotatedImage.createGraphics();
                        graphics.setTransform(transform);
                        graphics.drawImage((Image)this.$image, 0, 0, null);
                        graphics.dispose();
                        return rotatedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object normalizeImage$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        int width = this.$image.getWidth();
                        int height = this.$image.getHeight();
                        BufferedImage normalizedImage = new BufferedImage(width, height, this.$image.getType());
                        int[] red = new int[width * height];
                        int[] green = new int[width * height];
                        int[] blue = new int[width * height];
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                int rgb = this.$image.getRGB(x, y);
                                int i = y * width + x;
                                red[i] = rgb >> 16 & 0xFF;
                                green[i] = rgb >> 8 & 0xFF;
                                blue[i] = rgb & 0xFF;
                            }
                        }
                        Pair rMinMax = ScientificUtils.access$findMinMax(ScientificUtils.INSTANCE, red);
                        Pair gMinMax = ScientificUtils.access$findMinMax(ScientificUtils.INSTANCE, green);
                        Pair bMinMax = ScientificUtils.access$findMinMax(ScientificUtils.INSTANCE, blue);
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                int i = y * width + x;
                                int alpha = this.$image.getRGB(x, y) & 0xFF000000;
                                int normalizedR = ScientificUtils.access$normalizeChannel(ScientificUtils.INSTANCE, red[i], ((Number)rMinMax.getFirst()).intValue(), ((Number)rMinMax.getSecond()).intValue());
                                int normalizedG = ScientificUtils.access$normalizeChannel(ScientificUtils.INSTANCE, green[i], ((Number)gMinMax.getFirst()).intValue(), ((Number)gMinMax.getSecond()).intValue());
                                int normalizedB = ScientificUtils.access$normalizeChannel(ScientificUtils.INSTANCE, blue[i], ((Number)bMinMax.getFirst()).intValue(), ((Number)bMinMax.getSecond()).intValue());
                                int normalizedARGB = alpha | normalizedR << 16 | normalizedG << 8 | normalizedB;
                                normalizedImage.setRGB(x, y, normalizedARGB);
                            }
                        }
                        return normalizedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Pair<Integer, Integer> findMinMax(int[] array) {
        int min = array[0];
        int max = array[0];
        for (int value : array) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return new Pair((Object)min, (Object)max);
    }

    private final int normalizeChannel(int value, int min, int max) {
        return max > min ? RangesKt.coerceIn((int)((int)((float)(value - min) * (float)255 / (float)(max - min))), (int)0, (int)255) : value;
    }

    public static final /* synthetic */ Pair access$findMinMax(ScientificUtils $this, int[] array) {
        return $this.findMinMax(array);
    }

    public static final /* synthetic */ int access$normalizeChannel(ScientificUtils $this, int value, int min, int max) {
        return $this.normalizeChannel(value, min, max);
    }

    static {
        Key key = Key.create((String)"IMAGE_ROTATION_ANGLE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ROTATION_ANGLE_KEY = key;
        CURRENT_NOT_NORMALIZED_IMAGE_KEY = new Key("CURRENT_NOT_NORMALIZED_IMAGE");
        NORMALIZATION_APPLIED_KEY = new Key("NORMALIZATION_APPLIED");
    }
}

